/*---------------------------------------------------------*/
/*   Styx.cpp:  TStyxWindow member functions               */
/*---------------------------------------------------------*/

#define Uses_TRect
#define Uses_TView
#define Uses_TWindow
#include <tv.h>
#include <tvg.h>

#include <stdlib.h>
#include <stdio.h>
#include <dos.h>

#include "styx.h"

#define SETVELOCITY(X) X=random(8)+1;if(X>4) X=4-X;X*=32

gStyx::gStyx() : gObject(0) {
 int C;
 CurrentStick=0;
 StyxLocations[0].ChangeEnds(GraphXMax/3,GraphYMax/3,GraphXMax/2,GraphYMax/2);
 SETVELOCITY(vXA);
 SETVELOCITY(vYA);
 SETVELOCITY(vXB);
 SETVELOCITY(vYB);
 for (C=0;C<=15;C++) GraphProd();
}

void gStyx::GraphDraw(TRect& R) {
 const byte StyxColor[16] = {15,11,11,9,9,9,9,1,1,1,1,1,1,1,1,0};
 int count,Actual;
 for(count=0;count<=15;count++)
 {
  Actual=(16-count+CurrentStick)%16;
  StyxLocations[count].ChangeColor(StyxColor[Actual]);
  StyxLocations[count].GraphDraw(R);
 }
}

void gStyx::GraphProd() {
 int Count,LS;
 LS=CurrentStick++;
 CurrentStick %= 16;
 StyxLocations[CurrentStick].ChangeEnds(StyxLocations[LS]);
 StyxLocations[CurrentStick].DeltaEnds(vXA,vYA,vXB,vYB);
 if((StyxLocations[CurrentStick].Xa<=0) ||
    (StyxLocations[CurrentStick].Xa>=GraphXMax)) vXA=-vXA;
 if((StyxLocations[CurrentStick].Ya<=0) ||
    (StyxLocations[CurrentStick].Ya>=GraphYMax)) vYA=-vYA;
 if((StyxLocations[CurrentStick].Xb<=0) ||
    (StyxLocations[CurrentStick].Xb>=GraphXMax)) vXB=-vXB;
 if((StyxLocations[CurrentStick].Yb<=0) ||
    (StyxLocations[CurrentStick].Yb>=GraphYMax)) vYB=-vYB;
}

TStyxDemo::TStyxDemo() :
    gWindow( TRect(1, 1, 34, 12), "S.T.Y.X.", wnNoNumber ),
    TWindowInit( &TStyxDemo::initFrame )
{
    gView *GV;
    gStyx *STYX;
    TRect r(getExtent());
    r.grow(-1, -1);
    GV=new gView(r);
    STYX=new gStyx();
    if ((GV)&&(STYX)) {
        GV->Insert(STYX);
        insert(GV);
    }
}

