/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

/***
    Module      :   TVTOOLS

    Description :   Various tools and addings for TV

 ***/


#ifndef __TVTOOLS_H_
#define __TVTOOLS_H_

#pragma option -Vo-
#if defined( __BCOPT__ )
#pragma option -po-
#endif

#define Uses_TButton
#define Uses_TKeys
#define Uses_TWindow
#define Uses_TStreamableClass

#if defined(Uses_All)
#define Uses_TOutErr
#define Uses_TAsciiChart
#define Uses_TCalendar
#define Uses_TCalculator
#define Uses_TClockView
#define Uses_TGenCollection
#define Uses_THeapView
#define Uses_TInputRegExp
#define Uses_TInputHexa
#define Uses_TInputKey
#define Uses_TInputPasswd
#define Uses_TInputInt
#define Uses_TInputLong
#define Uses_TInputDouble
#define Uses_TInputDate
#define Uses_TInputCalcul
#define Uses_TFileView 
#define Uses_TStaticInputLine
#define Uses_TComboBox
#define Uses_Event
#define Uses_TStaticTextf
#endif

#if defined(Uses_TOutErr)
#define Uses_TApplication
#endif

#if defined(Uses_TAsciiChart) || \
    defined(Uses_TCalendar  ) || \
    defined(Uses_TCalculator)
#define Uses_TView
#define Uses_TDialog
#endif

#if defined(Uses_TClockView ) || \
    defined(Uses_THeapView  )
#define Uses_TView
#define Uses_TRect
#endif

#if defined(Uses_TFileView)
#define Uses_TCollection
#define Uses_TScroller
#define Uses_TWindow
#define Uses_TDialog
#endif

#if defined(Uses_TComboBox)
#define Uses_TEvent
#define Uses_TInputLine
#define Uses_TListViewer
#define Uses_TPalette
#define Uses_TScrollBar
#define Uses_TWindow
#define Uses_TGenCollection
#endif

#if defined(Uses_TInputKey   ) || \
    defined(Uses_TInputPasswd) || \
    defined(Uses_TInputRegExp) || \
    defined(Uses_TInputInt   ) || \
    defined(Uses_TInputLong  ) || \
    defined(Uses_TInputDouble) || \
    defined(Uses_TInputHexa  ) || \
    defined(Uses_TInputDate  ) || \
    defined(Uses_TInputCalcul) || \
    defined(Uses_TStaticInputLine)
#define Uses_TInputLine
#define Uses_TRect
#define Uses_pstream
#define __INPUT_INC
#endif

#if defined(Uses_TInputInt   ) || \
    defined(Uses_TInputLong  ) || \
    defined(Uses_TInputDouble) || \
    defined(Uses_TInputHexa  ) || \
    defined(Uses_TInputDate  ) || \
    defined(Uses_TInputCalcul)
#define Uses_TInputRegExp
#endif

#if defined(Uses_TStaticInputLine)
#define Uses_TGenCollection
#endif

#if defined(Uses_TGenCollection)
#define Uses_TStringCollection
#endif

#if defined(Uses_TStaticTextf)
#define Uses_TStaticText
#endif

#include <tv.h>

#include <string.h>

#if defined(Uses_TOutErr)
#include "touterr.h"
#endif

#if defined(Uses_TAsciiChart)
#include "ascii.h"
#endif

#if defined(Uses_TCalculator)
#include "calcul.h"
#endif

#if defined(Uses_TCalendar)
#include "calendar.h"
#endif

#if defined(Uses_TClockView)
#include "clock.h"
#endif

#if defined(Uses_TGenCollection)
#include "gencoll.h"
#endif

#if defined(__INPUT_INC)
#include "input.h"
#endif

#if defined(Uses_TComboBox)
#include "combobox.h"
#endif

#if defined(Uses_THeapView)
#include "heap.h"
#endif

#if defined(Uses_TFileView)
#include "fileview.h"
#endif

#if defined(Uses_TMenuItem)  || \
    defined(Uses_TSItem)     || \
    defined(Uses_TSubMenu)   || \
    defined(Uses_TStatusDef) || \
    defined(Uses_TStatusItem)
#include "menu.h"
#endif

#if defined(Uses_TStaticTextf)
#include "textf.h"
#endif



#define mfYesNo   (mfYesButton | mfNoButton)

#define TInput1Line(x, y, max)   TInputLine( TRect((x),(y),(x)+(max)+2,(y)+1), (max) )

#define T1StaticText(x, y, string)     TStaticText( TRect((x),(y),(x)+strlen(string)+1,(y)+1), (string) )

#define T1Label(x, y, string, link)    TLabel( TRect((x),(y),(x)+strlen(string)+1,(y)+1), (string), (link) )


void putCommand( ushort What, ushort Cmd );

void saveMouseState( void );
void restoreMouseState( void );

int appSystem( char *cmd );
#define dosShell()   appSystem( NULL )

void StatusBox( const char *message );
void StatusBoxf( const char *fmt, ... );
#define statusBox     StatusBox
#define statusBoxf    StatusBoxf

void RemoveStatusBox( void );
#define removeStatusBox()   RemoveStatusBox()

void appendStatusBox( const char *message );
void appendStatusBoxf( const char *fmt, ... );

Boolean existStatusBox( void );

ushort execDialog( TWindow *d, void *data = 0 );

void TwoButtons( TWindow *, int );
#define OKCancelButtons( window )     TwoButtons( window, 0 )
#define YesNoButtons( window )        TwoButtons( window, 1 )

ushort formatFloppy( int floppy );


#pragma option -Vo.
#if defined( __BCOPT__ )
#pragma option -po.
#endif

#endif __TVTOOLS_H_
