/***************************************************************************
  VESA unit
  VESA video mode routines
  PJB October 6, 1993, Internet mail to d91-pbr@nada.kth.se
  Copyright PJB 1993, All Rights Reserved.
  Free source, use at your own risk.
  If modified, please state so if you pass this around.

  This unit has been tested in protected mode with a PD VESA TSR.
  UNIVESA.EXE does not implement text mode support, so can't be used
  to test with.

  You can overlay this unit if you want to.

***************************************************************************/


#include "video.h"
#include "vesa.h"
#include "toycfg.h"

const
  VesaSignature vesaSig = "VESA";

ushort vesaVersion = 0;
Boolean vesaScanningSupported=False;
Boolean standardInfoAvailable=False;

/*******************************************************************
  Get VESA information (signature, version, video modes)
*******************************************************************/
Boolean getVesaInfo(VesaInfoBlock *vesaInfo)
{
  asm{
      mov  ax,0x4F00

     #ifdef DPMI
      mov  bx,vesaInfo.Word+2
      mov  RealModeRegs.TRealRegs.RealES,bx
      mov  di,vesaInfo.Word
      push 0x10
      call DPMI.RealModeInterrupt
     #else
      les  di,vesaInfo
      int  0x10
     #endif

      cmp  ax,0x004F
      mov  al,0
      jnz  fin
      inc  al
  }

 fin:
  return (Boolean)_AL;
}


/*******************************************************************
  Retrieve VESA video mode information
*******************************************************************/
Boolean getVesaModeInfo(ushort mode, VesaModeInfo *buffer)
{
  asm{
      mov  ax,0x4F01
      mov  cx,mode

     #ifdef DPMI
      mov  bx,buffer.Word+2
      mov  RealModeRegs.TRealRegs.RealES,bx
      mov  di,buffer.Word
      push 0x10
      call DPMI.RealModeInterrupt
     #else
      les  di,buffer
      int  0x10
     #endif

      cmp  ax,0x004F
      mov  al,0
      jnz  fin
      inc  ax

  }

 fin:
  return (Boolean)_AL;
}


/*******************************************************************
  Set VESA video mode
*******************************************************************/
void setVesaMode(ushort mode)
{
asm{
    mov  ax,0x4F02
    mov  bx,mode
    int  0x10
}
}


/*******************************************************************
  Retrieve current VESA video mode
*******************************************************************/
ushort getVesaMode()
{
  asm{
      mov  ax,0x4F03
      int  0x10
      xchg ax,bx
  }
  return _AX;
}


/*******************************************************************
  Get VESA version
*******************************************************************/
void detectVesaVersion()
{
 #ifdef DPMI
  vesaInfo      : PVesaInfoBlock;
  realBufferPtr : PVesaInfoBlock;
 #else
  VesaInfoBlock vesaInfo;
 #endif

 #ifdef DPMI
  if (!GetDosMem(Pointer(RealBufferPtr), Pointer(VesaInfo),
         sizeof(VesaInfoBlock)) )
    Exit;
  if (GetVesaInfo(RealBufferPtr) and (VesaInfo->VesaSignature==VesaSig) )
    VesaVersion=VesaInfo->VesaVersion;
  GlobalDosFree(Seg(vesaInfo^));
 #else
  if (getVesaInfo(&vesaInfo) && (vesaInfo.vesaSignature==vesaSig))
    vesaVersion=vesaInfo.vesaVersion;
 #endif
}


/*******************************************************************
  Determine available VESA text video modes
*******************************************************************/
void scanVesaModes(AddModeProc addMode)
{
  ushort *modes;
 #ifdef DPMI
  BufferPtr     : PVesaModeInfo;
  RealBufferPtr : PVesaModeInfo;
  VesaInfo      : PVesaInfoBlock ABSOLUTE BufferPtr;
 #else
  VesaModeInfo buffer;
 #endif

 #ifdef DPMI
  if( not GetDosMem(Pointer(RealBufferPtr), Pointer(BufferPtr),
         SizeOf(VesaInfoBlock)) )
    Exit;
  GetVesaInfo(PVesaInfoBlock(RealBufferPtr));
  Modes=DPMI.CreateRealModeSelector(VesaInfo->VideoModePtr, 0xFFFF);
 #else
  getVesaInfo((VesaInfoBlock*)&buffer);
  modes=((VesaInfoBlock*)&buffer)->videoModePtr;
 #endif

    while (*modes!=0xFFFF)
    {
     #ifdef DPMI
      if (GetVesaModeInfo(*Modes, RealBufferPtr) )
	with BufferPtr^ do
     #else
      if (getVesaModeInfo(*modes, &buffer))
     #endif
        if (buffer.attr.supported && !buffer.attr.graphics)
          if (buffer.attr.optionalInfo)
            addMode(*modes, buffer.height, buffer.width, buffer.charHeight,
                  Boolean(buffer.attr.color==1));
	  else
            switch (*modes)
	      case 2,3,7:
                addMode(*modes, 25, 80, 16, Boolean(*modes==3));

      modes++;
    }

   #ifdef DPMI
    FreeSelector(Seg(Modes^));
    GlobalDosFree(Seg(BufferPtr^));
   #endif
  }


/*******************************************************************
  Used to test if VESA Get Video Mode Info supported
*******************************************************************/
#pragma argsused
void far checkScanSupport(ushort mode, ushort rows, ushort columns, ushort charHeight, Boolean color)
{
  if (mode>7)
    vesaScanningSupported=True;
  else
    standardInfoAvailable=False;
}

/*******************************************************************
  Test the hard way if( VESA get video mode info Boolean supported
*******************************************************************/
Boolean vesaScanningPossible()
{
  standardInfoAvailable=True;
  if (vesaVersion)
    scanVesaModes(checkScanSupport);
  standardInfoAvailable=Boolean(!standardInfoAvailable);

  return vesaScanningSupported;
}

