;			        CIPHER
;
codeseg		segment
		assume	cs:codeseg, ds:codeseg
		org	100h
cipher		proc	far
 
start:
		mov	si,081h			; PSP command line buffer
cipher_ck:
		lodsb
		cmp	al,020h
		je	cipher_ck
		dec	si
		mov	di,si
		mov	c_start,si		; save start address
		cmp	byte ptr [si],0Dh	; error - no cipher string
		jne	cipher_get

		mov	dx,offset errmsg	; error message
		mov	cx,01Ah
		mov	bx,2			; std error output
		mov	ah,040h
		int	021h
	
Exit:		int	020h			; pgm terminate

cipher_get:
		lodsb				; measure cipher string
		cmp	al,020h
		je	cipher_len
		cmp	al,0Dh
		jne	cipher_get
cipher_len:
		dec	si
		mov	c_end,si		; point to end of cipher str
		mov	byte ptr [si],0		; null terminate string.
Main:
		cld
		mov	dx,offset last_line	; point to end of pgm block
		mov	cx,1000h		; arbitrary char count
		mov	bx,0			; std input
		mov	ah,03Fh			; input chars
		int	021h
	
		mov	cx,ax		; ax has actual input char count
		jcxz	Exit		; if it's 0, quit.
		push	cx		; save char count
		mov	bx,di		; save cipher offset in bx
		mov	si,dx		; point to buffer
		mov	di,dx
 
cipher_loop:
		cmp	bx,c_end	; see if we've reached end of cipher
		jne	cipher_it	; no? do it!
		mov	bx,c_start	; if so, start again.
cipher_it:
		mov	dx,[bx]
		mov	ax,6255h
		mul	dx
		add	ax,3619h
		mov	[bx],ax		; scramble cipher while we're at it
		inc	bx
		mov	dl,al		; remainder of the arithmetic
		lodsb
		xor	al,dl		; this encodes the character
		stosb			; and saves it (same address)
		loop	cipher_loop	; continue for cx chars
 
		mov	di,bx		; save bx
		pop	cx		; get saved char count
		mov	dx,offset last_line	; set up dx for output
		mov	bx,1			; std out
		mov	ah,40h			; output cx chars to std out
		int	21h
	
		jmp	short Main	; get more input.

c_start		dw	81h		; cipher string storage - initialized
c_end		dw	81h		; to PSP command line buffer.

errmsg		db	'Must specify a code word', 0Dh, 0Ah

last_line:	db	0		; marks last line of program.
 
cipher		endp
 
codeseg		ends
 
		end	start

