//--------------------------------BLURB.CPP---------------------------------
//
//  Blurb v2.0  This is the updated version of the fortune program.
//
//--------------------------------------------------------------------------
//
//                                 Notice:
//
//                      Confidential and Proprietary
//
//  This work contains valuable confidential and proprietary information.
//  Disclosure, use or reproduction without the written authorization from
//  Jon Privatt is prohibited.  This unpublished work by Jon Privatt is
//  protected by the laws of the United States and other countries.
//
//  If publication of the work should occur the following notice shall apply:
//
//  "Copyright (c) 1992, Jon Privatt, All Rights Reserved"
//
//--------------------------------------------------------------------------

#include <time.h>
#include <stdio.h>
#include <dos.h>
#include <conio.h>
#include <dir.h>
#include <stdlib.h>
#include <string.h>
#include <io.h>
#include <ctype.h>


//===========================COMPILER DEFINITIONS===========================


//===============================GLOBAL TYPES===============================


//=============================GLOBAL VARIABLES=============================
char  ch,
      *p,
      *q,
      outlines[26][134],
      blurb[1001];                // blurb input.

unsigned long
      choice,
      next=0,
      num;                     // number of blurbs

unsigned seed=0;

time_t first, second;
long curpos;

int   x=2,                     // current x position
      y=1,                     // current y position
      n=0,                     // position within blurb string!
      delayvalue=50,
      length,
      aa=2,
      nodelay=0,
      lines,
      words,                   // number of words in the blurb.
      mxx,                     // maximum x position
      mxy,                     // maximum y position
      bcolor=9,                // background color
      fcolor=15;               // foreground color

struct ftime
      fnow,                    // time/date of last reindex
      fthen;                   // time/date now

struct text_info
      ti;

enum BOOLEAN {false, true}
      quit=false,
      end=false,
      displayblurb=true,
      mixup=false,
      inorder=false,
      autodelay=false,
      border=true,
      hide=false,               // hide the author line.  Alters aa=0
      ERROR=false,              // error, Blurb renamed or altered if ==true.
      codes=true;

FILE *blurbs,                   // file containing the blurbs
     *cfg,                      // file containing configuration info.
     *idx;                      // index file to blurbs


//----------------------------------title------------------------------------
void title() {
  //Prints "Blurb v2.0"...encoded to prevent alteration.
  cprintf("%c%c%c%c%c%c%c%c%c%c",66,108,117,114,98,32,118,50,46,48);

  gotoxy((mxy-18),1);
  //Prints "Jon Privatt (c)1992"...encoded to prevent alternation.
  cprintf("%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c",74,111,110,32,80,114,105,118,97,116,116,32,40,99,41,49,57,57,50);
  }

//--------------------------------get_cfg-----------------------------------
int get_cfg() {

  p=searchpath("blurb.cfg");
  if((cfg=fopen(p,"rb"))==NULL) return 1;

  fseek(cfg,39,SEEK_SET);              // position past file header.

  fread(&num, sizeof(unsigned long), 1, cfg);
  fread(&border, sizeof(BOOLEAN), 1, cfg);
  fread(&hide,sizeof(BOOLEAN),1,cfg);
  fread(&bcolor, sizeof(int), 1, cfg);
  fread(&fcolor, sizeof(int), 1, cfg);
  fread(&delayvalue, sizeof(int), 1, cfg);
  fread(&codes,sizeof(BOOLEAN),1,cfg);
  fread(&autodelay,sizeof(BOOLEAN),1,cfg);
  fread(&fthen, sizeof(fthen), 1, cfg);
  fread(&next, sizeof(unsigned long), 1, cfg);
  fread(&inorder,sizeof(BOOLEAN),1,cfg);
  fread(&seed,sizeof(seed),1,cfg);
  fclose(cfg);
  return 0;
}


//-------------------------------save_cfg-----------------------------------
void save_cfg() {
  int yyyy;

  p=searchpath("blurb.cfg");
  if (p==NULL) {                  // file not in path. Create new one
    q=searchpath("blurb.exe");    //   wherever blurb.exe is located.
    yyyy=strlen(q)-3;
    q[yyyy++]='c';
    q[yyyy++]='f';
    q[yyyy]='g';
      if ((cfg=fopen(q,"w+b"))==NULL) {
      printf("Unable to create BLURB.CFG\n");
      exit(1);
      }
    }
    else {
      if((cfg=fopen(p,"w+b"))==NULL) {
	printf("Unable to create BLURB.CFG\n");
	exit(1);
	}
      }
  fputs("Blurb version 2.0\r\nConfiguration File\n",cfg); // File header.
  fputc(26,cfg);                                          // EOF mark.
  fwrite(&num, sizeof(unsigned long), 1, cfg);
  fwrite(&border, sizeof(BOOLEAN), 1, cfg);
  fwrite(&hide,sizeof(BOOLEAN),1,cfg);
  fwrite(&bcolor, sizeof(int), 1, cfg);
  fwrite(&fcolor, sizeof(int), 1, cfg);
  fwrite(&delayvalue, sizeof(int), 1, cfg);
  fwrite(&codes,sizeof(BOOLEAN),1,cfg);
  fwrite(&autodelay,sizeof(BOOLEAN),1,cfg);
  fwrite(&fthen, sizeof(fthen), 1, cfg);
  fwrite(&next, sizeof(unsigned long),1,cfg);
  fwrite(&inorder, sizeof(BOOLEAN), 1, cfg);
  fwrite(&seed,sizeof(seed),1,cfg);
  fclose(cfg);
}

//------------------------------reindex-----------------------------------
void reindex() {
  long fl;                           // total length of the file.
  long temp, percent, prev=-1;
  int yyyy;

  num=1;
  textcolor(7);
  textbackground(0);
  clrscr();
  title();
  gotoxy(1,3);
  cprintf("%clurbs has been altered.  %cuto-%ceindex %cngaged...",66,65,82,69);
  p=searchpath("blurbs");
  if((blurbs=fopen(p,"rt"))==NULL) {
    printf("Unable to find BLURBS\n");
    exit(1);
    }
  p=searchpath("blurb.idx");
  if (p==NULL) {                  // file not in path. Create new one
    q=searchpath("blurb.exe");    //   wherever blurb.exe is located.
    yyyy=strlen(q)-3;
    q[yyyy++]='i';
    q[yyyy++]='d';
    q[yyyy]='x';
    if ((idx=fopen(q,"w+b"))==NULL) {
      printf("Unable to create BLURB.IDX\n");
      fclose(blurbs);
      exit(1);
      }
    }
  else {
    if((idx=fopen(p,"w+b"))==NULL) {
      printf("Unable to create BLURB.IDX\n");
      fclose(blurbs);
      exit(1);
      }
    }
  fseek(blurbs,0L,SEEK_END);
  fl=ftell(blurbs);
  gotoxy(1,4);
  printf("%ceindexing:",82);
  if (fl>100) temp=fl/100;
  else percent=50;
  rewind(blurbs);
  curpos=ftell(blurbs);                 // write first record.
  fwrite(&curpos,sizeof(long),1,idx);
  while (fgets(blurb,1000,blurbs)!=NULL) {
    num++;
    curpos=ftell(blurbs);
    if (fl>100) percent=curpos/temp;
    if (percent!=prev) {
      gotoxy(13,4);
      prev=percent;
      printf("%ld%%",percent);
      }
    fwrite(&curpos, sizeof(long), 1, idx);
    }
  gotoxy(13,4);
  printf("100%%");
  gotoxy(1,5);
  printf("%lu BLURBS now indexed for maximum speed.\n",(num-1));
  displayblurb=false;
  fclose(idx);
  getftime(fileno(blurbs),&fthen);
  fclose(blurbs);
  save_cfg();
}


//-------------------------------get_idx-----------------------------------
void get_idx() {

  p=searchpath("blurbs");
  if((blurbs=fopen(p,"rt"))==NULL) {  // check for updated BLURBS
    printf("Unable to find BLURBS\n");
    exit(1);
    }
  getftime(fileno(blurbs),&fnow);
  fclose(blurbs);
  if ((fnow.ft_tsec!=fthen.ft_tsec)||(fnow.ft_min!=fthen.ft_min)||(fnow.ft_hour!=fthen.ft_hour)||(fnow.ft_day!=fthen.ft_day)||(fnow.ft_month!=fthen.ft_month)||(fnow.ft_year!=fthen.ft_year))
    reindex();

  p=searchpath("blurb.idx");
  if((idx=fopen(p,"rb"))==NULL) reindex();
  next++;
  if (next>num) next=0;
  if (inorder==true)
    choice = next;
  else
    choice = (rand()%num);
  curpos=(sizeof(long)*choice);
  fseek(idx,curpos,SEEK_SET);
  fread(&curpos,sizeof(long),1,idx);
  fclose(idx);

  p=searchpath("blurbs");
  if((blurbs=fopen(p,"rt"))==NULL) {
    printf("Unable to find BLURBS\n");
    exit(1);
    }
  fseek(blurbs,curpos,SEEK_SET);
  fgets(blurb,1000,blurbs);
  fclose(blurbs);
}


//----------------------------linelength-----------------------------------
int linelength() {
  int l;
  while (blurb[n]==' ') n++;
  if (border==true) {
    if ((length-n)<=(mxy-6)) {
      l=length-n;
      quit=true;
      }
    else {
      l=mxy-6;
      while (blurb[(n+l)]!=' ') l--;
      }
    }
  else {
    if ((length-n)<=mxy) {
      l=length-n;
      quit=true;
      }
    else {
      l=mxy;
      while (blurb[(n+l)]!=' ') l--;
      }
    }
  return l;
}

//-------------------------------printout------------------------------------
void printout() {
  int
      loop,
      pos;
  lines=0;
  if (border==true) {               // Set up the top line border.
    pos=0;
    while(pos<mxy) outlines[lines][pos++]='';
    outlines[lines][0]='';
    outlines[lines][(mxy-1)]='';
    lines++;
    }

  while(quit==false) {              // MAIN LOOP OF SUBROUTINE
    pos=0;
    if (border==true) {             // Set up the left margin.
      outlines[lines][pos++]='';
      outlines[lines][pos++]=' ';
      outlines[lines][pos++]=' ';
      }
    y=linelength();                 // Add a line.
    for (loop=0;loop<y;loop++)
      outlines[lines][pos++]=blurb[loop+n];
    n=n+y;
    while (pos<mxy) outlines[lines][pos++]=' ';
    if (border==true) {             // Set up the right margin.
      outlines[lines][(mxy-1)]='';
      }
    lines++;
    } // end while(quit==false)

  if (border==true) {               // Set up the bottom line border.
    pos=0;
    while(pos<mxy) outlines[lines][pos++]='';
    outlines[lines][0]='';
    outlines[lines][(mxy-1)]='';
    }
  else lines--;
}

//-------------------------------printit-----------------------------------

void printit() {
  int loop, loop2;

  for (loop=0;loop<=lines;loop++) {          // PRINT-OUT LOOP
    gotoxy(1,(loop+1+aa));
    for (loop2=0;loop2<mxy;loop2++)
      cprintf("%c",outlines[loop][loop2]);
    } // end loop
  }

//-------------------------------controlpanel--------------------------------
void controlpanel() {
  int i,ii;

  textcolor(fcolor);
  textbackground(bcolor);
  ii=((mxy/2)-20);
  gotoxy(ii,3);
  cprintf(" %cetup %cenu Ŀ",83,77);
  gotoxy(ii,4);
  cprintf("                                      ");
  gotoxy(ii,5);
  cprintf(" <%c>uto %cime %celay: ",65,84,68);
    if (autodelay==true) cprintf("%c%c                ",79,78);
    else cprintf("%c%c%c               ",79,70,70);
  gotoxy(ii,6);
  cprintf(" <%c>elay:  %d/100 second per word. ",68,delayvalue);
  if (delayvalue<10000) cprintf(" ");
  if (delayvalue<1000) cprintf(" ");
  if (delayvalue<100) cprintf(" ");
  if (delayvalue<10) cprintf(" ");
  cprintf("");
  gotoxy(ii,7);
  cprintf(" <%c>ackground %color                   ",66,67);
  gotoxy(ii,8);
  cprintf(" <%c>oreground %color                   ",70,67);
  gotoxy(ii,9);
  cprintf(" <%c>ide the %citle: ",72,84);
    if (hide==true) cprintf("%c%c%c%c%c%c             ",72,73,68,68,69,78);
      else cprintf("%c%c%c%c%c%c%c            ",86,73,83,73,66,76,69);
  gotoxy(ii,10);
  cprintf(" <%c>utlining %corder: ",79,66);
    if (border==true) cprintf("%c%c               ",79,78);
      else cprintf("%c%c%c              ",79,70,70);
  gotoxy(ii,11);
  cprintf(" <%c>election %cethod: ",83,77);
    if (inorder==true) cprintf("%c%c%c%c%c%c%c          ",73,78,79,82,68,69,82);
    else cprintf("%c%c%c%c%c%c%c%c%c%c       ",82,65,78,68,79,77,73,90,69,68);
  gotoxy(ii,12);
  cprintf("                                      ");
  gotoxy(ii,13);
  cprintf(" <%c>uit.                              ",81);
  gotoxy(ii,14);
  cprintf("                                      ");
  gotoxy(ii,15);
  cprintf("");
  gotoxy(mxy,mxx);
}

//-----------------------------------setup-----------------------------------
void setup() {
  int i,ii;
  long iii;

  clrscr();
  title();

  displayblurb=false;
  quit=false;
  while(quit==false) {
    controlpanel();
    ch=getch();
    switch (ch) {
      case 'a':
      case 'A':  if (autodelay==true) autodelay=false; else autodelay=true;
		 break;
      case 'd':
      case 'D':  gotoxy(1,16);
		 printf("Enter new delay value per word (100=1 second):");
		 scanf("%D",&iii);
		 if (iii<0) delayvalue=0;
		 else
		   if (iii>32000)delayvalue=32000;
		   else
		     delayvalue=(int)iii;
		 gotoxy(1,16);
		 printf("                                                      ");
		 break;
      case 'h':
      case 'H':  if (hide==true) hide=false;  else hide=true;
		 break;
      case 'B':
      case 'b':  bcolor++;
		 if (bcolor==16) bcolor=0;
		 break;
      case 'S':
      case 's':  if (inorder==true) inorder=false; else inorder=true;
		 break;
      case 'F':
      case 'f':  fcolor++;
		 if (fcolor==16) fcolor=0;
		 break;
      case 'o':
      case 'O':  if (border==true) border=false; else border=true;
		 break;
      case 'q':
      case 'Q':  quit=true;
		 if (delayvalue==0) autodelay=false;
		 save_cfg();
		 printf("\nInformation saved.\n");
		 break;
      default :  break;
      }
    }
  }

//----------------------------------info-------------------------------------
void info() {
  displayblurb=false;
  gotoxy(1,3);
  printf("%clurb v%c.%c %cnformation:\n\n",66,50,48,73);
  printf("%ciles %currently in %cse:\n",70,67,85);
  p=searchpath("blurb.exe"); printf("  %s\n",p);
  p=searchpath("blurb.cfg"); printf("  %s\n",p);
  p=searchpath("blurb.idx"); printf("  %s\n",p);
  p=searchpath("blurbs");    printf("  %s\n\n",p);
  printf("%clurbs on %cile:  %lu\n\n",66,70,num);
  printf("%ccreen:\n",83);
  printf("  %ceight:  %d\n",72,mxx);
  printf("  %cidth:   %d\n",87,mxy);
  exit(0);
  }

//-----------------------------------hlp-------------------------------------
void hlp() {
  int i;

  displayblurb=false;

  gotoxy(1,2);
  i=0;
  while (i++<mxy) printf("");

  gotoxy(1,4);
  i=0;
  while (i++<mxy) printf("");

  gotoxy(((mxy-20)/2),3); printf("%candom %clurb %celector",82,66,83);
  gotoxy(1,6);
  printf("%cormat:  %clurb (argument)\n",70,66);
  printf("(arguments)\n");
  printf(" /setup   %clurb setup menu.\n",66);
  printf(" /index   %corced reindexing.\n",70);
  printf(" ?        %chis help screen.\n",84);
  printf(" /info    %configuration information.\n",67);
  printf(" /delay   %cverrides setup option and uses delay.\n",79);
  printf(" /nodelay %cverrides setup option and uses no delay.\n\n",79);
  printf("%clease see the file %c%c%c%c%c.%c%c%c for more information.\n\n",80,66,76,85,82,66,68,79,67);
  if (1==0) printf("Error:  Adlib not responding.");
//  printf("Blurb has no warranties, expressed or implied.  Responsiblity of any\n");
//  printf("damage resulting from the use of this program falls completely upon the\n");
//  printf("user, the author will not be held responsible for any damage caused by\n");
//  printf("the program.  Blurb is freeware, however, donations would be appreciated\n");
//  printf("to spur the author to develop further software.\n");
//  printf("Blurb is written in C++ by a starving MBA student.  Any comments, questions,\n");
//  printf("recommendations, or donations should be sent to:\n");
//  printf("                           Jon Privatt\n");
//  printf("                           1400 Warren St.\n");
//  printf("                           Mankato, MN  56001");
  exit(0);
}

//---------------------------------timeout-----------------------------------
void timeout() {
  int i;
  double tt,ttemp;

  first=time(NULL);
  words=1;
  for (i=0;i<n;i++)                // compute number of words in message
    if (blurb[i]==32) words++;

  ttemp=(double)delayvalue;
  tt=(ttemp/100)*words;             // time delay, watch keyboard.
  save_cfg();
  second=time(NULL);
  while ((difftime(second,first)<tt)&&(words!=0)) {
    if (kbhit()) {
      words=0;
      getch();
      }
    second=time(NULL);
    }
  }

//-----------------------------------main------------------------------------
void main() {
  int i;

  textcolor(7);
  textbackground(0);
  clrscr();
  gettextinfo(&ti);
  mxy=ti.screenwidth;
  if (mxy>132) mxy=132;
  mxx=ti.screenheight;
  if (get_cfg()!=0) save_cfg();
  title();

  // Future blurbs may print special messages the first time on mondays and
  // fridays.  "I hate mondays"  "Thank God it's Friday!"
  // This would require blurb.cfg to be updated on every run and save the
  // date (maybe even the time) when it was last run.
  // Lunchtime messages could also appear.  These messages are optional to
  // the user.  Clock/Calendar-based messages:  Enabled/Disabled.
  // (A sophisticated version would be a special text file which could define
  //  when and what message to display...)

  // Still need the first liner option (as per user definition).

  p=searchpath("blurb.exe");                      // Check for Errors
  if (p==NULL) ERROR=true;        // not in path or renamed.


  if (ERROR==true) {
    gotoxy(1,3);
    printf("%cey!  I cannot find BLURB.EXE!\n\n",72);
    printf("%clurb will not work properly when it\n",66);
    printf("has been renamed, or isn't located\n");
    printf("in the system's %c%c%c%c.\n\n",80,65,84,72);
    exit(0);
    }

  if (_argc>1) {
    if (strstr(_argv[1],"?")!=NULL) hlp();
    p=strupr(_argv[1]);
    if (strstr(p,"INDEX")!=NULL) reindex();
    if (strstr(p,"SETUP")!=NULL) setup();
    if (strstr(p,"INFO")!=NULL)  info();
    if (strstr(p,"DELAY")!=NULL) nodelay=2;
    if (strstr(p,"NODELAY")!=NULL) nodelay=1;
    }

  if (hide==true) aa=0;
  textcolor(fcolor);
  textbackground(bcolor);
  if (seed>=65535) seed=0;        // randomize!!
  else seed++;
  srand(seed);

  get_idx();
    if (displayblurb==true) {
    while (strlen(blurb)<2) get_idx();
    length=(strlen(blurb)-1);
    printout();
    printit();
    if (nodelay==0) {
      if (autodelay==true)
	timeout();
      else
	save_cfg();
      }
    else
      if (nodelay==2)
	timeout();
      else
	save_cfg();
    }
  printf("\n");
  }
