'ADDNUMBER ADD OR REMOVES LINENUMBERS TO FILES                                     *
'Designed as an assistance to debugging unnumbered QuickBasic code
'(c) 1990 by DAVID WESSON, PhD.
'
' $INCLUDE: 'qb.bi'
'
DECLARE FUNCTION exists (filename$)

DIM SHARED inregs AS RegTypeX, outregs AS RegTypeX
CONST YES = 1, NO = 0

	CLS
READCOMMAND:
	a$ = COMMAND$
SPLITLINE:                                             'separate words in line
	  DIM arg$(4)
	  W = 1: word$ = ""                                 'and returns lowercase
	  FOR x = 1 TO LEN(a$)
			y$ = MID$(a$, x, 1): y = ASC(y$)
					IF y = 32 AND LEN(word$) < 1 THEN GOTO NEXTX
					IF y > 64 AND y < 91 THEN
						  y$ = CHR$(y + 32)
						  word$ = word$ + y$
						  GOTO NEXTX
					END IF
					IF y = 32 AND LEN(word$) > 1 THEN
						  arg$(W) = word$: W = W + 1: word$ = ""
						  GOTO NEXTX
			END IF
		 word$ = word$ + y$
NEXTX: NEXT x
	  IF LEN(word$) > 1 THEN arg$(W) = word$
BEGINNING:
	infile$ = arg$(1)
	IF infile$ = "" THEN GOTO HELP
	IF exists(infile$) = NO THEN GOTO NOFIND
	OPEN infile$ FOR INPUT AS 1
	GOSUB filename
	answer$ = file$
	oldfile$ = file$ + ".OLD"
	outfile$ = file$ + ".tmp"
	OPEN outfile$ FOR OUTPUT AS #2
	IF arg$(2) = "/a" THEN
		pro$ = "Adding linenumbers for "
	ELSEIF arg$(2) = "/r" THEN
		pro$ = "Removing linenumbers for "
	ELSE GOTO BADINSTRUCT
	END IF
HEADER:
	  COLOR 15: PRINT "ADD NUMBER  "; : COLOR 7: PRINT "adds or removes linenumbers from files."
	  PRINT pro$; infile$; ", creating backup as "; oldfile$
	  PRINT "Hit [Ctrl]+[Break] to terminate."
	  GOSUB TIME
	  PRINT "      Start time:"; newtime$
	  PRINT " Processing Line: "
	  z = 0
CYCLE:
	WHILE NOT EOF(1)
		LINE INPUT #1, l$
		LOCATE 5, 18: PRINT z
		z = z + 1
		IF arg$(2) = "/a" THEN
			PRINT #2, USING "####"; z;
			PRINT #2, " "; l$
		ELSEIF arg$(2) = "/r" THEN
			PRINT #2, MID$(l$, 6)
		END IF
	WEND
	GOTO FINISH
'*************************** GENERAL SUBROUTINES ******************************
TIME:
	  intime$ = TIME$                                     'current time changed
			hour$ = MID$(intime$, 1, 2)                     'to newtime$
			min$ = MID$(intime$, 4, 2)
			sec$ = MID$(intime$, 7, 2)
			hour = VAL(hour$)
				  IF hour < 12 THEN ampm$ = "am" ELSE ampm$ = "pm"
				  IF hour > 12 THEN hour = hour - 12
			hour$ = STR$(hour)
	  newtime$ = hour$ + ":" + min$ + ":" + sec$ + " " + ampm$
	  RETURN
'****************************** HELP AND ERROR ROUTINES ***********************
HELP:
	  PRINT " "
	  PRINT "ADDNUMBER  adds or removes linenumbers from files. "
	  PRINT "                                            (c) 1990 David A. Wesson"
	  PRINT " "
	  PRINT "Syntax: ADDNUM [d:]oldfile  /A/R"
	  PRINT " where  oldfile = original file (with .ext) [drive optional]      "
	  PRINT "       /A or /R = /A to ADD linenumbers, /R to REMOVE linenumbers"
	  PRINT ""
	  PRINT "NOTE: This procedure will work on any ASCII file, but only"
	  PRINT "      9999 lines will be numbered. Use REMOVE only on files"
	  PRINT "      with numbers ADDED by ADDNUMBER, since the first 5"
	  PRINT "      characters of each line are dropped in REMOVE processing."
	  PRINT "      A backup of the original called .OLD will be made."
	  END
NOFIND:
	  PRINT "ERROR: No file by that name found."
	  GOTO HELP
BADFILE:
	  PRINT "ERROR: Duplicate or missing filename."
	  GOTO HELP
BADINSTRUCT:
	  PRINT "ERROR: Bad or missing instruction."
	  GOTO HELP
FINISH:
	  CLOSE
	  IF exists(oldfile$) = YES THEN KILL oldfile$
	  NAME infile$ AS oldfile$
	  NAME outfile$ AS infile$
	  GOSUB TIME
	  PRINT "     Finish time:"; newtime$
	  END
filename:                                         'splits infile$ into
		  period = INSTR(infile$, ".")              'file$ and ext$
		IF period = 0 THEN
			file$ = UCASE$(infile$)
			ext$ = ""
			ELSE
				file$ = UCASE$(LEFT$(infile$, period - 1))
				ext$ = UCASE$(MID$(infile$, period + 1))
		END IF
		RETURN

FUNCTION exists (search$)
	 savefile$ = search$
	 inregs.ax = &H4E00
	 inregs.cx = 1     '3 for hidden
	 search$ = search$ + CHR$(0)
	 inregs.dx = SADD(search$)
	 inregs.ds = -1
	 CALL INTERRUPTX(&H21, inregs, outregs)
	 IF (outregs.flags AND 1) = 1 THEN
			exists = NO
	 ELSE
			exists = YES
	 END IF
	 search$ = savefile$
END FUNCTION

