#include<stdio.h>
#include<string.h>
#include<malloc.h>
#include<stdlib.h>
#include<ctype.h>
#include<values.h>
#include<stdarg.h>
#include<dirent.h>
#include<sys/types.h>
#include<sys/stat.h>



/*
   LM  version 2.06  29 January 1997

   AUTHOR:  Zhuhan Jiang,
	    University of New England,
	    Armidale NSW 2351, Australia.
	    zjiang@metz.une.edu.au

   LM is written primarily for purpose of assisting writing
   batch file in DOS or shell script in UNIX. It is compilable
   under either BORLANDC C++ 3.1 in COMPACT mode in DOS or gcc in UNIX.

   To compile:
	    DOS:    bcc -mc lm.c
	    UNIX:   gcc -DUNIXMODE lm.c

   To generate the user manual in DOS
	    bcc -DLINKMANUAL -ml lm.c
	    lm -hH > lm.man

   Functions that are specific to either DOS or UNIX are avoided
   in general, though not completely.

   One purpose of this program is to be run across different
   platforms with least possible hardware-dependent features
   or functions.  Hence sometimes the speed performance is
   the price to pay in the algorithm or strategy.


   LIMITATION:
	a line over the length of integer size will cause
	automatic spliting, though it often makes no difference
	to the output. An warning will be issued in this case.
*/





/* #define DEBUGMODE  */
		 /* uncomment above line, if you want to test whether
		    the option characters are valid.
		    comment it out in the final compilation
		 */


/* #define UNIXMODE   */
		 /* uncomment above line, if it's for UNIX.
		    UNIX format   dir1/dir2/file or /dir1/file
		    DOS  format   c:dir1\file c:\dir1\file dir1\file
				  (and case-insensitive)
		 */

/* #define LINKMANUAL  */
		 /* uncomment above line, if you want the whole
		    manual be linked with the program (thus readable
		    via option -hH
		 */



#ifdef UNIXMODE
#define DOSMODE 0
#include <unistd.h>
#define clreol()  fprintf(fptr,"  %c[K", 27)
#define CLREOL()  fprintf(namefptr, "%c[K",27)

#else
#define DOSMODE 1
#include <conio.h>
#include <dos.h>
#include <time.h>
#include <direct.h>
#include <dir.h>
#define CLREOL() clreol()
#endif


#ifndef max
#define max(a,b) (((a)>(b))? (a):(b))
#endif

#ifndef min
#define min(a,b) (((a)<(b))? (a):(b))
#endif

#define upcase(ch)  ( (((ch)>='a')&&((ch)<='z'))? ((ch)-'a'+'A'):(ch) )
#define lowcase(ch)  ( (((ch)>='A')&&((ch)<='Z'))? ((ch)-'A'+'a'):(ch) )


#ifdef UNIXMODE
#define DIRMARKER '/'
#else
#define DIRMARKER '\\'
#endif


#define S_BUFWIDTH  1024       /* hold a keyboard line etc */
#define L_BUFWIDTH  (1024*10)  /* input buffer */

#define MY_CLK_TCK    182
		 /* 10 times of CLK_TCK
		    This is to avoid decimal calculations so as
		    to shrink to program code in DOS
		 */


/* struct to hold a general entry of command parameter */
typedef struct chainbuf
	{ int  numone, numtwo;
	  char *strone, *strtwo;
	  struct chainbuf *prev, *next;
	} chain;


/* struct for DOS parents' PSP */
typedef struct pspbuf
	{ unsigned envsize,env, psp /* ,memsize,parent */ ;
	  struct pspbuf *prev, *next;
	} pspchain;




int OVERFLOW=0;                 /* line two long flag */
int CTRLBRK_KEY=0;              /* exitcode of ^break under DOS */
int MAXLINEWIDTH=MAXINT/3*2;    /* default max line width
				   must at least MAXLINEWIDTH < int */

chain *ENVFILENAMES=NULL;
   /* 'temporary' filenames given by environment parameter LMFILES */

char *TMPFILENAME=NULL, *ENVTMPDIR=NULL;
   /* tmp file to be deleted on ctrl_C in DOS
      In UNIX, such files will be left in /tmp/ and will thus be
      automatically deleted later on by the system */


/* debug purpose, for memory usage checking  */
int  GETFREELEVEL=0;
#define FREE(a)    free((GETFREELEVEL--, a))
#define MALLOC(a)  malloc((GETFREELEVEL++, a))




void printhelp(char *cmd)

#ifndef LINKMANUAL
{ if(cmd==NULL) cmd="LM";
  printf("%s manual not linked in this compact version.",cmd);
}


#else

{ if(cmd==NULL) cmd="LM";
printf("\
\n\
								%s(1)\n\
\n\
\n\
\n\
   Name\n\
     %s  - file or stream line manipulator  (ver 2.06)\n\
\n\
   Syntax\n\
     %s [-options] [-@] [offstrs ...]\n\
\n\
   Description\n\
     The %s command inputs line by line from files or stdin,\n\
     then manipulate the line according to the command line\n\
     options before sending the final form to a file or stdout.\n\
     If the final form of the line contains any/all the strings\n\
     specified in offstrs, then that line will not be output --\n\
     and is thus non-gripped. We note that the earlier version\n\
     of this utililty is call NG or NGRIP.\n\
\n\
     The main operations supported are grip/non-grip,\n\
     search/replace, synchronised line appendage from other\n\
     files, input/output line selection by line numbers or\n\
     passwords, spaces/empty lines absorption, filewise update\n\
     or renaming, line width imposition and etc. Input lines\n\
     can also be taken from only the command line.\n\
\n\
     All valid options strings must be immediately preceded by\n\
     '-', or a valid option entry of single character or number\n\
     option character type, see below. An invalid option string\n\
     becomes a part of offstrs. However, offstrs can also be\n\
     entered as normal parameters via -~offstrs. To force the\n\
     current valid option string as the last option string,\n\
     include '@' in that string.\n\
\n\
     Duplicated execution of %s maybe separately by \"-;\", while\n\
     long command parameters maybe taken from files via\n\
     \"-<filenames\" from which each separate line serves as one\n\
     execution of the %s. These two functions are largely\n\
     implemented to overcome the time waste of reloading %s for\n\
     multiple executions, and the maximum line width of a\n\
     command in DOS.\n\
\n\
     There are three types of option characters\n\
       1. String option character:\n\
	    all the characters in that string after the string\n\
	    option character compose a single substring that\n\
	    becomes the parameter specified by the option\n\
	    character.\n\
       2. Number option character:\n\
	    all the digits and possibly a leading '-' will be\n\
	    converted into an integer that becomes the\n\
	    parameter specified by the number option character.\n\
	    If no immediate digits are present, 0 is the\n\
	    default parameter number.\n\
       3. Simple single character:\n\
	    it can be put anywhere (not after string option\n\
	    character of course)\n\
\n\
     Directives via multi parameters specified by a same option\n\
     character will be performed sequentially. Thus all files\n\
     of a same purpose will for instance be read sequentially.\n\
\n\
     Different operation tasks are performed in the following\n\
     sequential order\n\
\n\
	-@  -<*  -;*  -hH -j# -v  -V  -X#  -/#  -{#(X13)  -[]*\n\
	-}*  -BE*(#)  -zZ#  -$*(j20-j28 &1-4)  -c#  -:*  -^*(+1)\n\
	-fF*(+0X#)  -*`*  -pP*(M#+2)  -iI#  -lL#  -sS#  -dD*(C2n#)\n\
	-g*(G#J1!#j9)[X5]  -qr*(j1j2j6-8)  -QR*(j3j4j6-8)  -()*\n\
	-m*(C3kK*)  -Y#  -t#  -T#  -a  -A*  -~*(C1J2)\n\
	-=#(X1)  -y#  -oO#(N#!#) -!#  -N#  -be*(#)  -w#(W#)\n\
	-uU*(+3)  -#?  -#?(even no. of such options)\n\
	-.#  -x#\n\
\n\
	(-=# -zZ# -$* -&# -j20-j28 are supported in DOS only)\n\
\n\
     where * is a string, # or ? (after a character) is a\n\
     number and the options in the parentheses are the related\n\
     flags, and those in square brackets are forced options.\n\
\n\
   Options\n\
     -a     absorb white spaces\n\
     -A*    add substr * in front of each character, other\n\
	    than the ending linebreak '\\n'. If the combined\n\
	    string is '0xff'?$, where ? is any char and $ is\n\
	    any string, then the char represented by ? will\n\
	    represent in $ the char that the whole string is\n\
	    in front of.    e.g. lm -/255A#x#y will translate\n\
	    input \"abc\" into  \"xayaxbybxcyc\".\n\
     -b*    strings * to be added at the beginning of each\n\
	    output line\n\
	    (cf. -e* -B* -E* -#)\n\
     -B*    strings * to be added at the beginning of the\n\
	    whole output\n\
	    (cf. -E* -b* -e* -#)\n\
     -c#    input comes only from the command line\n\
	      0=input only\n\
	      DOS meaningful:\n\
	      1=output path to the current copy of %s\n\
	      2=output full pathname of current %s\n\
		(output immediately after -B*)\n\
	    (cf. -:*)\n\
     -C#    case insensitive.\n\
	      0=no case for all (1,2,3 below)\n\
	      1=no case for non-grip (command line strs or -~*)\n\
	      2=no case for delimitered locate (-d* -D*)\n\
	      3=no case for mask filter (-m*)\n\
	      default: case sensitive\n\
     -d*    left delimiter string * to locate a substring\n\
	    (cf. -D* -C# -n#)\n\
     -D*    right delimiter * to locate/filter through a sub\n\
	    string\n\
	    (cf. -d* -C# -n#)\n\
     -e*    strings to be appended at end of each output line\n\
	    (cf. -b* -B* -E* -#)\n\
     -E*    strings * appended at the end of whole output\n\
	    (cf. -B* -b* -e* -#)\n\
     -f*    filename * for input, empty * implies stdin device.\n\
	    -f//# will replace //# by the #th-entry of the\n\
	    environmental parameter LMFILES (if it exists),\n\
	    separated by \";\" for DOS or \":\" for UNIX.\n\
	    (cf. -** -F* -+# -X7)\n\
     -F*    input filename *, support wild cards '*' and '?'\n\
	    in the UNIX convention. -F will also default to -X5\n\
	    unless -X# option is explicitly entered. -F* will\n\
	    make first level expansion of wild card filenames\n\
	    before any line input is done.  In the case of\n\
	    -F//*, * will be parsed and each entry separated\n\
	    by ';' for DOS or ':' for UNIX will be treated\n\
	    separately. e.g. -F//one*;two?? will be parsed as\n\
	    -Fone* -Ftwo??\n\
	    (cf. -** -`* -f* -+# -X5 -X7)\n\
     -g*    keep/output current line if it matches string * in\n\
	    the sense specified by -G#. If any of options -j9, -(*\n\
	    and -)* is present, -g* no longer grips lines for\n\
	    output. Instead, it lets all lines into output while\n\
	    marking those conaining specified substr for treatment\n\
	    by the -(* -)* options. In the case of -j9 being present,\n\
	    replacement via -qrQR* are applicable only to those\n\
	    gripped lines\n\
	    (cf. -G# -!#)\n\
     -G#    comparison mode:  (not co-existent)\n\
	      0=identical\n\
	      1=substring inside main line (default)\n\
	      2=identical upto letter case\n\
	      3=substring inside main line upto letter case\n\
	      4=identical upto case and consecutive spaces\n\
	      5=substring inside main line upto case and\n\
		consecutive spaces, e.g. \"ab AB\" = \"ab   AB\"\n\
	     10-15=0-5 plus interpretation for wild cards '*'\n\
		   and '?' in the UNIX convention.\n\
	    (cf. -g* -M#)\n\
     -h     simple help    =-? /? /h /H\n\
	    the above variants become active only if '@' is not\n\
	    used to terminate the option strings. It is used to\n\
	    guess user's intention to seek help.\n\
	    (cf. -H)\n\
     -H     further help. -hH will output this manual.\n\
	    (cf. -h)\n\
     -i#    lines after and including #-th one from input will\n\
	    be read in\n\
	      #<0 =reset line counter to 0 filewise\n\
	    (cf. -I# -o# -O# -p* -P*)\n\
     -I#    lines after #-th one from input will be dumped\n\
	    (cf. -i# -o# -O# -p* -P*)\n\
	      #<0 =reset line counter to 0 filewise\n\
     -j#    mode of string replacement\n\
	      1=replace all found strings via -qr (default)\n\
	      2=replace strings which start from the first\n\
		letter of the line for via -qr\n\
	      3=replace all via -QR (default)\n\
	      4=replace far left string via -QR\n\
	      5=normal mode\n\
	      6=only words separated by non-alphabets are to\n\
		be replaced\n\
	      7=only words separated by non-alphabets other\n\
		than '_' are to	be replaced\n\
	      8=only words separated by space or tab are to be\n\
		replaced\n\
	      9=replace only those strs in the lines gripped via\n\
		the -g* option (changes normal meaning of -g)\n\
	     10-19=change buffer line width to MAXINT/11*(j-9)\n\
	     20-28=(DOS only)\n\
		   keyboard instant input of a char via -$*,\n\
		   the opposite of the following 20-27 is the\n\
		   default mode\n\
	     20=match is case insensitive\n\
	     21=char echo off\n\
	     22=escape key enabled: escape key leaves the\n\
		direct key input mode\n\
	     23=no beep at an unexpected key\n\
	     24=exitcode returned in the end will be the ASCII\n\
		char code instead of the position found in the\n\
		string given via -$*\n\
	     25=clear keyboard buffer first\n\
	     26=no loop: leave immediately after getting a key,\n\
		whether it is valid or not\n\
	     27=no wait: get a key from keyboard buffer, leave\n\
		immediately afterwards. Priority over looping.\n\
	     28=get extended keys. In this mode extended keys\n\
		can be filtered in via -$* directly\n\
	     <0=maximum line width is forced to corresponding\n\
		absolute value #\n\
	    (cf. -q* -r* -Q* -R* -$*)\n\
     -J#    AND mode for multi-string search\n\
	      0=AND mode for all (1+2 below)\n\
	      1=for grip via -g*\n\
	      2=for non-grip via -~* or offstrs\n\
	    (cf. -g* -~*)\n\
     -k#    character of ASCII code # is accepted as one of the\n\
	    pre-delimiters for the masked filter via -m* .\n\
	    default pre-delimiters=\" \\n\"\n\
            (cf. -K# -m*)\n\
     -K#    character of ASCII code # as one of the post-\n\
            delimiters for the masked filter via -m*.  All\n\
            pre-delimiters that are not in the post-delimiters\n\
	    will be translated into the post-delimiters if\n\
	    successfully filtered.\n\
	    default post-delimiters=\" \\n\", -kK0=no delimiters\n\
	    (cf. -k# -m*)\n\
     -l#    letters in any line will be kept after and including\n\
	    the #-th letter\n\
	    (cf. -L# -s# -S#)\n\
     -L#    letters in any line will not be kept after #-th one\n\
            (cf. -l# -s# -S#)\n\
     -m*    string * as mask (no wild cards) for filtering\n\
	    through the substrings *.\n\
	    (cf. -C# -k# -K#)\n\
     -M#    comparison mode for input password on/off switch,\n\
	    see -G# for the meaning of #.\n\
	    default: #=1 (inside, case sensitive)\n\
	    (cf. -p* -P* -G#)\n\
     -n#    directive for locating substrings via -d* -D*\n\
	      0=find the last occurrence, i.e. find from right\n\
		hand side\n\
              1=located substring will go along with its\n\
                delimiters\n\
		default: find from the left, delimiters will be\n\
		striped off\n\
	    (cf. -d* -D* -C#)\n\
     -N#    total number of allowed output lines, terminate\n\
	    immediately when reached\n\
	      #<0 =reset output line counter to 0 filewise\n\
	    (cf. -o# -O#)\n\
     -o#    output lines after and including the #-th line\n\
	    will be sent to stdout, -o# -O# can be given in\n\
	    any order as the program will figure out a\n\
	    meaningful collection of choice intervals.\n\
	      #<0 =reset line counter to 0 filewise\n\
	    (cf. -O# -N# -!# -i# -I#)\n\
     -O#    output lines after #-th line will not be sent to\n\
	    the stdout\n\
	      #<0 =reset line counter to 0 filewise\n\
	    (cf. -o# -N# -!# -i# -I#)\n\
     -p*    password to switch on/off the input, the current\n\
	    line will not be taken. Only one switch per line\n\
	    may be performed.\n\
	    (cf. -M# -i# -I#)\n\
     -P*    password * to switch on/off the input, the current\n\
            line will be taken\n\
            (cf. -M# -i# -I#)\n\
     -q*    search string * for replacement, case sensitive\n\
	    (cf. -r* -j# -Q* -R*)\n\
     -Q*    search string * for replacement, no case\n\
	    (cf. -R* -j# -q* -r*)\n\
     -r*    replaced string *, for the case sensitive search\n\
	    via -q*\n\
	    (cf. -q* -j# -Q* -R*)\n\
     -R*    replaced string *, for the case insensitive search\n\
            via -Q*\n\
	    (cf. -Q* -j# -q* -r*)\n\
     -s#    string/word after and including the #-th one will\n\
	    be kept\n\
            (cf. -S# -l# -L#)\n\
     -S#    string/word after the #-th one will be dumped\n\
            (cf. -s# -l# -L#)\n\
     -t#    translate characters\n\
	      0=TAB to single space\n\
	      1=convert to upper case (priority)\n\
	      2=convert to lower case\n\
	      3=reverse the order of characters in a line\n\
     -T#    trim off the leading and trailing spaces\n\
	      0=1+2 of the options below\n\
	      1=remove leading spaces/TABs\n\
	      2=remove trailing spaces/TABs\n\
     -u*    file * whose lines will be added in front of each\n\
	    input line in the synchronised mode\n\
	    (cf. -U* -+# -w#)\n\
     -U*    file * whose lines will be added at the end of each\n\
	    input line in the synchronised mode\n\
	    (cf. -u* -+# -w#)\n\
     -v     view the command parameters, as understood by the\n\
	    computer\n\
     -V     the strings specified via -beBE$ will be sent to\n\
	    the stderr.\n\
     -w#    wrap line into no more than the width #. If -u* or\n\
	    -U* are present, then -w# is disabled.\n\
	    (cf. -W# -u* -U*)\n\
     -W#    width of line-wrap control\n\
	      0=1+2 of the options below\n\
	      1=protect words  (default: no protection)\n\
	      2=pad spaces on the right upto the width given\n\
		via -w#\n\
	      3=pad spaces on the right without break up lines\n\
	    (cf. -w*)\n\
     -x#    exit error level request of type #\n\
	      0=any of the followings has been achieved\n\
	      1=pP (-p -P are the corresponding option letters)\n\
	      2=empty input\n\
	      3=lL    4=sS    5=dD     6=qrQR    7=g      8=m\n\
	      9=t    10=T    11=Y     12=a      13=A     14=N\n\
	      15=y   16=~ or non-grip (command line strs)\n\
	      17=-=* successful (DOS only)\n\
	      18=dir/file names via -fF matched with -* -` options\n\
	      19=readable filenames via -fF matched with -* -`\n\
	      20=exit code is number of output lines + initial\n\
		 number given via -#. Lines given via -beBEw\n\
		 are not counted, lines linked via -Y# will\n\
		 still be counted separately. If -# is entered\n\
		 even number of times, the virtual input line\n\
		 number plus the initial number specified by the\n\
		 sum of the -# option will be the exit code.\n\
	      21=some lines not gripped nor accepted via -!, when\n\
		 a -g option is present. This option is disabled\n\
		 -(* or -)*\n\
	      -$* overrides exitcode request via -x#.\n\
	    (cf. -.#)\n\
     -X#    message display level\n\
	      0=1+2\n\
	      1=suppress the line width overflow warning, or\n\
		warning for unable to set (some) environment\n\
		parameters\n\
	      2=no input filenames display\n\
	      3=input filenames sent to stderr device\n\
	      4=input filenames sent to stdout or output file\n\
	      5=display all filenames searched/failed to stderr\n\
	      6=display all filenames searched/failed to stdout\n\
		or the output file\n\
	      7=display extra filenames for the matched entries\n\
	      8=same as 7, except without the prompt \"MATCHED: \"\n\
	      9=display in 7/8 dir names\n\
	     10=display in 7/8 file names\n\
	     11=always display all file names to stderr\n\
	      default=none of the above, unless -F option is\n\
		      used in which default=-X5\n\
	      When -X7 or -X8 is present, if neither -X9 nor -X10\n\
	      is present, then all dir/file names will be\n\
	      displayed with \"+\" added to the front of the\n\
	      directory names.\n\
	     12=quiet: no messages for rename filewise via -{1[*]*\n\
		Otherwise output to device stderr or stdout\n\
	     13=allow overwrite via -{2 (double confirmation)\n\
\n\
	     99=programmer's memory report, 0=all memory released\n\
	    (cf. -F*)\n\
     -y#    empty line deletion\n\
	      0=consecutive empty lines become one single empty\n\
		line\n\
	      1=remove all empty lines\n\
	      2=consecutive duplicated input lines will be left\n\
		with just one input line\n\
	     <0=consecutive lines considered mathched as in 2\n\
		if (-#)-th words are matched correspondingly.\n\
		Action in 2 will then be performed. Empty words\n\
		are always matched.\n\
     -Y#    line link-up (line break deletion)\n\
	    linebreak becomes/absorbed-into a white space.\n\
	      0=paragraph become a single line\n\
	      1=whole input becomes a single line\n\
     -z#    (DOS only) play sound of frequency # immediately\n\
	    after -B* with duration given via -Z#\n\
	    (cf. -Z#)\n\
     -Z#    (DOS only) sound duration in milliseconds matching\n\
	    the frequency one by one given via -z#\n\
	    (cf. -z#)\n\
     -<*    take line by line from file *, as if they are\n\
	    the command parameters. This option is to enable\n\
	    long command parameters to be treated properly.\n\
	    -<* has priority over -;*\n\
	    (cf. -;* -~*)\n\
	    When -<* type options are present, then all command\n\
            parameters upto the last occurrence of -<* will be\n\
            processed first if there's at least one separate\n\
	    option appears in front of the string that contains\n\
            the first -<* type option, otherwise such\n\
	    intermediate options will be ignored. If there are\n\
            further options string after the last occurrence of\n\
	    -<*, %s is run again with these option parameters.\n\
            e.g.\n\
	      %s -a \"-Y<file1\" -y \"-t<file2\" -w60\n\
	    gives essentially the output of\n\
	      %s -aYyt | %s \"-<file1\" \"-<file2\" |%s -w60\n\
	    while\n\
	      %s  \"-Y<file1\" -y \"-t<file2\"\n\
	    gives the output of\n\
	      %s  \"-<file1\"  \"-<file2\"\n\
            as the 'middle' options -Yyt under such circumstance\n\
	    is best ignored because their natural interpretation\n\
	    is somewhat ambiguous.\n\
     -;*    execute %s with command parameters upto the\n\
	    current one, then execute %s again with the\n\
            following parameters upto the next appearance of\n\
	    \";\" as the command parameters. Then go on likewise.\n\
	    (cf. -<* -~*)\n\
     -[*    string in filename to be searched in filewise mode via\n\
	    -{#. Replaced str given by -]*\n\
	    (cf. -]* -{# -}*)\n\
     -]*    replaced str for the found match via -]*.\n\
	    (cf. -[* -{# -}#)\n\
     -{#    output filewise: output filenams are changed along with\n\
	    the input filenames via the use of -[* -]* and -}*.\n\
	      0=filewise rename for DOS and move for UNIX\n\
	      1=normal filewise\n\
	      2=make subdirs if needed\n\
	      3=2+ no query\n\
	      4=3+ no query\n\
	     -n=remove leading subdirs upto n dir delimiters\n\
	     default=no filewise\n\
	    For update, root files for DOS or /tmp/ files for UNIX\n\
	    are used for temporary files on the same disk as input\n\
	    files.\n\
     -}*    in filewise output mode (-{#: #>=0), output filenames\n\
	    are dressed up by the strs * from the input filenames.\n\
	    Input filenames (minus path) are first processed by the\n\
	    -[]* replacement, the resulting str is appended in the\n\
	    front of every -}* option starting from the 2nd one.\n\
	    If none of -}* exist, the resulting str above is the\n\
	    default output filename. e.g. option\n\
	      -{}d: -}xx -fc:foo.txt -[.txt -].a\n\
	    implies input from c:foo.txt and output to d:foo.axx\n\
	    (cf. -{# -[* -]*)\n\
     -~*    this is option version of entering offstrs: lines\n\
	    that contain * will be removed from considerations.\n\
	    This option is to allow \"-<*\" or \"-;*\" to be properly\n\
	    entered.\n\
	    (cf. -<* -;*)\n\
     -.#    force the summation of such # as the exit code,\n\
            overriding -x# and -$* options.\n\
            (cf. -x# -$#)\n\
     -:*    token string/lines as input, they are always the\n\
	    first ones to be read in when present.\n\
	    (cf. -c)\n\
     -+#    cyclic mode of some operations.\n\
	      0=dir read in recursively\n\
	      1=output via -^* will be in append mode\n\
	      2=last two parameters  specified by -p* or -P*\n\
                will be duplicated infinitely.\n\
              3=cyclically read files specified by -u* and -U*\n\
            (cf. -f* -F* -p* -P* -u* -U*)\n\
     -#?    input number placement mode, ?=the initial line\n\
	    number. In this mode, if the character immediately\n\
	    following any of -beBE is '#', then that position\n\
	    is replaced by the current output line number plus\n\
            the summation (initial value) of the numbers entered\n\
	    via -#. Moreover, even number of options of -# type\n\
            imply that the summation of the initial value with\n\
	    the input line number will be used instead. This\n\
	    likewise affects the exit code via -x20.\n\
     -^*    first valid filename * will be sent the output. If\n\
            none of the names specified by * is valid, the\n\
            output is sent to stdout device.\n\
	    -^//# replaces //# there by the #-th entry in the\n\
	    environmental parameter LMFILES.\n\
	    Since -h -v has priority over -^*, their output is\n\
            always directed to stdout device.\n\
            (cf. -f*, -+#)\n\
     -/#    #=ASCII code of a character.  -/# provides a means\n\
	    to enter any (non-zero) character into any string\n\
	    parameter specified after a string option character.\n\
	    Characters specified by -/# will be absorbed into\n\
            the first encountered string parameter on the right.\n\
            If there are -/# type characters between two string\n\
	    parameters following a same string option character,\n\
	    then these parameter strings will be linked up along\n\
	    with the characters specified via -/# into a single\n\
	    string parameter.\n\
            e.g.\n\
		    %s -/65/66/67dok -/68/69\n\
	       is   %s -dABCokEF\n\
		    %s -done -/0dtwo -fONE -fTWO\n\
	       is   %s -donetwo -fONE -fTWO\n\
     -!#    # number of lines will be accepted unconditionally\n\
	    after any line that is accepted because it contains a\n\
	    substring specified by a -g option\n\
	    (cf. -g* -N# -o# -O#)\n\
     -(*    strs to be inserted in front of each line marked by\n\
	    -g*, thus changes the normal meaning of -g* and disables\n\
	    -x21\n\
	    (cf. -)* -g* -!# -x21)\n\
     -)*    strs to be appended after each line marked by -g*\n\
	    (cf. -(* -g* -!# -x21)\n\
     -=#    (DOS only) set the 'proper' lines as environment\n\
	    parameters. The output device that would be affected\n\
	    under option -V (e.g. -BEbe) will thus not be\n\
	    interpreted. When a line is interpreted as an\n\
	    environment parameter, there must be an unique '='\n\
	    in the line so that the left hand side is the name\n\
	    and the right hand side is the parameter it will set\n\
	    to. However, if \"==\" are the first two characters,\n\
	    then all environment parameters will be deleted. If\n\
	    '=' is the first character, then all the environment\n\
	    parameters will be displayed unless there is a specific\n\
	    parameter name following that leading '=' (and may be\n\
	    terminated by another '=') in which case only that\n\
	    specific environment parameter is to be displayed.\n\
	    Otherwise the input line will be ignored. The ending\n\
	    linebreaks will be ignored too. (old version: '-=#' \n\
	    will try to set the lines in the environmental blocks\n\
	    belonging to upto #-th process).\n\
	      0=set environment parameter of the ancestor's\n\
		process (oldest parent), set only the valid\n\
		environment parameters\n\
	      1=0+set even invalid env parameters, if possible\n\
     -&#    (DOS only) meaning of such options depend their\n\
	    appearing order. The first to the last such options\n\
	    are sequentially described below\n\
	      timeout:  at which second to time out\n\
			(positive timeout enables ^C for -$*)\n\
		 beep:  which second to beep\n\
	    countdown:  which second to display count down on\n\
			the upper right corner of the screen\n\
	      default:  default pressed key in ASCII for the\n\
			timeout case under -$*\n\
	     exitcode:  exitcode under ^C\n\
	       column:  column the cursor will be moved to\n\
			immediately moved to at the start\n\
	    (7)   row:  row cursor to move to initially\n\
	      clrline:  nonzero number clear the line from the\n\
			current cursor to the end of line\n\
	      delline:  delete the number of lines starting from\n\
			the line containing the current cursor.\n\
			Negative number deletes just one line\n\
	      insline:  insert the number of empty line below\n\
	       clrscr:  nonzero number clears current screen\n\
	      scrmode:  0=do nothing. Nonzero number is the\n\
			screen mode to set.\n\
			e.g.  1= 40x25   at B800\n\
			      2= 80x25   at B800\n\
			      3= 80x50   at B800\n\
			      7= 80x25   mono at B800\n\
			 others= graphic modes\n\
	    (cf. -$*)\n\
     -$*    (DOS only) this option is available for DOS version\n\
	    only. Input an instant key from keyboard immediately\n\
	    after the completion of -B*. Then return accordingly\n\
	    as the exitcode (unless overridden by -.#). The\n\
	    strategy is controlled by the modes via -j20 to -j28.\n\
	    Return the char position in $* if retchar (j24) is\n\
	    not enabled (0=not found or escaped when escapemode\n\
	    is on), otherwise return charcode of the last read\n\
	    key. If * is empty, i.e. -$ stands alone, then it\n\
	    will wait for just one any key, and exit with code 0\n\
	    unless option -j24 is set. One may use this function\n\
	    to find out the code number of any extended key.\n\
	       case:   match will be case sensitive\n\
	       echo:   echo the last read char unless escaped\n\
		       when escapemode is on\n\
	     escape:   escape key leaves input\n\
	       beep:   beep at any illegal input char\n\
	    retchar:   return last input char code\n\
	    clrkeys:   clear keyboard buffer first\n\
	       loop:   keep reading when waitmode is on until a\n\
		       legal char is read in or escaped when\n\
		       escapemode is on\n\
	       wait:   wait to get chars if key buffer is empty\n\
	   extended:   if this mode is on, then any character\n\
		       in -$* following the char 0xFF (code 255)\n\
		       will denote the corresponding extended\n\
		       key. The char of code 255 itself will\n\
		       thus be meaningless.\n\
	    (cf. -&#, -j#)\n\
     -**   only files matching name mask (2nd) * will be read in\n\
	   (cf. -`* -F*)\n\
     -`*   only files not matching * will be read in\n\
	   (cf. -** -F*)\n\
     -\n\
\n\
",
cmd,cmd,cmd,cmd,cmd,cmd,cmd,cmd,cmd,cmd,
cmd,cmd,cmd,cmd,cmd,cmd,cmd,cmd,cmd,cmd,
cmd,cmd
);


printf("\
   Environment\n\
     If environment parameter LMFILES exists, then any of\n\
	   -f//#   -^//#   -u//#   -U//#  \"-<//#\"\n\
     is a shorthand notation: \"//#\" there will be replaced\n\
     by the #-th entry in LMFILES. Entries of filenames in\n\
     LMFILES are separated by \";\" for DOS and by \":\" for UNIX.\n\
\n\
     TMPDIR is the preferred directory for temporary files.\n\
\n\
   Examples\n\
     1.  Keep 2nd to 3rd words and all those after the 5th one,\n\
	 and convert everything into upper case\n\
	      %s -s2S3s5t1\n\
\n\
     2.  Throw away the lines that contain \"ONE\" and \"two\"\n\
	      %s -J2 ONE two\n\
\n\
     3.  Input lines first from stdin, then file foo.txt and\n\
	 finally from stdin again\n\
	      %s -f -ffoo.txt -f\n\
\n\
     4.  Replace \"help\" to \"HELP\" and \"keyword\" to \"_KEYWORD\".\n\
	 Disregard the case of \"keyword\". Do the str replacement\n\
	 only if the lines contains \"do:\" at the beginning\n\
	      %s -qhelp -rHELP -R_KEYWORD -Qkeyword -j9G10gdo:*\n\
	 (or any other order)\n\
\n\
     5.  Replace string \"man\" in foo.txt to highlight it in\n\
	 the way UNIX man file requires\n\
	      %s -qman -/95/8rm -/95/8ra -/95/8/rn <foo.txt\n\
\n\
     6.  Pick all the files foo.* in subdirectory \"dir\"  (and\n\
	 the lines inside) that contain the strings \"seed??\"\n\
	 and \"is\" in a same line.\n\
	 DOS:      %s -J1G11gseed?? -gis -Fdir\\foo.*\n\
	 UNIX:     %s -J1G11gseed\\?\\? -gis -Fdir/foo.\\*\n\
\n\
     7.  Pick out from foo.txt the lines between \"-START-\" and\n\
	 \"-END-\" sequentially, regardless the letter case.\n\
	      %s -M3+2p -p-start- -p-end- -ffoo.txt\n\
\n\
     8.  Get a line of music in ANSI format from file tune.ans\n\
	 into current input file foo.txt, so that the display\n\
	 speed of the file is controlled/accompanied by the\n\
	 music. e.g. add the music notes cyclically.\n\
	      %s -ffoo.txt -+3Utune.ans\n\
\n\
     9.  Format file foo.txt paragraph-wise to the width of 50\n\
	 characters, do not break up long words\n\
	      %s -atTYffoo.txt | %s -W1w50\n\
	 or via direct temporary file\n\
	      %s -atTYffoo.txt -^d:tmp -; -W1w50fd:tmp\n\
	 or via environment parameter\n\
	      set LMFILES=d:filename.tmp\n\
	      %s -atTYffoo.txt -^//1 -; -W1w50f//1\n\
\n\
    10.  Count the lines of file foo.txt\n\
	      %s -##E# -G0g0 < foo.txt\n\
\n\
    11.  Count the words (connected strings) of file foo.txt\n\
	      set LMFILES=d:tmp1;d:tmp2;\n\
	      %s -atT/32q -/10r -ffoo.txt -^//1 -;\n\
		 -f//1 -y1^//2 -; -f//2 -##E# -G0g0^nul\n\
	 (above two lines should be on a same line)\n\
\n\
    12.  Get first two word columns from file foo and try\n\
	 to align them at 0-th and 20-th character position\n\
	      set LMFILES=c:\\tmp\\tmpfile\n\
	      %s -Ts1S1^//1 -Ww20 -ffoo -; -Ts2S2u//1 -ffoo\n\
\n\
    13.  Find the PATH of a file specimen (in DOS)\n\
	 Thus\n\
	      %s -c:c:\\one\\two\\file.exe -nn1D\\ -D:\n\
	      %s -c:c:file.exe -nn1D\\ -D:\n\
	 gives respectively\n\
	      c:\\one\\two\\\n\
              c:\n\
\n\
    14.  Check if PATH contains c:\\gscript  (in DOS)\n\
	      path |%s -C2dpath= |%s -q; -/10r\n\
	      |%s -Ty1e; -/10e |%s -x7G5gc:\\gscript; >nul\n\
	 (above two lines should be one a same line)\n\
	 if errorlevel==2, then c:\\gscript has been found.\n\
\n\
    15.  List all the file numerically (in DOS 5)\n\
	    dir /b /aa|%s -#b#=|%s -W2w18Y1|%s -W1w74t2\n\
\n\
    16.  Get the 5th file of current directory (UNIX)\n\
	      ls | %s -o5O5 | %s -x1\n\
	 If exit error code is 2, then 5th file not found.\n\
\n\
    17.  Find out if user \"xyz\" have currently logged on in UNIX\n\
	      users |%s -mxyz |%s -x1 >/dev/null\n\
	 If exitcode is 0, then \"xyz\" is logged on.\n\
\n\
    18.  Get long command parameters such as these\n\
	 (PsWD) <-- my password\n\
	     \"-cBDEMO for input command line parameters\" -/10/10\n\
	     \"-cBLong command parameters may be given \" -/10\n\
	     \"-cBin a file like this one, as a long line\" -/10\n\
	     \"-cBor in a few lines!\" -/10/10\n\
	     \"-cBWe may look for this file from e.g.\" -/10\n\
	     \"-c1Bthe place [\" \"-:] where we kept %s\" -/10/10\n\
	     -+t1F* -G5gjiang \"-BSEARCH KEYWORD jiang :\" -/10\n\
	 (PsWD)\n\
	 use e.g.\n\
	     set LMFILES=d:\\tmpfile.tmp\n\
	     %s -p -pPsWD -pPsWD -flm.man -^//1 \"-<//1\"\n\
	 Here we used this current file for the input of long\n\
	 or multi-options.\n\
\n\
    19.  Display the first 2 lines of all files of names LM*.C\n\
	     %s -N-1N2+F\\* -**\\LM*.C\n\
\n\
    20.  List all file names inside current directory and its\n\
	 subdirectories, matching mask \"*bc*.c\"; return exitcode\n\
	 2 if such files are found.\n\
	     %s -N-1N+F -**bc*.c -X8x19\n\
\n\
    21.  Increase environment parameter COUNT by -2 (in DOS\n\
	 batch mode)\n\
	     %s -c#-2#%%COUNT%% -ECOUNT= -E# | %s -=\n\
\n\
    22.  Read from stdin and force input line width be no\n\
	 more than 99 characters; pick out lines marked by\n\
	 \"+/\" and throw aways lines with have same 2nd and\n\
	 5th words as the previous line.\n\
	     %s -j-99 -G10g+/* -y-2y-5\n\
	 e.g.  an input of phone records\n\
		+/  Jim 5/12/96  mobile  London\n\
		+/  Jim 6/11/96  home Paris\n\
		+/  Kay 30/11/96 office Sydney\n\
	 will thus give last phone type and date for all\n\
	 people at all different places\n\
		+/  Jim 5/12/96  mobile  London\n\
		+/  Kay 30/11/96 office Sydney\n\
\n\
    23.  Rename all files in foo and its subdirs so that all\n\
	 \"abc\" and extension \".c\" in the filenames are\n\
	 replaced by \"xyz\" and \".cpp\" correspondingly, with\n\
	 renaming messages suppressed\n\
	     %s -{[.c -].cpp -[abc -]xyz -+Ffoo -X12\n\
\n\
    24.  Update all files with extension \".doc\" so that all\n\
	 lines containing \"mark??me\" will be preceded by the\n\
	 inserted line \"+++\" and followed by \"---\" likewise.\n\
	 Set exitcode to 2 if at least one replacement is done\n\
	     %s -x7{1F*.doc -gmark??me -(+++ -/10( -)--- -/10)\n\
\n\
    25.  Process all files with extension \".c\" in dir c:\\foo and\n\
	 its subdirs by replacing \"ver1.21\" to \"ver1.22\".\n\
	 Save the results in dir d:newfoo and preserve subdir structure\n\
	 with no confirmation asked for overwrite permission. e.g.\n\
	     %s -+Fc:\\foo -**.c -X13{-2{4}d:newfoo\\ -}\n\
		-qver1.21 -rver1.22\n\
	 will process file c:\\foo\\tmp\\x.c and save it as\n\
	 d:newfoo\\tmp\\x.c, and creating subdir d:newfoo\\tmp\n\
	 if necessary without asking for confirmation\n\
      .\n\
\n\
   Author\n\
     Zhuhan Jiang (zjiang@metz.une.edu.au)\n\
     University of New England, Armidale NSW 2351, Australia\n\
\n\
   Restrictions\n\
     Lines of width over 2/3 of maximum integer may cause some\n\
     manipulations unprecise of their definitions. In current\n\
     version, options -Y and -w# are not fully compatible.\n\
     Instead, %s should be run twice or via \"-;\" to achieve\n\
     this task.\n\
",
cmd,cmd,cmd,cmd,cmd,cmd,cmd,cmd,cmd,cmd,
cmd,cmd,cmd,cmd,cmd,cmd,cmd,cmd,cmd,cmd,
cmd,cmd,cmd,cmd,cmd,cmd,cmd,cmd,cmd,cmd,
cmd,cmd,cmd,cmd,cmd,cmd,cmd,cmd,cmd,cmd,
cmd,cmd,cmd,cmd,cmd,cmd,cmd,cmd,cmd,cmd
);
}

#endif





/************************************************************
basic of the basics
*************************************************************/

int chkmemory(void *ptr)
{ if(ptr==NULL)
   { fprintf(stderr,"%s","\nLack of memory."); exit(1); }
  return(0);
}


char *fmalloc(size_t total)
{ char *oneline;
  oneline=(char *) MALLOC(total);
  chkmemory(oneline);
  return(oneline);
}


void movebytes(char *source, char *newaddress,
	      unsigned length, unsigned zeros)
/* no checking for source=NULL or newaddress=NULL
*/
{  int i;
   char *ptr;
   for(i=0;i<length;i++) newaddress[i]=source[i];
   ptr=newaddress+length;
   for(i=0;i<zeros;i++) ptr[i]=0;
}


char *dupstr(char *source, int extrazeros)
/* duplicate str with extra zeros appended at the end
   if extrazeros <0, then source==NULL gives "" as output
*/
{ char *oneline;
  int i,m,n;
  if(source==NULL && !extrazeros) return(NULL);
  if(extrazeros<0) extrazeros=0;
  n=m=(source==NULL)? 0:strlen(source);
  if(extrazeros>0) n=m+extrazeros;
  oneline=fmalloc(n+1);
  for(i=0;i<m;i++) oneline[i]=source[i];
  for(i=m;i<n+1;i++) oneline[i]=0;
  return(oneline);
}


void uplowcase(char *oneline, int isupcase)
/*  convert str oneline to upper or lower case
    cf. strupr strlwr
*/
{ int m,i;
  char ch;
  m=(oneline==NULL)? 0:strlen(oneline);
  for(i=0;i<m;i++)
  { ch=oneline[i];
    oneline[i]= isupcase? upcase(ch): lowcase(ch);
  }
}



/************************************************************
get a physical line from a file/stdin
*************************************************************/

char *inputaline(FILE *fptr)
/* Input a line from the file and return it as a string.
   If line width is over MAXLINEWIDTH, then breaks it there.
   Abort program if lack of memory.
   Global var OVERFLOW=1 if linewidth is over MAXLINEWIDTH
   before '\n' or EOF is encountered.
*/
{ int ch,i,j,k,inputdone,length;
  int totalchar=0;
  static char *buff=NULL;        /*  char buff[L_BUFWIDTH+1];  */
  char *oneline=NULL, *chptr;
  if(buff==NULL)
  { buff=fmalloc(L_BUFWIDTH+1); GETFREELEVEL--; }
  k=0;  ch=0; inputdone=0;
  while (1)
  {  if (inputdone) break;
     ch=getc(fptr);
     totalchar++;
     if(!ch) ch=' ';
     if (ch==-1) break;
     if (totalchar>=MAXLINEWIDTH) {inputdone=1; OVERFLOW=1;}
     if(k>=L_BUFWIDTH)
       { if(oneline!=NULL) length=strlen(oneline); else length=0;
	 chptr=fmalloc(L_BUFWIDTH+length+1);
	 movebytes(oneline,chptr,length,0);
	 movebytes(buff,chptr+length,L_BUFWIDTH,1);
	 if(oneline!=NULL) FREE(oneline);
	 oneline=chptr;
	 k=0;
       }
     buff[k++]=ch;
     if(ch=='\n' ) inputdone=1;
  }
  if (k)
      {	 if(oneline!=NULL) length=strlen(oneline); else length=0;
	 chptr=fmalloc(k+length+1);
	 movebytes(oneline,chptr,length,0);
	 movebytes(buff,chptr+length,k,1);
	 if(oneline!=NULL) FREE(oneline);
	 oneline=chptr;
	 k=0;
       }
  return(oneline);
}


int yesno(int addnewline)
/* -1=ctrl_c, 0=no, yes=1 */
{  char *oneline;
   int ch, yes=0,ctrl_c=0;

#ifdef UNIXMODE
   oneline=inputaline(stdin);
   ch=*oneline;
   FREE(oneline);
   yes= (ch=='y' || ch=='Y');
#else
   ch=getch();
   if(ch==3) ctrl_c=1;  /* 3=ctrl-c */
   if(!ch) ch=getch();  /* extended key */
   if(ch=='y' || ch=='Y') {yes=1; fprintf(stderr,"<yes>");}
   else fprintf(stderr,"<no>");
   if(addnewline) fprintf(stderr,"\n");
#endif

   if(ctrl_c) return(-1);
   return(yes);
}


/************************************************************
basic operations needed to parse comand line parameters
*************************************************************/

char *locatepos(char *mainstr, unsigned mainlength,
		char *substr,  unsigned sublength, int nocase)
/*  locate the first position of a list of bytes (to be used
    under DOS)
*/
{ int ch, newch, matched=0, matching=0;
  char *ptr=mainstr, *str=substr;
  unsigned maincount=0, subcount=0;
  if(!mainlength || !sublength) return(NULL);
  while (1)
   { ch= *ptr; ptr++; maincount++;
     if (maincount> mainlength) break;

     if(nocase) ch=upcase(ch);
     if (matching)
       { newch= *str;
	 if(nocase) newch=upcase(newch);
	 if ( newch==ch)
	 { str++; subcount++; }
	 else
	 { matching=0; subcount=0; str=substr; }
       }
     if (!matching)
       { newch= *str;
	 if(nocase) newch=upcase(newch);
	 if (newch==ch)
	 { matching=1; str++; subcount++;}
       }
     if (matching && subcount>=sublength )
       { matched=1; break; }
   }
   if(matched) return(ptr-sublength);
   return(NULL);
}


int foundstr(char *oneline, char *onestr, int nocase)
/*  check if oneline contains substring onestr.
    nocase: case insensitive.
    Return:
      0     =not found, under whatever circumstance
      i<>0  =i-th element is the element immediately after the found string

      e.g  5=5th elment is the element immediately after the found string
*/
{
  int m,n;
  char *ptr;
  m=oneline==NULL?0:strlen(oneline);
  n=onestr==NULL?0:strlen(onestr);
  if (!m || !n) return(0);
  ptr=locatepos(oneline,m,onestr,n,nocase);
  if(ptr==NULL) return(0);
  else return(ptr-oneline+n);
}



int needhelp(int argn, char *argv[])
/*   commandline options containing any of
     -h -H -? /h /H /? will return 1
*/
{ int i, found=0;
  char *one;
  for(i=1;i<argn;i++)
   { one=argv[i];
    if (   !strcmp(one,"/?") || !strcmp(one,"-?")
	|| !strcmp(one,"/h") || !strcmp(one,"-h")
	|| !strcmp(one,"/H") || !strcmp(one,"-H"))
       {found=1; break;}
   }
   return(found);
}


int instr(char *oneline, char ch)
/* return  1=truly found nonzero ch inside nonzero oneline
	   0=other wise  (ch=0  or ch not inside oneline)   */
{  int i,n;
   if(oneline==NULL || !ch) return(0);
   n=strlen(oneline);
   if(!n) return(0);
   for(i=0;i<n;i++)
     if(ch==oneline[i]) return(1);
   return(0);
}


int incmd(int count, char *argv[], char *strops, char option)
/*  check if option char is found in the string argv[1]-argv[count]
    and is not in any single string after any char found in strops.
    count is ususally the total number of arguments on command line
    which are to be considered  ( count<argn ).
    return: 1=found,  0=not found

*/
{ int i,j,n,found;
  char *one;
  found=0;
  for(i=1;i<=count;i++)
   { one=argv[i];
     if(one==NULL) n=0; else n=strlen(one);
     for(j=0;j<n;j++)
       if(instr(strops,one[j])) { n=j; break; }
     for(j=1;j<n; j++)
      if ( one[j]==option) { found=1; break;}
   }
   return(found);
}


int activechar(char *oneline, char ch, char *strops)
/* check if ch is given outside strops domain, and is
   thus active with respect to other option modes
   return 1=active:  find ch in oneline and is outside strops domain,
	  0=non active    (e.g. ch=0 )
*/

{  int i,n;
   char buffch;
   if(oneline==NULL) n=0; else n=strlen(oneline);
   if(!n) return(0);
   for(i=0;i<n;i++)
    { buffch=oneline[i];
      if(instr(strops,buffch)) return(0);
      if(ch==buffch) return(1);
    }
   return(0);
}


int optioncount(int argn, char *argv[], char *charops,
		 char *numops, char *strops)
/* check how many options are given in FRONT,
   -@ means last option,
   any char in numops will expect an integer following it.
   char in numops takes priority than those in charops.
   char in strops takes priority than those in numops.
   charops essentially contains '@' though may not explicitly
   be done so, '@' is a reserved option char which forces the
   the termination of option paramters. Otherwise a parameter
   without a front char '-' will terminate the parameters.

   return:  0= no legal options are present
	    i= argv[1]-argv[i] are valid option parameters
*/
{  int i,j,k,m,n,count=0,legal=1;
   char *one, ch, buffchar;
   if(charops==NULL) charops="";
   if(numops==NULL) numops="";
   if(strops=="") strops="";


#ifdef DEBUGMODE
   one=strpbrk(strops,charops);
   if(one==NULL) one=strpbrk(strops,numops);
   if(one==NULL) one=strpbrk(numops,charops);
   if(one==NULL) one=strpbrk(charops,"-@0123456789");
   if(one==NULL) one=strpbrk(numops,"-@0123456789");
   if(one==NULL) one=strpbrk(strops,"-@0123456789");
   if(one!=NULL)
    { fprintf(stderr, "\nIncorrect option characters: recompile please!");
      exit(1);
    }
#endif


   for(i=1;i<argn;i++)
    { one=argv[i];
      if (one[0]!='-') break;
      n=strlen(one);
      for(j=1;j<n;j++)
      {	ch=one[j];
	m=0;
	if(instr(strops,ch)) break;
	if(instr(numops,ch))
	 {  for(k=j+1; k<n; k++)
	    { buffchar=one[k];
	      if( (buffchar=='-'&& k==j+1) || isdigit(buffchar) ) m++;
	      else break;
	     }
	    j=j+m;
	    continue;
	  }
	if(instr(charops,ch) || ch=='@') continue;
	legal=0;
       }
      if(legal) count++;
      if(!legal || activechar(one,'@',strops) ) break;
    }
   return(count);
}




/************************************************************
load/parse comand line parameters
  each option record is given by the struct `chain'

format of command line parameters:
  1. all (option) parameters are on the left
  2. all paras start with '-'
  3. a para string (with leading '-') containing '@',
     implies this para string is the last para string.
  4. any para string containing illegal chars or format implies
     it is not a para string.
  5. any string of para format following a non-para string is
     not a para string.

  6. strops, numops and charops should contain no common letters,
     and should not contain special characters '-' and '@'

*************************************************************/

chain *emptychain(void)
/* allocate an empty chain entry
*/
{ chain *ptr;
  ptr=(chain*) MALLOC(sizeof(chain));
  chkmemory(ptr);
  ptr->prev=ptr->next=NULL;
  ptr->numone=ptr->numtwo=0;
  ptr->strone=ptr->strtwo=NULL;
  return(ptr);
}


int freechain(chain **chainptr)
/* entry:   *chainptr must be a valid chain,
	     e.g.  front->prev=tail->next=NULL
   release all the REST of the chain entries
   return:  0=nothing done, 1=done
*/
{ chain *front= *chainptr,*ptr, *newptr;
  int quit=0;
  if(front==NULL) return(0);
  if(front->prev!=NULL) front->prev->next=NULL;
  ptr=front;
  while(ptr->next!=NULL) ptr=ptr->next;
  while(1)
    { if(quit) break;
      newptr=ptr->prev;
      if(ptr->strone!=NULL) FREE(ptr->strone);
      if(ptr->strtwo!=NULL) FREE(ptr->strtwo);
      if(ptr==front) quit=1;
      FREE(ptr);
      ptr=newptr;
    }
  *chainptr=NULL;
  return(1);
}


chain *dupchain(chain *chainptr)
/* duplicate chainptr apart from ->prev and ->next
*/
{ chain *ptr;
  if(chainptr==NULL) return(NULL);
  ptr=emptychain();
  ptr->numone=chainptr->numone;
  ptr->numtwo=chainptr->numtwo;
  ptr->strone=dupstr(chainptr->strone,0);
  ptr->strtwo=dupstr(chainptr->strtwo,0);
  return(ptr);
}


chain *multichain(int argn, char *argv[],
	 char *strops, int optionnum, char *  chrs, char *numchrs)
/*  load in all the string options and number options (but not
    character options) in the cmd order.

    the strings are specified by those of chrs, and the numbers
    are specified by those of numchrs. chrs must be a subset of
    strops, obviously.

    keep it in strone/strnum, keep the (option) single char in strtwo.
*/
{
  chain *front, *current, *ptr;
  char ch, *buffstr, *str;
  int i,j,k,m,n;

  m= (chrs==NULL) ?   0 : strlen(chrs);
  n= (numchrs==NULL)? 0 : strlen(numchrs);
  if(m+n<1) return(NULL);

  argn=min(optionnum+1, argn);
  front=current=NULL;
  for(i=1; i< argn; i++)
  { str=argv[i];
    m=strlen(str);
    for(j=0;j<m;j++)
    { ch=str[j];
      ptr=NULL;
      if(instr(chrs, ch))
       {  ptr=emptychain();
	  n=strlen(str+j+1);
	  buffstr=fmalloc(n+1);
	  movebytes(str+j+1, buffstr,n,1);
	  ptr->strone=buffstr;
	  buffstr=fmalloc(2);
	  buffstr[0]=ch;
	  buffstr[1]=0;
	  ptr->strtwo=buffstr;
	  j=m;
       }
      else if(instr(numchrs,ch))
	   {  ptr=emptychain();
	      buffstr=fmalloc(2);
	      buffstr[0]=ch;
	      buffstr[1]=0;
	      ptr->strtwo=buffstr;

	      n=j+1;
	      for(k=j+1;k<m;k++)
	      {	if( (str[k]=='-'&& k==j+1) || isdigit(str[k]) ) n=k+1;
		else break;
		/* m points to the future character to be considered */
	       }
	      ptr->numone=(*(str+j+1)=='+')? 0:atoi(str+j+1);
	      j=n-1;
	    }
       else if(instr(strops,ch)) j=m;

       if(ptr!=NULL)
       { if(front==NULL) front=current=ptr;
	 else { current->next=ptr; ptr->prev=current; current=ptr; }
       }
    }
  }
  return(front);
}


void combinestrnum(chain ** chainptr)
/*  enter binary code into string parameters

    absorb numbers into the strings, with num interpreted as ASCII code.
    str1/A -> n1->n2->str2/B
      =>  str1/A -> ( chr(n1)+chr(n2)+str1 )/B    if A!=B
	  str1+chr(n1)+chr(n2)+str1               if A==B
    str1/A ->n1     => str1+chr(n1)
    n1->str1/A      => chr(n1)+str1
*/
{ chain *front, *current, *ahead, *behind, *ptr;
  char  ch=0, prevch=0, *newstr, *numstr;
  int i,m,n,count;

  front=current= *chainptr;
  while(current!=NULL)
  {
  if (current->strone==NULL)
   { ptr=current; count=0; ch=0;
     while(ptr!=NULL)
     { if (ptr->strone==NULL)
	 { if(ptr->numone>0) count++;
	   ptr=ptr->next;
	   continue;
	 }
       ch=ptr->strtwo[0];
       break;
     }

     numstr=fmalloc(count+1);
     ptr=current; count=0;

     while(ptr!=NULL)
     { if (ptr->strone==NULL)
	 { if(ptr->numone>0) numstr[count++]=ptr->numone;
	   ptr=ptr->next;
	   continue;
	 }
       break;
     }
     numstr[count]=0;

     ahead=current->prev;
     behind=ptr;

     /* current strictly in front of behind */
     if(behind!=NULL) behind->prev->next=NULL;
     if(ahead!=NULL) ahead->next=behind;
     if(behind!=NULL) behind->prev=ahead;
     current->prev=NULL;

     if(front==current)
       {front=behind; front->prev=NULL; }
     freechain(&current);


     if(!ch)
      { if(front!=behind)
	     { m=strlen(ahead->strone);
	       newstr=fmalloc(m+count+1);
	       movebytes(ahead->strone, newstr, m, 0);
	       movebytes(numstr,newstr+m,count, 1);
	       FREE(ahead->strone);
	       ahead->strone=newstr;
	     }
	FREE(numstr); break;
      }
     else
      { if(front==behind )
	     { m=strlen(behind->strone);
	       newstr=fmalloc(m+count+1);
	       movebytes(numstr, newstr, count,0);
	       movebytes(behind->strone,newstr+count,m,1);
	       FREE(behind->strone);
	       behind->strone=newstr;
	     }
	 else
	     { prevch=ahead->strtwo[0];
	       ch=behind->strtwo[0];
	       m=strlen(ahead->strone);
	       n=strlen(behind->strone);
	       if(prevch==ch)
	       {newstr=fmalloc(m+n+count+1);
		movebytes(ahead->strone,newstr,m,0);
		movebytes(numstr, newstr+m, count,0);
		movebytes(behind->strone,newstr+count+m,n,1);
		FREE(ahead->strone);
		ahead->strone=newstr;
		ahead->next=behind->next;
		if(behind->next!=NULL) behind->next->prev=ahead;
		behind->prev=behind->next=NULL;
		freechain(&behind);
		behind=ahead->next;
	       }
	       else
	       {newstr=fmalloc(n+count+1);
		movebytes(numstr, newstr, count,0);
		movebytes(behind->strone,newstr+count,n,1);
		FREE(behind->strone);
		behind->strone=newstr;
	       }
	     }
	FREE(numstr);
      }
   }
  else behind=current->next;
  current=behind;
  }   /* while */

  *chainptr=front;

}


chain *getmultisubchain(chain *chainptr,char *chrs)
/*  pick (with dupl.) subchain corresponding to characters inside chrs
*/
{ chain *ptr, *front=NULL, *current=NULL, *newptr;
  char *str;
  int m;
  ptr=chainptr;
  while(ptr!=NULL)
  { if(ptr->strtwo!=NULL && instr(chrs,ptr->strtwo[0]) )
    { newptr=dupchain(ptr);
      if(front==NULL) front=current=newptr;
      else
	 {current->next=newptr;
	  newptr->prev=current;
	  current=newptr;
	 }
    }
    ptr=ptr->next;
  }
  return(front);
}


chain *getsubchain(chain *chainptr,char ch)
/*  pick (with dupl.) subchain corresponding to character ch
*/
{ char strs[2];
  strs[0]=ch; strs[1]=0;
  return(getmultisubchain(chainptr,strs));
}


chain *getsubnumchain(chain *chainptr,char ch,
		       int num1, int num2)
/*  pick subchain corresponding to character ch
    num1 and num2 are replaced by 0 and 1, while
    other numbers associated with ch will be ignored
*/
{ chain *ptr, *front=NULL, *current=NULL, *newptr;
  char *str;
  int m;
  ptr=chainptr;
  while(ptr!=NULL)
  { if(ptr->strtwo!=NULL && ptr->strtwo[0]==ch &&
       (ptr->numone==num1 || ptr->numone==num2 ) )
    { newptr=dupchain(ptr);
      if(newptr->numone==num1) newptr->numone=0;
      if(newptr->numone==num2) newptr->numone=1;
      if(front==NULL) front=current=newptr;
      else
	 {current->next=newptr;
	  newptr->prev=current;
	  current=newptr;
	 }
    }
    ptr=ptr->next;
  }
  return(front);
}




/************************************************************
get options from cmd parameters
*************************************************************/

int containnum(chain *chainptr, int num)
/*  aim:  check if .numone in chainptr contains the number num.
 return:  0=not found
	  1=found   (if num=0)
	  num=found (if num!=0)
*/
{ chain *ptr;
  int i,retval=0;
  ptr=chainptr;
  while(ptr!=NULL)
  { if(ptr->numone==num) { retval=1; break; }
    ptr=ptr->next;
  }
  if(num && retval) return(num);
  return(retval);
}


int maxmininum(chain *chainptr, int maxmode)
/*  aim:  find the max/mini value in chainptr
 return:  the max/mini value
*/
{ chain *ptr;
  int retval=0;
  ptr=chainptr;
  if(ptr!=NULL) retval=ptr->numone;
  while(ptr!=NULL)
  { retval=maxmode?
	 max(ptr->numone, retval): min(ptr->numone,retval);
    ptr=ptr->next;
  }
  return(retval);
}


int getcharparas(chain *mainchain,  int nargin, ... )
/*  ...:  must appear in (int) ch, &intvar  pairs.
	  If cmd paras contains char ch, then intvar set to 1. Otherwise
	  intvar is set to 0.
   nargin: pair numbers
*/
{ int i,ch, *flag;
  chain *ptr;
  va_list ap;
  va_start(ap, nargin);
  for(i=1;i<=nargin;i++)
  {  ch=va_arg(ap, int);
     flag=va_arg(ap, int *);
     ptr=getsubchain(mainchain, (char) ch);
     if(ptr!=NULL) *flag=1; else *flag=0;
     freechain(&ptr);
  }
  va_end(ap);
  return(0);
}


int getnumparas(chain *mainchain, int nargin, ... )
/* ... :    char, &intvar, int_default, etc
   nargin:  triplet numbers
*/
{ int i,ch,given,*flag;
  chain *ptr;
  va_list ap;
  va_start(ap, nargin);
  for(i=1;i<=nargin;i++)
  {  ch=va_arg(ap, int);
     flag=va_arg(ap, int *);
     given=va_arg(ap, int);
     ptr=getsubchain(mainchain, (char) ch);
     if(ptr==NULL) *flag=given; else *flag=ptr->numone;
     freechain(&ptr);
  }
  va_end(ap);
  return(0);
}


int setnummodes(chain *chainptr, int nargin, ... )
/* ... :    int, &intvar,  etc
   nargin:  pair numbers
   set corresponding flags if chainptr contains the num.
   otherwise the flag is NOT altered.

*/
{ int i,n,*flag;
  chain *ptr;
  va_list ap;
  va_start(ap, nargin);
  for(i=1;i<=nargin;i++)
  {  n=va_arg(ap, int);
     flag=va_arg(ap, int *);
     if(containnum(chainptr,n)) *flag=1;
  }
  va_end(ap);
  return(0);
}


int getchainparas(chain *mainchain, int nargin, ... )
/*   ... :    char, chainptr, etc
   nargin:    pair numbers
*/
{ int i,ch;
  chain **ptrptr;
  va_list ap;
  va_start(ap, nargin);
  for(i=1;i<=nargin;i++)
  {  ch=va_arg(ap, int);
     ptrptr=va_arg(ap, chain **);
     *ptrptr=getsubchain(mainchain, (char) ch);
  }
  va_end(ap);
  return(0);
}


int freemultichains(int nargin, ... )
/*   ... :    chain **
   nargin:    number of chains to be freed
   free the memory of a list of chains
*/
{ int i;
  chain **ptrptr;
  va_list ap;
  va_start(ap, nargin);
  for(i=1;i<=nargin;i++)
  {  ptrptr=va_arg(ap, chain **);
     freechain(ptrptr);
  }
  va_end(ap);
  return(0);
}


int sillyhelp(int argn, char *argv[],
		char *charops, char *numops, char *strops)
/*    search 'illegal' paramaers such as "/h"
      which might mean the need of help.
      "/h" etc will NOT be interpreted as help request if
      "-@" is legally present to end front options

      charops,numops and strops are all not allowed
      to contain digits, '@' and '-' .
*/
{ int found,count;
  count=optioncount(argn,argv,charops,numops,strops);
  found=incmd(count,argv,strops,'h')
	|| incmd(count,argv,strops,'H');
  if(!found && !incmd(count,argv,strops,'@')) return(needhelp(argn,argv) );
  else return(0);
}


/************************************************************
above functions for basic comand parameter parsing
*************************************************************/










/************************************************************
create a keep/remove interval map chain
*************************************************************/

int sortchain(chain ** chainptr, int strmode)
/* sort chain in the increasing order of
     numone   (if strmode=0)
  or strone   (if strmode<>0 )

  return 0=nothing done
	 1=done something
*/
{ chain *ptr, *leastptr, *front, *current;
  int  sorted=0;
  front=current= *chainptr;
  while(current!=NULL)
  {  leastptr=current;
     ptr=current->next;
     while(ptr!=NULL)
     { if( strmode && strcmp(ptr->strone, leastptr->strone)<0  /*CMP*/
	  || !strmode && ptr->numone<leastptr->numone )
       leastptr=ptr;
       ptr=ptr->next;
     }

     if(leastptr!=current)
     { sorted=1;
       ptr=leastptr->prev;
       if(current->prev!=NULL) current->prev->next=leastptr;
       leastptr->prev=current->prev;
       ptr->next=leastptr->next;
       if(leastptr->next!=NULL) leastptr->next->prev=ptr;
       leastptr->next=current;
       current->prev=leastptr;
       if(front==current) { front=leastptr; front->prev=NULL; }
     }
     current=leastptr->next;
  }
  *chainptr=front;
  return(sorted);
}


chain * mixchain(chain *begchain, chain *endchain)
/*   Entry:  begchain and endchain must already be sorted.
       Aim:  take values from chain->numone to create newchain such that
	     chain->numone <= chain->numtwo  <=  chain->next->numone.
	     The output is to be fed to compliment().
Convertion:  chain->numtwo==-1:  to the end of line
*/
{ chain	*front, *tail, *ptr, *ptrone, *ptrtwo;
  int one,two,quit,nosave,ontop;

   while(begchain!=NULL)
     if(begchain->numone<=0) begchain=begchain->next;
     else break;
   while(endchain!=NULL)
     if(endchain->numone<=0) endchain=endchain->next;
     else break;

   ptrone=begchain; ptrtwo=endchain;
   front=tail=NULL;
   ontop=1;
	   /* if one has already got a beginning number
	      and is trying to find the matching ending number,
	      then one is in the mode of ontop==1 */
   quit=0;
   while(1)
   {  if(ptrone==NULL && ptrtwo==NULL) break;
      nosave=0;
      if(ontop)
       { if(ptrone!=NULL) one=ptrone->numone; else one=0;
		      /* ptr=NULL can only happen at the entry point */
	 two=0;  ptr=ptrtwo;
	 while(ptr!=NULL)
	  { if(ptr->numone >=one && ptr->numone >0)
		      /* 1-based number,inclusive */
	      { two=ptr->numone;  break;}
	    else ptr=ptr->next;
	  }
	 if(!two)     /* no matching end found, default to end of line */
	   { quit=1; two= -1;
		      /* -1= to the end of line */
	     if(one<=0) one=1;
	     if(one==1 && two== -1) nosave=1;
	   }
	 else if(!one) one=1;
	 ontop=0;
	 if(ptrone!=NULL) ptrone=ptrone->next;
	 ptrtwo=ptr;
	}
      else
       { ptr=ptrone;
	 two=ptrtwo->numone;  /* ptrtwo here couldn't be null */
	 one=0;
	 while(ptr!=NULL)
	  { if(ptr->numone < two) ptr=ptr->next;
	    else {one=ptr->numone; break;}
	  }
	 if(!one) {quit=1; nosave=1; }
	 ontop=1;
	 ptrone=ptr;
	 ptrtwo=ptrtwo->next;
	}

       if( !nosave && !ontop )
	{ ptr=emptychain();
	  ptr->numone=one; ptr->numtwo=two;
	  ptr->prev=tail;
	  if(tail!=NULL) tail->next=ptr;
	  if(front==NULL) front=ptr;
	  tail=ptr;
	}
       if(quit) break;
   }

   if(begchain!=NULL && endchain!=NULL)
     if(begchain->numone > endchain->numone && endchain->numone>0 )
	{ ptr=emptychain();
	  ptr->numone=1; ptr->numtwo=endchain->numone;
	  if(front!=NULL)
	   { ptr->next=front;
	     front->prev=ptr;
	   }
	  front=ptr;
	}

   return(front);
}


chain *compliment(chain *goodchain)
/*  Entry:  goodchain must come from mixchain() .
      Aim:  transform goodchain that indicates which (1-based) elements
	    are to be included, into a chain that indicates which (0-based)
	    elements (typically characters inside a string) are to be
	    removed.
     Note:  to be fed to chaintable() .
*/
{  int m,n;
   chain *front, *tail, *current, *ptr;

   front=tail=NULL;
   if(goodchain==NULL) return(NULL);
   m=goodchain->numone;
   if(m>1)
   {  front=tail=emptychain();
      front->numone=0; front->numtwo=m-2;
   }
   current=goodchain;
   while(current!=NULL)
   { m=current->numtwo;
     if(m<0) break;
     if(current->next==NULL) n= -1; else n=current->next->numone-2;
     ptr=emptychain();
     ptr->numone=m; ptr->numtwo=n;
     ptr->prev=tail;
     if(tail!=NULL) tail->next=ptr;
     tail=ptr;
     if(front==NULL) front=ptr;
     current=current->next;
    }
   return(front);
}


chain *chaintable(chain *mainchain,
		 char charbegin, char charend, int removal)
/*  sort and re-arange the number in the paras given by
    charbegin and charend, then produce a continous chain which
    gives each interval in [chain->numone, chain->numtwo].

    removal: 0=sorted list explained above
	     1=complimented list (for removal)
*/
{ chain *ptrone, *ptrtwo, *ptr;
  ptrone=getsubchain(mainchain,charbegin);
  ptrtwo=getsubchain(mainchain,charend);
  sortchain(&ptrone,0);
  sortchain(&ptrtwo,0);
  ptr=mixchain(ptrone,ptrtwo);
  freechain(&ptrone);
  freechain(&ptrtwo);
  if(removal)
   { ptrone=compliment(ptr);
     freechain(&ptr);
     return(ptrone);
   }
  else return(ptr);
}





/************************************************************
replace substring in a main string by new substrings
*************************************************************/

int matchcount(char *oneline, char *onestr, int nocase, int wordmode)
/*  nocase==1: case insensitive
    return: -1=empty strings (no match)
	     0=no match
	    >0=number of matches
    aim: find how may times onestr is matched in oneline
*/
{
  int ch, newch, matched=0, matching=0;
  char *ptr=oneline, *str=onestr;
  if(*ptr=='\0' | *str=='\0') return(-1);
  else
  while (1)
   { ch= *ptr; ptr++;
     if (ch=='\0') break;
     if(nocase) ch=upcase(ch);
     if (matching)
       { newch= *str;
	 if(nocase) newch=upcase(newch);
	 if ( newch==ch) str++;
	  else
	    { ptr -= (str-onestr-1);
	      matching=0;
	      str=onestr;
	    }
	}

     if (!matching)
       { newch= *str;
	 if(nocase) newch=upcase(newch);
	 if (newch==ch &&
	    (   !wordmode
	     || wordmode==1 && ( !isalpha(*(ptr-2)) || ptr==oneline+1)
	     || wordmode==2 && ( !isalpha(*(ptr-2)) && *(ptr-2)!='_' || ptr==oneline+1)
	     || wordmode==3 && ( *(ptr-2)==' ' || *(ptr-2)==0x9 || ptr==oneline+1)
	      )
	    )
	   { matching=1; str++; }
	}

     if (matching && *str=='\0' &&
	    (   !wordmode
	     || wordmode==1 &&  !isalpha(*ptr)
	     || wordmode==2 &&  !isalpha(*ptr) && *ptr!='_'
	     || wordmode==3 && ( *ptr==' ' || *ptr==0x9 || *ptr=='\n' || *ptr==0 )
	    )
	)
     { matched++;
       matching=0;
       str=onestr;
     }
   }
   return(matched);
}


int replacedlen(char *oneline, char *onestr, char *newstr, int nocase, int wordmode)
/*  estimate the total str length, if all substring onestr in oneline
    are replaced by newstr
*/
{
  int n,m,matched,total;
  m=strlen(onestr); n=strlen(newstr);
  matched=matchcount(oneline,onestr,nocase,wordmode);
  total=strlen(oneline);
  if(matched<0) matched=0;
  total=total-matched*(m-n);
  if(total<0) total=0;
  return(total);
}


char * replacedstr(char *oneline, char *onestr, char *newstr, int nocase,
		   int wordmode)
/*     aim:  replace all onestr in oneline by newstr
      case:  sensitive if nocase=0
    return:  replaced outputline
      note:  L_BUFWIDTH should be large, so that the new string could
	     could NORMALLY still be within the max width L_BUFWIDTH,
	     and in any case should be shorter than the size of integer.
  wordmode:  0=anyword
	     1=word delimited by any non-alphabet
	     2=word delimited by any non-alphabet except '_'
	     3=word delimited by space or newline
*/
{
  int n,m,ch, newch, matched=0, matching=0, buffcount, p;
  static char *buff=NULL;
  static int buffwidth=L_BUFWIDTH;
  char *ptr=oneline, *str=onestr, *outline=NULL;
  n=strlen(onestr);
  m=strlen(newstr);
  if(buff==NULL){ buff=fmalloc(buffwidth+2); GETFREELEVEL--;}
  if(buffwidth>L_BUFWIDTH)
    { FREE(buff); buffwidth=L_BUFWIDTH;
      buff=fmalloc(buffwidth+2);
    }
  buffcount=replacedlen(oneline,onestr,newstr,nocase,wordmode);
  if(buffcount>=buffwidth)
    { FREE(buff); buffwidth=buffcount+1;
      buff=fmalloc(buffwidth+2);
    }
  buffcount=0;
  if( !(*ptr=='\0' | *str=='\0'))
  while (1)
   { ch= *ptr; ptr++;
     buff[buffcount]=ch;
     buffcount++;
     if(buffcount>buffwidth)
      { fprintf(stderr, "%s",
	    "\nMemory error: line too long for replacement.");
	exit(1);    /* shouldn't happen ? */
      }
     if (ch=='\0') break;
     if(nocase) ch=upcase(ch);
     if (matching)
       { newch= *str;
	 if(nocase) newch=upcase(newch);
	 if ( newch==ch)  str++;
	  else
	    { p=str-onestr-1;
	      buffcount -=p;
	      ptr -=p;
	      matching=0;
	      str=onestr;

	    }
	}
     if (!matching)
       { newch= *str;
	 if(nocase) newch=upcase(newch);
	 if (newch==ch &&
	    (   !wordmode
	     || wordmode==1 && ( !isalpha(*(ptr-2)) || ptr==oneline+1)
	     || wordmode==2 && ( !isalpha(*(ptr-2)) && *(ptr-2)!='_' || ptr==oneline+1)
	     || wordmode==3 && ( *(ptr-2)==' ' || *(ptr-2)==0x9 || ptr==oneline+1)
	      )
	    )
	   { matching=1; str++; }
	}
     if (matching && *str=='\0' &&
	    (   !wordmode
	     || wordmode==1 &&  !isalpha(*ptr)
	     || wordmode==2 &&  !isalpha(*ptr) && *ptr!='_'
	     || wordmode==3 && ( *ptr==' ' || *ptr==0x9 || *ptr=='\n' || *ptr==0 )
	    )
	)
      { matched++;
	matching=0;
	str=onestr;
	if(matched<=0) matched= -1;
	if(buffcount-n+m<buffwidth)
	  { movebytes(newstr, buff+buffcount-n, m, 1);
	    buffcount+=m-n;
	  }
	else
	  { fprintf(stderr,"%s","Fail to replace: line too long!");
	    exit(1);
	  }
      }
   }
   if(matched) n=strlen(buff); else n=strlen(oneline);
   outline=fmalloc(n+1);
   if(matched) movebytes(buff,outline,n,1);
   else movebytes(oneline, outline,n,1);
   return(outline);
}


char * freplacedstr(char *oneline, char *onestr, char *newstr, int nocase,
		    int wordmode)
/*  aim:  replace onestr in oneline by newstr if onestr starts
	  from the 1st char.
 others:  same as replacedstr() .
*/
{
  int n,m,p,i,ch, newch, matched;
  char *outline;
  n=strlen(onestr);
  m=strlen(newstr);
  p=strlen(oneline);
  matched=1;
  if(p<n) matched=0;
  if(matched)
  for(i=0;i<n;i++)
   { ch=oneline[i];
     newch=onestr[i];
     if(nocase) { ch=upcase(ch); newch=upcase(newch); }
     if (newch!=ch) { matched=0; break; }
   }
   ch=oneline[i];
   if(! ( matched &&
	( !wordmode
	 || wordmode==1 &&  !isalpha(ch)
	 || wordmode==2 &&  !isalpha(ch) && ch!='_'
	 || wordmode==3 && ( ch==' ' || ch==0x9 || ch=='\n' || ch==0 )
	) )
     ) matched=0;

   if(matched) p=p-n+m;
   outline=fmalloc(p+1);
   if(matched)
     { movebytes(newstr,outline,m,0);
       movebytes(oneline+n,outline+m,p-m,1);
     }
   else movebytes(oneline,outline,p,1);
   return(outline);
}


char *replace(char *oneline, chain *oldchain, chain *newchain,
	    int nocase, int wordmode, chain * frontonly)
/*  For oneline, replace strs given oldchain by those in newchain.
    Replace string that starts at the very beginning if frontonly<>0 .
*/
{ char *buffline, *outline;
  chain *ptr, *newptr;
  outline=replacedstr(oneline, "", "", nocase,wordmode);
  if((oldchain==NULL)||(newchain==NULL)) return(outline);
  ptr=oldchain;
  newptr=newchain;
  while(ptr!=NULL)
  { if(newptr==NULL) break;
    if(frontonly!=NULL && frontonly->numone)
      buffline=freplacedstr(outline, ptr->strone, newptr->strone, nocase,wordmode);
    else
      buffline=replacedstr(outline, ptr->strone, newptr->strone, nocase,wordmode);
    FREE(outline);
    outline=buffline;
    ptr=ptr->next; newptr=newptr->next;
    if(frontonly!=NULL) frontonly=frontonly->next;
  }
  return(outline);
}





/************************************************************
locate a substring by delimiters
*************************************************************/

char *delimitedstr(char *oneline, char *frontline, char *endline,
		   int nocase, int findlast, int inclusive)
/*     aim: find the 1st (or the last if findlast<>0) substring
	    in oneline, which is delimited on the left by frontline
	    and on the right by endline.
	    demiliter strs are case sensitive if nocase=0.
	    "" delimiter is ignored.

    return: along with the delimiter strs if inclusive<>0 .
	    NULL =not found.
		  or oneline=NULL
		  or frontline=endline=null
       "" : empty string (but found!)
     "xyz": e.g. the delimited string
*/

{ int n,found,empty=0, totaln, frontlen=0, endlen=0;
  char * ptr=oneline, * newstr, *moreptr ;
  if(oneline==NULL || frontline==NULL && endline==NULL) return(NULL);
  found=0;
  if(frontline!=NULL)
    { frontlen=strlen(frontline);
      if(frontlen) { totaln=0;
	      while(1)
	      { n=foundstr(ptr, frontline, nocase);
		ptr=ptr+n;
		totaln+=n;
		if(!n || !findlast) break;
	      }
	      n=totaln;
	      if(!n) found= -1;
	      else n=strlen(ptr);
	    }
      else empty=1;
    }
    /* found=-1 means failed immediately */

  moreptr=ptr;
  if(endline!=NULL)
    { endlen=strlen(endline);
      if(endlen) { totaln=0;
	      while(1)
	      { n=foundstr(moreptr, endline, nocase);
		moreptr=moreptr+n;
		totaln+=n;
		if(!n || !findlast) break;
	      }
	      n=totaln;
	      if(n) {n=n-endlen; if(found>=0) found=1; }
	    }
      else { if(found>=0) found=1;
	     if(empty) found=0;
	   }

    }
  else { if(found>=0) found=1; if(empty) found=0; }

  if(found>0) { if(inclusive)
		 { ptr=ptr-frontlen;
		   n=n+frontlen+endlen;
		 }
		newstr=fmalloc(n+1);
		movebytes(ptr, newstr, n, 1);
		return(newstr);
	       }
  else return(NULL);
}


char * grepsubstr(char *oneline, chain *front, chain *tail,
       int nocase, int findlast, int inclusive)
/*   get a substring, with delimiter strs given by
     front and tail.
     other paras same as delimitedstr() .
*/
{ chain *first, *second;
  char *strptr=NULL, *strone, *strtwo;
  first=front; second=tail;
  while(1)
  { if(first==NULL && second==NULL) break;
    if(first!=NULL) strone=first->strone; else strone="";
    if(second!=NULL) strtwo=second->strone; else strtwo="";
    if(!strlen(strone) && !strlen(strtwo))
    { strptr=dupstr(oneline,0); break; }
    else
    { strptr=delimitedstr(oneline,strone,strtwo,nocase,findlast,inclusive);
      if(strptr!=NULL) break;
      if(first!=NULL) first=first->next;
      if(second!=NULL) second=second->next;
    }
  }
  return(strptr);
}





/************************************************************
manipulate extra spaces in/around a string
*************************************************************/

int trimline(char *oneline, int mode)
/* remove leading and tailing spaces or TABs
   return = number of chars removed
   mode: 0=trim both ends
	 1=trim front     2=trim end
*/
{  int first,last,ch,n,i,extra,next,extrasearch;
   n=strlen(oneline);
   if (n<=0) return(0);
   if(mode && mode!=1) first=0;
   else
   { first=n;
     for(i=0;i<n;i++)
      { ch=oneline[i];
	if(!(ch==0x20 || ch==0x9))
	 {first=i; break;}
      }
   }
   extra= n;
   if(mode && mode!=2) last=n-1;
   else
   { last= -1; extrasearch=1;
     for(i=n-1;i>=0;i--)
      { ch=oneline[i];
	if ( (ch=='\n'  /*  || ch=='\r' */ ) && extrasearch) extra=i;
	  else extrasearch=0;
	if(!(ch==0x20 || ch==0x9 || extrasearch))
	  {last=i; break;}
      }
   }
   for(i=first; i<=last; i++)
     oneline[i-first]=oneline[i];
   if (first<=last) next=last-first+1; else next=0;
   for(i=extra;i<n;i++)
     oneline[next+i-extra]=oneline[i];
   next=next+n-extra;
   oneline[next]=0;
   i=strlen(oneline);
   return(n-i);
}


int tab2space(char *oneline)
/* change TAB into a single space.
   return 0=nothing changed  1=otherwise */
{  int i,n, retval=0;
   n=strlen(oneline);
   for(i=0;i<n;i++)
     if(oneline[i]==0x9) {retval=1; oneline[i]=' ';}
   return(retval);
}


int absorbspace(char *oneline)
/* remove consecutive spaces or TABs
   return 0= if nothing changed  1=otherwise
*/
{  int first,last,ch,n,i,j,removed=0;
   n=strlen(oneline);
   if (n<=0) return(0);
   i=0;
   while (1)
    { if(i>=n) break;
      ch=oneline[i];
      if( ch==0x20 || ch==0x9)
	 { if (ch==0x9) { removed=1; oneline[i]=0x20;}
	   first=i;  /* first space */
	   last=first-1;
	   for(j=i+1;j<n;j++)
	    { ch=oneline[j];
	      if (ch==0x20 || ch==0x9) last=j; else break;
	    }
	    if ( first<last)
	      {  for(j=1; j<n-last; j++)
		 oneline[first+j]=oneline[last+j];
		 oneline[first+j]=0;
		 n=strlen(oneline);
		 removed=1;
	      }
       } /* end of if */
       i++;
   }  /* end of while */
   return(removed);
}





/************************************************************
string comparison
*************************************************************/

int strmatch(char *realstr, char *maskstr)
/*  return 0=no match
	   1=match     or  ""="" or NULL

    wild card char: '*'=any string, '?'=ONE char
*/
{ int i,j,m,n;
  char ch,maskch;
  if(realstr==NULL) realstr="";
  if(maskstr==NULL) maskstr="";
  m=strlen(realstr);
  n=strlen(maskstr);
  if(!m && !n) return(1);
  if(m && !n) return(0);

  ch=realstr[0]; maskch=maskstr[0];
  if(maskch!='*')
   { if(!ch || !m) return(0);
     if(ch==maskch || maskch=='?')
       return( strmatch(realstr+1, maskstr+1) );
     else return(0);
   }
  else
   { if(!m || n<=1)
      { for(i=1;i<n;i++) if(maskstr[i]!='*') return(0);
	return(1);
      }
     for(i=0;i<m;i++)
      if (strmatch(realstr+i, maskstr+1) ) return(1);
     return(0);
   }
}


int comparestrs(char *subline, char *mainline, int mode)
/*  mode:  0=identical
	   1=subline inside mainline
	   2=identical upto case
	   3=subline inside mainline upto case
	   4=identical upto case and spaces
	   5=subline inside mainline upto case and spaces
    10+(0-5)=0-5 + wild card '*' '?' interpretation
	   '*'=any string, '?'=one char
   return: 0= not achieved Or either of subline/mainline =NULL
	   1= achieved
*/
{ int i,m,n,retval;
  char *lineone, *linetwo, *linebuff;
  if(subline==NULL || mainline==NULL) return(0);
  m=strlen(subline);
  n=strlen(mainline);
  lineone=fmalloc(m+1);
  linetwo=fmalloc(n+1);
  strcpy(lineone,subline); strcpy(linetwo,mainline);
  if(mode>=2 && mode<10 || mode>=12)
   { for(i=0;i<m;i++) lineone[i]=upcase(lineone[i]);
     for(i=0;i<n;i++) linetwo[i]=upcase(linetwo[i]);
   }
  if(mode>=4&&mode<10 || mode>=14)
   { tab2space(lineone); absorbspace(lineone); trimline(lineone,0);
     tab2space(linetwo); absorbspace(linetwo); trimline(linetwo,0);
   }
  m=strlen(lineone);
  n=strlen(linetwo);
  if((mode==11 || mode==13 || mode>=15) && m)
    { linebuff=fmalloc(m+3);
      movebytes(lineone,linebuff+1,m,0);
      linebuff[0]=linebuff[m+1]='*';
      linebuff[m+2]=0;
      FREE(lineone);
      lineone=linebuff;
      m=m+2;
    }
  if(!n || !m){ FREE(lineone); FREE(linetwo); }
  if(!m && !n) return(1);
  if(!n) return(0);
  if(!m) if(mode==0 || mode==2 || mode==4) return(0); else return(1);
  switch(mode)
  { case 0:
    case 2:
    case 4:   retval=!strcmp(lineone,linetwo); break;
    case 1:
    case 3:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9: retval=foundstr(linetwo,lineone,0);break;
    default:  retval=strmatch(linetwo,lineone);
  }
  FREE(lineone); FREE(linetwo);
  if(retval) retval=1;
  return(retval);
}


int grepped(char *oneline, chain *token, int mode, int and_mode_on)
/*      aim:  check if oneline matches any strs in token
	      under the given mode.
and_mode_on:  1=all strings must be found, in order to be regarded as
		matched/grepped/found
*/
{
  int i,m, found=0;
  chain *chainptr;
  char *strptr;
  if(token==NULL || oneline==NULL) return(0);
  m=strlen(oneline);
  if(!m) return(0);
  chainptr=token;
  while(chainptr!=NULL)
   { strptr=chainptr->strone;
     i=comparestrs(strptr, oneline, mode);
     chainptr=chainptr->next;
     if(i)
       { if(and_mode_on) if(chainptr==NULL) found=1;
			 else continue;
	 else found=1;
       }
     else if(and_mode_on) break;
     if(found) break;
   }
  return(found);
}


int wordcmp(char *one, char *two, int start, int end)
/* compare word strs one and two, from start-th word to end-th word
   return: similar to strcmp
*/
{
  char *ptr, *oneptr;
  int i,j, wordended;
  if( one==NULL && two==NULL) return(0);
  if( one==NULL) return(-1);
  if( two==NULL) return(1);

  ptr=one;
  while((*ptr==' ' || *ptr==0x9 || *ptr=='\n' ) && *ptr) ptr++;
  for(i=0;i<start-1;i++)
  {  while(*ptr!=' ' && *ptr!=0x9 && *ptr!='\n' && *ptr) ptr++;
     while((*ptr==' ' || *ptr==0x9 || *ptr=='\n' ) && *ptr) ptr++;
  }
  oneptr=ptr;

  ptr=two;
  while( (*ptr==' ' || *ptr==0x9 || *ptr=='\n' ) && *ptr) ptr++;
  for(i=0;i<start-1;i++)
  {  while(*ptr!=' ' && *ptr!=0x9 && *ptr!='\n' && *ptr) ptr++;
     while((*ptr==' ' || *ptr==0x9 || *ptr=='\n' ) && *ptr) ptr++;
  }
  i=strlen(ptr);
  j=strlen(oneptr);
  if(!i && !j) return(0);
  if(!i) return(-1);
  if(!j) return(1);

  i=start;
  wordended=0;
  while(i<=end)
  {  if(*ptr<*oneptr) return(1);
     if(*ptr>*oneptr) return(-1);
     if(!*ptr) return(0);
     if((*ptr==' ' || *ptr==0x9 || *ptr=='\n') && i>=end) return(0);
     if(*ptr==' ' || *ptr==0x9 || *ptr=='\n') { wordended=1; }
     else if(wordended) { wordended=0; i++; }
     ptr++;
     oneptr++;
  }
  return(0);
}


int cmpwords(chain *front, char *lineone, char *linetwo)
{ chain *ptr;
  int i, position;
  if(front==NULL) return(1);
  if(lineone==NULL && linetwo==NULL) return(0);
  if(lineone==NULL || linetwo==NULL) return(1);

  ptr=front;
  while(ptr!=NULL)
  {  position=ptr->numone;
     if(position<0)
     { position = -position;
       i=wordcmp(lineone,linetwo,position, position);
       if(i) return(i);
     }
     ptr=ptr->next;
  }
  return(0);
}




/************************************************************
remove n-th substrings or characters
*************************************************************/

int zerocount(char *oneline, int maxlen)
{ int i;
  for(i=0;i<maxlen;i++)
   if(oneline[i]!=0) break;
  return(i);
}


int squeeze(char *oneline, chain *front)
/*    aim:   remove characters of string oneline according to
	     the character intervals given by front .
    entry:   front should come from compliment()
   return:   0=nothing done
	    >0=squeezed
*/
{ int i,j,k,m,mm,n,p;
  char *chptr;
  chain *ptr;
  if(oneline==NULL) {mm=m=0;} else mm=m=strlen(oneline);
  if(front==NULL || !m) return(0);
  n=m;
  for(i=m-1;i>=0;i--)
    if(oneline[i]=='\n' /* || oneline[i]=='\r' */ ) n=i;
    else break;
  ptr=front;
  while(ptr!=NULL)
   { i=ptr->numone; j=ptr->numtwo;
     i=max(i,0);
     p=min(j+1,n);
     if(j<0) p=n;
     for(k=i;k<p;k++) oneline[k]=0;
     ptr=ptr->next;
   }

   chptr=oneline;
   while(m>0)
   { if(*chptr==0)
      { p=zerocount(chptr,m);
	movebytes(chptr+p, chptr, m-p,0);
	m=m-p;
      }
     else
      { chptr++;  m--; }
   }
   *chptr=0;
   m=strlen(oneline);
   return(mm-m);
}


int shrink(char *oneline, chain *front)
/*    aim:   remove substrings of string oneline according to
	     the string intervals given by front .
    entry:   front should come from compliment()
   return:   0=nothing done
	    >0=shrinked
     note:    space/TAB are white spaces
*/
{ int i,m,mm,n,p,q,index,count,begfound,endfound,whitespace;
  int strhead,strtail,headnum,tailnum;
  chain *ptr,*current;
  char  *chptr, ch;
  if(oneline==NULL) {mm=m=0;} else mm=m=strlen(oneline);
  if(front==NULL || !m) return(0);
  n=m;
  for(i=m-1;i>=0;i--)    /* protect CR from deletion */
    if(oneline[i]=='\n' /* || oneline[i]=='\r' */ ) n=i;
    else break;

  ptr=front;
  while(ptr->next!=NULL) ptr=ptr->next;
  current=ptr;
  while(1)
   { if(current==front->prev) break;
     p=current->numone+1;
     q=current->numtwo+1;   /* 0-based to 1-based */
     current=current->prev;
     p=max(p,1);
     if(q<=0) q= -1;
     if(p>q && q>=0) continue;
     begfound=0; endfound=0;
     i=index=0;
     for( ;  i<n; i++)     /* remove white spaces */
       { ch=oneline[i];
	 whitespace=(ch==' ' || ch==0x9 || ch==0);
	 if(!whitespace) break;
       }
     index=i; count=0;
     while(1)
     {    /* index =n, or  points to non whitespace */
	if(!begfound)
	  if(count>=p)   {begfound=1;  strhead=headnum; }
	if(begfound && !endfound)
	  if(count>=q)
	    { endfound=1;
	      if(q<0) strtail=n-1; else strtail=tailnum;
	    }
	if(begfound && endfound) break;
	if(index>=n)
	{ if(!begfound) break;
	  if(endfound) break;
	  else  { strtail=n-1;  break;}
	}
	i=index; headnum=i;
		/* head of nontrivial string, if exist (ie i<n) */
	for( ; i<n;  i++)
	  { ch=oneline[i];
	    whitespace=(ch==' ' || ch==0x9 || ch==0);
	    if(whitespace) break;
	  }
	tailnum=i-1; count++;
	for( ;  i<n; i++)     /* remove white spaces */
	  { ch=oneline[i];
	    whitespace=(ch==' ' || ch==0x9 || ch==0);
	    if(!whitespace) break;
	  }
	index=i;
     }
     if(begfound)
       for(i=strhead;i<=strtail;i++) oneline[i]=0;
  }   /* end of main while */

   /* remove  zeros in oneline */
   chptr=oneline;
   while(m>0)
   { if(*chptr==0)
      { p=zerocount(chptr,m);
	movebytes(chptr+p, chptr, m-p,0);
	m=m-p;
      }
     else
      { chptr++;  m--; }
   }
   *chptr=0;
   m=strlen(oneline);
   return(mm-m);
}





/************************************************************
filter matched/masked substrs
*************************************************************/

int maskstring(char *oneline, chain * chainptr,
	   char *prespaces, char *postspaces, int nocase)
/*    aim:  grep all the substrings in chainptr that are
	    delimited by any char in prespaces.
	    The grepped substrs will be separated by the
	    1st char in postspaces unless its right delimiter
	    is already a char in postspaces.
     case:  comparison with substrings in chainptr will be case
	    sensitive if nocase=0.
     note:  prespaces=NULL or "" implies no delimiters are required.
	    non-empty postspaces forces the char after the found
	    substring into a char in postspaces IMMEDIATELY, unless
	    postspaces=NULL or "".
	    Hence to replace all substrs without delimiters, one
	    needs prespaces=postspaces="".
   return:  0=oneline not changed, mask-pipe (chainptr) not present
	    1=mask-piped, but not changed
	    2=mask-piped, changed
	    3=mask-piped to null

*/
{ int m,n,p,found,current,i,j,frontch,endch,tokenlen,retval=0,leftmost= -2;
  char * maskstr, *token, *partial, *backupstr ;
  chain *ptr;
  if(oneline==NULL || chainptr==NULL) return(0);
  if(prespaces==NULL) prespaces="";
  if(postspaces==NULL) postspaces="";
  m=strlen(prespaces); n=strlen(postspaces);
  p=strlen(oneline);
  if(!p) return(0);
  maskstr=fmalloc(p+1);
  backupstr=fmalloc(p+1);
  strcpy(backupstr,oneline);
  for(i=0;i<p+1;i++) maskstr[i]=0;
  ptr=chainptr;
  while(ptr!=NULL)
  { token=ptr->strone;
    tokenlen=strlen(token);
    current=0; partial=oneline;
    while(current<p)
    { found=foundstr(partial,token,nocase);
      if(found)
       { frontch= partial[found-tokenlen-1];
	 endch= partial[found];
	 i=instr(prespaces, frontch) || m==0 || current+found-tokenlen-1<0 ;
	 if(!i && current+found-tokenlen-1<0) i=1;
	 j=instr(prespaces, endch) || m==0 || current+found>=p  ;
	 if(!j && current+found>p) j=1;
	 if(!j || !i)
	   { current++;
	     partial=oneline+current;
	     continue;
	   }
	 i=instr(postspaces,frontch);
	 j=instr(postspaces,endch);
	 if(!i && n!=0 && current+found-tokenlen-1>=0)
	   partial[found-tokenlen-1]=postspaces[0];
	 if(!j && n!=0 && current+found<p )
	   partial[found]=postspaces[0];
       }
      if(found) retval=1;
      else break;
      for(i=current+found-tokenlen,j=0; j<tokenlen; i++,j++) maskstr[i]=1;
      i=current+found-tokenlen-1;
      if(n!=0 && i>=0)
	{ maskstr[i]=1;
	  if(leftmost<-1) leftmost=i;
	  else if(leftmost>i) leftmost=i;
	}
      else leftmost= -1;
      current=current+found;
      partial=oneline+current;
    }
    ptr=ptr->next;
  }
  if(leftmost>=0) maskstr[leftmost]=0;
  i=0; j=0;
  while(i<p)
  { if(maskstr[i])
     { oneline[j]=oneline[i]; j++; }
    i++;
   }
  oneline[j]=0;
  if(strcmp(oneline, backupstr)) retval=2;
  if(! strlen(oneline)) retval=3;
  FREE(maskstr);
  FREE(backupstr);
  return(retval);

}




/************************************************************
house-keeping
*************************************************************/

char * code2str(chain *chainptr)
/* returned: " \n"    if chainptr=NULL
	     string   containing all the charcodes in chainptr
	     ""       0 value in 1st entry of chainptr (stop here)
       note: returned string has an extra space for char
*/
{ char *str, *buffstr;
  chain *ptr;
  int m,n;
  ptr=chainptr;
  if(chainptr==NULL)
   { str=fmalloc(4);
     str[0]=' '; str[1]='\n'; str[2]=0;
     return(str);
   }
  str=fmalloc(2);
  str[0]=0;

  while(ptr!=NULL)
  { m=ptr->numone;
    n=strlen(str);
    buffstr=fmalloc(n+3);
    movebytes(str,buffstr,n,0);
    buffstr[n]=(char ) m; buffstr[n+1]=0;
    FREE(str);
    str=buffstr;
    ptr=ptr->next;
    if(!m) break;
  }
  return(str);
}


int notinchain(chain *chainptr, int num)
/* aim     check if num in within the intervals specified by
	   numone-numtwo in any entry of chainptr.
   note    typically, chainptr is the output of chaintable().
   return  1: chainptr=NULL, or num<0, or not found (but more to come)
	   2: not in chain, past the last value
	      (no future values can be in the chain)
	   0: in chain
*/
{ chain *ptr;
  int last;
  if(chainptr==NULL || num<0 ) return(1);
  ptr=chainptr;
  while(ptr!=NULL)
  { last=ptr->numtwo;
    if(num>=ptr->numone && (last<0 || num<=last))
    return(0);
    ptr=ptr->next;
  }
  if(num>last && last>=0 ) return(2);
  return(1);
}


int isempty(char * oneline)
/*  empty if: oneline contains no more than spaces, TABs and \n
*/
{ int i,n;
  n=strlen(oneline);
  if(!n) return(1);
  for(i=0;i<n;i++)
   if( /* oneline[i]!='\r' && */ oneline[i]!='\n'
       && oneline[i]!=' ' && oneline[i]!=0x9) return(0);
  return(1);
}


int taketheline(char * oneline, chain ** chainptr, char on_char,
		int * keeplineptr, int mode)
/*
     aim:  decide if current (boundary) line is to be included or not,
	   according to the on/off strategy described in
	   *chainptr.
  return:  future action directives
	   0=no status change required
	   1=switch found
	   2=take current line, if on/off switch is encountered.
	   return makes sense only if on/off switch is encountered
    mode:  0=identical
	   1=subline inside mainline
	   2=identical upto case
	   3=subline inside mainline upto case
	   4=identical upto case and spaces
	   5=subline inside mainline upto case and spaces
*/
{ chain *ptr;
  int retval=0, keepline= *keeplineptr, windup=0;
  char *str;
  ptr= *chainptr;
  if(ptr==NULL || oneline==NULL) return(0);

  while(1)
  {  str=ptr->strone;
     if(*str) break;
     ptr=ptr->next;
     if(ptr==NULL)
      { *chainptr=ptr; *keeplineptr=keepline; return(retval); }
     keepline=!keepline;
  }

  windup=comparestrs(str,oneline,mode);
  if(windup)
  {  keepline=!keepline; retval=1;
     if(ptr->strtwo!=NULL && ptr->strtwo[0]==on_char) retval=2;

     while(1)
     {  ptr=ptr->next;
	if(ptr==NULL) break;
	str=ptr->strone;
	if(*str) break;
	keepline=!keepline;
     }
   }
   *chainptr=ptr;
   *keeplineptr=keepline;
   return(retval);
}


int printstrchain(FILE *fptr,chain *onechain, long linenum, int prnnum)
/*  print to screen all the strings (in strone) in onechain
    to file fptr.
    Do the the line number interpretation if prnnum<>0.
    i.e.  1st char of strone is ignored, unless it is '#' which
	  puts the number linenum there.

    e.g. "xone=", "#" in strone implies printing "one=(linenum)"

*/
{ chain *ptr=onechain;
  char *str;
  while(ptr!=NULL)
   {str=ptr->strone;
    if(prnnum)
     { if(*str=='#') {fprintf(fptr,"%ld",linenum); str=str+1;}
     }
    fprintf(fptr,"%s", str);
    ptr=ptr->next;
   }
  return(0);
}


int delendcr(char *oneline)
/* 0=nothing done
   1=done
*/
{ int i,m, retval=0;
  if(oneline==NULL) return(0);
  m=strlen(oneline);
  for(i=m-1;i>=0; i--)
   if(oneline[i]!='\n') break;
   else {retval=1; oneline[i]=0;}
  return(retval);
}


int padprint(FILE *fptr, char *oneline, int width)
/*  return:  0=not padded    1=padded
    width<=0: print without padding spaces on right
*/
{ char *buffline;
  int m,n,i,retval=0;

  if(width<=0) fprintf(fptr,"%s",oneline);
  m=(oneline==NULL)? 0:strlen(oneline);
  n=m;
  for(i=m-1;i>=0;i--)
    if(oneline[i]!='\n') break;
    else n=i;
  if(n<width)
  {  buffline=fmalloc(width+m-n+1);
     movebytes(oneline, buffline, n, 0);
     for(i=n;i<width;i++) buffline[i]=' ';
     movebytes(oneline+n,buffline+width,m-n,1);
     fprintf(fptr,"%s",buffline);
     FREE(buffline);
     retval=1;
  }
  else fprintf(fptr,"%s", oneline);
  return(retval);
}


int printaline(FILE *fptr, FILE *infptr, char *oneline, chain *header,
	       chain *tailer, int width, int respect, int rightpad,
	       long linenum, int prnnum, char *headline, char *tailline)
/*    aim:   print oneline to screen, with strs in header and tailer
	     appended at the front and end respectively.
	     header and tailer are printed to file device fptr .
    width:   break oneline into sublines of length no more than width.
	     no subline breaks if width<=0.
	     tailing spaces/TABs are ignored while leading spaces respected.
  respect:   strings delimited by spaces are respected if respect<>0,
	     unless that whole string is itself longer than width.
	     0= no respect, brutal format
	   <>0= respect all strings. long strings are not wrapped even
		if its length is over the width.

   return:   how many lines oneline has been split into.
*/
{  int length,endnum,current,n,i,j,printmore,tailwid;
   char buffer,ch;
   int linecount=0;

   length=strlen(oneline);
   if(!length) return(0);
   delendcr(headline);
   delendcr(tailline);
   if(headline==NULL) headline="";
   if(tailline==NULL) tailline="";
   tailwid=strlen(tailline);

   if(width<=0 || rightpad>1)
     { printstrchain(fptr,header,linenum, prnnum);
       if(tailer!=NULL || tailwid>0 ||rightpad>1) i=delendcr(oneline);
       else i=0;
       fprintf(infptr,"%s%s",headline,oneline);
       if(rightpad>1)
       { n=strlen(oneline);
	 for(j=n;j<width;j++) fprintf(infptr,"%c",' ');
       }
       fprintf(infptr,"%s",tailline);
       if(tailer==NULL && i) fprintf(infptr,"\n");
       printstrchain(fptr,tailer,linenum,prnnum);
       return(1);
     }

   current=0;
   for(i=current;i<length;i++)
    { ch=oneline[i];
      if(ch!=' ' && ch!=0x9) break;
    }
   trimline(oneline+i,0);
   length=strlen(oneline);
   while(1)
   {  linecount++;
      endnum=current+width-1;
      printmore=1;
      for(i=endnum+1;i<length;i++)
	{ ch=oneline[i];
	  if(!(ch==' ' || ch=='\n')) break;
	}
      if(i>=length) printmore=0;

      if(printmore)
      {  ch=oneline[endnum+1];
	 n=endnum;
	 if(!(ch==' '|| ch==0x9))
	   { for(j=endnum;j>=current; j--)
	      { ch=oneline[j];
		if(ch==' '|| ch==0x9) break;
		else n=j-1;
	      }
	     if(n<current)
	       if(!respect) n=endnum;
	       else
	       { for(i=endnum+1;i<length;i++)
		  { ch=oneline[i];
		    if(ch==' ' || ch==0x9) break;
		    else n=i;
		  }
		  if(i>=length) printmore=0;
	       }
	   }
       }
      else n=length-1;

      buffer=oneline[n+1];
      oneline[n+1]=0;
      printstrchain(fptr,header,linenum,prnnum);
      if ( tailer!=NULL && (oneline[n]=='\n') ) oneline[n]=0;
      if(rightpad)
	   padprint(infptr,oneline+current,width);
      else fprintf(infptr,"%s",oneline+current);
      printstrchain(fptr,tailer,linenum,prnnum);

      if(printmore) { if(tailer==NULL) fprintf(infptr,"\n"); }
      else break;
      oneline[n+1]=buffer;
      current=n+1;
      while(current<length)
       { ch=oneline[current];
	 if(ch==' ' || ch==0x9 ) current++;
	 else break;
       }
   }
   return(linecount);
}


void inputnames(int cond, int elsecond, int failed, FILE *fptr,
		int filenum, char *filename, char isconcr, char *outfile)
/* isconcr <>0: '\r'
   display filenames in different ways for each input file
*/
{ char *linkto=" TO ", *outputname="";
  if(outfile!=NULL) outputname=outfile; else linkto=outputname;

  if(cond)
  fprintf(fptr ,"INPUT [%d]: CMD LINE:", filenum);
  else if(elsecond)
	 fprintf(fptr, "INPUT [%d]: STDIN:",filenum);
       else if(!failed)
	    fprintf(fptr, "INPUT [%d]: %s%s%s",filenum, filename,
		     linkto, outputname);
	    else
	    fprintf(fptr, "NONE [%d]: %s",filenum, filename);
  if(isconcr) { isconcr='\r'; clreol();} else isconcr='\n';
  fprintf(fptr,"%c",isconcr);
}


char *inputnextline(chain *files1, chain *files2, int which, int cyclic)
/*  get a line from
	files1:  if which=1
	files2:  if which=2
initialisation:  if otherwise
       read files again, if cyclic<>=0.
*/

{ char *oneline=NULL;
  char *filename=NULL;
  static chain  *current1=NULL, *current2=NULL,
		*front1=NULL, *front2=NULL, *ptr;
  static FILE   *fptr1=NULL, *fptr2=NULL;
  chain *current, *files;
  FILE *fptr;
  int i,j,k;


  if(which<=0 || which >=3)
  { front1=files1; front2=files2;
    for(i=1;i<=2;i++)
    { if(i==1) files=files1; else files=files2;
      if(files!=NULL)
      { current=files;
	fptr=NULL;
	filename=current->strone;
	if(filename!=NULL) fptr=fopen(filename,"r");
	if(i==1)  { current1=current; fptr1=fptr; }
	else { current2=current; fptr2=fptr; }
      }
    }
    return(NULL);
   }

  if(which==1) {current=current1; fptr=fptr1; ptr=front1; }
  else {current=current2; fptr=fptr2; ptr=front2; }

  for(k=1; k<=2; k++)
{
  if(fptr!=NULL) oneline=inputaline(fptr);
  if(oneline==NULL && current!=NULL)
  { while(1)
    {  filename=NULL;
       current=current->next;
       while(current!=NULL)
	{ filename=current->strone;
	  if(filename!=NULL) break; else current=current->next;
	}
      if(filename==NULL) break;
      if(fptr!=NULL) fclose(fptr);
      fptr=fopen(filename,"r");
      if(fptr==NULL) continue;
      oneline=inputaline(fptr);
      if(oneline==NULL)
	{ fclose(fptr); fptr=NULL; continue; }
      break;
    }
  }

  if(!cyclic || oneline!=NULL) break;
  else if(ptr!=NULL)
       { current=ptr;
	 if(fptr!=NULL) fclose(fptr);
	 fptr=NULL;
	 filename=current->strone;
	 if(filename!=NULL) fptr=fopen(filename,"r");
       }
       else break;
}

  if(which==1) {current1=current; fptr1=fptr; }
  else {current2=current; fptr2=fptr; }
  return(oneline);
}




/************************************************************
get masked files / UNIX type wild cards
*************************************************************/

chain *getdirfiles(char *dirname, char *flagstr)
/*  add flagch to ->strtwo if flagch!=0
*/
{ DIR *dir;
  struct dirent *direntry;
  char *filename, *entry;
  int m;
  chain *front=NULL, *current, *ptr;
  if((dir=opendir(dirname))==NULL) return(NULL);
  while((direntry=readdir(dir))!=NULL)
  { entry=direntry->d_name;
    if(!strcmp(entry,".") || !strcmp(entry,"..")) continue;
    ptr=emptychain();
    if(flagstr!=NULL) ptr->strtwo=dupstr(flagstr,0);
    ptr->strone=dupstr(entry,0);
    if(front==NULL)
    { front=current=ptr;}
    else
    { current->next=ptr; ptr->prev=current;
      current=ptr;
    }
  }
  closedir(dir);
  sortchain(&front,1);
  return(front);
}


char *findvalidpath(char *maskstr, int dosmode)
{ int ch,i,j,m;
  char *path;
  DIR *dir;
  m=(maskstr==NULL)? 0:strlen(maskstr);
  path=fmalloc(m+2);
  movebytes(maskstr,path,m,2);
  if(!m) { path[0]='.'; return(path); }

  for(j=0;;j++)
  {
    m=strlen(path);
    ch=path[m-1]; path[m+1]=0;
    if( dosmode && ch!='\\' && ch!=':')  path[m]='\\';
    else if (!dosmode && ch!='/' ) path[m]='/';

    if((dir=opendir(path))!=NULL)
    { closedir(dir); return(path); }
    path[m]=0;

    if(j) break;

    for(i=m-1; i>=0; i--)
    { ch=path[i];
      if(dosmode)
      { if(ch=='\\' || ch==':') break; }
      else
      { if(ch=='/') break; }
    }

    if(!m || i<0)
    { path[0]='.'; path[1]=0; return(path); }
    path[i+1]=0;
  }
  FREE(path);
  return(NULL);
}


int mayadddot(char *pathname)
/* check if pathname under DOS is same as adding a right '.'
*/
{ int ch,i,m,found;
  m=(pathname==NULL)? 0:strlen(pathname);
  if(!m) return(0);
  ch=pathname[m-1];
  if(ch=='\\' || ch==':') return(0);
  found=0;
  for(i=m-1;i>=0;i--)
   { ch=pathname[i];
     if(ch=='\\' ||  ch==':') break;
     else if(ch=='.') { found=1; break; }
   }
  return(!found);
}


chain *getmaskfiles(char *maskstr, char *flagstr, int dosmode)
{ chain *dirfiles, *front, *current, *ptr;
  char *filename, *path, *filemask, *buffline;
  int i,m,n,matched,chkdot;

  path=findvalidpath(maskstr,dosmode);
  if(path==NULL) return(NULL);
  dirfiles=getdirfiles(path,flagstr);
  if(dirfiles==NULL) { FREE(path); return(NULL);}

  m=max(strlen(maskstr), strlen(path) );
  filemask=fmalloc(m+2);
  movebytes(maskstr,filemask,m,1);

  if(dosmode) for(i=0;i<m;i++) filemask[i]=upcase(filemask[i]);

  if(!strcmp(path,maskstr) || strlen(path)>strlen(maskstr) )
    { filemask[0]='*'; filemask[1]=0; }
  else if(strcmp(path,"."))
       { i=strlen(path);
	 movebytes(filemask+i, filemask, m-i,1);
       }

  if(dosmode)
  { chkdot=strlen(maskstr);
    for(i=chkdot-1;i>=0;i--)
      if(maskstr[i]!='*') break;
    if(i>0 && maskstr[i]=='.') chkdot=1; else chkdot=0;
  }

  front=current=dirfiles;
  while(current!=NULL)
  { filename=current->strone;
    matched=strmatch(filename,filemask);

    if(!matched && dosmode && chkdot && mayadddot(filename) )
    { buffline=dupstr(filename,2);
      buffline[strlen(filename)]='.';
      matched=strmatch(buffline,filemask);
      FREE(buffline);
    }

    if(matched) current=current->next;
    else
    { ptr=current;
      if(front==current)
      { front=current=current->next;
	if(current!=NULL) current->prev=NULL;
      }
      else
      { current->prev->next=current->next;
	current=current->next;
	if(current!=NULL) current->prev=ptr->prev;
      }
      ptr->prev=ptr->next=NULL;
      freechain(&ptr);
    }
  }

  if(strcmp(path,"."))
  { current=front; n=strlen(path);
    while(current!=NULL)
    { filename=current->strone;
      if(filename!=NULL)
      { m=strlen(filename);
	buffline=fmalloc(m+n+1);
	movebytes(path,buffline,n,0);
	movebytes(filename, buffline+n, m,1);
	FREE(filename);
	current->strone=buffline;
      }
      current=current->next;
    }
  }

  FREE(path);
  FREE(filemask);
  return(front);
}


chain *getfulldirfiles(char *dirname, char *flagstr, int dosmode)
/* get a full directory list matching dirname, replace ->strtwo by
   the character flagstr so as to specify the entry
*/
{ chain *front, *current;
  char *filename, *path, *buffline;
  int ch,m,n;

  m=(dirname==NULL)? 0:strlen(dirname);
  if(!m) return(NULL);
  path=dupstr(dirname,2);
  ch=path[m-1];
  if(dosmode) { if(ch!='\\' || ch!=':') path[m]='\\';}
  else { if(ch!='/' ) path[m]='/'; }

  front=current=getdirfiles(path,flagstr);
  if(front==NULL) { FREE(path); return(NULL); }

  n=strlen(path);
  while(current!=NULL)
  { filename=current->strone;
      if(filename!=NULL)
      { m=strlen(filename);
	buffline=fmalloc(m+n+1);
	movebytes(path,buffline,n,0);
	movebytes(filename, buffline+n, m, 1);
	FREE(filename);
	current->strone=buffline;
      }
      current=current->next;
  }

  FREE(path);
  return(front);
}


chain *expandmaskfiles(chain *maskchain, char *flagstr, int dosmode)
/* get all dir entries matching any entry given via maskchain
*/
{ chain *front, *tail, *current, *ptr;
  char *maskstr;
  if(maskchain==NULL) return(NULL);

  current=maskchain;
  front=tail=NULL;
  while(current!=NULL)
  { maskstr=current->strone;
    ptr=getmaskfiles(maskstr,flagstr,dosmode);
    if(ptr!=NULL)
    { if(tail==NULL) front=ptr;
      else { tail->next=ptr; ptr->prev=tail; }
      while(ptr->next!=NULL) ptr=ptr->next;
      tail=ptr;
    }
    current=current->next;
  }
  return(front);
}


int maskmatched(char *str, chain *maskptr)
{ chain *ptr;
  ptr=maskptr;
  while(ptr!=NULL)
  { if(!strmatch(str,ptr->strone)) return(0);
    ptr=ptr->next;
  }
  return(1);
}


int removalmatched(char *str, chain *maskptr)
{ chain *ptr;
  ptr=maskptr;
  while(ptr!=NULL)
  { if(strmatch(str,ptr->strone)) return(1);
    ptr=ptr->next;
  }
  return(0);
}



int insidesubdir(char *dirstr, chain *maskchain)
/* check if maskchain (in and mode) can possibly be obtained
   from dir seed dirstr
*/
{ char *chptr,*str;
  chain *ptr;
  int retval=1,i,j,n,m;
  if(maskchain==NULL) return(1);  /* i.e. no masks exist */
  if(dirstr==NULL) return(0);
  ptr=maskchain;
  m=strlen(dirstr);
  while(ptr!=NULL && retval)
  { chptr=ptr->strone;
    if(chptr!=NULL)
    { j=n=strlen(chptr);
      for(i=0;i<n;i++) if(chptr[i]=='*') {n=i; break;}
      if(i>=j && m>n) {retval=0; break;}
      n=min(n,m);
      for(i=0;i<n;i++)
       if(dirstr[i]!=chptr[i] && chptr[i]!='?') {retval=0; break; }
    }
    ptr=ptr->next;
  }
  return(retval);
}



/************************************************************
chain basic operations
*************************************************************/

chain *linkchain(chain *one, chain *two)
/* one and two can no longer be used after the linkage
   best make them NULL after the linkage
*/
{ chain *ptr;
  if(one==NULL && two==NULL) return(NULL);
  if(one==NULL) return(two);
  if(two==NULL) return(one);
  ptr=one;
  while(ptr->next!=NULL) ptr=ptr->next;
  ptr->next=two;
  two->prev=ptr;
  return(one);
}


int insertchain(chain *mainptr, chain *subptr)
/* nothing done if either pointer is NULL
   mainptr->next=subptr, subptr->next=mainptr->next
*/
{ chain *ptr;
  if(mainptr==NULL || subptr==NULL) return(0);
  if(mainptr->next!=NULL)
  {  ptr=subptr;
     while(ptr->next!=NULL) ptr=ptr->next;
     mainptr->next->prev=ptr;
     ptr->next=mainptr->next;
  }
  mainptr->next=subptr;
  subptr->prev=mainptr;
  return(1);
}


int appendchain(chain **mainptr, chain *subptr)
/* nothing done if either subptr is NULL
   subptr will be meaningless after appendiment
*/
{ chain *ptr;
  if(subptr==NULL) return(0);
  if(*mainptr==NULL) *mainptr=subptr;
  ptr= *mainptr;
  if(ptr!=subptr)
  {  while(ptr->next!=NULL) ptr=ptr->next;
     ptr->next=subptr;  subptr->prev=ptr;
  }
  return(1);
}


char * catchain(chain *chainptr)
/* make a single linked/combined string out of a chain
*/
{ int i,j,m;
  chain *ptr;
  char *oneline=NULL;
  if(chainptr==NULL) return(NULL);
  ptr=chainptr;
  m=0;
  while(ptr!=NULL)
  { m+= (ptr->strone==NULL)? 0:strlen(ptr->strone);
    ptr=ptr->next;
  }
  if(m>0)
  { oneline=fmalloc(m+1);
    i=0; ptr=chainptr;
    while(ptr!=NULL)
    { j=(ptr->strone==NULL)? 0:strlen(ptr->strone);
      if(j && i+j<=m)
       { movebytes(ptr->strone,oneline+i,j,0); i +=j; }
      ptr=ptr->next;
    }
    oneline[m]=0;
  }
  return(oneline);
}


/************************************************************
char-wise ops
*************************************************************/

int insertchwise(char **onelineptr, char *substr)
/* aim:  insert substr in front each character, apart from
	 the last '\n'
 entry:  *onelineptr must be allocated via malloc .
return:  1=done,   0=nothing to be done .
*/
{ int crdeleted,i,j,m,n,cvtyes=0,cvtchar;
  char *oneline= *onelineptr, *newline, ch;

  if(*onelineptr==NULL || substr==NULL) return(0);

  if( ( (unsigned char) substr[0])==0xff && substr[1]!=0 )
  { cvtyes=1; cvtchar=substr[1]; substr+=2;}

  crdeleted=delendcr(oneline);
  m=strlen(oneline);
  n=strlen(substr);
  newline=fmalloc(m*(n+1)+2);
  for(i=0;i<m;i++)
  { movebytes(substr,newline+i*(n+1), n,0);
    newline[i*(n+1)+n]=oneline[i];
  }
  newline[m*(n+1)]=newline[m*(n+1)+1]=0;
  if(crdeleted) newline[m*(n+1)]='\n';
  FREE(oneline);
  *onelineptr=newline;
  if(!cvtyes) return(1);

  m=strlen(newline);
  n=strlen(substr);
  for(i=0;i<m;i++)
  { ch=newline[i+n];
    if(ch=='\n' || ch=='\r') continue;
    for(j=0;j<n;j++)
    if(newline[j+i]==cvtchar) newline[j+i]=ch;
    i+=n;
  }
  return(1);
}


chain * charparse(char *env, char marker, char flagchar)
/*  create a chain of substrings delimitered by char marker
    from a single string env. the field ->strtwo of each chain entry
    will be replaced by char flagchar
    e.g.  marker=; and env=one;;two; will create chain
	  one->"" ->two
*/
{ chain *front, *current, *ptr;
  char backup, *chptr, flag[2];
  int m, quit;
  m=(env==NULL)? 0:strlen(env);
  if(!m) return(NULL);

  front=current=NULL;
  quit=0;
  while(1)
  { if(!*env) break;
    chptr=strchr(env,marker);
    if(chptr==NULL)  quit=1;
    else { backup= *chptr; *chptr=0; }
    ptr=emptychain();
    ptr->strone=dupstr(env,0);
    if(flagchar)
    { flag[0]=flagchar; flag[1]=0;
      ptr->strtwo=dupstr(flag,0);
    }
    if(current==NULL) front=current=ptr;
    else
    { current->next=ptr; ptr->prev=current;
      current=ptr;
    }
    if(quit) break;
    *chptr=backup;
    env=chptr+1;
  }
  return(front);
}


int revletters(char **lineone)
{ char *aline=*lineone;  /* -t3 */
  int total,half,i,ch;
  if(aline==NULL || !(total=strlen(aline)) ) return(0);
  if(aline[total-1]=='\n') total--;
  half=total/2; total--;
  for(i=0; i<half; i++)
    {   ch=aline[total-i]; aline[total-i]=aline[i];
	aline[i]=ch;
    }
  return(0);
}



/************************************************************
shorthand
*************************************************************/

int useshorthand(chain *front, chain *env)
/*  replace shorthand notation of ->strone in each chain entry
    by the ones given by env
    shorthand:  //1  = 1st entry of env, i.e. env->strone
		//3  = 3rd entry of env, i.e. env->next->next->strone
*/
{ chain *ptr;
  char *chptr;
  int m,i,retval=0;

  if(front==NULL || env==NULL) return(0);
  while(front!=NULL)
  {  chptr=front->strone;
     if(chptr!=NULL && chptr[0]=='/' && chptr[1]=='/')
     { m=atoi(chptr+2);
       if(m>0)
       { ptr=env;
	 for(i=1;i<m;i++)
	   if(ptr!=NULL) ptr=ptr->next; else break;
	 if(ptr!=NULL)
	 { chptr=ptr->strone;
	   if(chptr!=NULL)
	   { FREE(front->strone);
	     front->strone=dupstr(chptr,0);
	     retval=1;
	   }
	 }
       }
     }
     front=front->next;
  }
  return(retval);
}


int usecompactform(chain **frontptr, char marker)
/*  parse chain entry ->strone into a list a subchains
    entry->strone will be parse if it's of the form
      entry->strone="//str1<marker>str2<marker>"
*/
{ chain *ptr, *nextptr, *front= *frontptr;
  char *chptr;
  int ch,retval=0;
  if(front==NULL) return(0);
  while(front!=NULL)
  {  chptr=front->strone;
     if(chptr!=NULL && chptr[0]=='/' && chptr[1]=='/')
     { retval=1;
       ch= *(front->strtwo);
       ptr=charparse(chptr+2, marker, ch);
       nextptr=front->next;
       front->next=NULL;
       if(nextptr!=NULL) nextptr->prev=NULL;
       if(*frontptr==front) ch=1; else ch=0;
       freechain(&front);
       if(ch) *frontptr=NULL;
       appendchain(frontptr,ptr);
       appendchain(frontptr,nextptr);
       front=nextptr;
       continue;
     }
     front=front->next;
  }
  return(retval);
}




/************************************************************
DOS specific: environment para, keyboard, sound
*************************************************************/

#ifndef UNIXMODE  /* these are functions specific to DOS  */

void waitakey(int timedelay, int beepat, int countdown, int timeoutkey)
/*  wait until there is a key availabe in keyboard buffer,
    unless timedelay>0 and timedelay seconds have been waited.

    if timedelay>0, then there will be a beep at beepat-th seconds (from
    the timeout) and display count down in seconds from countdown-th
    seconds (from the end).

    if timeoutkey!=0, then a key of ASCII code timeoutkey will be
    pushed into the keyboard buffer to be immmediately read in
*/
{ clock_t entry;
  struct text_info scrinfo;
  char scrbuff[23];
  long timeold= -1,timenow;
  long elapsed;

  if(timedelay<=0) countdown=0;
  entry=clock();

  if(countdown>0)
  { gettextinfo(&scrinfo);
    gettext(scrinfo.winright-10,scrinfo.wintop,
	    scrinfo.winright, scrinfo.wintop, scrbuff);
  }

  while(1)
  { if(kbhit()) break;
    elapsed=(clock()-entry)*10;
    if(elapsed > ((long) timedelay)*MY_CLK_TCK) break;
    timenow= elapsed/MY_CLK_TCK;

    if(countdown>0)
    { if(timedelay-timenow<=countdown && timenow!=timeold)
      { timeold=timenow;
	gotoxy(scrinfo.winright-10, scrinfo.wintop);
	clreol();
	if(timedelay-timenow<=2)
	{ textbackground(RED); textcolor(YELLOW+BLINK); }
	else
	{ textbackground(CYAN); textcolor(YELLOW); }
	cprintf(" %ld ", timedelay-timenow);
	textattr(scrinfo.attribute);
	gotoxy(scrinfo.curx, scrinfo.cury);
      }
    }

    if(beepat>0)
      if(timedelay-timenow==beepat)
      {beepat=0;
       sound(440); delay(200); nosound();
      }
  }

  if(countdown>0)
  { puttext(scrinfo.winright-10,scrinfo.wintop,
	    scrinfo.winright, scrinfo.wintop, scrbuff);
    textattr(scrinfo.attribute);
    gotoxy(scrinfo.curx, scrinfo.cury);
  }

  if(!kbhit() && timeoutkey) ungetch(timeoutkey);
}


int getkeylevel(FILE *fptr, char *keys, int nocase, int echo, int mayescape,
		int beep, int retchar, int clrkeys, int loop,
		int waitforkey, int extendkeys,
		int timedelay, int beepat, int countdown, int timeoutkey)
/* return:    0=not found or escaped (when mayescape!=0)

   waitforkey:wait to get chars if key buffer is empty
   keys:      found if console input char matches one char in keys;
	      return the position if retchar==0, otherwise return charcode.
	      if keys=="", then just wait for one char to be input, unless
	      waitforkey==0
   loop:      keep reading (when waitforkey!=0) until a legal char
	      is read in or escaped when mayescape!=0
   nocase:    if nocase==0, then the match will be case sensitive
   retchar:   return last input char code
   echo:      echo the last read char unless escaped when mayescape!=0
   clrkeys:   clear keyboard buffer first
   beep:      beep at any illegal input char
   timedelay,beepat,countdown,timeoutkey: see waitakey()

   empty keys:  ignores extendkeys, loop and beep, accept at most 1 key
		extended key preserved if retchar!=0, i.e. return 0
		and leave the next half in buffer.
		if retchar==0, always return 0
   noempty:     extended keys are filtered out, as if they are not
		pressed at all
*/
{ int retval,matched,m,i,j,k;
  char ch,reply[3];
  m=keys==NULL? 0:strlen(keys);
  ch=0;
  if(nocase) for(i=0;i<m;i++)
    { j=keys[i];
      if(!extendkeys || extendkeys && ch!=(char)255) keys[i]=upcase(j);
      ch=j;
    }
  if(clrkeys) while(kbhit()) getch();

  if(!m)
  { if(waitforkey || kbhit() )
    { waitakey(timedelay,beepat,countdown,timeoutkey);
      if(!kbhit() && timedelay>0) return(0);
      i=getch();
    } else i=999;
    retval= ( retchar && (i!=999) )? i:0;
    if(!i && !retchar && kbhit() ) j=getch();
    if(nocase) i=upcase(i);

    if(echo && i!=999 && (mayescape && i!=27 || !mayescape) )
      if(i) fprintf(fptr,"%c",i);
      else if(!retchar) fprintf(fptr,"[%u]",j);

    return(retval);
  }

  while(1)
  { if(waitforkey || !waitforkey && kbhit() )
    { waitakey(timedelay,beepat,countdown,timeoutkey);
      if(!kbhit() && timedelay>0) return(0);
      j=getch();
    }  else j=999;
    if(j==999) return(0);

    reply[1]=reply[2]=0;
    reply[0]=j;
    if(!j) reply[1]=getch();
    if(nocase && j) *reply=j=upcase(j);

    if(!j) reply[0]=255;

    i=retval=foundstr(keys,reply,0);
    while(i>1 && !reply[1] && extendkeys && keys[retval-2]==(char) 255)
    {  i=foundstr(keys+retval,reply,0);
       if(!i) retval=0; else retval+=i;
    }

    matched=!( !retval || !extendkeys && !j ||
		extendkeys && (char) j==(char) 255 );
    if(matched || !loop)
    { if(retchar) retval= j? reply[0]: reply[1];
      else
      { k=0;
	for(i=0;i<retval;i++)
	 if(!extendkeys || keys[i]!=(char) 255 ) k++;
	if(extendkeys && (char) j== (char) 255 ) k=0;
	retval=k;
      }
    }

    if(j==27 && mayescape)
    {  matched=1;
       retval=retchar? 27:0;
    }

    if(!matched && beep && waitforkey && loop) fprintf(fptr,"%c",0x7);
    if(echo && (matched || !loop) && (mayescape && j!=27 || !mayescape) )
      if(j) fprintf(fptr,"%s",reply);
      else fprintf(fptr,"[%u]",reply[1]);
    if(matched || !loop) break;
  }

  return(retval);
}


pspchain *getparents(void)
/*  get a list of the PSP addresses (along with environment block
    address and size ) of all the parent processes starting from
    the current process.
*/
{ unsigned parent, current;
  pspchain *front=NULL, *tail, *ptr;
  current=_psp;
  while(1)
  { parent= * ( (unsigned int *) MK_FP(current,0x16));
    ptr=MALLOC(sizeof(pspchain));
    ptr->next=ptr->prev=NULL;
    ptr->env= *( (unsigned int *) MK_FP(current,0x2c) ) ;
    ptr->envsize= *( (unsigned int *) MK_FP(ptr->env-1,3) );
    ptr->psp=current;
/*
    ptr->parent=parent;
    ptr->memsize= *( (unsigned int *) MK_FP(current-1,3));
*/
    if(front==NULL) front=tail=ptr;
    else
    { tail->next=ptr;
      ptr->prev=tail;
      tail=ptr;
    }
    if(parent==current) break; else current=parent;
  }
  return(front);
}


int displayenv(FILE *outfptr, pspchain *enventry, int deleteall)
/* aim:     display DOS environment parameter of its parent processes
	    directly
   return:  1=always successful
*/
{ int i;
  char *ptr;
  unsigned envseg,k,extrawidth,delwidth,firstwidth,secondwidth,mainwidth ;
  envseg=*( (unsigned int *) MK_FP(enventry->psp,0x2c) );
  ptr=(char *) MK_FP(envseg,0);
  if(deleteall) { ptr[0]=0; ptr[1]=0; return(1);}
  while(1)
  { if((i=strlen(ptr))!=0) fprintf(outfptr,"%s\n",ptr); else break;
    ptr+=i+1;
  }
  return(1);
}


int setenv(FILE *outfptr,pspchain *enventry, char *setcmd, int org, int brute)
/* aim:     set DOS environment parameter of its parent processes
	    directly

   return:  0=failed attempt
	    1=done successfully
	   -1=nothing needs done

  env->COMSPEC=...0PATH=.... 0 0 1 0 C:\BC\ng.exe   0
       |<-- firstwidth ------->| |<-- 2ndwidth    ->|
			env+firstwidth+secondwidth ->|

  org:  0=not ancester, all envparas considered
	1= (<>0) oldest parent env, only parameters delimitered
	   by 0 0 are considered
  brute:    0=check on validity of setcmd
	    1=non-check

*/
{ int i,j,found,displaymode=0;
  char ch, *env,buff[2];
  char *matchptr, *zerosptr, *ptr;
  unsigned envseg,k,extrawidth,delwidth,firstwidth,secondwidth,mainwidth ;

  if( setcmd!=NULL && setcmd[0]=='=')
  { i=foundstr(setcmd+1,"=",0);
    if(!i) i=strlen(setcmd);
    if(! strcmp(setcmd,"=") || ! (j=strcmp(setcmd,"==")) )
      { displayenv(outfptr,enventry,!j); return(-1); }
    movebytes(setcmd+1,setcmd,i,0);
    setcmd[i-1]='='; setcmd[i]=0;
    displaymode=1;
  }

  if( !( (setcmd==NULL)? 0:strlen(setcmd) ) ) return(-1);
  found=foundstr(setcmd,"=",0);
  if(!found || found==1) return(-1);
  if(!brute && foundstr(setcmd+found,"=",0)) return(-1);
  if(enventry==NULL) return(0);

  for(i=0;i<found;i++)
  { ch=setcmd[i];
    setcmd[i]=upcase(ch);
  }

  envseg=*( (unsigned int *) MK_FP(enventry->psp,0x2c) );
  env=(char *) MK_FP(envseg,0);
  buff[0]=buff[1]=0;
  mainwidth=enventry->envsize*16;
  extrawidth=strlen(setcmd)+1;

  zerosptr=locatepos(env,mainwidth,buff,2,0);
  if(zerosptr==NULL) return(0);
  firstwidth=zerosptr-env+2;

  envseg=0;
  ch=setcmd[found];
  setcmd[found]=0;
  while(1)
  { matchptr=locatepos(env+envseg, firstwidth-envseg,
	       setcmd, strlen(setcmd), 0);
    ptr=matchptr; ptr--;
    if(matchptr==NULL || matchptr==env || *(ptr)==0) break;
    envseg=matchptr-env+1;
  }
  setcmd[found]=ch;

  if(matchptr!=NULL && displaymode)
  { i=foundstr(matchptr,"=",0);
    fprintf(outfptr,"%s",matchptr+i);
    return(-1);
  }
  if(matchptr!=NULL) delwidth=strlen(matchptr)+1; else delwidth=0;

  envseg= *(  (unsigned int *) (zerosptr+2) );

  secondwidth=0;
  if(!org)
  { if(firstwidth+2<=mainwidth && envseg)
    { ptr=zerosptr+4;
      for(k=0;k<envseg;k++)
      { ptr=locatepos(ptr, env+(mainwidth-1)-ptr, buff,1,0);
	if(ptr==NULL) break; else ptr++;
      }
      if(ptr!=NULL) secondwidth=ptr-zerosptr-3;
      secondwidth+=2;
    }
  }

  if(!strlen(setcmd+found))
  { if(delwidth)
    { movebytes(matchptr+delwidth,matchptr,
		firstwidth-delwidth-(matchptr-env),0);
      envseg=firstwidth-delwidth-1;
      if(envseg) envseg--;
      movebytes(zerosptr,env+envseg,secondwidth+2,0);
      return(1);
    }
    else return(-1);
  }

  if( !(firstwidth+extrawidth-delwidth+secondwidth<=mainwidth) )
  return(0);

  if(delwidth)
     movebytes(matchptr+delwidth,matchptr,
	       firstwidth-delwidth-(matchptr-env),0);
  if(delwidth<extrawidth)
  { envseg=extrawidth-delwidth;
    for(k=firstwidth+secondwidth-1;k>=firstwidth;k--)
      *(env+k+envseg)=*(env+k);
  }
  else
  { envseg=firstwidth+extrawidth-delwidth-2;
    movebytes(zerosptr,env+envseg,secondwidth+2,0);
  }

  envseg=firstwidth-delwidth-1;
  if(envseg==1) envseg=0;
  movebytes(setcmd,env+envseg,extrawidth,1);
  return(1);
}


int soundplay(chain *soundchain)
/*  play the sound according to the frequency and duration
    stored in each entry of chain soundchain
*/
{ chain *ptr=soundchain;
  int oldsound=0;
  if(ptr==NULL) return(0);
  while(ptr!=NULL)
  { if(ptr->numone)
    { if(oldsound==ptr->numone) nosound();
      oldsound=ptr->numone;
      sound(oldsound);
    } else nosound();
    delay(ptr->numtwo);
    ptr=ptr->next;
    kbhit();    /* this is for intercept c-break */
  }
  nosound();
  return(1);
}


int c_break(void)
/* new ctrl-break handler
   now ^C will exit with error level given by CTRLBRK_KEY
   which maybe given at the command line
*/
{ nosound();
  fcloseall();
  if(TMPFILENAME!=NULL) remove(TMPFILENAME);
  exit(CTRLBRK_KEY);
  return(0);
}


#endif





/************************************************************
file and directory utilities
*************************************************************/

char *formname(char *name, chain *extra)
/* extra=NULL gives a copy of name
   construction:  <extra-1><name><extra-2><name>..<name><extra-last>
	     or:  <extra-1>  if extra->next=NULL
*/
{ int n,total=0;
  chain *ptr=extra;
  char *newname, *pos;
  if(name==NULL) name="";
  total=n=strlen(name);
  if(ptr==NULL)
  { newname= (char *) fmalloc(total+1);
    strcpy(newname,name);
    return(newname);
  }
  total+= strlen(ptr->strone);
  ptr=ptr->next;
  while(ptr!=NULL){total+= n+strlen(ptr->strone); ptr=ptr->next;}
  pos=newname= fmalloc(total+1);
  strcpy(pos,extra->strone);
  pos+=strlen(extra->strone);
  ptr=extra->next;
  while(ptr!=NULL)
  {  strcpy(pos,name); pos+=n;
     strcpy(pos,ptr->strone);
     pos+=strlen(ptr->strone);
     ptr=ptr->next;
  }
  *pos=0;
  return(newname);
}


char *fullname(char *filename)
/* return complete pathfilename, in allocated new memory string
  e.g. c:\x\..\\y.z -> C:\Y.Z
*/
{  char ch, drive, *newname, *ptr, *current, *subptr;
   int i,chklastdot;

   if(filename==NULL) filename="";
   current=newname=fmalloc(S_BUFWIDTH);

#ifdef UNIXMODE

/*   strcpy(newname,filename);  */

   getcwd(current,S_BUFWIDTH);
   i=strlen(current);
   if(i>1){ current[i]=DIRMARKER; current[++i]=0; }
   if(*filename==DIRMARKER) strcpy(current,filename);
   else strcpy(current+i,filename);

#else
   uplowcase(filename,1);
   ptr=strchr(filename,':');
   drive=*filename;
   if(ptr==NULL) drive= getdisk()+'A';  else filename=ptr+1;
   if(_getdcwd(drive -'A'+1, current, S_BUFWIDTH-3)==NULL)
     if( _getdcwd(getdisk()+1, current, S_BUFWIDTH-3)==NULL) *current=0;
   if(strlen(current)<=3) current[2]=0;

   if(*filename==DIRMARKER) {current[2]=0; filename++;}
   current=newname+ strlen(newname);
   *current++=DIRMARKER;
   strcpy(current,filename);

   while(*current)
   { chklastdot=0;
     for(i=0;i<8;i++)
     {  ch=*(current++);
	if(ch==DIRMARKER || ch=='.') break;
     }

     if(i) chklastdot=1;
     switch(ch)
     {  case DIRMARKER:   continue;
	case '.':         break;
	default:
	    ptr=strchr(current, DIRMARKER);
	    subptr=strchr(current,'.');
	    if(subptr==NULL)
	    { if(ptr==NULL){ *current=0; continue; }
	      strcpy(current,ptr); current++; continue;
	    }
	    else
	    { if(ptr==NULL || subptr<ptr)
	      { strcpy(current,subptr); current++; }
	      else { strcpy(current,ptr); continue; }
	    }
     }

     if(chklastdot && (*current==DIRMARKER || !*current)) strcpy(current-1,current);
     for(i=0;i<3;i++)
     {  ch=*(current++);
	if(ch==DIRMARKER) break;
     }

     if(ch==DIRMARKER) continue;
     ptr=strchr(current, DIRMARKER);
     if(ptr!=NULL) strcpy(current,ptr);
     else { *current=0; break; }
   }
#endif

   /* remove consecutive '\\' */
   ptr=newname;
   while(*ptr)
   { if(*ptr!=DIRMARKER) { ptr++; continue;}
     current=ptr;
     while(*(current+1) && *(current+1)==DIRMARKER) current++;
     if(current!=ptr) strcpy(ptr,current);
     ptr++;
   }

   /* remove '\.\' */
   ptr=newname;
   while(*ptr)
   { if(*ptr==DIRMARKER)
     { if(ptr[1]=='.' && ptr[2]==DIRMARKER) strcpy(ptr,ptr+2); else ptr++; }
     else ptr++;
   }

   /* deal with '\..\' */
   ptr=newname;
   while((ch=*ptr)!=0)
   { if(ch!=DIRMARKER) {ptr++; continue;}
     if(ptr[1]=='.' && ptr[2]=='.' && ptr[3]==DIRMARKER)
     {  *ptr=0;
	subptr=strrchr(newname,DIRMARKER);
	if(subptr==NULL) {*ptr++=ch; continue; }
	if(subptr[1]=='.' && subptr[2]=='.' && subptr[3]==0)
	  { *ptr++=ch; continue; }
	*ptr=ch;
	strcpy(subptr,ptr+3);
	ptr=subptr;
	continue;
     }
     ptr++;
   }

   ptr=fmalloc(strlen(newname)+1);
   strcpy(ptr,newname);
   FREE(newname);
   return(ptr);
}



int filecopy(char *source, char *target)
/* return 0=success
	  1=NULL names
	  2=fail to read source
	  3=fail to write target
	  4=fail to write completely (disk shortage?)
	  5=fail to close target file
*/
{ FILE *in, *out;
  char *fullsource,*fulltarget;
  int i,same=0;
  if(source==NULL || target==NULL) return(1);
  fullsource=fullname(source);
  fulltarget=fullname(target);
  same=!strcmp(fullsource, fulltarget);

#ifdef UNIXMODE
  in=fopen(fullsource,"r");
  if(in!=NULL) out=fopen(fulltarget,"w");
#else
  in=fopen(fullsource,"rb");
  if(in!=NULL) out=fopen(fulltarget,"wb");
#endif

  FREE(fullsource);
  FREE(fulltarget);
  if(same) return(0);

  if(in==NULL) { if(out==NULL) fclose(out); return(2); }
  if(out==NULL) { if(in==NULL) fclose(in); return(3); }

  while((i=fgetc(in))!=EOF)
  {  if( fputc(i,out)==EOF )
     { fclose(in);  fclose(out); return(4); }
  }
  fclose(in);
  if(fflush(out)) return(5);
  if(fclose(out)) return(5);
  return(0);
}



int makedirs(char *pathfilename, int chkexistence)
/*  return:  0=nothing done
	   n>0=success with n new dirs
	  -n<0=fail at creating n-th new dirs
    if chkexistence<>0
	     0=ok
	    -1=would fail to enter the directory
*/
{ char *ptr, *current=pathfilename,*front,*tail=NULL,*olddir;
  int ch,i,count=0,drive,olddrive,retval=0;

  if(current==NULL) return(retval);

#ifndef UNIXMODE
  olddrive=drive=getdisk()+'A';
  if((ptr=strrchr(current,':'))!=NULL)
  { ch= upcase(*current);
    if(ch>='A' && ch<='Z') drive=ch;
    if(ptr!=current){ strcpy(current+1, ptr); *current=drive; }
    else strcpy(current,ptr+1);
  }
  if((ptr=strrchr(current,':'))!=NULL) current=ptr+1;
  if(_chdrive(drive-'A'+1)) return(-1);
#endif

  olddir=getcwd(NULL,S_BUFWIDTH);
  front=current;

  if(chkexistence)
  {  if((tail=strrchr(front,DIRMARKER))!=NULL
	&& tail!=front )  /* not root */
     { ch=*tail; *tail=0;
       retval=chdir(front);
       *tail=ch;
     }
  }
  else
  while((tail=strchr(current+1,DIRMARKER))!=NULL)
  { ch=*tail;  *tail=0;
    if(chdir(front))
    { if(
#ifdef UNIXMODE
      mkdir(front, 1023 ) ) /* all permission given 111111111=1023 */
#else
      mkdir(front) )
#endif
      { *tail=ch;
	retval=-count-1;
	break;
      }
      else retval= ++count;
    }
    chdir(olddir);
    current=tail; *tail=ch;
  }


#ifndef UNIXMODE
  _chdrive(olddrive-'A'+1);
#endif

  chdir(olddir);
  free(olddir);
  return(retval);
}



char *formnewname(char *filename, chain *strinoldname, chain *strinnewname,
		  chain *extrainname, int dir_level)
/*
   input:  /a/b/c/d/file.name -> c/d/file.name (under dir_level=3)
	    a/b/c/d/file.name -> d/file.name
		  d/file.name -> file.name
   e.g.   -Fc:\a\b\  -}d:c\ -}  -> d:\a\b\c\file.name
	   -Fc:a\b\  -}d:c\ -}  -> d:c\file.name
	   -Fc:a\b\  -}d:\c\ -} -> d:\c\file.name
      -{-2 -+Fc:\a\b\ -}d:c\ -} -> d:c\b\subdirs\file.name
*/
{ char *ptr, *newfilename, *buffline, *tmpline;
  int i,j,k;

  if(filename==NULL) return(NULL);
  ptr=buffline=strrchr(filename,DIRMARKER);

#ifndef UNIXMODE
  if(buffline==NULL) ptr=buffline=strrchr(filename,':');
#endif

  if(dir_level<0)
  {  buffline=filename;
     for(i=0;i< -dir_level;i++)
       if((tmpline=strchr(buffline, DIRMARKER))!=NULL) buffline= ++tmpline;
       else { buffline=ptr; break; }
     if(buffline!=ptr) buffline--;
  }

  if(buffline==NULL)
  {  buffline=filename; i=0; }
  else i= *buffline++;

  newfilename=replace(buffline,strinoldname,strinnewname,0,0,NULL);
  buffline=formname(newfilename,extrainname);
  FREE(newfilename);

  tmpline=NULL;
  if(ptr!=NULL)   /* may need to keep part of path of original
			    name to the new filename */
  {  i=*(++ptr);

#ifndef UNIXMODE
     if( (newfilename=strrchr(buffline,':'))!=NULL)
     {  tmpline=buffline;
	buffline= ++newfilename;
	newfilename=dupstr(newfilename,0);
	*buffline=0;
	buffline=newfilename;
     }
#endif

     if(*buffline!=DIRMARKER) *ptr=0;
     else { i=*filename; *filename=0; ptr=filename; }
     j=strlen(filename);
  } else j=0;

  k=tmpline==NULL?0:strlen(tmpline);
  newfilename=fmalloc(k+j+strlen(buffline)+3);
  if(ptr!=NULL)
  {  if(k) strcpy(newfilename,tmpline);
     strcpy(newfilename+k,filename);
     strcpy(newfilename+k+j,buffline);
     *ptr=i;
  }
  else strcpy(newfilename,buffline); /* nothing to take from oldfilename*/

  if(dir_level<0) strcpy(newfilename+k,buffline);
  if(tmpline!=NULL) FREE(tmpline);
  FREE(buffline);


#ifndef UNIXMODE
  tmpline=strchr(newfilename,':');
  ptr=strrchr(newfilename,':');
  if(tmpline!=ptr) strcpy(tmpline,ptr);

  j=strlen(newfilename); k= -1;
  for(i=0;i<j;i++) if(newfilename[i]==':') k=i;
  if(k>0) strcpy(newfilename,newfilename+(k-1) );
#endif

  buffline=fullname(newfilename);
  FREE(newfilename);
  return(buffline);
}



void renamefile(char *filename, char *newfilename, int no_ren_mesg,
		FILE *namefptr)
{ char *ptr, *buffline;
  int i;

  i=strcmp(ptr=fullname(filename),newfilename);
  FREE(ptr);

  if(i)
  {  buffline=fmalloc(S_BUFWIDTH);

#ifdef UNIXMODE
     sprintf(buffline,"mv -i %s %s", filename,newfilename);
#else
     ptr=strrchr(newfilename,DIRMARKER);
     if(ptr!=NULL) ptr++; else ptr=newfilename;
     sprintf(buffline,"ren %s %s", filename,ptr);
#endif

     if(!no_ren_mesg)
     {  if(namefptr!=stdout) fprintf(stderr,"%s\n",buffline);
	else  fprintf(stdout,"%s\n",buffline);
     }
     if(system(buffline))
     {
#ifdef UNIXMODE
	fprintf(stderr,"Continue? ");
	if(yesno(0)<=0) exit(1);
#endif
     }

     FREE(buffline);
  }
}









/************************************************************
essentially the main function
*************************************************************/

int submain(int argn, char * argv[],
	    char *charops, char *numops, char *strops)
{ int
   i,j,k,m,n,a,b,    /* scratch integers  */
   found,            /* current line found to contain ngrep strs given */
		     /*	    on the cmd line  */
   count,            /* valid cmd parameter number  */
   width,            /* format column width         */
   totallines,       /* total allowed output lines  */
   absorb_space,     /* remove consecutive spaces/tabs  */
   del_cr,           /* remove all linebreaks, absorbed as white space */
   view_str,         /* output command line options                    */
   visible_con,      /* left/right front/end appended strs to stderr   */
   trim_mode,        /* mode to remove leading/tailing spaces/tabs    */
   tab_2_space,      /* convert tab into single space         */
   para_aline,       /* convert paragraph into a single line  */
   respect_str,      /* str longer than width via -w protected */
   no_duplicate,     /* remove duplicate input */
   no_empty,         /* remove all empty lines  */
   one_empty,        /* absorb consecutive empty lines to one empty line */
   empty,            /* emptyline flag  */
   emptyline,        /* re-synchronised consecutive emptyline count  */
   find_last,        /* locate substr via delimiters from right  */
   mark_incl,        /* located substrs attach delimiters  */
   and_on_grep,      /* AND mode for grep (-g)             */
   and_on_ngrep,     /* AND mode for ngrep  (cmd paras)    */
   grepstr_on,       /* ngrep become grep mode, filter in if found grep strs */
   maskpipe_on,      /* lines to be filtered via mask tokens           */
   prn_num,          /* print line number directive '#' active         */
   no_overflow,      /* suppress line width overflow (long too long) message */
   switch_cyclic,    /* input on/off switch via passwords cyclic 4 last 2 */
   file_cyclic,      /* read synchronised insert files cyclically      */
   cmd_lines_mode,   /* input lines from command line strs only        */
   right_pad,        /* pad spaces on right until the width via -w     */
   filename_level=0, /* how to print input file names */
   show_filenames=0, /* print filenames that match masks via -*  */
   clr_promptnames=0,/* no 'MATCHED:' */
   prompt_mode=0,    /* bit 1=show dir match, bit 2=show filenames */
   filename_printed=0,/* has filename been printed ? */
   always_filename,  /* print all filenames         */
   more_filename,
   already_printed,  /* filename already printed    */
   nofake_input,     /* some input filenames are valid */
   dir_recursive,    /* locate dir files recursively   */
   append_output,    /* output in append mode to designated output file */
   casechange_level, /* which option is case sensitive */

   err_code=0,       /* return error code                              */
   true_input=0,     /* current input fr file/stdin, or from cmd tokens */
   true_exit=0,      /* exit all the way to end the program            */
   ini_line=0,       /* initial line num for printing line num via '#' */
   switch_on=1,      /* current input door open/off                    */
   total_inputfile=0,
   lineno_filewise=0, /* treat -i -I filewise */
   outlineno_filewise=0, /*outputline number re-synchronised for each file */
   total_filewise=0,   /* re-synchronise output lineno for each file */
   out_filenames=0,  /* always display input filenames */
   grep_followup=0,  /* how many more lines to display after a gripped line*/
   soft_grep=0,      /* counter starting from a gripped line for -!# */
   word_mode=0,      /* cmp mode for str match for replacement */
   rev_letters=0,    /* reverse chars of input line ? */
   write_filewise=-1,/* -1=no filewise,  0=rename, 1=normal filewise
			  2=normal+create dirs, 3=overwrite, 4=3+create dirs */
   dir_level=0,      /* how many subdir markers to be stripped from input filenames*/
   tmpfileactive=0,  /* use tmp file for output before updating the input file*/
   no_ren_mesg=0,    /* display rename messages */
   ins_add_pending=0,/* line insertion for gripped line is currently active*/
   marked4repl=1,    /* everyline is marked for replacement */

#ifndef UNIXMODE     /* variables specific to DOS version */
   environ_mode,     /* how to set environment parameter */
   no_envchk,        /* invalid form of env tokens may be put to env para */
   root_env,         /* need to set parameter in root environment block */
   environ_fail=0,   /* some env paras not been set due to lack of space */
   inkey_level=0,    /* exit errorlevel induced by console input */
   echo_key=1,       /* echo the valid input key required by -$* */
   nocase_forkey=0,  /* key request is case insensitive */
   may_escape=1,     /* escape key will leave the key request */
   beep_badkey=1,    /* unwanted keys will be beeped at */
   wait_forkey=1,    /* wait for a key to press, if key buffer is empty */
   loop_getkey=1,    /* wait until a valid key is pressed */
   ret_charcode=0,   /* exit code should be ASCII code instead of position */
   clr_keybuff=0,    /* clear key buffer before reading a key request */
   extend_keys=0,    /* interpretation for extended key is active */
   instant_read,     /* direct keyboard read is activated by -$*  */
   time_delay,       /* time to wait before a timeout is considered */
   beep_at,          /* beep at this moment before the scheduled timeout */
   count_down,       /* enable countdown in seconds at count_down from end */
   timeout_key,      /* timeout be regarded as if key timeout_key is accepted */
#endif


   no_case,          /* ngrep case sensitivity */
   grep_nocase,      /* locate via -dD no case */
   mask_nocase,      /* masked filter via -m* no case */
   cmp_mode,         /* comparison mode for grep/match -g via -G */
   on_off_cmp,       /* comparison mode for input on/off via -pP */
   exit_mode,        /* exit error level report request  */
   debug_on,         /* author's own debug mode  */
   force_exitcode,   /* forced exitcode is enabled */
   force_code,       /* forced exit code */

   entry_level=GETFREELEVEL  /* GETFREELEVEL is a global var */
    ;


  long
   input_count=0,    /* which input line   */
   output_count=0,   /* which output line  */
   subinput_count=0, /* input lineno resynchronised for each input file*/
   suboutput_count=0,/* output lineno */
   true_lines=0,     /* actual number of output lines, after it's done */
   bufflong;

  char
   *oneline=NULL,    /* a typical input line */
   *headline,        /* synchronised line to add to front of current line */
   *tailline,        /* synchronised line to add to the end of currentline */
   *preseparators,   /* left delimiter for mask filter   */
   *postseparators,  /* right separators for mask filter */
   *filename=NULL,   /* current input filename    */
   *insertedstr,     /* character-wise insertion  */
   *cmdstr,          /* current command string */
   *lastoneline=NULL,/* last input line */
   *buffline,
   *tmpline,
   *tmpfilename=NULL,/* for output file before updating the input file*/
   *newfilename=NULL /* output filename in filewise mode */
     ;


  FILE  *fptr,
	*confptr,   /* file ptr for output appended head/tail strs */
	*outputptr, /* output file pointer  */
	*outputptrbak, /* the main output (default) device */
	*namefptr,  /* where input filenames should be sent */
	*tmpfptr
	;

  chain
   *allstrs,        /* hold all cmd str options     */
   *allnums,        /* hold all cmd number options  */
   *allchars,       /* hold all cmd character options */

   *inputmap,       /* which input lines are to be taken */
   *outputmap,      /* which output lines will actually goto output device*/
   *charmap,        /* which char intervals are filtered in   */
   *strmap,         /* which str/word intervals are filtered in  */
   *headfilestr,    /* files whose line to be appended to everyline  */
   *tailfilestr,    /* files whose lines to be added in synchronised mode */
   *outfilestr,     /* files for output, first valid output chosen  */
   *maskfilestr,    /* files given with wild cards */
   *andmaskstr,     /* allowed files must match the mask */
   *notmaskstr,     /* allowed files must not match the mask */

   *firststr,       /* strs added to the beginning of output */
   *laststr,        /* strs added to the end of output */
   *headerstr,      /* strs added to the begining of each line */
   *tailerstr,      /* strs added to the end of each line */

   *oldstrcase,     /* searched str for replacement (case sensitive)  */
   *newstrcase,     /* replaced str for case sensitive search pairing */
   *oldstrnocase,   /* searched str for replcement (no case )         */
   *newstrnocase,   /* replaced str pairing  case-insensitive search  */

   *leftstr,        /* str filter left delimiter */
   *rightstr,       /* str filter right delimiter (locate substr */
   *matchstr,       /* strs match will filter the whole line through  */
   *maskfilterstr,  /* substr filter mask  */
   *nongrepstr,     /* strs that will remove current input line from prcessed*/

   *inputfilestr,   /* filenames for main input (thus replace stdin)  */
   *onlineptr,      /* lines input on command line */
   *onlineptrfront, /* front of onlineptr, for debug mode   */
   *switchstr,      /* password strs to direct input on/off */
   *frontonlycase,  /* mode for frontonly replace */
   *frontonlynocase,
   *wordplaces,     /* word positions used to determine `duplicated' lines*/

   *strinoldname,   /* strs in filename to be replaced */
   *strinnewname,   /* strs replacing those in input filenames*/
   *extrainname,    /* strs to dress up existing filename */

   *inslines,       /* str/lines to be inserted before a gripped line */
   *addlines,       /* str/lines to be added after a gripped line */

   *furtherptr,     /* three scratch chain pointers */
   *moreptr,
   *ptr
    ;

  struct stat dirstat; /* determine if a name is dir or file */


#ifndef UNIXMODE
  char  *promptstr ;   /* acceptable chars given by -$*, DOS only */
  chain *soundmap=NULL; /* sound frequency/duration map */
  pspchain *parent_list, *tmplist;

#endif


  /* valid char options, number options, andr char options */
  count=optioncount(argn,argv,charops,numops,strops);
  found=!!(sillyhelp(argn,argv,charops,numops,strops)
	|| incmd(count,argv,strops,'h'));


  if((cmdstr=strrchr(argv[0],DIRMARKER))!=NULL)
  {  cmdstr++;
     if((buffline=strrchr(cmdstr,'.'))!=NULL) *buffline=0;
     buffline=NULL;  uplowcase(cmdstr,1);
  }
  else cmdstr=argv[0];

  if(incmd(count,argv,strops,'H'))found=2;
  if(incmd(count,argv,strops,'h') && found==2)
   { printhelp(
#ifdef UNIXMODE
  "LM"
#else
   cmdstr
#endif
   ); return(0); }



  if(found)
  {
#ifndef UNIXMODE
     strlwr(cmdstr);
#endif
     printf("\
Line manipulator  - ver 2.06 January 1997  by Zhuhan Jiang.\n\
\n\
usage     %s  [-options] [string1] [string2 etc]\n\
helps     %s  -h (simple help)  %s -H (more help)  %s -hH (manual)\n\
\n\
priority  -@ -<* -;* -hH -j# -v -V -X# -/# -{#[]}* -BE*(#) -zZ# -$*(j20-28&#)\n\
	  -c# -:* -^*(+1) -fF*(+0**X7-11) -*`* -pP*(M#+2) -iI# -lL# -sS#\n\
	  -dD*(C2n#) -g*(G#J1j9!#)[X5] -qr*(j1j2j6-8) -QR*(j3j4j6-8) -()*\n\
	  -m*(C3kK*) -Y# -t# -T# -a -A* -~*(C1J2) -=#(X1) -y# -oO#(N#!#) -!#\n\
	  -N# -be*(#) -w#(W#) -uU*(+3) -#? -#?(even no. such options) -.# -x#\n\
	  *=str, #|?=no. (after a char), ()=related mode, []=forced option\n\
shorthand //# via -f^uU< is #th file of LMFILES, -F//*[;|:]* parses path *\n\
tmpfiles  in TMPDIR or root directory\n\
extendkey (dos) 0? for -$* under -j28 is denoted by 255? e.g. \"-/255$;\"=F1\n"
, cmdstr,cmdstr,cmdstr,cmdstr
	  );


     if(found>1)
     {

printf("\n\
-a   absorb consecutive spaces\n\
-A*  * ahead each char; -/255A?*: each char repl by * (? in * are the char)\n\
-b*  begin every output line with * (cf -#)\n\
-B*  begin while output by *\n\
-c#  cmd strs only; 0=input only 1=0+path 2=0+full pathname (cf -:*)\n\
-C#  case insensitive: 1=~/non-grip 2=-dD 3=-m 0=1+2+3\n\
-d*  left delimiter to locate substr (cf -n#)\n\
-D*  right delimiter to locate substr\n\
-e*  end every output line by appending * (cf -#)\n\
-E*  end whole output by *\n\
-f*  filename * as input file; -f//# for #th file in LMFILES (cf -F*)\n\
-F*  input file via wild cards; -F//*[[;|:]*] parse path (cf -** -`* -+# -X#)\n\
-g*  str * to be gripped, or marked for -j9qrQR or -(), cmpmode by -G# (cf -!#)\n\
-G#  mode -g: 0=exact 1=inside 2/3=1/2+no case 4/5=2/3+spaces 10-15=0-5+wild ?*\n\
-h   simple help (cf -? /?)\n\
-H   detailed help\n\
-hH  output manual if linked\n\
-i#  input on fr line #; #<0: reset line counter filewise\n\
-I#  input off fr line #; e.g -i3I7=input lines 3 to 7 (cf -p* -P* -N#)\n\
-j#  mode: 1/3 repl all for -qr/QR; 2/4 repl strs at line start;\n\
     6/7/8=repl. word separated by nonalphabets/6 & not _/space only;\n\
     9=lines matched via -g* are replacable for -qrQR* options;\n\
     10-19=max line width to MAXINT/11*(#-9), #<0=max width to -#;\n\
     20-28=case/echo/esc/beep/0char/0clrb/loop/wait/0extkey (cf -$*)\n\
-J#  AND for multi-strs: 0=1+2 (all) 1=grip via -g 2=~/non-grip\n\
-k#  ascii # for pre-marks for -m*; -kK0=no delimiters\n\
-K#  post-marks, default=\" \\n\" as for -k#\n\
-l#  letter on from #th position\n\
-L#  letter off from position #\n\
-m*  str * as mask to filter, unmatched part removed (cf -k# -K# -C#)\n\
-M#  cmp mode for -pP: ID|inside+nocase+spaces++wild, same as -G#\n\
-n#  direction for -dD: 0=find fr last 1=0+delimiters (cf -C#)\n\
-N#  allowed total output lines; #<0: count filewise (cf -o# O#)\n\
-o#  output on from line # (cf -N#)\n\
-O#  output off from line #; #<0: count filewise\n\
-p*  password toggle input on/off, current line exclusive\n\
-P*  line input toggle, password contained boundary line inclusive\n\
-q*  str * quested to replace\n\
-Q*  str * searched for replace (cf -j1-8)\n\
-r*  replaced str (case sensitive)\n\
-R*  replaced str matching -Q (no case)\n\
-s#  str kept from  #th word\n\
-S#  str off after #th word\n\
-t#  0=tab to space 1/2=convert to up/low case 3=reverse chars\n\
-T#  trim line, 1/2=remove lead/end spaces 0=1+2\n\
-u*  synchronised line appendage on left fr file *; -u//#\n\
-U*  synchronised linewise add on right fr *; -U//#\n\
-v   view cmd parameters etc\n\
-V   visible via stderr for -beBE\n\
-w#  output col width #, disabled by -uU* (cf -W#)\n\
-W#  mode for -w: 1=protect word 2=padwrap 3=pad+nobreak 0=1+2\n\
-x#  exitcode: 0=all 1=empty 2=pP 3=lL 4=sS 5=dD 6=qrQR 7=g 8=m 9=t 10=T 11=Y\n\
     12=a 13=A 14=N 15=y 16=~/cmd 17=env(=) 18=match via -fF*` 19=18+truefiles\n\
     (-$* overrides -x0-19) 21=! 20=-#? +out_no/+in_no if even -#? (ign. -w)\n\
-X#  0=1+2 1/2=no oflow/fname 3/4=names to stderr/stdout 5/6=3/4+search|failed\n\
     7=+matched 8=7-\"MATCHED: \" 9/10=dir/file with 7 or 8 11=allname to stderr\n\
     12=ren mesg off 13=allow overwrite via -{2\n\
-y#  0/1=del dup/all emptyline, 2=del consecutive dupl, <0=(-#)th word matched\n\
-Y#  0/1=paragraph/all as a line\n\
-z# +sound frequency after -B* (+=available to dos only)\n\
-Z# +sound in milliseconds paring -z#\n\
-@   this cmd str=last option str\n\
-#?  ?=ini no. for -beBE; more -# see -x20\n\
-/#  ascii code to next str option\n\
-{#  output: 0=ren 1=filewise 2=1+mkdir 3/4=1/2+force(-X13) -n=rmv n dirs\n\
-}*  filewise names: conact *'s, add infile name ahead of 2nd/later -}*\n\
-[*  str * in infile name to be replaced via -]*\n\
-]*  replacedv str for -[*\n\
-+#  cyclic effect: 0=-F 1=-^ 2=-pP 3=-uU\n\
-^*  output file as if \" > * \"; -^//#\n\
-:*  line * done first, then fr input or files\n\
-.#  force sum of # as exit code\n\
-~*  non-grip strs that delete lines\n\
-<*  cmd options from file *; -<//#\n\
-;*  exec again with paras after this one\n\
-**  input files must match mask *\n\
-`*  input filenames must not match mask *\n\
-!#  lines to accept after gripped via -g, disabled by -()*\n\
-(*  strs inserted in front of matched ones via -g, disables -! -x21\n\
-)*  strs inserted after matched ones via -g, -(*)* change meaning of -g\n\
-=# +setenv 0=valid paras 1=0+nonchk; a=b: set a, =a: show a, ==: del all\n\
-&# +timeout/beep/flash/key/^C/col/row/clrline/deline/insline/clrscr/scrmode\n\
-$* +exitcode=kbd key (cf j20-28); -j28/255$#=# is extended code\n\
    ^\n\
    |---- '+' here implies it is for dos only"
);

#ifdef UNIXMODE
    printf("\n");
#endif

     }

  return(0);
  }



  /* option -X99 is author's special  */
  allstrs=multichain(argn, argv,strops,count, strops, "/");
  allnums=multichain(argn, argv,strops,count, "", numops );
  allchars=multichain(argn, argv,strops,count, "", charops );
  combinestrnum(&allstrs);

  /* group getting char options */
  getcharparas(allchars, 3,
   (int)  'v', &view_str,
   (int)  'V', &visible_con,
   (int)  'a', &absorb_space
   );

  /* get options for mode 'j' */
  ptr=getsubchain(allnums,'j');
  j=0;
  for(i=19;i>=10; i--)
    if(containnum(ptr,i)) {j=i; break; }
  if(j)  MAXLINEWIDTH=MAXINT/11*(j-9);

  if(containnum(ptr,6)) word_mode=1;
  if(containnum(ptr,7)) word_mode=2;
  if(containnum(ptr,8)) word_mode=3;
  if(containnum(ptr,9)) marked4repl=0;

#ifndef UNIXMODE
  for(i=20;i<29; i++)
    if(containnum(ptr,i))
    { switch(i)
      { case 20: nocase_forkey=1; break;
	case 21: echo_key=0; break;
	case 22: may_escape=0; break;
	case 23: beep_badkey=0; break;
	case 24: ret_charcode=1; break;
	case 25: clr_keybuff=1; break;
	case 26: loop_getkey=0; break;
	case 27: wait_forkey=0; break;
	case 28: extend_keys=1; break;
	default: ;
      }
    }
#endif

  if((i=maxmininum(ptr,0))<0) MAXLINEWIDTH= -i;
  freechain(&ptr);

  /* process -v option */
  if (view_str)
    {  printf("\nCommand line parameters interpreted as ( ___=end mark ) :");
       for(i=1;i<argn;i++) printf("\n ( %2d ) %s___", i,argv[i]);
       if(ENVFILENAMES!=NULL)
       { printf("\n\nShorthand filenames given via LMFILES are :");
	 ptr=ENVFILENAMES; i=1;
	 while(ptr!=NULL)
	 { printf("\n ( %2d ) %s___", i, ptr->strone);
	   i++; ptr=ptr->next;
	 }
       }
       printf("\n\nTemporary file dir TMPDIR=%s",
	    ENVTMPDIR==NULL?"":ENVTMPDIR);

       bufflong=MAXLINEWIDTH;
       printf("\n\
\nValid number of option strs  ( %d )\
\nChosen maximum line width    ( %ld )\n", count,bufflong);
       return(0);
     }

  /* group getting number options, mostly for defaults */
  getnumparas(allnums, 6,
   (int)  'w', &width, -1,
   (int)  'M', &on_off_cmp, 1,
   (int)  'N', &totallines, -1,
   (int)  'G', &cmp_mode, 1,
   (int)  '!', &grep_followup, 0,
   (int)  'x', &exit_mode, -999  );

  /* group getting str/chain options */
  getchainparas(allstrs, 27,
   (int)  'B', &firststr,
   (int)  'E', &laststr,
   (int)  'b', &headerstr,
   (int)  'e', &tailerstr,
   (int)  ':', &onlineptr,
   (int)  'f', &inputfilestr,
   (int)  'g', &matchstr,
   (int)  'm', &maskfilterstr,
   (int)  'q', &oldstrcase,
   (int)  'r', &newstrcase,
   (int)  'Q', &oldstrnocase,
   (int)  'R', &newstrnocase,
   (int)  'd', &leftstr,
   (int)  'D', &rightstr,
   (int)  'u', &headfilestr,
   (int)  'U', &tailfilestr,
   (int)  '^', &outfilestr,
   (int)  '~', &nongrepstr,
   (int)  'F', &maskfilestr,
   (int)  '*', &andmaskstr,
   (int)  '`', &notmaskstr,
   (int)  'A', &ptr,
   (int)  '[', &strinoldname,
   (int)  ']', &strinnewname,
   (int)  '}', &extrainname,
   (int)  '(', &inslines,
   (int)  ')', &addlines
   );

  /* get the substr for characterwise insertion */
  insertedstr=catchain(ptr);
  freechain(&ptr);

  soft_grep=grep_followup;

  /* upcase for DOS filenames */
#ifndef UNIXMODE
  ptr=strinoldname;
  while(ptr!=NULL)
  { uplowcase(ptr->strone,1);
    ptr=ptr->next;
  }

  ptr=strinnewname;
  while(ptr!=NULL)
  { uplowcase(ptr->strone,1);
    ptr=ptr->next;
  }

  ptr=extrainname;
  while(ptr!=NULL)
  { uplowcase(ptr->strone,1);
    ptr=ptr->next;
  }

  ptr=andmaskstr;
  while(ptr!=NULL)
  { uplowcase(ptr->strone,1);
    ptr=ptr->next;
  }

  ptr=notmaskstr;
  while(ptr!=NULL)
  { uplowcase(ptr->strone,1);
    ptr=ptr->next;
  }
  ptr=NULL;
#endif

  onlineptrfront=onlineptr;  /* redundent */

  /* default to -X5 option for wild card filenames via -F */
  if(maskfilestr!=NULL) filename_level=5;

  /* make non-grep chain  */
  for(i=count+1;i<argn;i++)
  {  ptr=emptychain();
     ptr->strtwo=dupstr("~",0);
     ptr->strone=dupstr(argv[i],0);
     appendchain(&nongrepstr,ptr);
  }

  /* process filename shorthand */
  useshorthand(inputfilestr, ENVFILENAMES);
  useshorthand(outfilestr, ENVFILENAMES);
  useshorthand(headfilestr, ENVFILENAMES);
  useshorthand(tailfilestr, ENVFILENAMES);
  usecompactform(&maskfilestr,
#ifdef UNIXMODE
    ':' );
#else
    ';' );
#endif


  /* expand first level wild card filenames  */
  ptr=expandmaskfiles(maskfilestr,"f", DOSMODE);
  inputfilestr=linkchain(inputfilestr, ptr);
  if(maskfilestr!=NULL) nofake_input=1; else nofake_input=0;
  freechain(&maskfilestr);
  ptr=NULL;

  /* -uU option override -wW options */
  if(headfilestr!=NULL || tailfilestr!=NULL) width= -1;

  /* get filewise parameters */
  ptr=getsubchain(allnums,'{');
  write_filewise= ptr==NULL? -1: maxmininum(ptr,1);
  dir_level=maxmininum(ptr,0);
  freechain(&ptr);

  /* get cyclic/recursive reading status */
  ptr=getsubchain(allnums,'+');
  append_output=dir_recursive=file_cyclic=switch_cyclic=0;
  setnummodes(ptr,4,
     0,  &dir_recursive,
     1,  &append_output,
     2,  &switch_cyclic,
     3,  &file_cyclic );
  freechain(&ptr);

  /* get output device */
  outputptr=NULL;
  while(outfilestr!=NULL)
  { buffline=outfilestr->strone;
    if(append_output)
      outputptr=fopen(buffline,"a");
    else
      outputptr=fopen(buffline,"w");
    if(outputptr!=NULL) break;
    outfilestr=outfilestr->next;
  }
  if(outputptr==NULL) outputptr=stdout;
  outputptrbak=outputptr;

  /* get forced exit code, overriding -x# etc */
  moreptr=ptr=getsubchain(allnums,'.');
  force_code=0;
  if(ptr!=NULL) force_exitcode=1; else force_exitcode=0;
  while(ptr!=NULL) {force_code+=ptr->numone; ptr=ptr->next;}
  freechain(&moreptr);

  /* get locate (grep substr) directives */
  ptr=getsubchain(allnums,'n');
  find_last=mark_incl=0;
  setnummodes(ptr,2,
     1,  &mark_incl,
     0,  &find_last );
  freechain(&ptr);

  /* get empty-delete mode */
  wordplaces=ptr=getsubchain(allnums,'y');
  one_empty=no_empty=no_duplicate=0;
  setnummodes(ptr,3,
     0,  &one_empty,
     1,  &no_empty,
     2,  &no_duplicate );
  if(maxmininum(wordplaces,0)<0) no_duplicate=1;
  else { freechain(&ptr); wordplaces=NULL;  }
  /* freechain(&ptr);  */


  /* get empty-delete mode */
  ptr=getsubchain(allnums,'Y');
  del_cr=para_aline=0;
  setnummodes(ptr,2,
     0,  &para_aline,
     1,  &del_cr );
  freechain(&ptr);

  /* get width format mode  */
  ptr=getsubchain(allnums,'W');
  j=i=respect_str=right_pad=0;
  setnummodes(ptr,4,
     0,  &i,
     3,  &j,
     1,  &respect_str,
     2,  &right_pad );
  freechain(&ptr);
  if(i) respect_str=right_pad=1;
  if(j) right_pad=2;

  /* get comparison AND or OR choice */
  ptr=getsubchain(allnums,'J');
  i=and_on_grep=and_on_ngrep=0;
  setnummodes(ptr,3,
     0,  &i,
     1,  &and_on_grep,
     2,  &and_on_ngrep );
  freechain(&ptr);
  if(i) and_on_grep=and_on_ngrep=1;

  /* get translation, upcase/lowcase conversion level */
  ptr=getsubchain(allnums,'t');
  i=tab_2_space=casechange_level=0;
  setnummodes(ptr,4,
     0,  &tab_2_space,
     1,  &casechange_level,
     3,  &rev_letters,
     2,  &i );
  freechain(&ptr);
  if(i && !casechange_level) casechange_level=2;

  /* get trim-mode */
  ptr=getsubchain(allnums,'T');
  i=j=trim_mode=0;
  setnummodes(ptr,3,
     0,  &i,
     1,  &j,
     2,  &trim_mode );
  freechain(&ptr);
  if(!i && !j && !trim_mode) trim_mode= -1;
  else if(i || j && trim_mode) trim_mode=0;
       else trim_mode=j? 1:2;

  /* get mode for command lines only */
  ptr=getsubchain(allnums,'c');
  cmd_lines_mode= -999;
  for(i=0;i<=2; i++)
    if(containnum(ptr,i)) cmd_lines_mode=i;
  freechain(&ptr);

  /* get line numbering mode */
  ptr=getsubchain(allnums,'i');
  moreptr=getsubchain(allnums,'I');
  if ( min(maxmininum(ptr,0), maxmininum(moreptr,0) )<0) lineno_filewise=1;
  freechain(&ptr);
  freechain(&moreptr);
  ptr=getsubchain(allnums,'o');
  moreptr=getsubchain(allnums,'O');
  if ( min(maxmininum(ptr,0), maxmininum(moreptr,0) )<0) outlineno_filewise=1;
  freechain(&ptr);
  freechain(&moreptr);
  ptr=getsubchain(allnums,'N');
  /*  totallines=-1 if none of options -N# specify #>=0
		    (will be ignored later on)
      totallines=0  if max number in -N# is 0
  */
  if (maxmininum(ptr,0)<0) total_filewise=999;
  totallines=ptr==NULL? -1:maxmininum(ptr,1);
  freechain(&ptr);

  /* get filename output mode */
  ptr=getsubchain(allnums,'X');
  /* 0=1+2
     1=no warning message
     2=no filenames
     3=filenames to stderr
     4=filenames to stdout/redirected device
     5=all filenames to stderr
     6=all filenames to stdout
     7=display filenames that match masks
     8=clear filename prompt
     9=show dirnames
    10=show filenames
    11=all filenames to stderr
    12=no messages for rename via -{1[*]*
    13=double check for -{2 (safty measure)

    99=author's own debug mode
  */

  /* decide how to output filenames */
  always_filename=0;
  if(containnum(ptr,1)) no_overflow=1; else no_overflow=0;
  for(i=6;i>=2; i--)
    if(containnum(ptr,i)) filename_level=i;
  if(containnum(ptr,0)) { no_overflow=1; filename_level=2; }
  if(containnum(ptr,99)) debug_on=1; else debug_on=0;
  out_filenames=containnum(ptr,11);
  no_ren_mesg=containnum(ptr,12);
  if(write_filewise>2 && !containnum(ptr,13))
  { if((write_filewise/2)*2==write_filewise) /*even*/ write_filewise=2;
    else write_filewise=1;
  }
  clr_promptnames=containnum(ptr,8);
  show_filenames=containnum(ptr,7) || clr_promptnames;
  i=0;
  if(containnum(ptr,9)) {i=1; prompt_mode=prompt_mode | 1 ; }
  if(containnum(ptr,10)) {i=1; prompt_mode=prompt_mode | 2 ; }
  if(!i) prompt_mode=7;

  freechain(&ptr);
  switch (filename_level)
  { case 3: namefptr=stderr; break;
    case 4: namefptr=stdout;break;
    case 5: always_filename=1; namefptr=stderr; break;
    case 6: always_filename=2; namefptr=stdout; break;
    default: namefptr=NULL;
  }

  if(namefptr==stdout) namefptr=outputptr;


  /* get pre- and post- delimiters for masked string filter */
  ptr=getsubchain(allnums,'k');
  preseparators=code2str(ptr);
  freechain(&ptr);
  ptr=getsubchain(allnums,'K');
  postseparators=code2str(ptr);
  freechain(&ptr);

  /* get initial line number, and forces interpretation of
       leading '#' in -beBE options
  */
  moreptr=ptr=getsubchain(allnums,'#');
  if(ptr==NULL) { prn_num=0; ini_line=0; }
  else { prn_num=1; i=0;
	 while(ptr!=NULL)
	  { ini_line+=ptr->numone; i++;
	    ptr=ptr->next;
	  }
	 if(i/2*2==i) prn_num=2;
       }
  freechain(&moreptr);


#ifndef UNIXMODE
  setcbrk(1);
  ctrlbrk(c_break);

  /* get the substr for prompt str */
  ptr=getsubchain(allstrs,'$');
  promptstr=catchain(ptr);
  instant_read= ptr!=NULL ? 1:0;
  freechain(&ptr);

  /* get timeout parameters */
  moreptr=ptr=getsubchain(allnums,'&');
  count=a=b=k=m=n=i=timeout_key=time_delay=count_down=beep_at=0;
  while(ptr!=NULL)
  { i++;
    j=ptr->numone;
    switch(i)
    { case 1: time_delay=j; break;
      case 2: beep_at=j; break;
      case 3: count_down=j; break;
      case 4: timeout_key=j; break;
      case 5: CTRLBRK_KEY=j; break;
      case 6: m=j; break;
      case 7: n=j; break;
      case 8: if(j) k=k | 1; break;
      case 9: a=j; break;
     case 10: b=j; break;
     case 11: if(j) k=k | 2; break;
     case 12: if(j) count=j;
    }
    ptr=ptr->next;
  }
  freechain(&ptr);

  if(count )
    asm {  mov ax, count;
	   xor bx,bx;
	   xor cx,cx;
	   xor dx,dx;
	  int 0x10
	}
  if(count==3)
    asm {  mov ax, 0x1112;
	   int 0x10
	}

  if(m>0 && n>0) gotoxy(m,n);
  if (k & 1) clreol();
  if (a>0) for(i=0;i<a;i++) delline(); else if(a) delline();
  if (b>0) for(i=0;i<b;i++) insline(); else if(b) insline();
  if (k & 2) clrscr();

  /* get environment-setting mode */
  ptr=getsubchain(allnums,'=');
  /*  old version of setting quoted here for reference
      0=set root
      1=set to 1st generation of parent
      2=set to 2nd generation
      ...
     -1=set to all generation
     -2=-1+no validity check on env parameters

     environ_mode:
      -999=do nothing, no request for env parameters
	 1=set to upto 1st generation
	 2=set to upto 2nd generation
  */

  environ_mode= (ptr==NULL)? -999:0;
  no_envchk=containnum(ptr,1);
  root_env= no_envchk || containnum(ptr,0);
  freechain(&ptr);
  parent_list= (environ_mode==-999)?NULL:getparents();

  /* get sound strs */
  ptr=soundmap=getsubchain(allnums,'Z');
  furtherptr=moreptr=getsubchain(allnums,'z');
  while(ptr!=NULL)
  { ptr->numtwo=ptr->numone;
    ptr->numone=(moreptr==NULL)? 0: moreptr->numone;
    ptr=ptr->next; moreptr=moreptr->next;
  }
  freechain(&furtherptr);
#endif


  /* build smart (begin, end) interval list/map */
  charmap=chaintable(allnums,'l','L',1);
  strmap=chaintable(allnums,'s','S',1);
  inputmap=chaintable(allnums,'i','I',0);
  outputmap=chaintable(allnums,'o','O',0);

  /* get input on/off switching passwords,
     link last two entry up, if cyclic mode is requested
  */
  ptr=switchstr= getmultisubchain(allstrs,"pP");
  if(ptr!=NULL && switch_cyclic)
  { while(ptr->next!=NULL) ptr=ptr->next;
    if(ptr->prev!=NULL &&
       ( strlen(ptr->prev->strone)|| strlen(ptr->strone)) )
	 ptr->next=ptr->prev;
    else if(ptr->prev==NULL && strlen(ptr->strone) )
	 {ptr->next=dupchain(ptr);
	  ptr->next->next=ptr; }
  }


  /*  get replace mode (replace all / replace ones starting
	at the first element
  */
  frontonlycase=getsubnumchain(allnums,'j',1,2);
  frontonlynocase=getsubnumchain(allnums,'j',3,4);

  /*  get no-case mode */
  ptr=getsubchain(allnums,'C');
  i=no_case=grep_nocase=mask_nocase=0;
  setnummodes(ptr,4,
     0,  &i,
     1,  &no_case,
     2,  &grep_nocase,
     3,  &mask_nocase );
  freechain(&ptr);
  if(i) no_case=grep_nocase=mask_nocase=1;

  /*  get the output device for those given by -beBE */
  if(visible_con) confptr=stderr; else confptr=outputptr;
  if(one_empty&& no_empty) one_empty=0;    /*no empty lines has priority */
  if(para_aline) {del_cr=1; one_empty=1; no_empty=0; }
  if(leftstr==NULL && rightstr==NULL) grepstr_on=0; else grepstr_on=1;
  if(maskfilterstr!=NULL) maskpipe_on=1; else maskpipe_on=0;

  emptyline=0; 	/* emptyline=1 if 1 empty line has just been processed */
  headline=tailline=inputnextline(headfilestr,tailfilestr,0, 0);


  /* get inputfile names */
  if(inputfilestr==NULL)
   { inputfilestr=emptychain();
     inputfilestr->strone=dupstr(NULL,1);
   }
  else nofake_input=0;

  /* free command options str chains */
  freechain(&allstrs);
  freechain(&allnums);
  freechain(&allchars);

  printstrchain(confptr,firststr,
    ini_line+(prn_num>1?
     (lineno_filewise? subinput_count:input_count):true_lines+1),prn_num);

  if(cmd_lines_mode==1)
     fprintf(confptr,"%s", findvalidpath(argv[0],DOSMODE));
  if(cmd_lines_mode==2)
     fprintf(confptr,"%s", argv[0]);


#ifndef UNIXMODE
  soundplay(soundmap);

  if(instant_read)
  inkey_level=getkeylevel(confptr,promptstr,
       nocase_forkey, echo_key, may_escape, beep_badkey,
       ret_charcode, clr_keybuff, loop_getkey, wait_forkey, extend_keys,
       time_delay, beep_at, count_down, timeout_key);
#endif



  /*******************************************
  * while 1       find an input device/file
  *******************************************/
  while(inputfilestr!=NULL)
  {
      /* will free the subdir which is used to generate recursively
	 the files inside the subdir     */
    ptr=inputfilestr->prev; inputfilestr->prev=NULL;
    if(ptr!=NULL) { ptr->next=NULL; freechain(&ptr); }

    fptr=NULL;
    if(filename!=NULL) FREE(filename);
    filename=dupstr(inputfilestr->strone,0);

    if(total_filewise)
    { if(total_filewise!=999) true_lines=0;
      total_filewise=1;
    }
    suboutput_count=subinput_count=0;
    if(strlen(filename))
    {

#ifndef UNIXMODE
   uplowcase(filename,1);
#endif
       i=maskmatched(filename,andmaskstr)
	   && ! removalmatched(filename,notmaskstr);
       if(casechange_level) uplowcase(filename,casechange_level!=2);
       if(i)
	 {fptr=fopen(filename,"r");
	  if(show_filenames &&
	     ( fptr==NULL && (prompt_mode & 1)
	       || fptr!=NULL && (prompt_mode & 2) )
	    )
	  { CLREOL();
	    if(!clr_promptnames) fprintf(stdout,"MATCHED: ");
	    if( fptr==NULL && (prompt_mode & 4)) fprintf(stdout,"+ ");
	    fprintf(stdout,"%s\n",filename);
	  }
	  if(exit_mode==0 || exit_mode==18 || exit_mode==19 && fptr!=NULL)
	     err_code=2;
	 }
       else
	  fptr=NULL;

#ifdef UNIXMODE
       if(fptr!=NULL) /* make shift for UNIX dir */
	 {
	   /* valid for mips
	   i=fgetc(fptr);
	   if(i==-1) { fclose(fptr); fptr=NULL;}
	   else ungetc(i,fptr);    */

	   /* for others */
	   if( !fstat(fileno(fptr), &dirstat) &&
		!(dirstat.st_mode & S_IFREG) )
	   { fclose(fptr); fptr=NULL;}
	 }
#endif

       if(fptr==NULL && dir_recursive)
       {

#ifndef UNIXMODE
   uplowcase(filename,1);
#endif
	 i=insidesubdir(filename,andmaskstr)
	   && ! removalmatched(filename,notmaskstr) ;
	 if(casechange_level) uplowcase(filename,casechange_level!=2);
	 if(i) ptr=getfulldirfiles(filename, "f", DOSMODE);
	 else ptr=NULL;
	 if(ptr!=NULL)
	  { insertchain(inputfilestr,ptr);
	    inputfilestr=inputfilestr->next; ptr=NULL;
	    continue;
	  }
       }
    }
    else fptr=stdin;

    /* if fptr=NULL, then filename is directory name,
       or filename not permitted by mask */

    newfilename=NULL;
    tmpfileactive=0;
     if(write_filewise>=0)
    {  /* get corresponding output filename */
       newfilename=formnewname(filename,strinoldname,strinnewname,
		   extrainname,dir_level);

      /* rename file */
      if(!write_filewise)
      { if(fptr!=stdin && fptr!=NULL)
	{ fflush(fptr); fclose(fptr);
	  renamefile(filename,newfilename,no_ren_mesg,namefptr);
	}
	if(newfilename!=NULL) FREE(newfilename);
	newfilename=NULL;

	ptr=inputfilestr; ptr->prev=NULL;
	inputfilestr=inputfilestr->next;
	if(inputfilestr!=NULL) inputfilestr->prev=NULL;
	if(ptr!=NULL) { ptr->next=NULL; freechain(&ptr); }
	continue;
      }


      if(fptr!=NULL)
      {	buffline=strlen(filename)? fullname(filename): dupstr(filename,0);
	i=! strcmp(buffline,newfilename);
	FREE(buffline); buffline=NULL;
	if(i) {
	       if(ENVTMPDIR!=NULL)
	       TMPFILENAME=tmpfilename=tempnam(ENVTMPDIR,
#ifdef UNIXMODE
	       "tmp_ng_");
#else
	       "tmp");
#endif

	       if(ENVTMPDIR==NULL || tmpfilename==NULL)
	       TMPFILENAME=tmpfilename=tempnam(
#ifdef UNIXMODE
	"/tmp/", "tmp_ng_");
#else
	"\\", "tmp" );
#endif
		tmpfileactive=1;
	       }
	else tmpfilename=newfilename;

	if(!strlen(filename))
	{ FREE(newfilename); newfilename=NULL;
	  if(tmpfileactive) free(tmpfilename);
	  tmpfileactive=0;
	  newfilename=tmpfilename=NULL;
	  outputptr=outputptrbak;
	}
	else
	{
	  if( (write_filewise==2 || write_filewise==4)
	      && makedirs(tmpfilename,1) )
	  {  i=0;
	     if(write_filewise==2)
	     {  fprintf(stderr,"Create subdirs for %s? ", tmpfilename);
#ifdef UNIXMODE
		fprintf(stderr, "%c[K",27);
#else
		clreol();
#endif

		if((i=yesno(1))==-1) /* ctrl_c */ exit(1);

	     }
	     if(write_filewise==4 || i) makedirs(tmpfilename,0);
	  }

	  i=0;
	  if(append_output) outputptr=fopen(tmpfilename,"a+");
	  else
	  {  if(write_filewise==1 || write_filewise==2)
	     {  tmpfptr=fopen(tmpfilename,"r");
		if(tmpfptr!=NULL) /* file exists */
		{ fclose(tmpfptr);
		  i=1;
		  fprintf(stderr,"Overwrite %s for %s? ",tmpfilename,filename);
#ifdef UNIXMODE
		  fprintf(stderr, "%c[K",27);
#else
		  clreol();
#endif

		  if((j=yesno(0))==-1) /* ctrl_c */ exit(1);

		  if(j) outputptr=fopen(tmpfilename,"w+");
		  else outputptr=NULL;
		}
		else outputptr=fopen(tmpfilename,"w+");
	     }
	     else outputptr=fopen(tmpfilename,"w+");
	  }

	  if(outputptr==NULL)
	    {  if(i) if(j!=1) /* overwrite cancelled */
		       fprintf(stderr, ": skipped\n");
		     else fprintf(stderr,": but write failed\n");
	       else fprintf(stderr,"Fail to write %s\n",tmpfilename);
	       fflush(fptr); fclose(fptr);
	       if(tmpfileactive)
	       { free(tmpfilename);
		 TMPFILENAME=tmpfilename=NULL; tmpfileactive=0;
	       }
	       if(newfilename!=NULL) FREE(newfilename);
	       newfilename=NULL;

	       ptr=inputfilestr; ptr->prev=NULL;
	       inputfilestr=inputfilestr->next;
	       if(inputfilestr!=NULL) inputfilestr->prev=NULL;
	       if(ptr!=NULL) { ptr->next=NULL; freechain(&ptr); }

	       continue;

	    }
	    else if(i) fprintf(stderr,"\n");

       }
      }
      else
      { FREE(newfilename); newfilename=NULL; }
    }



    if(totallines==0)  /*totallines<0 means something else */
    { if ( (exit_mode==1 || exit_mode==0) && (fptr!=stdin)
	   && (fptr==NULL || (i=fgetc(fptr))==EOF) ) err_code=2 ;
       /* above deals with option -N0 which means no lines will
	  be read in; other cases dealt with elsewhere */
      fclose(fptr); fptr=NULL;
      if(!total_filewise) break;
     }


    if(filename_printed && always_filename) fprintf(namefptr,"\n");
    if(out_filenames)
    {  fprintf(stderr,"--------  scan [%d]: %s",total_inputfile+1, filename);
       fprintf(stderr,"  %c[K", 27);
       fprintf(stderr,"\r");
       fflush(stderr);
    }
    filename_printed=0; total_inputfile++;
    already_printed=0;

    if(namefptr!=NULL && !filename_printed && always_filename)
      {	if(! (nofake_input && fptr==stdin))
	{ inputnames(onlineptr!=NULL, fptr==stdin, fptr==NULL, namefptr,
		     total_inputfile, filename, namefptr==stderr,
		     tmpfileactive?NULL:newfilename  );
	  already_printed=1;
	}
       }

    /*  will free the name of an opened file */
    ptr=inputfilestr; ptr->prev=NULL;
    inputfilestr=inputfilestr->next;
    if(inputfilestr!=NULL) inputfilestr->prev=NULL;
    if(ptr!=NULL) { ptr->next=NULL; freechain(&ptr); }
    more_filename=0;


    /********************************
    * while 2     read in from the chosen device
    ********************************/
    while(1)
    { if(more_filename)
	  { filename_printed=0; total_inputfile++;  more_filename=0;
	    if(always_filename)
	    { fprintf(namefptr,"\n");
	      inputnames(0, fptr==stdin, fptr==NULL, namefptr,
		   total_inputfile, filename, namefptr==stderr,
		   tmpfileactive?NULL:newfilename  );
	      already_printed=1;
	    }
	  }
      if(oneline!=NULL) {FREE(oneline); oneline=NULL;}
      if(onlineptr==NULL && cmd_lines_mode>=0 ) {true_exit=1; break;}
      if(onlineptr!=NULL)
	{ oneline=(onlineptr==NULL)?
		 NULL:dupstr(onlineptr->strone,0);  /* dup str */
	  onlineptr=onlineptr->next;
	  if(oneline==NULL) onlineptr=NULL;
	  if(onlineptr==NULL) more_filename=1;
	  if(oneline==NULL) continue;
	}
      else
	{ if(fptr==NULL || nofake_input) break;
	  else { oneline=inputaline(fptr);
		 if(headline!=NULL) FREE(headline);
		 if(tailline!=NULL) FREE(tailline);
		 headline=inputnextline(NULL,NULL,1,file_cyclic);
		 tailline=inputnextline(NULL,NULL,2,file_cyclic);
		}
	}

      if(oneline!=NULL && *oneline) {input_count++; subinput_count++;}
      if(inputmap!=NULL)
	i=notinchain(inputmap, (lineno_filewise? subinput_count:input_count));
      else i=0;
      if(i>1)
	if(!lineno_filewise) { true_exit=1; break;}  /* not more input lines allowed */
	else break;  /* leave reading current file */

      if(oneline==NULL) break;
      if(i) continue;

      true_input=1;
      i=taketheline(oneline,&switchstr,'P',&switch_on, on_off_cmp);
      if(i>=1 && (exit_mode==2 || exit_mode==0)) err_code=2;
      if(i==1) continue;
      else { if (!i && !switch_on ) continue; }


      ins_add_pending=0;

      /*  various operations performed below for each line */
      if(rev_letters) revletters(&oneline);

      i=squeeze(oneline,charmap);
      if(i && (exit_mode==3 || exit_mode==0)) err_code=2;

      i=shrink(oneline,strmap);
      if(i && (exit_mode==4 || exit_mode==0)) err_code=2;

      if(grepstr_on)
      {	buffline=grepsubstr(oneline,leftstr,rightstr,
			    grep_nocase, find_last, mark_incl);
	FREE(oneline);
	oneline=buffline;
	if(oneline==NULL)
	{ oneline=fmalloc(1);
	  oneline[0]=0;
	  continue;
	}
	else if(exit_mode==5 || exit_mode==0) err_code=2;
      }

      i=0; /*not found */
      if(matchstr!=NULL)
	{ i=found=grepped(oneline, matchstr, cmp_mode,and_on_grep);
	  if(inslines!=NULL || addlines!=NULL || !marked4repl )
	  { if(found) { printstrchain(outputptr,inslines,0L,0);
			ins_add_pending=1;
			if(exit_mode==7 || exit_mode==0) err_code=2;
		      }
	    found=1;
	  }
	  else
	  { if(found && (exit_mode==7 || exit_mode==0) ) err_code=2;
	    if(found) soft_grep=0;
	    else
	    { if(soft_grep<grep_followup) {found=1; soft_grep++;}
	      else if(exit_mode==21 || exit_mode==0) err_code=2;
	    }
	  }
	}
      else found=1;
      if(!found) continue;

      if(oldstrcase!=NULL && newstrcase!=NULL && (i || marked4repl) )
      { buffline=replace(oneline,oldstrcase,newstrcase,0,word_mode,frontonlycase);
	if( !strcmp(buffline, oneline))
	  if(exit_mode==6 || exit_mode==0) err_code=2;
	FREE(oneline);
	if(oldstrnocase!=NULL && newstrnocase!=NULL)
	{ oneline=replace(buffline,oldstrnocase,newstrnocase,1,word_mode,frontonlynocase);
	  if(!strcmp(buffline, oneline))
	    if(exit_mode==6 || exit_mode==0) err_code=2;
	  FREE(buffline);
	}
	else oneline=buffline;
      }
      else
	if(oldstrnocase!=NULL && newstrnocase!=NULL && (i || marked4repl) )
	{ buffline=replace(oneline,oldstrnocase,newstrnocase,1,word_mode,frontonlynocase);
	  if(!strcmp(buffline, oneline))
	    if(exit_mode==6 || exit_mode==0) err_code=2;
	  FREE(oneline);
	  oneline=buffline;
	}


      if(maskpipe_on)
      {	i=maskstring(oneline,maskfilterstr,
		     preseparators,postseparators,mask_nocase);
	if((i==1|| i==2) && (exit_mode==8|| exit_mode==0)) err_code=2;
      }

      if(tab_2_space)
      { i=tab2space(oneline);
	if(i && (exit_mode==9|| exit_mode==0)) err_code=2; }

      if(trim_mode!=-1)
      { i=trimline(oneline,trim_mode);
	if(i && (exit_mode==10|| exit_mode==0)) err_code=2; }

      if(del_cr)
      { j=strlen(oneline);
	for(i=0;i<j;i++)
	  if(oneline[i]=='\n')
	  { oneline[i]=' ';
	    if(exit_mode==11 || exit_mode==0) err_code=2;
	  }
       }

      if(absorb_space)
      { i=absorbspace(oneline);
	if(exit_mode==12|| exit_mode==0) err_code=2; }

      if(casechange_level==1) uplowcase(oneline,1);
      if(casechange_level==2) uplowcase(oneline,0);

      if(insertedstr!=NULL)
      { i=insertchwise(&oneline, insertedstr);
	if(exit_mode==13|| exit_mode==0) err_code=2; }

      /* non-grep operation */
      found=0;
      ptr=nongrepstr;
      while(ptr!=NULL)
      {	if(foundstr(oneline, ptr->strone, no_case))
	 { if(and_on_ngrep) if(ptr->next==NULL) {found=1; break; }
			    else {ptr=ptr->next; continue; }
	   else { found=1; break; }
	 }
	else if(and_on_ngrep) break;
	ptr=ptr->next;
      }


#ifndef UNIXMODE
      /* set environment parameters if necessary */
      if(environ_mode!=-999)
      { j=1; tmplist=parent_list;
	delendcr(oneline);
	while(tmplist!=NULL)
	{ if(environ_mode==-1 || j<=environ_mode && environ_mode
	    || (root_env || !environ_mode) && tmplist->next==NULL)
	  i=setenv(outputptr,tmplist, oneline, tmplist->next==NULL, no_envchk);
	  else i=1;
	  environ_fail=environ_fail || !i ;
	  j++;
	  tmplist=tmplist->next;
	}
	continue;
      }
#endif

      /* remove duplicated input line */
      if(no_duplicate)
      { if(!cmpwords(wordplaces,lastoneline,oneline)) continue;
	if(lastoneline!=NULL && !strcmp(lastoneline,oneline) ) continue;
	else
	{  if(lastoneline!=NULL) FREE(lastoneline);
	   lastoneline= dupstr(oneline,0);
	}
      }


      /*  decide whether to output the current line,
	  particular when empty lines are involved.
      */
      if (!found)
      {	empty=isempty(oneline);
	if(!empty)
	   { /* not an empty line: simpler process */
	     emptyline=0;
	     i=1;
	     if(totallines>=0)
	       if(true_lines+1>totallines) i=0;;
	     if(i)
		{ output_count++; suboutput_count++;
		  if(outputmap!=NULL) j=notinchain(outputmap,
		    (outlineno_filewise? suboutput_count:output_count));
		  else j=0;
		  if(!j)
		  {
		   if(namefptr!=NULL && !filename_printed)
		   {
		     if(!always_filename) fprintf(namefptr,"\n");
		     if(!already_printed)
		     inputnames(onlineptr!=NULL || more_filename,
		       fptr==stdin, fptr==NULL, namefptr,
		       total_inputfile, filename, namefptr==stderr,
		       tmpfileactive?NULL:newfilename  );
		     already_printed=1;
		     filename_printed=1;
		     if(namefptr==stderr) fprintf(namefptr,"\n");
		   }
		     printaline(confptr,outputptr,oneline,headerstr,tailerstr,width,
		     respect_str, right_pad,
		     ini_line+(prn_num>1?
		      (lineno_filewise? subinput_count:input_count):true_lines+1),prn_num,
		     headline,tailline );
		     true_lines++;
		  }
		  if(true_lines>=totallines && totallines>=0) i=0;
		}

	     if(ins_add_pending) printstrchain(outputptr,addlines,0L,0);

	     if(!i)
	       { if(exit_mode==14 || exit_mode==0) err_code=2;
		 if(!total_filewise) true_exit=1; break;
	       }
	   }
	if(empty &&
	   (!no_empty && !one_empty || one_empty && !emptyline) )
	   { /* empty line, but must keep this one
	     */
	     emptyline=1;
	     i=1;
	     if(totallines>=0)
	       if(true_lines+1>totallines) i=0;;
	     if(i)
	      { output_count++; suboutput_count++;
		if(outputmap!=NULL) j=notinchain(outputmap,
		  (outlineno_filewise? suboutput_count:output_count));
		else j=0;
		if(!j)
		{
		   if(namefptr!=NULL && !filename_printed)
		   {
		     if(!always_filename) fprintf(namefptr,"\n");
		     if(!already_printed)
		     inputnames(onlineptr!=NULL || more_filename,
		       fptr==stdin, fptr==NULL, namefptr,
		       total_inputfile, filename, namefptr==stderr,
		       tmpfileactive?NULL:newfilename  );
		     already_printed=1;
		     filename_printed=1;
		     if(namefptr==stderr) fprintf(namefptr,"\n");
		   }
		  printaline(confptr,outputptr,oneline,headerstr,tailerstr,width,
		  respect_str, right_pad,
		  ini_line+(prn_num>1?
		   (lineno_filewise? subinput_count:input_count):true_lines+1),prn_num ,
		  headline, tailline);
		  true_lines++;
		}
		if(para_aline)
		 { fprintf(outputptr,"\n\n"); true_lines++; }
		if(true_lines>=totallines && totallines>=0) i=0;
	      }
	     if(!i)
	       { if(exit_mode==14 || exit_mode==0) err_code=2;
		 if(!total_filewise) true_exit=1; break;
	       }
	   }
	else if(empty && (exit_mode==15 || exit_mode==0)) err_code=2;
      }
     else
      if(exit_mode==16 || exit_mode==0) err_code=2;
    }  /* end of while 2 */

  if(fptr!=stdin && fptr!=NULL )
  {  fflush(fptr); /* problems for delete under DOS if not flushed first */
     fclose(fptr); /* this seems to be a compiler's problem */
  }
  if(write_filewise>=0 && outputptr!=stdout && outputptr!=stderr)
  { if(outputptr!=NULL && fptr!=NULL)
    { if((i=fflush(outputptr))!=EOF )
      { if(fseek(outputptr,-1L,SEEK_END)) /*empty file */
	{ i=fputc(0x1a,outputptr); /* 0=ok */
	  if(i!=EOF) /* ok */
	  {  fflush(outputptr); fclose(outputptr);
	     outputptr=fopen(tmpfilename,"w+"); /* reset length to 0*/
	  }
	}
	else
	{ k=fgetc(outputptr);
	  fseek(outputptr,-1L,SEEK_END);
	  i=fputc(k,outputptr);
	}
      }
      if(fflush(outputptr)==EOF) i=EOF;

      fflush(outputptr);
      fclose(outputptr);

      if(i==EOF && tmpfilename!=NULL) /*fail to output successfully */
      { fprintf(stderr,"Incomplete %s", tmpfilename);
	if(tmpfileactive)
	{  remove(tmpfilename);
	   free(tmpfilename);
	   TMPFILENAME=tmpfilename=NULL;
	   tmpfileactive=0;
	   fprintf(stderr,", %s not updated\n",filename);
	}
	else fprintf(stderr," may be written\n");
      }
      else
    {
      if(tmpfileactive)
      { if(write_filewise<3)
	{ fprintf(stderr,"Update %s? ",newfilename);

#ifdef UNIXMODE
		  fprintf(stderr, "%c[K",27);
#else
		  clreol();
#endif

	  i=yesno(1);
	}
	else i=1; /* yes */


	if(i==-1) /* ctrl_c */
	  { remove(tmpfilename); TMPFILENAME=NULL; exit(1); }
	if(i)
	  { if(filecopy(tmpfilename,newfilename)) /* error */
	    fprintf(stderr,"Fail to update %s\n", newfilename);
	  }

	remove(tmpfilename);
	free(tmpfilename);   /* tmpfilename is created via tempnam() */
	TMPFILENAME=tmpfilename=NULL;
	tmpfileactive=0;
      }
    }
    }
      if(newfilename!=NULL) FREE(newfilename);
      newfilename=NULL;
  }


  if(true_exit) break;
  }   /* end of while 1 */

  printstrchain(confptr,laststr,
    ini_line+(prn_num>1?
    (lineno_filewise? subinput_count:input_count):true_lines),prn_num);
  if (exit_mode==1 || exit_mode==0)
     if (!true_input && totallines) err_code=2 ;
     /* totallines==0 case is treated earlier on */
  if(!no_overflow && OVERFLOW)
   { bufflong=MAXLINEWIDTH;
    fprintf(stderr, "\n%s%ld%s\n", "WARNING: Line width over capacity (",
	    bufflong,").");
   }

  if(filename_level==5) CLREOL();
  if(outputptr!=stdout) fclose(outputptr);

  if(exit_mode==20) err_code=ini_line+ (prn_num>1?
   (lineno_filewise? subinput_count:input_count):true_lines);


  /* for author's own debug memory checking: may be removed along with
     function freemultichains(), variable debug_on
  */
     if(headline!=NULL) FREE(headline);
     if(tailline!=NULL) FREE(tailline);
     if(preseparators!=NULL) FREE(preseparators);
     if(postseparators!=NULL) FREE(postseparators);
     if(insertedstr!=NULL) FREE(insertedstr);
     if(filename!=NULL) FREE(filename);
     freemultichains(33,
	 &firststr,
	 &laststr,
	 &headerstr,
	 &tailerstr,
	 &onlineptr,
	 &inputfilestr,   /* freed already */
	 &matchstr,
	 &maskfilterstr,
	 &oldstrcase,
	 &newstrcase,
	 &oldstrnocase,
	 &newstrnocase,
	 &leftstr,
	 &rightstr,
	 &headfilestr,
	 &tailfilestr,
	 &outfilestr,
	 &maskfilestr,   /* freed already */
	 &andmaskstr,
	 &nongrepstr,

	 &inputmap,
	 &outputmap,
	 &charmap,
	 &strmap,

	 &frontonlycase,
	 &frontonlynocase,
	 &onlineptrfront,
	 &wordplaces,

	 &strinoldname,
	 &strinnewname,
	 &extrainname,

	 &inslines,
	 &addlines

	    );


#ifndef UNIXMODE
  if(promptstr!=NULL) FREE(promptstr);
  freechain(&soundmap);

  if(parent_list!=NULL)
  { while(parent_list->next!=NULL) parent_list=parent_list->next;
    while(1)
    { tmplist=parent_list->prev;
      FREE(parent_list);
      if(tmplist==NULL) break; else parent_list=tmplist;
    }
  }
  if(environ_fail && !no_overflow)
  fprintf(stderr, "\nLack of environment space!%c\n", 0x7);
  if(environ_fail && (exit_mode==17 || exit_mode==0) ) err_code=2;
  if(instant_read) err_code=inkey_level;
#endif


  if(debug_on)
     fprintf(stderr,
	    "\nMemory get/free level=%d\n",GETFREELEVEL-entry_level);

  if(force_exitcode) err_code=force_code;
  return(err_code);

}





/************************************************************
build virtual command line
*************************************************************/

char ** parsestr(char *oldline, int *total)
/*  DOS:  abc"de fg"  interpreted as "abc" "de fg"
    UNIX: abc"de fg"  interpreted as "abcde fg"
*/
{ char *ptr, *oneline, *start;
  int inquote, ch, prevch, i,m, nobreak;
  char **argv, **newargv;

  *total=0;
  ptr=oneline=dupstr(oldline,1);
  argv=newargv=NULL;

  while(*ptr)
  { start=ptr;
    inquote=0;
    while( (*start==' ' || *start==0x9 || *start=='\n') && *start ) start++;
    if(!*ptr) break;
    if(start!=ptr) movebytes(start,ptr,strlen(start),1);
    start=ptr;

    if(*start=='"')
      { inquote=1;
	movebytes(start+1,start,strlen(start+1),1);
      }

    prevch= *start;
    nobreak=0;
    if (!*start) break;

    while(1)
    { ch= *ptr;
      if(ch=='"' && prevch=='\\')
      { movebytes(ptr, ptr-1, strlen(ptr), 1);
	prevch=ch;
	continue;
      }

      if(ch=='"')
	if (inquote)
	{   inquote=0;
#ifdef UNIXMODE
	    movebytes(ptr+1, ptr, strlen(ptr+1), 1);
	    prevch=ch;
	    continue;
#else
	    ch= *ptr=' ';
#endif
	}
	else
	{   inquote=1;
#ifdef UNIXMODE
	    movebytes(ptr+1, ptr, strlen(ptr+1), 1);
	    prevch=ch;
	    continue;
#else
	    ch= *ptr=' '; nobreak=1;
#endif
	}

      if( !ch || !inquote && (ch==' ' || ch==0x9 || ch=='\n') || nobreak )
      {	prevch=ch;
	*ptr=0;
	m= *total+1;
	if(m<=0)
	 { fprintf(stderr,"\nCMD too long."); exit(1); }
	newargv=(char **) MALLOC(sizeof(char*)*(m+1));
	chkmemory(newargv);
	for(i=0;i<*total;i++) newargv[i]=argv[i];
	if(argv!=NULL) FREE(argv);
	argv=newargv;
	argv[m-1]=dupstr(start,0);
	argv[m]=NULL;
	*ptr=prevch;
	*total=m;
	if(nobreak)
	{ nobreak=0; ptr=start=ptr+1; continue; }
	break;
      }
      else ptr++;
      prevch=ch;
    }
    if(!ch) break;
  }
  FREE(oneline);
  return(argv);
}


char **dupcombine(int argn1, char ** argv1, int argn2, char ** argv2)
/* make str array which contains array argv1 and array argv2
*/
{ char ** argv;
  int i;
  if(argn1+argn2<=0) return(NULL);
  argv=(char **) MALLOC(sizeof(char*)*(argn1+argn2+1));
  for(i=0;i<argn1;i++) argv[i]=dupstr(argv1[i],0);
  for(i=0;i<argn2;i++) argv[i+argn1]=dupstr(argv2[i],0);
  argv[argn1+argn2]=NULL;
  return(argv);
}



void freeargv(char *** argvptr)
/* free string array (terminated by NULL)
*/
{ char **argv;
  argv= *argvptr;
  while(*argv!=NULL)
  { FREE(*argv);
    argv++;
  }
  if(*argvptr!=NULL) FREE(*argvptr);
  *argvptr=NULL;
}




/************************************************************
quickly locate a character from command line
*************************************************************/

char *findchar(int argn, char *argv[], int optionnum,
	       char *strops, char ch, int *strnum, int *chnum)
/*
    Find the position of character _ch inside argv[i]
    with i< min(optionnum+1,argn), one at a time.

    return
       NULL: no more found
      other: position of the found _ch (str not duplicated)

    argn=0:  reset pointer to first option character;
	     every call of findchar gets the next number following ch;
	     pointer of found string (no dup) will be returned
    argn<0:  set pointer to strnum:chnum

    strnum:chnum  =the location of the found _ch
*/
{  int i,j,m,n,found,buffchar;
   static int start, nextat;
   char *resultptr=NULL, *one;

   if (argn==0)   /* reset counters */
      { start=1;
	nextat=0;
	*strnum=start; *chnum=nextat;
	return(NULL);
      }
   if (argn<0)    /* set counters */
      {	start= *strnum; nextat= *chnum;
	return(NULL);
      }
   argn=min(optionnum+1, argn);
   if( start>=argn) return(NULL);

   found=0;
   for(i=start; i< argn; i++)      /* end is inclusive ! */
    { one=argv[i];
      n=(one==NULL)? 0:strlen(one);
      for(j=nextat;j<n; j++)
	{ buffchar=one[j];
	  if(buffchar==ch)
	    { found=1;
	      m=n;
	      *strnum=i; *chnum=j;
	      resultptr=one+j+1;
	      nextat=m;
	      break;
	    }
	  if(instr(strops, buffchar)) break;
	 }
       if(found) break; else nextat=0;
     }
    start=i;
    return(resultptr);
}




/************************************************************
quasimain: handles semi-pipe
*************************************************************/

int quasimain(int argn, char **argv,
	      char *charops, char *numops, char *strops)
{ int  retval,strnum,i,j,count;
  char **varg, *chptr;

  count=optioncount(argn,argv,charops,numops,strops);
  strnum=0;
  findchar(0,argv,count,strops,';', &i, &j);
  while(1)
  { chptr=findchar(argn,argv,count,strops,';', &i, &j);
    if(chptr==NULL) i=argn-1;
    varg=dupcombine(1,argv, i-strnum,argv+strnum+1);
    retval=submain(i-strnum+1,varg,charops,numops,strops);
    freeargv(&varg);
    strnum=i;
    if(chptr==NULL) break;
  }
  return(retval);
}




/************************************************************
main function
*************************************************************/

int main(int argn, char **argv, char **env)
{ int  count,retval,narg,strnum,inistrnum,
       i,j;
  char **varg, **vvarg;
  char *charops, *numops, *strops,
       *oneline=NULL, *filename, *chptr;
  chain *allstrs, *cmdfiles, *cmdheader;
  FILE *fptr=NULL;



  /* find environment parameter
  */
  filename="LMFILES=";
  i=strlen(filename);
#ifdef UNIXMODE
  j=':';
#else
  j=';';
#endif
  while((chptr= *env)!=NULL)
  { if(foundstr(chptr,filename,0)==i)
    { chptr=chptr+i;
      ENVFILENAMES=charparse(chptr,j,0);
/*      break;  */
    }

    if(ENVTMPDIR==NULL &&
	foundstr(chptr,"TMPDIR=",0)==7) /* 7=strlen("TMPDIR") */
    {  strcpy(chptr,chptr+7);
       ENVTMPDIR=dupstr(chptr,0);
       GETFREELEVEL--;  /* adjust debug info */
    }

    env++;
  }



#ifdef UNIXMODE
  charops="hHvVa";
  numops="lLsSiIoOkKCMjJNnwWxX#/G+.cyYtT!{";
  strops="beBEqrQRdDgmuUpPfF^:<~;A*`[]}()";
#else
  charops="hHvVa";
  numops="lLsSiIoOkKCMjJNnwWxX#/G+.cyYtT=&zZ!{";
  strops="beBEqrQRdDgmuUpPfF^:<~;A$*`[]}()";
#endif

  count=optioncount(argn,argv,charops,numops,strops);
  allstrs=multichain(argn, argv,strops,count, strops, "/");
  combinestrnum(&allstrs);
  cmdfiles=getsubchain(allstrs,'<');
  useshorthand(cmdfiles, ENVFILENAMES);
  cmdheader=cmdfiles;

  inistrnum=strnum=0;
  findchar(0,argv,count,strops,'<', &i, &j);
  while(1)
  {  chptr=findchar(argn,argv,count,strops,'<', &i, &j);
     if(chptr==NULL) break;
     else strnum=i;
     if(!inistrnum) inistrnum=strnum;
  }

  if(cmdfiles!=NULL && inistrnum>1)
     retval=quasimain(strnum+1,argv,charops,numops,strops);
  else retval=0;

  while(cmdfiles!=NULL)
  { filename=cmdfiles->strone;
    fptr=fopen(filename,"r");
    if(fptr==NULL)
    { cmdfiles=cmdfiles->next;
      continue;
    }
    while(1)
    {  if(oneline!=NULL) FREE(oneline);
       oneline=inputaline(fptr);
       if(oneline==NULL) break;
       if(isempty(oneline)) continue;
       varg=parsestr(oneline, &narg);
       vvarg=dupcombine(1,argv, narg,varg);
       freeargv(&varg);
       varg=vvarg;
       retval=quasimain(narg+1,varg,charops,numops,strops);
       freeargv(&varg);
    }
    fclose(fptr);
    cmdfiles=cmdfiles->next;
  }

  if(!strnum || strnum+1<argn)
  { strnum++;
    varg=dupcombine(1,argv, argn-strnum,argv+strnum);
    retval=quasimain(argn-strnum+1,varg,charops,numops,strops);
    freeargv(&varg);
  }

  freechain(&allstrs);
  freechain(&cmdheader);
  return(retval);
}



/************************************************************
END of whole program -- end of file
*************************************************************/
