#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define EXPORT 
#define IMPORT  extern
#define DATA    static
#define SHARE   
#define METHOD  extern 

extern  char   *stpncpy();

/* input buffer data */
DATA char    *s;      /* read from here        */
DATA char    *ibuffer;
DATA int      ibuffersize;
DATA char    *ibufferlim;
DATA int      iflag;  /* not input buffer full  */

/* input buffer interface */
METHOD void     in_reset ();
METHOD char    *in_line ();
METHOD void     in_out ();
METHOD void     in_new ();
METHOD int      in_isliteral();

/* input buffer shared data */
SHARE int      lineno;

/* global data */
IMPORT char     boxchar;

void         in_new (n)
/* make an input buffer of size n.
   set ibuffersize, ibuffer and ibufferlim.
 */
    int      n;
{
    ibuffersize = n;
    ibuffer = (char *) calloc (ibuffersize, sizeof (char));
    if (ibuffer == 0)
	usage (4);
    ibufferlim = ibuffer + n;
}

void            in_out ()
/* copy the input buffer at s to the output buffer */
{
    out_put (s);
}

void           in_reset ()
/* reset the input buffer pointer s to the origin. */
{
    s = ibuffer;
}

void      in_increase (n)
/* increase the size of the input buffer.
   set ibuffersize, ibuffer and ibufferlim.
 */
    int   n;
{
      static    char *oldbuf;

      oldbuf = ibuffer;
      in_new (ibuffersize + n); /* ibuffersize changes */
      in_reset ();
      strncpy (ibuffer, oldbuf, ibuffersize - n);
      free (oldbuf);         /* try again */
}



char           *in_line ()
/* read in a new line  to buffer &
 * set iflag = 0  to indicate that we're about to process it.
 * If necessary, increase buffer size.
 * If boxchar!=0, remove box surround.
 */
{
    static  char *noteof;
    static  int   offset;

    offset= 0;
    iflag = 0;
    lineno++;
     
    while (ibufferlim[-1] = 0,  /* check for overwrite later */
         noteof = fgets (s+offset, ibuffersize-offset+1, stdin),
         ibufferlim[-1]         /* check now */
        ) {  /* might have to make a bigger buffer */
      if (ibufferlim[-1] == '\n') {
        ibufferlim[-1]=0;
        break;                  /* happy after all */
      }
      offset = ibuffersize;
      in_increase (ibuffersize); /* double size & retry */
    }            
    /* here we're about to return */      
    if (boxchar && *s == boxchar && isspace (s[1])) {
      /* remove left part of box */
      offset = stpncpy (ibuffer, ibuffer + 2, ibuffersize - 2) - ibuffer;
      /* and right */
      if (ibuffer[offset - 2] == boxchar)
        ibuffer[offset - 2] = 0;
      /* while we're here ... */
      if (ibuffer[offset - 1] == '\n')
        ibuffer[offset - 1] = 0;
    }       
    return noteof;
}

char           *in_word ()
/* step one more word along input buffer s &
 * set iflag=1 to indicate that we've started processing the ibuffer.
 * The distinction is needed to tell strtok when to load new buffer.
 */
{
    static char           *w;

    switch (iflag) {
    case 0:
	w = strtok (s, " \t\n");
	iflag = 1;
	break;

    default:
	w = strtok (NULL, " \t\n");
	break;
    }
    return w;
}

int          in_isliteral()
/* check whether line in the input buffer is one of the special sort
   that should be skipped. Starting with a space, dot, backslash, or
   percent.
 */
{
    return !*s
     || isspace (*s)
     || *s=='.'
     || *s=='\\'
     || *s=='%'
     ;
}

int          in_boxline ()
/* check whether line in the input buffer looks like its intended to be
   a row of boxchars, as the top or bottom line of a box.
 */
{
      return  *s==boxchar && !isspace (s[1]);
}

