/*
 *  lmail: local mail delivery agent
 *
 *  Stephen Trier
 *  January 12, 1990
 *
 *  Version 1.0   1/12/90  "cat" command.  Uses binary mode for I/O.  Need
 *     a sensible way to handle ^Z.  Uses standard MS-DOS wildcard filespecs.
 *
 *  Version 1.1   3/27/90  Convert from "cat" into "lmail".  Complete
 *     rewrite.  This version is fast, but may thrash if several recipients
 *     are specified on the command line.
 *
 *  This program is in the public domain.
 *
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <pwd.h>
#include "config.h"

#define BUFLEN      80   /* Size of buffer to use when copying     */
#define MAXFILES    40   /* MS-DOS command line can hold 128 chars */

char buf[BUFLEN];
FILE *fp[MAXFILES];

/*
 *   Configuration code
 */

#define RCVAR(A)    ((A == 0) ? "UUPCSYSRC" : "UUPCUSRRC")

char *ms_maildir = "\\usr\\mail",
     *ms_passwd = NULL;

static struct table_entry table[] = {
	"passwd", &ms_passwd,
	"maildir", &ms_maildir,
	NULL
	} ;

/*
 *      Main routine here.  Shotgun-style copying to mail directories.
 */

int main(int argc, char *argv[])
{
    char mailbox[80];
    int i, j, errlevel = 0;

    ms_config(table);
    pw_openfile(ms_passwd);  /* Defaults to NULL, or default file */

    for (j = 0, i = 1; i < argc; i++)
	if (getpwnam(argv[i]) != NULL)  {
	    sprintf(mailbox, "%s/%s", ms_maildir, argv[i]);
	    fp[j++] = fopen(mailbox, "a");
	    }
	else  {
	    errlevel = 1;
	    fprintf(stderr, "lmail: user \"%s\" unknown.\n", argv[i]);
	    }

    while (fgets(buf, BUFLEN, stdin) != NULL)
	for (i = 0; i < j; i++)
	    fputs(buf, fp[i]);

    return errlevel;
}

