/*
 *      msdos.c: MS-DOS specific functions for smail 2.5
 *
 *      Stephen Trier
 *      March 26, 1990
 *
 *      This file is in the public domain.
 *
 */

/*
 *      This is where the UUPC dependencies come out of the woodwork.
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <pwd.h>
#include "config.h"

char *ms_hostname = "host",
     *ms_hostdomain = "host.domain",
     *ms_smarthost = "smart-host",
     *ms_alias = "/usr/lib/aliases",
     *ms_fullnames = "/usr/lib/fullnames",
     *ms_paths = "/usr/lib/uucp/paths",
     *ms_username = "noone",
     *ms_logfile = "/usr/spool/uucp/mail.log",
     *ms_passwd = NULL,
     *ms_lmail = "lmail",
     *ms_tmpdir = NULL;

static struct table_entry table[] = {
	"nodename", &ms_hostname,
	"domain", &ms_hostdomain,
	"mailserv", &ms_smarthost,
	"aliases", &ms_alias,
	"fullnames", &ms_fullnames,
	"paths", &ms_paths,
	"mailbox", &ms_username,
	"smaillog", &ms_logfile,
	"passwd", &ms_passwd,
	"localmail", &ms_lmail,
	"tempdir", &ms_tmpdir,
	NULL
	} ;

extern char *pathfile, *aliasfile, *fnlist;  /* Imported from main.c */

void config(void)
{
    ms_config(table);

    pw_openfile(ms_passwd);  /* Defaults to NULL, default file. */
    pathfile = ms_paths;
    aliasfile = ms_alias;
    fnlist = ms_fullnames;
    if (ms_tmpdir == NULL)
	if ((ms_tmpdir = getenv("TMP")) == NULL)
	    if ((ms_tmpdir = getenv("TMPDIR")) == NULL)
		ms_tmpdir = "/tmp";
}


/*
 *      getuid:  Look up uupc.rc username in password file and return uid
 */

int getuid(void)
{
    struct passwd *pwbuf;

    pwbuf = getpwnam(ms_username);
    if (pwbuf)
	return pwbuf->pw_uid;
    else
	return -1;
}

