/*
 *      popen.c: popen/pclose routines for MS-DOS smail
 *
 *      Stephen Trier
 *      3/27/90
 *
 *      These routines are for the MS-DOS version of smail only.  They
 *      implement only write pipes, and only one pipe can be used at a
 *      time.  Although this implementation is not very general, it is
 *      sufficient for smail.
 *
 *      This file is in the public domain.
 *
 */

#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <process.h>
#include <dir.h>
#include <io.h>

static FILE *pipefp;
static char cmd[128], pipefile[80];
extern char *ms_tmpdir;

FILE *popen(char *command, char *type)
{
    if ((*type == 'w') && (strcpy(cmd, command) != NULL))  {
	sprintf(pipefile, "%s/pipeXXXXXX", ms_tmpdir);
	mktemp(pipefile);
	pipefp = fopen(pipefile, "w");
	return pipefp;  /* Return NULL if error */
	}
    else
	return NULL;
}

int pclose(FILE *fp)
{
    int pipefd, stdinfd, returnval = 0;
    char *args;

    if (fp == pipefp)  {
	args = strchr(cmd, ' ');
	if (args != NULL)  {
	    *args = '\0';  /* Mark end of command and beginning of args */
	    args++;
	    }
	fclose(pipefp);
	pipefp = fopen(pipefile, "rb");
	pipefd = fileno(pipefp);
	stdinfd = dup(0);         /* Save standard input for afterwards */
	dup2(pipefd, 0);          /* New standard input is from pipe    */
	returnval = spawnlp(P_WAIT, cmd, cmd, args, NULL);  /* Fork the command */
	dup2(stdinfd, 0);         /* Restore the standard input         */
	close(stdinfd);           /* Get rid of the duplicate stdin     */
	fclose(pipefp);           /* Prepare to remove the pipe         */
	unlink(pipefile);         /* Delete the pipe                    */

	return returnval << 8;
	}
    else
	return -1;
}

