        NAME    FAKEVGA
        TITLE   FAKEVGA -- pretent the display adapter is a VGA
        PAGE    58,132
;..............................................................................
;
;       FAKEVGA pretends that the display adapter is a VGA.
;
;       Some video cards, in particular the Zenith 449, are capable of
;       a 640 by 480 16 color mode that is compatible with the VGA.
;
;       However, these cards lack the BIOS support IBM added to the PS/2
;       machines.  In particular, IBM added a function 1A, "Get or Set
;       Display Combination Code" to the BIOS video interrupt, INT 10.
;       This function is a natural way for application software to test
;       for the existance of a VGA.  If the function is not provided,
;       the software will assume that no VGA is present and will not attempt
;       to use the 640 by 480 mode.
;
;       FAKEVGA provides minimal support of function 1A, which is often
;       enough to convince an application program to use the 640 by 480
;       mode.
;
;       FAKEVGA will report to its caller that a VGA with either a
;       color or monochrome analog monitor is present.  If the
;       application program then assumes features of the display
;       adapter that are not available, the result is undefined.
;       In the case of the Zenith 449, this will happen if the program
;       attempts to use the 320 by 200 256 color mode, which is present
;       in a real VGA but not on the 449 card.
;
;       FAKEVGA does not provide any support for function 1B, "Get
;       Functionality/State Information", which is another natural
;       way to check for the presence of a VGA.  However, few programs
;       seem to use function 1B currently.
;
;       FAKEVGA is known to fool the following programs:
;
;               Wordperfect 5.0
;               Programs written using Turbo Pascal 4.0
;
;
;       Generate into a COM file as follows:
;               MASM FAKEVGA;
;               LINK FAKEVGA;
;               EXE2BIN FAKEVGA.EXE FAKEVGA.COM
;               ERASE FAKEVGA.OBJ
;               ERASE FAKEVGA.EXE
;
;
;       This program was written by myself and is hereby placed in the
;       public domain.  No warranty of any kind is expressed or implied.
;
;       Neil Erdwien
;       Computing Activities
;       Cardwell Hall
;       Kansas State University
;       Manhattan, KS  66506
;       NEIL@KSUVM  (BITNET)  or  NEIL@KSUVM.KSU.EDU  (Internet)
;       (913) 532-6311
;
;..............................................................................

cseg    SEGMENT
        ASSUME  cs:cseg

        ORG     100h
entry:  jmp     install
        db      'FAKEVGA',0
        even

oldint10 dd     0
dispcode dw     8

newint10 PROC   far

        cmp     ah,1ah          ;Is this function 1A?
        jne     punt            ;...if not, call the BIOS INT10

        cmp     al,00h          ;Is this a GET (AL=00) or SET (AL=01)?
        mov     al,ah           ;(set AL=1A to indicate fcn supported)
        jne     set

        mov     bx,dispcode     ;This is a GET request -- return the DISPCODE
        iret

set:
        mov     dispcode,bx     ;This is a SET request -- save the DISPCODE
        iret

punt:
        jmp     [oldint10]

newint10 ENDP


install:
        ASSUME  ds:cseg

        mov     ax,3510h        ;Get interrupt vector for INT 10
        int     21h
                                ;ES:BX now points to the old INT 10 handler

        mov     word ptr oldint10,bx    ;...save for later use
        mov     word ptr oldint10+2,es

        mov     ax,2510h        ;Set interrupt vector for INT 10
        mov     dx,offset newint10
        int     21h

        mov     ax,3100h                ;Stay resident, exit code = 0
        mov     dx,offset install
        int     21h

cseg    ENDS

        END     entry
