{$A+,B-,D+,E+,F-,I+,L+,N-,O-,R-,S+,V-}
{$M 16384,0,655360}
program Read_bootsector_partitiontable_for_later_use_with_BOOTCOMP;
{(C) Copyright A. Merckens 1989}
{DO NOT MODIFY IN ANY WAY}

uses Crt, Dos;

type
  cluster_size = array [0..511] of byte;

var
  reg: registers;
  buffer, buffer2: cluster_size;
  f: file;
  i, j, track, sector, head: integer;
  active, disk: byte;
  p1, filename: string ;
  ch: char;

procedure abort(code: integer; s: string );
begin
  writeln; writeln(s);
  if code = 1 then
  begin
  writeln('Call: BOOTREAD [drive] [filenaam]  - see manual');
  end;
  halt(255);
end;

procedure read_sector_from_drive(drive, track, sector, head: integer;
                                 var buffer: cluster_size);

begin
  reg.ah := 2; reg.al := 1; reg.ch := track; reg.cl := sector; {sector nummer}
  reg.dh := head; reg.dl := drive; reg.es := seg(buffer); reg.bx := ofs(buffer);
  intr($13, reg);
  if (reg.flags and 1) = 1 then
    if reg.dl < 80 then
      abort(0,'Disk read error: disk in drive? ')
    else
      abort(0,'Disk read error');
end;

begin
  clrscr;
  highvideo;
  write('BOOTREAD 1.0 -  Save information for use with BOOTCOMP   - (C) A. Merckens 1989');
  normvideo;
  gotoxy(1,2);
  If Paramcount > 2 then abort(1, 'Too many parameters specified.');

  If Paramcount = 2 then
  Begin
    p1 := paramstr(1); filename := paramstr(2);
    if NOT ((pos(':', p1) = 2) and (length(p1) = 2)) then
    begin
      filename := p1; p1 := paramstr(2);
    end;

    p1[1] := UpCase(p1[1]);

    if NOT ((pos(':', p1) = 2) or (length(p1) <> 2)) and
	   (p1[1] in ['A'..'Z','1','2']) then
    abort(1, 'Wrong parameters specified');

	if (p1[1] >= 'C') or (p1[1]='1') then disk := $80
	else if p1[2] = '2' then disk := $81
    else disk := ord((p1[1])) - 65; {Start met A-drive}
  End
  Else abort(1, 'Not enough parameters specified.');

  write('The bootsector ');
  if disk >=$80 then write(' + partitiontable of harddisk ',disk-$80)
  else write('of disk in drive ',p1[1]);
  writeln('  --> file ', filename);

  assign(f, filename);
  {$I-}
  reset(f);
  {$I+}
  If Ioresult = 0 then
  begin
    close(f);
    write(#7,'File ',filename,' already exists. Overwrite it? (Y/N) ');
    repeat ch := Upcase(readkey) until ch in ['Y','N']; write(ch);
    if ch = 'N' then abort(0,'BOOTREAD not executed');
  end;
  rewrite(f, 1);

  active := 0;

  read_sector_from_drive(disk, 0, 1, 0, buffer);
  if disk >= $80 then
  begin

    for i := 1 to 4 do if buffer[$1AE + i * $10] = $80 then active := i;
(*
   writeln('track ',buffer[$1ae+active*$10+3], {track / cylinder with next:}
                   ' sector ',buffer[$1ae+active*$10+2], {sector}
                   ' head ',buffer[$1ae+active*$10+4]  {head}
                  );
*)

    if active = 0 then
       abort(0, 'No active bootsector found for harddisk '+char(disk-$50));

    blockwrite(f, buffer, 512);

    read_sector_from_drive($80, buffer[$1AE + active * $10 + 3], {track /
                                        cylinder with next:}
                           buffer[$1AE + active * $10 + 2], {sector}
                           buffer[$1AE + active * $10 + 1], {head}
                           buffer);

  end;
  blockwrite(f, buffer, 512); close(f);

end.
