.radix 16

cseg        segment
            assume cs:cseg
            org    100h
                                                 ;
start:      jmp    startcode

                                                 ; 3-inch diskette
kreet           db 'BOOTCOMP'                   ; 8 bytes
sectsize        dw 200                          ; adres 0B
clustsize       db 02                           ; adres 0D
ressects        dw 01                           ; adres 0E
fatcnt          db 02                           ; adres 10
rootsiz         dw 70                           ; adres 11
totsects        dw 5a0                          ; adres 13
media           db 0f9                          ; adres 15
fatsize         dw 03                           ; adres 16
trkres          dw 09                           ; adres 18
headcnt         dw 02                           ; adres 1A
hidnsect        dw 00                           ; adres 1C

ASSUME cs:07c0

startcode:
            cli
            xor   ax,ax
            mov   ss,ax
            mov   sp,7bf0
            sti

            push  ax
            pop   ds                             ; dataseg points to 0
            mov   ax,07e0
            push  ax
            pop   es                             ; ES points to 07e0 (200 bytes away from cs)

            MOV   DL,0                           ; driveA
            MOV   DH,0                           ; head 0
            MOV   CH,1                           ; track 1
            MOV   CL,1                           ; sector 1
            MOV   AL,1                           ; # sectors 1
            MOV   AH,2                           ; read
            XOR   bx,bx                          ; bx = 0
            INT   13                             ; perform a read

            JC    disk_error                     ; a disk read error
;
;Now the interrupt addresses will be put in the file BOOTCOMP.exe
;
            MOV   AX,DS:[4C]                    ; old int 13
            PUSH  AX
            MOV   ES:[129],AX
            MOV   AX,DS:[4E]
            PUSH  AX
            MOV   ES:[12F],AX
            MOV   AX,DS:[100]                   ; old int 40
            MOV   ES:[11D],AX
            MOV   AX,DS:[102]
            MOV   ES:[123],AX

            POP   DS
            POP   SI
            MOV   DI,152
            MOVSW
            MOV   DI,158
            MOVSW

            MOV   AL, 1
            MOV   DL,0                          ; drive A ; rest of registers unchanged
            MOV   AH, 3 ; schrijven
            INT   13

            JC    disk_error                    ; A disk write error

            mov   si,message1+7b00              ; write install_message

write_mess:

            push  cs                            ; dataseg points to codeseg = 07c0
            pop   ds

            nop
            cld
next_byte:
            lodsb
            or    al,al
            jz    next_boot
            push  si
            mov   ah,0e
            mov   bx,0007
            int   10
            pop   si
            jmp   next_byte

next_boot:
            xor   ah,ah
            int   16
            mov   ah,0f
            int   10
            xor   ah,ah
            int   10
            int   19

disk_error:
            mov   si,message2+7b00
            jmp   write_mess

message1:

db 0A,0D,0A,0D,
db 'BOOTCOMP has been installed for this specific computer.',0A,0D,0A,0D
db '   Remove the disk from drive A',0A,0D
db '   Make the disk write-protected with a tab',0A,0D
db '   Reboot with a systemdisk in drive A or from harddisk',0A,0D
db 00

message2:

db 0A,0D,0A,0D,07,'BOOTCOMP has NOT been installed: ',07
db 'the disk is probably "write-protected".',0A,0D,0A,0D
db '   Remove the tab and try again',0A,0D
db  00

db '(C) Copyright A. Merckens 1989'                      ; do NOT modify
db  00 00 00 00 00 00 00 00 00 00 00 00 00 00 00

cseg        ends
                                                         ;
            end    start



