#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include "dir.h"

main(int argc, char *argv[]) {

int	dir, x, name;
int	tot, dead;
int	xflag = 0;
int	dstat, low;
char	*home, *fnam;
long	kill = 15000;

time_t	start, finish;

struct direct *dp;
struct stat stbuf;

printf("\n\n'hk' - (c) 1991 Bob Kirkpatrick\n");
time(&start);
if (argc < 2) {
	printf("oops.\ntry:    hk /newsdir/group/path\n");
	printf("\n/newsdir/ is your waffle news base directory.\n");
	printf("group/path is the actual directory on your\n");
	printf("system where the newsgroup to be filtered keeps\n");
	printf("it's articles. ex: d:/news/alt/binaries/pictures.\n");
	exit(1);
	}
tot = 1;
dead = 1;
dir = 0;
if (!(getcwd(home,40))) {
	printf("no home reference.\ninternal error\n");
	exit(1);
	}
chdir(argv[1]);
if (!(dir = opendir(argv[1]))) {
	printf("error opening dir...\n");
	chdir(home);
	exit(1);
	}
printf("\n%s:\n", argv[1]);
while (dp = readdir(dir)) {
	if (dp->d_name == NULL)
		break;
	stat(dp->d_name, &stbuf);
	if (stbuf.st_size < 1) {
		printf("non-article: \"%s\"\n", dp->d_name);
		continue;
		}
	tot++;
	if (xflag == 0) {
		xflag++;
		name = atoi(dp->d_name);
		if (name == 0)
			name++;
		}
	if (stbuf.st_size < kill) {
		unlink(dp->d_name);
		dead++;
		}
	}
closedir(dir);
dir = 0;
low = name;
if (dead == 1) {
	printf("directory unchanged\nno files to process.\n");
	chdir(home);
	exit(0);
	}
if (!(dir = opendir(argv[1]))) {
	printf("rename aborted.\ncan't open dir.\n");
	exit(1);
	}
while ((dp = readdir(dir)) != 0) {
	if (dp->d_name == NULL)
		break;
	if (strncmp(dp->d_name, ".", 1) == 0)
		continue;
	if (atoi(dp->d_name) < 1)
		continue;
	itoa(name++, fnam, 10);
	rename(dp->d_name, fnam);
	}
closedir(dir);
dir = 0;
time(&finish);
printf("%d messages processed, %d removed in %.2f seconds.\n", --tot, --dead, difftime(finish, start));
if (tot == dead)
	printf("there are no messages remaining.\n");
else
	printf("%d remain: lowest is %d, highest is %s.\n", (atoi(fnam) - low), low, fnam);
chdir(home);
}
