#include <ctype.h>
#include <nwmisc.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <kjslib.h>

void GetZipName(char *realname,char *name);
void Usage(void);

boolean writefile = FALSE;/* If true write file, else put in master environment */
char filename[128];                                  /* Batch file to write */
char *userinfofile = "USERINFO.DAT";         /* File to get users name from */
char *zipfile = "F:\\WAFFLE\\ZIPNEWS\\ZN_USERS.LST";
char *usernamev = "USER";                  /* Variable to put users name in */

void main(int argc,char *argv[])
{
   char name[9];
   char realname[100];
   char *s;
   FILE *fp;

   while (--argc > 0 && ((*++argv)[0] == '-' || (*argv)[0] == '/'))
      for (s = argv[0]+1; *s != '\0'; s++)          /* Isolate the switches */
         switch (toupper(*s)) {
            case 'F' : strcpy(filename,s);          /* Copy wanted filename */
                       MoveUp(filename,0);            /* Get rid of the 'F' */
                       strupr(filename);
							  while (*s != '\0')
								  s++;
							  s--;
                       writefile = TRUE;
							  break;
            case '?' : Usage();                    /* Display program usage */
                       break;
            case '-' : break;                        /* Allowed but ignored */
            case '/' : break;                        /* Allowed but ignored */
            default  : fprintf(stderr,"Illegal option '%c'\n",toupper(*s));
                       Usage();
                       break;
         }

   if (writefile)
      unlink(filename);
   else
      if (PutEnvironmentVariable(usernamev,'\0') != 0) {
         printf("Error removing %s from environment.\n",usernamev);
         exit(2);
      }
   if ((fp = fopen(userinfofile,"r")) == NULL) {
      printf("Error opening file %s\n",userinfofile);
      exit(2);
   }
   Get_File_String(realname,sizeof(realname)-2,fp);
   fclose(fp);
   GetZipName(realname,name);
   if (writefile) {
      if ((fp = fopen(filename,"wt")) == NULL) {
         printf("Error opening file %s\n",filename);
         exit(2);
      }
      fprintf(fp,"@echo off\n");
      fprintf(fp,"set %s=%s\n",usernamev,name);
      fclose(fp);
   } else
      if (PutEnvironmentVariable(usernamev,name) != 0) {
         printf("Error adding %s to environment.\n",usernamev);
         exit(2);
      }
   exit(0);
}

void GetZipName(char *realname,char *name)
{
   int i;
   char buffer[200],buff[200];
   FILE *fp;

   if ((fp = fopen(zipfile,"r")) == NULL) {
      printf("Error opening file %s\n",zipfile);
      exit(2);
   }
   do {
      Get_File_String(buffer,sizeof(buffer)-2,fp);
      if (!feof(fp)) {
         for (i = strlen(buffer) - 1; i < 0, buffer[i] != ' '; i--)
            buff[strlen(buffer)-i-1] = buffer[i];
         buff[strlen(buffer)-i-1] = '\0';
         buffer[i] = '\0';
      }
   } while (!feof(fp) && strcmp(realname,buffer));
   fclose(fp);
   if (!strcmp(realname,buffer)) {
      for (i = 0; i < strlen(buff); i++)
         name[strlen(buff)-i-1] = buff[i];
      name[strlen(buff)] = '\0';
      return;
   }
   printf("Please run the ZipNews option from the menu.\n");
   printf("This will set up your username for UseNet News\n");
   printf("and create your directory structure.\n");
   printf("Then re-run Solar and it will operate correctly.\n");
   exit(1);
}

void Usage(void)
{
   printf("Program to get users Waffle name from the ZipNews file\n%s\n",zipfile);
   printf("using the information in %s\n",userinfofile);
   printf("\nThe only parameter is an option /f followed by a batch file to write\n");
   printf("If the /f parameter is not given the username is put into the master DOS\n");
   printf("environment variable %s\n",usernamev);
   exit(2);
}