/*===========================================================================
SOLAR slrreply :: Module ..\slrreply\extract.h
Original author : Kevin Houle <kjhoule@iowegia.dsm.ia.us>

This source code has been released into the public domain.
===========================================================================*/

/* Common Includes */

#include "..\common\yesno.h"

/* Definitions */

#define MSGID_VERSION            "0953"   /* Version for msgid field */
#define BUFSIZE                   1024    /* Size of buffer          */
#define REPLY_TMP       "SOLARREP.TMP"    /* Temporary reply message */
#define NEWS_HEAD_DENY  "NEWSHEAD.DNY"    /* News header deny list   */
#define MAIL_HEAD_DENY  "MAILHEAD.DNY"    /* Mail header deny list   */
#define NEWS_HEAD_ORDER "NEWSHEAD.ORD"    /* News header order list  */
#define MAIL_HEAD_ORDER "MAILHEAD.ORD"    /* Mail header order list  */

/* External Functions */

extern char *rfctime();                 /* From rfctime.c  */
extern int  scan_forums(char *header);  /* From forums.c   */

/* External Data */

extern char _slrerr[80];                /* From config.c   */
extern long _maxnewssize;               /* From config.c   */
extern long _maxmailsize;               /* From config.c   */
extern long spam_max;                   /* From config.c   */
extern char solar_path[MAXPATH];        /* From config.c   */
extern char username[10];               /* From config.c   */
extern char uucp_name[10];              /* From config.c   */
extern char domain_name[40];            /* From config.c   */
extern char real_name[20];              /* From config.c   */
extern char organization[128];          /* From config.c   */
extern char msg_type;                   /* From process.c  */
extern char mod_address[80];            /* From forums.c   */

/* Local Data Types */

typedef struct _Header {
  char   info[BUFSIZE];
  int    used;
  struct _Header *next;
} HEADER;

/* Local Functions */

int  allow_header(char *string);
int  dump_header(HEADER *header, FILE *work_file);
int  write_msgid(FILE *work_file);
long binlen(char bigendian[4]);
long spam_count();

/* Local Data */

char msgbuf[BUFSIZE];
