/*===========================================================================
SOLAR v0.95.3 solar :: Module ..\solar\config.h
Original Author: Kevin Houle <kjhoule@iowegia.dsm.ia.us>

This software module has been placed in the public domain.
===========================================================================*/

#include "..\common\yesno.h"

#define OPTIONS_NAME    "OPTIONS.SLR"

/* Global Data */

char temp_path[MAXPATH];				/* Path to temporary directory			*/
char user_path[MAXPATH];				/* Path to user's directory         */
char menu_path[MAXPATH];        /* Path to Solar's menu file        */
char config_path[MAXPATH];      /* Full path to Solar config file   */
char log_path[MAXPATH]; 				/* Full path to Solar log file			*/
char solar_path[MAXPATH]; 			/* Full path to main Solar directory*/
char static_path[MAXPATH];			/* Full path to Waffle's static     */
char waffle_path[MAXPATH];			/* Full path to Waffle root dir 		*/
char system_path[MAXPATH];			/* Path to Waffle system directory	*/
char extern_path[MAXPATH];			/* Path to Waffle extern directory	*/
char extern_root[MAXPATH];      /* Name of root extern file         */
char help_path[MAXPATH];        /* Path to Solar's help file        */
char swap_path[MAXPATH];        /* Path to swap directory           */
char uucpname[10];              /* System's UUCP name               */

int  diskswap;                  /* Swap to disk ?                   */
int  stupid_user;               /* Show 'em the menu after x errors */
int  use_fossil;                /* Use a FOSSIL driver              */
int  port;											/* COM port for FOSSIL, 0=COM1: 		*/
int  verbose; 									/* Verbose mode toggle							*/
char speed[6];									/* Modem speed from command line		*/
char _slrerr[80]; 							/* Global error message buffer			*/

enum SOUP_Types { u, M, m, n, C, c, i, b, B };	/* Possible SOUP types */

/* News control parameters */
int  news_type; 								/* SOUP message format							 */
int  news_index;								/* SOUP index format								 */
long news_area_bytes; 					/* Max. number of bytes per msg area */
long news_area_messages;				/* Max. number of msgs per msg area  */
long news_total_bytes;					/* Max. number of bytes total 			 */
long news_total_messages; 			/* Max. number of messages total		 */

/* Mail control parameters */
int  mail_index;								/* SOUP mail index format 					 */
int  mail_type; 								/* SOUP mail message format 				 */
int  send_mail; 								/* Send mail in SOUP packet?				 */
int  delete_mail; 							/* Delete mail after download?			 */

/* Other optional parameters */
int  send_list; 								/* Send LIST file?									 */
char default_keyword; 					/* Default newsrc.slr keyword 			 */
char protocol[10];							/* Transfer protocol type 					 */
char compress[10];							/* File compression type						 */
int  use_wafjoin; 							/* Use Waffle's JOIN file?           */
int  time_left; 								/* Time remaining online in min.		 */
long disk_minimum;              /* Minimum free disk space          */

/* Common Functions */
extern char *extract_parm(char string[128], char delimiter);
extern int	convert_to_number(char *argument);
extern int	get_protocol_type(char buf[128]);
extern int	get_compress_type(char buf[128]);
extern int  view_file(char filepath[MAXPATH]);
