/*===========================================================================
SOLAR v0.95.1 solar :: Module ..\solar\register.h
Original Author: Kevin Houle <kjhoule@iowegia.dsm.ia.us>

This software module has been placed in the public domain.
30/10/95  KJS  Added definition for _slrerr
===========================================================================*/

/* Common Includes */

#include "..\common\fossil.h"
#include "..\common\yesno.h"

/* Static Data Definitions */

#define NEWSRC      "NEWSRC.SLR"
#define NEWSRC_TMP  "NEWSRC.TMP"

/* External Common Functions */

extern FILE *open_forum_file(char path[MAXPATH]);
extern FILE *open_newsrc(const char *newsrc_type, const char *open_mode);
extern int  read_newsrc(FILE *newsrc);
extern int  write_newsrc(const char *newsrc_type, const char *open_mode);
extern int  kill_newsrc(const char *newsrc_type);
extern int  update_newsrc();
extern int  load_forums();
extern int  set_default_path();

/* External Global Data */

extern char username[10];                     /* From config.c */
extern char area_name[80];                    /* From newsrc.c */
extern char keyword;                          /* From newsrc.c */
extern long index_high;                       /* From newsrc.c */
extern long msg_high;                         /* From newsrc.c */
extern char _slrerr[80];

/* Local Global Data */

typedef struct forum_type {
	char forum_path[MAXPATH];
  struct forum_type *next;
} FORUM;
extern FORUM *forum;

/* Local Global Functions */

long high_fileno();
long low_fileno();
