/*
 *   This file is a part of uuhydra, a replacment for Waffle's uucico
 *
 *   Copyright (C) 1993  Erik Bos (erik@trashcan.hacktic.nl)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

extern int AsyncInitPort(int port)
{
	asm {
		mov ax,0x0400
		mov bx,ax
		mov dx,[port]
		int 0x14

		cmp ax,0x1954
		mov al,bh
		mov ah,0x0
		je  end_init

		xor ax,ax
	}

end_init:
	asm {
	}
}

extern void AsyncDeInitPort(int port)
{
	asm {
		mov ax,0x0500
		mov dx,[port]
		int 0x14
	}
}

extern void AsyncSetDTR(int port, char state)
{
	asm {
		mov ah,0x06
		mov al,[state]
		mov dx,[port]
		int 0x14
	}
}

extern unsigned int AsyncSetBaudRate(int port, unsigned char baudrate)
{
	asm {
		xor ah,ah
		mov al,[baudrate]
		mov dx,[port]
		int 0x14
	}
}

extern unsigned int AsyncGetPortStatus(int port)
{
	asm {
		mov ax,0x0300
		mov dx,[port]
		int 0x14
	}
}

extern void AsyncTxFlush(int port)
{
	asm {
		mov ax,0x0800
		mov dx,[port]
		int 0x14
	}
}

extern void AsyncRxPurge(int port)
{
	asm {
		mov ax,0x0a00
		mov dx,[port]
		int 0x14
	}
}

extern void AsyncTxPurge(int port)
{
	asm {
		mov ax,0x0900
		mov dx,[port]
		int 0x14
	}
}

extern void AsyncSetFlowCtl(int port, unsigned char state)
{
	asm {
		mov ah,0x0f
		mov al,[state]
		mov dx,[port]
		int 0x14
	}
}

extern int AsyncKbPeek(void)
{
	asm {
		mov ah,0x0d
		int 0x14
	}
}

extern unsigned int AsyncGetKbChar(void)
{
	asm {
		mov ah,0x0e
		int 0x14
	}
}

extern void AsyncSetBreak(int port, char state)
{
	asm {
		mov ah,0x1a
		mov al,[state]
		mov dx,[port]
		int 0x14
	}
}

extern int AsyncTxChar(int port, unsigned char databyte)
{
	asm {
		mov ah,0x01
		mov al,[databyte]
		mov dx,[port]
		int 0x14
	}
}

extern unsigned char AsyncRxChar(int port)
{
	asm {
		mov ah,0x02
		mov dx,[port]
		int 0x14
	}
}

extern void AsyncTxBlock(int p, char *buffer, unsigned int length)
{
	while (length--)
		AsyncTxChar(p,*buffer++);
}
