#============================================================================
#
#       OUTPORT Demo Program for XA
#
#       This command file shows you a method for outputing
#       data to an LPT (Printer) port.
#
#       A Camcorder with remote recording capabilities can be controlled
#       by data sent through the printer port.  This command file converts
#       a normal camcorder into a time-lapse camcorder.  The camcorder is
#       turned On for 1 second, then turned Off for 30 seconds. 
#
#       The particular camcorder controlled here has a jack that 
#       accepts a 2-connector 1/8" phone plug (R.S. Cat No 274-287). 
#       A SPST 5-Volt Reed relay connected to the parallel port 
#       controls the circuit. Since LPT is already  connected to a printer, 
#       LPT2 was used to control the camera.
#
#
#
#                       +----------------------------------------+
#                       |                                        |
#        +---+  pin 2   |                                        |
#        |: :|-----------------+                                 |
#        |: :|          |      |                                 |||||====
#  LPT2  |: :|          |      |                                 |  Phone
#   25   |: :|          |     -+---------+                       |  Jack
#  pin   |: :|          +----+    Reed   |-----------------------+
# Dshell |: :|                -+---------+
#        |: :|  pin 25         |
#        |: :| ----------------+
#        +---+
#       
#
#       Pins 2 and 25 from the D-shell connection trigger the relay.
#       Pin 2 is the least significant data bit, Pin 25 is ground. 
#       The relay acts as a switch to control the camera. This particular
#       camera is triggered by an Off to On switch transition only. 
#       
#       THIS FILE IS FOR INFORMATIONAL PURPOSES ONLY. YOU, AND YOU ALONE
#       ARE RESPONSIBLE FOR ANY DAMAGE YOU MAY INFLICT ON YOUR COMPUTER
#       OR PERIPHERAL EQUIPMENT.
#
#
#       
#
#  DEFINE some strings used by this program.
#

DEFINE DELAY_OFF DELAY 0:0:20       # Camera OFF time
DEFINE DELAY_1 DELAY 0:0:1          # Delay 1 second
DEFINE DELAY_2 DELAY 0:0:2          # Delay 2 seconds
DEFINE CAMERA_ON OUTPORT 278H 1     # Turn On relay (via pin 2)
DEFINE CAMERA_OFF OUTPORT 278H 0    # Turn Off relay (via pin 2)


:start                              # This is the start of the loop

CAMERA_OFF                          # 0 - 1 transition 
CAMERA_ON                           # ...starts recording
DELAY_2                             # ...for 2 seconds.

CAMERA_OFF                          # 0 - 1 transition
CAMERA_ON                           # stops recording.
DELAY_1                             # 
CAMERA_OFF                          # turn relay off

DELAY_OFF                           # Wait 20 seconds...
goto start                          # Start all over again

:exit
