DISPLAY ON
#
#  KEY.CMD - Demonstration of the following XA facilities:
#     * Keyboard Function Key checking. Execute commands based on keystrokes.
#     * INKEY, F1KEY...F12KEY input checking
#     * IF/ELSE programming
#     * GOSUB/RETURNS
#
pause  
display off
declare var key         # This is where INKEY places keyboard characters
gosub :menu

:loop_start
key = inkey

if (key == F1KEY)
  DISPLAY ON   
  Front_Porch On
  DISPLAY OFF
  gosub menu
  endif 

if (key == F2KEY)
  DISPLAY ON
  Front_Porch Off
  DISPLAY OFF
  gosub menu
  endif 

if key == F3KEY
  DISPLAY ON
  Security_Lights On
  DISPLAY OFF
  gosub menu
  endif 

if key == F4KEY
  DISPLAY ON
  Security_Lights Off
  DISPLAY OFF
  gosub menu
  endif

if key == F5KEY
  DISPLAY OFF
  VIDEO1 WHITE BLACK         # For TRUE expressions
  VIDEO2 LIGHTGRAY BLACK     # For FALSE expressions
  VIDEO3 BLACK LIGHTGRAY     # For DIRECT COMMANDS
  VIDEO4 LIGHTGRAY BLACK     # For EVENTS
  VIDEO5 WHITE BLACK         # For Important XA Messages
  VIDEO6 LIGHTGRAY BLACK     # For Supplemental statements (comments)
  VIDEO7 WHITE LIGHTGRAY     # For Event Bargraph
  VIDEO8 LIGHTGRAY BLACK     # For Comments
  DISPLAY OFF
  gosub menu
  endif

if key == F6KEY
  DISPLAY OFF
  VIDEO1 LIGHTGREEN BLACK    # For TRUE expressions
  VIDEO2 RED BLACK           # For FALSE expressions
  VIDEO3 YELLOW BLACK        # For DIRECT COMMANDS
  VIDEO4 CYAN BLACK          # For EVENTS
  VIDEO5 YELLOW BLACK        # For Important XA Messages
  VIDEO6 LIGHTGRAY BLUE      # For Supplemental statements (comments)
  VIDEO7 CYAN BLUE           # For Event Bargraph
  VIDEO8 YELLOW BLUE         # For Comments
  DISPLAY OFF
  gosub menu
  endif

if key == F7KEY
  # Use the DOS token to invoke another copy of XA for monitoring
  dos cls
  DISPLAY ON
  dos XA "MONITOR"          # causes immediate monitoring
  DISPLAY OFF
  gosub menu
  endif

if key == F8KEY
  # Use the DOS token to invoke another copy of XA for powerfail recovery
  dos cls
  DISPLAY ON
  dos XA -p
  DISPLAY OFF
  gosub menu
  endif

if key == F9KEY
  # Use the INCLUDE token to have XA read another command file
  dos cls
  DISPLAY ON
  include xa.cmd
  DISPLAY OFF
  gosub menu
  endif

if key == F10KEY
  # Use the INCLUDE token to have XA read another command file
  dos cls
  DISPLAY ON
  include demo.cmd
  DISPLAY OFF
  gosub menu
  endif

if key == F11KEY
  # Perform CP-290 diagnostics
  dos cls
  DISPLAY ON
  diagnose
  DISPLAY OFF
  gosub menu
  endif

if key == F12KEY
  # Use the INCLUDE token to have XA read another command file
  dos cls
  DISPLAY ON
  include usage.xa
  DISPLAY OFF
  gosub menu
  endif

goto :loop_start


:menu                                                              
dos cls
DISPLAY ON



#
#  PRESS ONE OF THE FOLLOWING FUNCTION KEYS, ESC TO EXIT:
#
#  Ŀ                            Ŀ
#   F1   Porch Lights On             F2   Porch Lights Off
#                              
#  Ŀ                            Ŀ
#   F3   Security Lights On          F4   Security Lights Off
#                              
#  Ŀ                            Ŀ
#   F5   Black and White Display     F6   Color Display
#                              
#  Ŀ                            Ŀ
#   F7   Monitor CP-290 Activity     F8   Powerfail Recovery
#                              
#  Ŀ                            Ŀ
#   F9   Download XA.CMD             F10  Execute DEMO Program
#                              
#  Ŀ                            Ŀ
#   F11  CP-290 Diagnostics          F12  XA's "Usage" file (HELP)
#                              
#  Ŀ             
#   ESC  EXIT PROGRAM
#               
DISPLAY OFF
RETURN

