
#include "stdio.h"
#include "ctype.h"
#include "dos.h"			/* mscv4.0 (others, you're on your own!) */

#undef tolower				/* we want function, not macro from ctype.h */

#define FAST static

static int left_flag, do_padding, num1, num2;
static char outbuf[32], *sp_ptr, pad_character;
static void outs(int (*)(int),char *), outnum(int (*)(int), long, long);
static int getnum(char **);

union REGS srv,rrv;		/*
								** this uses the ansiterm.c routines that
								** are provided with Pro-Yam
								*/
struct {
	char name[26];
	char pass[11];
	int timeson;
} user;

struct {
	int users;
	int last_user;
	char spare[35];
} user_hdr;

struct {
	char to[26];
	int mnum;
} msg;

struct {
	int nxt_mnum;
	int msgs;
	char spare[24];
} msg_hdr;

int mail;
int local;
int pers;
int usrs;
int msgs;
int urec;
char uname[26],inpbuf[128];

FILE *ufd;
FILE *mfd;


/* expects:   first last 0 0
**                 |     | |
**   name of user /      | |
**         signed on = 1/  |
**               local = 1/
**
** above can be achieved through:
**
** in challeng.t after getting the user's name and confirmation
** (the name MUST be limited to 25 characters plus a NULL or you will
**  have to change the structs above etc.)
** add the line: obey "!~bbs %remote 0 0"
**
** in phones.t add the line: set bbs "~bbs %remote 1 0"
**
** to run locally enter: bbs <first> <last> 0 1
**                   or: bbs <first> <last> 1 1
** where <first> is your first name and <last> is your last name
*/ 

main(argc,argv)int argc;
char **argv;
{
	int i;

	if(argc<5) {
		sendf("\nArg error (%d, %s %s %s %s)\n",argc,argv[1],argv[2],argv[3],argv[4]);
		sendf("\nTell my boss!\n");
		exit(1);
	}
	mail=atoi(argv[3]);
	local=atoi(argv[4]);
	strlwr(argv[1]);
	strlwr(argv[2]);
	argv[1][0]=toupper(argv[1][0]);
	argv[2][0]=toupper(argv[2][0]);
	sprintf(uname,"%s %s",argv[1],argv[2]);
	pers=FALSE;
	if(mail)
		goto do_mail;
	sendf("\n\n\n\nRemote Pro-Yam Signon Utility v1.00 (c)1987 Simon J. Ewins\n");
	if((ufd=fopen("\\rem\\users.bbs","r+"))==0) {
		ufd=fopen("\\rem\\users.bbs","w+");
		if(!ufd) {
			sendf("\nCan't make users file, tell my boss!\n");
			exit(1);
		}
		user_hdr.users=0;
		r_put(ufd,0,sizeof(user_hdr),&user_hdr);
	}
	r_get(ufd,0,sizeof(user_hdr),&user_hdr);
	usrs=user_hdr.users;
	sendf("\nSearching %d users.\n",usrs);
	if(usrs==0) {
		i=1;
		goto not_found;
	}
	for(i=1;i<=usrs;++i) {
		sendf("\r# %d ",i);
		r_get(ufd,i,sizeof(user),&user);
		if(!strcmp(user.name,uname))
			goto found;
	}
not_found:
	sendf("\nCan't find %s. Please choose a password: ",uname);
	get_line(10,TRUE,inpbuf);
	if(!strlen(inpbuf))
		goto not_found;
	strcpy(user.name,uname);
	strcpy(user.pass,inpbuf);
	user.timeson=0;
	r_put(ufd,i,sizeof(user),&user);
	++user_hdr.users;
	user_hdr.last_user=i;
	++usrs;
	r_put(ufd,0,sizeof(user_hdr),&user_hdr);
	fflush(ufd);
	sendf("\nRemember it and be careful because");
found:
	urec=i;
	sendf("\nUpper and Lower case count!\nPassword: ");
	get_line(10,FALSE,inpbuf);
	if(!strlen(inpbuf) || strcmp(user.pass,inpbuf)) {
		sendf(" <== wrong!");
		goto found;
	}
	++user.timeson;
	r_put(ufd,urec,sizeof(user),&user);
	fclose(ufd);
	sendf("\nLogin: %d",user.timeson);
	sendf("\nChecking for mail.\n");

	if((mfd=fopen("\\rem\\msgs.bbs","r+"))==0) {
		mfd=fopen("\\rem\\msgs.bbs","w+");
		if(!mfd) {
			sendf("\nCan't make msg file, tell my boss!\n");
			exit(1);
		}
		msg_hdr.nxt_mnum=0;
		msg_hdr.msgs=0;
		r_put(mfd,0,sizeof(msg_hdr),&msg_hdr);
	}
	r_get(mfd,0,sizeof(msg_hdr),&msg_hdr);
	if(msg_hdr.msgs==0)
		goto mnot_found;
	for(i=1;i<=msg_hdr.msgs;++i) {
		sendf("\r...\b\b\b");
		r_get(mfd,i,sizeof(msg),&msg);
		if(!strcmp(msg.to,uname))
			goto mfound;
	}
mnot_found:
	sendf("\nCan't find any for you.\n");
	fclose(mfd);
	exit(0);
mfound:
	sendf("\nThere is mail for you...");
	pers=TRUE;
	fclose(mfd);
do_mail:
	if((mfd=fopen("\\rem\\msgs.bbs","r+"))==0) {
		mfd=fopen("\\rem\\msgs.bbs","w+");
		if(!mfd) {
			sendf("\nCan't create the msg file! Tell my boss.");
			exit(1);
		}
		msg_hdr.nxt_mnum=0;
		msg_hdr.msgs=0;
		r_put(mfd,0,sizeof(msg_hdr),&msg_hdr);
	}
	r_get(mfd,0,sizeof(msg_hdr),&msg_hdr);
mloop:
	switch(tolower(menu())) {
	int sho;
	case 'q':
		goto done;	
	case 'a':
		for(i=1,sho=0;i<=msg_hdr.msgs;++i) {
			if(getchr()==24)
				break;
			sendf("...\b\b\b");
			r_get(mfd,i,sizeof(msg),&msg);
			if(!strcmp(msg.to,"All")) {
				++sho;
				if(shomsg(msg.mnum)=='q')
					break;
			}
		}
		sendf("\nFound %d public message(s), [Press any key]",sho);
		wtchr();
		break;
	case 'p':
		for(i=1,sho=0;i<=msg_hdr.msgs;++i) {
			if(getchr()==24)
				break;
			sendf("...\b\b\b");
			r_get(mfd,i,sizeof(msg),&msg);
			if(!strcmp(msg.to,uname) || local) {
				++sho;
				if(shomsg(msg.mnum)=='q')
					break;
			}
		}
		sendf("\nFound %d message(s) for you, [Press any key]",sho);
		wtchr();
		break;
	case 'u':
		users();
		break;
	case 'e':
		enter();
		break;
	case 's':
		if(local)
			sysop();
		break;
	}
	goto mloop;
done:
	if(pers) {
		sendf("\nDeleting personal messages.\n");
		for(i=1;i<=msg_hdr.msgs;++i) {
			sendf("...\b\b\b");
			r_get(mfd,i,sizeof(msg),&msg);
			if(!strcmp(msg.to,uname)) {
				msg.to[0]=NULL;
				r_put(mfd,i,sizeof(msg),&msg);
				sprintf(inpbuf,"\\rem\\%05d.msg",msg.mnum);
				unlink(inpbuf);
			}
		}
	}
	fclose(mfd);
	exit(0);
}


menu()
{
	sendf("\n\n\n\nRemote Pro-Yam Mail Utility v1.00 (c)1987 Simon J. Ewins\n\n");
	sendf("Select: A - Read all public messages\n");
	sendf("        P - Read your personal messages\n");
	sendf("        U - Display users list\n");
	sendf("        E - Enter a message\n");
	sendf("        Q - Quit");
	if(pers)
		sendf(" and delete personal messages");
	putchr('\n');
	sendf("?> ");
	return(wtchr());
}


shomsg(n)
int n;
{
	FILE *tfd;
	int c,ch;

	sendf("\nPress ^X to quit:\n\n");
	sprintf(inpbuf,"\\rem\\%05d.msg",msg.mnum);
	tfd=fopen(inpbuf,"r");
	if(!tfd) {
		sendf("\nHmmm, couldn't open that one!");
		return;
	}
	while((c=fgetc(tfd))!=EOF) {
		if(getchr()==19)
			wtchr();
		if(c==1) {
			sendf("R)ead, S)kip, Q)uit: ");
			ch=tolower(wtchr());
			switch(ch) {
			case 'r':
			case '\r':
				sendf("\r                     \r");
				continue;
			case 'q':
			case 's':
				goto done;
			}
		}
		putchr(c);
		if(getchr()==24)
			break;
	}
done:
	fclose(tfd);
	return(ch);
}


enter()
{
	char *p,d[9],t[9],*strchr();
	char c,message[2049];
	int pos,hdr,limit;
	FILE *tfd;

get_to:
	sendf("\n\nTo: ");
	get_line(25,TRUE,inpbuf);
	if(!strlen(inpbuf))
		return;
	strlwr(inpbuf);
	if(!strcmp(inpbuf,"sysop")) {
		sendf("\nUse 'private' at Yam-Host level to leave comments to Sysop.");
		return;
	}
	if(strcmp(inpbuf,"all")) {
		p=strchr(inpbuf,' ');
		if(!p) {
			sendf("\nNeed first AND last name.");
			goto get_to;
		}
		++p;
		*p=toupper(*p);
	}
	*inpbuf=toupper(*inpbuf);
	strcpy(msg.to,inpbuf);
	getdte(d,t);
	sprintf(message,"From: %s     Date: %s     Time: %s\n\1\0",uname,d,t);
	pos=0;
	hdr=strlen(message);
	limit=2048-hdr;
	p=message+hdr;
	sendf("\nEnter your message, (%d characters), ^Z to end:\n",limit);
	while(TRUE) {
		c=wtchr();
		if(c==26)
			break;
		if(c=='\b' || c==127) {
			if(pos<1) {
				putchr(7);
				continue;
			}
			putchr('\b');
			putchr(' ');
			putchr('\b');
			*p--=NULL;
			--pos;
			continue;
		}
		if(c=='\r') {
			if(pos+2>limit) {
				putchr(7);
				continue;
			}
			*p++=c;
			*p++='\n';
			pos+=2;
			putchr('\n');
			continue;
		}
		if(pos+1>limit) {
			putchr(7);
			continue;
		}
		*p++=c;
		++pos;
		putchr(c);
	}
	*p=EOF;
	r_get(mfd,0,sizeof(msg_hdr),&msg_hdr);
	msg_hdr.msgs++;
	msg.mnum=msg_hdr.nxt_mnum++;
	r_put(mfd,0,sizeof(msg_hdr),&msg_hdr);
	r_put(mfd,msg_hdr.msgs,sizeof(msg),&msg);
	fflush(mfd);
	sprintf(inpbuf,"\\rem\\%05d.msg",msg.mnum);
	tfd=fopen(inpbuf,"w+");
	fwrite(message,pos+hdr+1,1,tfd);
	fclose(tfd);
}


users()
{
	int i;

	if((ufd=fopen("\\rem\\users.bbs","r+"))==0)
	if(!ufd)
		return;
	r_get(ufd,0,sizeof(user_hdr),&user_hdr);
	usrs=user_hdr.users;
	sendf("\n\nThere are %d users. [use ^X to quit]\n",usrs);
	if(usrs==0) {
		sendf("\nNone found.");
		fclose(ufd);
		return;
	}
	for(i=1;i<=usrs;++i) {
		if(getchr()==24)
			break;
		r_get(ufd,i,sizeof(user),&user);
		sendf("\n%5d: %s",i,user.name);
		if(i%23==0) {
			sendf("\nPress any key: ");
			wtchr();
		}
	}
	fclose(ufd);
	sendf("\nPress any key: ");
	wtchr();
}


sysop()
{
	int i,ch;

	if((ufd=fopen("\\rem\\users.bbs","r+"))==0)
	if(!ufd)
		return;
	r_get(ufd,0,sizeof(user_hdr),&user_hdr);
	usrs=user_hdr.users;
	sendf("\n\nThere are %d users. [use ^X to quit]\n",usrs);
	if(usrs==0) {
		sendf("\nNone found.");
		fclose(ufd);
		return;
	}
	for(i=1;i<=usrs;++i) {
		if(getchr()==24)
			break;
		r_get(ufd,i,sizeof(user),&user);
		sendf("\n%5d: %s   D)elete, Q)uit, N)ext:",i,user.name);
		ch=tolower(wtchr());
		switch(ch) {
		case 'd':
			user.name[0]=NULL;
			r_put(ufd,i,sizeof(user),&user);
			sendf(" <== Gone!");
			break;
		case 'q':
			goto done;
			break;
		}
	}
done:
	fclose(ufd);
	sendf("\nPress any key: ");
	wtchr();
}


/* read record rec from file fd to buff based on record size size */
r_get(fd,rec,size,buff)
FILE *fd;
int rec;
int size;
char *buff;
{
	long pos;
	
	pos=rec*size;
	if(fseek(fd,pos,SEEK_SET))
		return(FALSE);
	fread(buff,size,1,fd);
	return(TRUE);
}


/* write record rec to file fd from buff based on record size size */
r_put(fd,rec,size,buff)
FILE *fd;
int rec;
int size;
char *buff;
{
	long pos;

	pos=rec*size;
	if(fseek(fd,pos,SEEK_SET))
		return(FALSE);
	fwrite(buff,size,1,fd);
	return(TRUE);
}


/* get a line of input of length l to buff, if e then echo characters */
get_line(l,e,buff)
int l,e;
char *buff;
{
	int c,i;
	char *p;

	p=buff;
	i=0;
	while(TRUE) {
		c=wtchr();
		if(c=='\r' || c==0x1b)
			break;
		if(c=='\b' || c==127) {
			if(i<1)
				continue;
			putchr('\b');
			putchr(' ');
			putchr('\b');
			*buff--=NULL;
			--i;
			continue;
		}
		if(i+1>l)
			continue;
		*buff++=c;
		++i;
		if(e)
			putchr(c);
		else
			putchr('.');
	}
	*buff=NULL;
}


/* send character c to modem and screen */
putchr(c)
{
	fputc(c,stderr);
	while(!moready() && carrier())
		;
	mochar(c);
	if(c=='\n') {
		while(!moready() && carrier())
			;
		mochar('\r');
	}
}


getchr()
{
	int c;

	if(c=inkey())
		return(c);
	if(miready())
		return(michar());
	return(NULL);
}


/* wait for a character from console or modem */
wtchr()
{
	int c;

	while((c=getchr())==NULL)
		;
	return(c);
}


/* returns non 0 iff a modem character ready */
miready()
{
	if(local)
		return(0);
	srv.x.ax = 0x0300;
	int86(0x14, &srv, &rrv);
	return (rrv.x.ax & 0x100);
}

/* input a character from modem assuming miready returns 1 */
michar()
{
	srv.x.ax = 0x0200;
	int86(0x14, &srv, &rrv);
	return (rrv.x.ax & 0xff);
}

carrier()		/* only tests COM1 -- change 0x3fe to 0x2fe for COM2 */
{
	if(local)
		return(TRUE);
	if((inp(0x3fe)&0x80)!=0x80) {
		if(ufd)
			fclose(ufd);
		if(mfd)
			fclose(mfd);
		exit(1);
	}
	return(TRUE);
}


/* Returns non 0 iff modem is ready to send a character */
moready()
{
	if(local)
		return(1);
	srv.x.ax = 0x0300;
	int86(0x14, &srv, &rrv);
	return (rrv.x.ax & 0x2000);
}

/* sends c to the modem */
mochar(c)
{
	if(local)
		return;
	srv.x.ax = 0x0100 | (c & 0xff);
	int86(0x14, &srv, &rrv);
}


/*
 *	Print on terminal
 */
sendf(ctrl, args)
char *ctrl;
unsigned int args;
{
	static void doprint();
	
	doprint(putchr, ctrl, &args);
}


/*
 *	Generalized routine
 */
static void doprint(outfunc, ctrl, argp)
int (*outfunc)(int);
unsigned int *argp;
char *ctrl;
{
   register int long_flag, dot_flag;
   FAST unsigned int *pi;
   FAST unsigned long *pl;
	FAST char **ps,*cp, ch;

   pi=argp;
	pl=(ULONG *)argp;
	ps=(char **)argp;
	for (;*ctrl;ctrl++) {
		if (*ctrl!='%') {
			(*outfunc)(*ctrl);
			continue;
		}
		dot_flag=long_flag=left_flag=do_padding=0;
		num2=32767;
		pad_character=' ';

try_next:	ch = *(++ctrl);

		if (isdigit(ch)) {
			if (dot_flag)
				num2=getnum(&ctrl);
			else {
				if (ch=='0')
					pad_character='0';
				num1=getnum(&ctrl);
				do_padding=1;
			}
			ctrl--;
			goto try_next;
		}

		switch (tolower(ch)) {
		case 0:
			return;
		case '%':
			(*outfunc)('%');
			continue;
		case '-':
			left_flag=1;
			break;
		case '.':
			dot_flag=1;
			break;
		case 'l':
			long_flag=1;
			break;
		case 'd':
			if (long_flag || ch=='D') {
				outnum(outfunc, *((long *)argp), 10L);
				ps=(char **)++pl;
				pi=(UINT *)ps;
				argp=pi;
				continue;
			} else {
				outnum(outfunc, (long)(*((int *)argp)), 10L);
				ps=(char **)++pi;
				pl=(ULONG *)ps;
				argp=(UINT *)pl;
				continue;
			}
		case 'x':
			if (long_flag || ch=='X') {
				outnum(outfunc, *((long *)argp), 16L);
				ps=(char **)++pl;
				pi=(UINT *)ps;
				argp=pi;
				continue;
			} else {
				outnum(outfunc, (long)(*((int *)argp)), 16L);
				ps=(char **)++pi;
				pl=(ULONG *)ps;
				argp=(UINT *)pl;
				continue;
			}
		case 'o':
			if (long_flag || ch=='X') {
				outnum(outfunc, *((long *)argp), 8L);
				ps=(char **)++pl;
				pi=(UINT *)ps;
				argp=pi;
				continue;
			} else {
				outnum(outfunc, (long)(*((int *)argp)), 8L);
				ps=(char **)++pi;
				pl=(ULONG *)ps;
				argp=(UINT *)pl;
				continue;
			}
		case 's':
			outs(outfunc, *((char **)argp));
			pl=(ULONG *)++ps;
			pi=(UINT *)pl;
			argp=pi;
			continue;
		case 'c':
			(*outfunc)(*((int *)argp));
			ps=(char **)++pi;
			pl=(ULONG *)ps;
			argp=(UINT *)pl;
			continue;
		case 'f':
		case 'e':
		case 'g':
			do_padding=0;
			num2=32767;
			outs(outfunc, "*No floating point in kprintf!*");
			continue;
		default:
			continue;
		}
		goto try_next;
	}
}


/*
 *	Function used to output a line
 */
static void outs(outfunc, lp)
int (*outfunc)(int);
char *lp;
{
   register int i, len;

	/* Blank pad on left if needed */
	if (do_padding && !left_flag && (len=strlen(lp))<num1)
		for (i=len; i<num1; i++)
			(*outfunc)(pad_character);

	/* Now output string */
	while (*lp && num2--)
		(*outfunc)(*lp++);

	/* Blank pad on right if needed */
	if (do_padding && left_flag && (len=strlen(lp))<num1)
		for (i=len; i<num1; i++)
			(*outfunc)(pad_character);
}


/*
 *	Output a number
 */
static void outnum(outfunc, num, base)
int (*outfunc)(int);
long num, base;
{
   register int i, len;
   FAST int negative;
	FAST char *cp;
	FAST char digits[]="0123456789ABCDEF";

	/* Build number (backwards) in outbuf */
	if (num<0L) {
		negative = 1;
		num = -num;
	} else
		negative = 0;

	cp=outbuf;
	do {
		*cp++ = digits[num%base];
	} while ((num/=base) > 0);
	if (negative)
		*cp++ = '-';
	*cp-- = 0;
	len=strlen(outbuf);

	/* Blank pad on left if needed */
	if (do_padding && !left_flag && len<num1)
		for (i=len; i<num1; i++)
			(*outfunc)(pad_character);

	/* Now output the buffer in reverse order */
	while (cp>=outbuf)
		(*outfunc)(*cp--);

	/* Blank pad on right if needed */
	if (do_padding && left_flag && len<num1)
		for (i=len; i<num1; i++)
			(*outfunc)(pad_character);
}

/*
 *	Get a number from the control string.
 *
 *	This function takes a pointer to a character pointer (which it
 *	updates to point to the character after the end of the number)
 *	and returns an integer result.
 */

static int getnum(linep)
char **linep;
{
	register int n;
	register char *cp;

	cp = *linep;
	n = 0;

	while (isdigit(*cp))
		n = n*10 + ((*cp++)-'0');

	*linep = cp;
	return(n);
}

