        ::
        :: Intel 14.4EX Modem Dialer Script
        :: Written 2-15-93, Dick Flanagan
        ::
        :: This dialing script supports the following modifiers:
        ::
        ::      /_s        enable software flow control
        ::      /rel       relax hardware flow control
        ::      /nop       disable dial tone and busy detection
        ::      /lock      lock port/modem interface speed
        ::      /dir       force normal connection
        ::      /mnp       force MNP connection
        ::      /v42       force LAPM connection
        ::      /v22       set V.21/V.22 protocols
        ::      /xm5       disable MNP5 data compression
        ::      /c:mmmm    other modem commands
        ::      /man       manual dialing
        ::
        :: Several of these options are mutually exclusive.
        ::
        :: Full error control--including MNP as a fallback for LAPM--
        :: is the default.
        ::
        :: Hardware flow control with XOFF passthru is the default.
        ::
        :: Port/modem interface speed is locked by either /mnp, /lock
        :: or /_s as per phones.t convention.
        ::

        :: initmodem initializes an Intel 14.4EX
initmodem:
        echo "Initializing Intel 14.4EX modem"
        speed 57600
        pat
        pat 0 OK
        pat 1 ERROR
        put "AT "
        put "&F "                       : get all factory defaults
        put "L0 "                       : turn speaker way down
        put "\\J1 "                     : enable port speed change
        put "&W "                       : save as default config
        put "\r"
        wait -f5
        if 1 echo "ERROR: cycle power on the modem and retry"; abort
        return


        ::
        :: dialnum establishes dial-up connection
        ::
        :: Input string vars:  s0: original speed
        ::                     s1: non-empty to lock port speed
        ::                     s2: current dial option
        ::                     s3: current telno
        ::
        :: Output string vars: s0, s1, s2, s3: unchanged
        ::                     s8: result string from modem
        ::                     s9: empty means no connection
        ::
dialnum:
        if "as0>57600" sp 57600
        gosub waketb                    : get modem to respond
        pat
        pat 1 OK
        put "AT "
        put "E1 "                       : echo on
        put "Q0 "                       : display result codes
        put "V1 "                       : verbal result codes
        put "\\V2 "                     : display error/compression
        if %s1 put "\\J0 "              : disable port speed change
        if js2,nop put "X1 "            : disable dial tone or busy detect
        else put "X4 "                  : wait for dial tone
        if js2,_s put "\\Q1 "           : set XON/XOFF flowcontrol
        if js2,_s put "\\X1 "           : passthru XON/XOFF
        if js2,dir put "-J0 "           : disable error control handshake
        if js2,dir put "\\N0 "          : force normal connection
        if js2,mnp put "\\N2 "          : force MNP connection
        if js2,v42 put "\\N4 "          : force LAPM connection
        if js2,v22 put "B0 "            : force V.21/22 protocol
        if js2,xm5 put "\%C0 "          : disable MNP5 compression
        ss s2 "(c:)(.*)"; if %z2 put "%z2 "     : other modem commands
        put "\r"
        wait -f2
        if %alds if ps3,0 putw "ATS8=10\r"
        put "%mprefix"; put "%s3%alds"
        dis -Q                          : enable display of modem data
        if js2,man put ";\r"; echo "Hit F1 when Tone is heard"; t; put "ATD"
        put "\r"
        dis -t                          : disable any throttling
        if "js3,;" accept s1 "Lift Telephone Receiver, Hit ENTER"; o; return
        pat 1 BUSY
        pat 2 RING
        pat 3 ERROR
        pat 4 "NO CARRIER"
        pat 5 "NO DIALTONE"
        pat 6 "NO ANSWER"
        pat 7 "CONNECT\r"
        pat 8l "NECT 12"
        pat 9l "NECT 24"
        pat 10l "NECT 48"
        pat 11l "NECT 72"
        pat 12l "NECT 96"
        pat 13l "NECT 120"
        pat 14l "NECT 144"
        wait -f75
        sets s8 %y2                     : save modem result string
        while "2&&!L>3" wait -f40       : wait for a few rings only
        if "n||1||2||3||4||5||6" goto exerr
        dis -d                          : enable carrier lost msg
        if dd while "!c&&L<20" sleep 1  : for modems with slow CD
        if 7 estimate 0 300             : save modem speed for estimates
        else if "hCONNECT" ss y "[0-9]+"; estimate 0 z0
        if js2,_s handshake sw
        else if js2,rel handshake slow
        else handshake both
        if "h/REL" echo "Reliable Connection"
        if "h-COMP" echo "Data Compression"
        if %s1 echo "Speed Locked"; goto exend
        if 7 sp 300 goto exend
        if 8 sp 1200 goto exend
        if 9 sp 2400 goto exend
        if 10 sp 4800 goto exend
        if 11 sp 7200 goto exend
        if 12 sp 9600 goto exend
        if 13 sp 12000 goto exend
        if 14 sp 14400
exend:  set s9 "y"                      : flag s9 for good connect
        return

exerr:  echo "No Connect Message Detected."
        set s9 ""                       : flag s9 for bad connect
        return

