
  PHOMAST.T  [Version 6.4a]                                  Michael R. Ash
  Revised 20 May 96 Chuck Forsberg


  This is the latest in a series of updates to PHOMAST.T scripts designed
  to get you up and running utilizing the power of Professional-YAM or ZCOMM.
  For performance and clarity I have moved my opening remarks and instructions
  about setting up this script to a separate file called: -> PHOMAST.DOC <-
  New features of this update include fully automated menu configuration,
  autospeed detection, and lots of slick coding examples...

  When run for the first time this script will generate a new file called
  'PROFILE.DAT' containing specific configuration information that in the
  past you used to have to know and write into the script with an editor
  in advance before using YAM or ZCOMM.  This file, 'PROFILE.DAT', if present
  is loaded every time YAM/ZCOMM is run and defines your generalized defaults.
  I have included comments everywhere to help you understand the fascinating
  and comprehensive script language included in YAM and ZCOMM.  Any information
  that follows a colon (:) mark is not read by YAM or ZCOMM since it is taken
  as a comment.  When you are instructed to uncomment a line it means to load
  the script into an editor and delete the colon at the start of the line so
  the program can use it.

  When ZCOMM is loaded it looks in the \ZCOMM subdirectory for a file called
  PHOMAST.T  -=-  When YAM is loaded it looks in the root for a file called
  PHONES.T (you could rename PHOMAST.T to PHONES.T and put it in the root
  but there are a couple of better ways to handle this). The simplest and
  most flexible method is to use the DOS 'set phones' command (shown below)
  to tell YAM/ZCOMM where to find its phones file.  Another method is to
  have PUTSNP.EXE (the serial number installing routine) change the default
  location of the phones files.

                         set PHONES=c:\yam\phomast.t

  The line above can be added to your AUTOEXEC.BAT file to tell YAM where
  to look for its phones file.  ZCOMM users won't need to use this line
  unless they want to have PHOMAST.T in another directory since it is already
  the default location for ZCOMM.  The phones file (PHOMAST.T) gives YAM/ZCOMM
  directions on how you want the package to operate.

  For those of you that haven't heard of YAM, it's the short name for
  Professional-YAM, a commercial package that includes all of ZCOMM (its
  shareware subset) plus advanced capabilities for professional tele-
  communications requirements.

  Dialing entries can be placed anywhere in the script but since the script
  is read from the top down, entries placed near the top will be found first.
  A simple dialing entry is usually one line as below, with the label
  starting in column 1.  Using the command 'call pcmag' will cause the
  following.  The old line will be 'hung-up', speed will be set to 2400 baud,
  number dialed, then Error correction turned on and terminal mode entered
  in 8 bit graphics format.  Just copy this line, make a new label, add a
  new number and you're all set with a new phone directory entry...

pcmag   sp 2400   1-212-503-5255 ena -E;t -8g    :PC Magazine BBS

                        ------------------------------

  I have tried to make this script as perfect as possible but like most
  things in life there are no guarantees that I found everything.  I wish
  you the best of luck with YAM or ZCOMM.  Please let me know if you run
  into problems...

  I have spent hundreds of hours over many years on this script to make
  ZCOMM or YAM useful to new users right out of the starting blocks.  If
  this has helped you get a better grasp of the package I would like
  to hear from you.  If this really made a difference, and you think my
  time is was well spent, throw a couple bucks my way and I will go out
  for a taco...

  Whatever you decide, I would appreciate a postcard, just to get an
  idea who this script finally reached...

                                            Michael Ash
                                            POB 231323
                                            Encinitas CA 92023-1323


                      ---------- Have Fun ----------


::----------------------------------------------------------------------------::

         -- Special AutoSense Dialing Script with speed fallback --

  Below is specialized code you don't need to concern yourself with.  If you
  want to change the default menu colors or the initial generic modem string,
  search for the character <*> to direct you to those parts of the code. Again
  this is optional since 95% of the users out there will be able to use the
  script as is.

  The dial routine below replaces internal YAM/ZCOMM carrier detect code...
  This dialing routine is called by the first line in 'setup' section of code
  by the command:  set mcommand "gosub dial"

  Calls you make with your modem at 2400 baud that connect to 2400, 1200,
  or 300 baud modems on the other end will automatically change your modem
  speed to match.  It is IMPORTANT to give Xn value in modem setup string the
  highest number available to insure your modem answer using full words, not
  just codes...

  To manual dial a voice call use construct: 'xxx-xxxxxv' where 'xxx-xxxx'
  is the phone number you want to call from the command line followed by the
  letter 'v'.  If you need more complex dial routines for mnp and high speed
  modems see 'adial' label under PHONES.T provided with Professional-YAM or
  download DIALERS.ZIP from the scripts subdirectory on Telegodzilla, the
  YAM/ZCOMM support BBS, or FTP.cs.pdx.edu pub/zmodem FTP site.

dial    pat     :Clear old patterns

        if "%telno<2" echo "\n\nPhone number must be at least 2 numbers\n\n"; return
        bye                   : %telno is string containing phone number
	sleep 10

        if "%mprefix<2" goto mandial   :If no modem prefix defined (e.g. ATDT)
                                       :This allows for manual phone dialing.
        pat 0c "v"                     :Search for "v" voice call
                                       :Below list possible messages from modem
        pat 1l CONNECT; pat 2 "NO CARRIER"; pat 3 BUSY; pat 4 RING; pat 9 OK

        put %mprefix; putw %telno\r    :Send dial prefix (e.g. ATDT) and phone #

        if !0  goto nov :Skip instruction if not a voice call (eg not a ';')
        echo "\n\n\n\n\n\t\t\t Voice Calling in Progress...\n\n"
        echo "\t\t    >>> Once phone ringing Hit RETURN <<<\n\n"
        if y bye ; return        :once key hit, hang up modem...

nov:
        wait -f72
        while "4&&!L>3" wait -f40       :while ringing less then 4 times wait
        if "n||2||3||9" echo "No connection made..." pat; o; fail

        while "!c&&L<20"  sleep 1       :wait for slow carrier detect
	if "hCONNECT" ss y "[0-9]+";  estimate 0 z0
	if "hCARRIER" ss y "[0-9]+";  estimate 0 z0
	if "hCONNECT" ss y "[0-9]+"; ife az0<4800 speed z0; else handshake on

	set telno ""                    :erase telephone number from variable
	dis -d
        return

        :: If modem prefix string less than 2 characters, Manual dialing
        :: is assumed.  This allows the special case where you may have
        :: to have an operator make the call (or dial manually on phone)

mandial:
        : putw "ATZ\r"        :put modem in standard configuration
        echo "\n\n\n     Please dial %telno... \n"
        lput "     Once dialed wait for FIRST RING then hit F1 and hang up the phone!  "
        t             :Put into terminal mode to prepare modem...
        put "ATD\r"   :Force modem to answer
        echo "\nIf you want to have MODEM do the dialing hit Shift-F6 and change option...\n"
        return


::
:: Advanced Dial shell  Rev 5-21-96
::
::  String vars: s0: original speed   s1:non empty to lock interface speed
::	s2: Current dial option   s3:Current telno
::      s4: Remaining alternate telnums    s5: provisional speed
::	s8: Result string from modem    s9: empty means no connection
::
::	Bypass fail command if called as gosub adial,nofail
::

:: Call modem specific init routine
initmodem
	sets s0 %args
	gosub init.%lib/%MODEM

adial	
	set s8 "h/w"; set s9 "port"
	if "itelno,1" if dX echo "Vritual Channel 1"; return
	if "itelno,2" if dX echo "Vritual Channel 2"; return
	if "itelno,3" if dX echo "Vritual Channel 3"; return
	if "itelno,1" port 1;  set dirrx "";  echo "Port 1"; return
	if "itelno,2" port 2;  set dirrx "";  echo "Port 2"; return
	set s8 ""; set s9 ""
	if "%telno<2" echo "Please do not use \"call adial\""; abort

	set? s0 S;  sets s4 %telno
adia2:	split s4 "+" ""; sets s4 %z1; sets s3 %z0
	set s1 ""; split s3 "/" ""; sets s3 %z0; sets s2 %z1
	handshake sw;  pat;  sets s5 "%s0"
	echo "PORT = %dport  MODEM = %MODEM  modifier = %s2"
	if js2,mnp set s1 "mnp"
	if js2,_s set s1 "_s"
	if js2,lock set s1 "lock"
	if js2,1200 sp 1200; set s5 1200
	else if js2,300 sp 300; set s5 300
	else if S==450 sp 300 echo "300 bps"
	else if !%s1 if "S<9500&&S>1201" sp 2400 echo "2400 bps"
	if !dv bye

	:: set up for modem specific dialnum routine
	set s8 ""; set s9 ""
	gosub dialnum.%lib/%MODEM
	pat;  if %s9 goto adiend
	if %s4 echo "Attempting %s4";  speed s0;  goback adia2
	bye; bye; if "!jargs,nofail" fail

adiend:	sets telno %s3		: Telephone number we connected to
	if !js2,nodel queue delete
	if dl<2 echo "Please type t<Enter> to enter terminal function."
	return


::----------------------------------------------------------------------------::
::                                                                            ::
::              >>>  This SETUP script is where it all begins <<<             ::
::                                                                            ::
::      In both Professional-YAM and ZCOMM "setup" is the first subroutine    ::
::      executed.  In a departure from the standard PHONES script, this       ::
::      version of the phones file actually looks for another file called     ::
::      PROFILE.DAT where specific setup information is stored.  If this      ::
::      file doesn't exist, this script will actually write the code.  This   ::
::      allows for easy menu modification of things like PORT number and      ::
::      Dialing Prefix.  Once an entry is made using the menu, a new          ::
::      PROFILE.DAT file is written to disk and used in the future to load    ::
::      saved setup information.  The examples assume the modem responds      ::
::      to the HAYES command set and either COM1 or COM2 connected to a       ::
::      modem.  Others can modify the script for their application...         ::
::                                                                            ::
::      This allows for easy setup modification without the use of an editor  ::
::      to change configuration information -=- especially useful to laptop   ::
::      users out there who may need to quickly change dialing configuration  ::
::      while on the road.  Setup code has been moved to the bottom of the    ::
::      script since it is run only once at startup...                        ::
::                                                                            ::
::----------------------------------------------------------------------------::

setup:  lput "\r\n\n...working\r\n\n"  goto do_it    :skip to 'setup' code


::============================================================================::

::     --- Some San Antonio Bulletin Boards using simple Phone Directory ---
::     Remember if you are out of the area you must add (512) area code...

apco24     speed 2400  496-5558 ena -E;t -8g  :membership board #
apco12     speed 1200  496-5558 ena -E;t -8g
public     speed 1200  434-1557 ena -E;t -8g  :APCO public BBS
chess      nolog speed 1200 494-5478 ena -E;t -8g  :Chess BBS

::  Note to users -- Some of the above San Antonio bulletin boards operate
::  at speeds higher than 1200 baud.  If you have a 2400 baud modem, just
::  edit the 'speed 1200' to read 'speed 2400' as appropriate in the above
::  directory.  Want to add other favorites?  Just add them in with an ASCII
::  text editor using the above as example entries.  It's easy!  AreaCode=512

::  To call one of these just give the command 'call buerg' for example...

::                     --- Some Classic BBS systems ---

buerg24    sp 2400   1-707-778-8944 ena -E;t -8g    :Vern Buerg's BBS
buerg12    sp 1200   1-707-778-8944 ena -E;t -8g

qedit      speed 1200 %l,404-296-9681 ena -E; kill :QEdit Sammy Mitchell (area 5)
           restime; create -S+ %tmp\qedt%d.log ; t -8g

virusinfo  sp 2400 %l,408-988-4004 ena -E;t -8g  :John McAfee Viruscan -voice 408-988-3832

::               -=- End of simple phone directory entries -=-
::  ---------------------------------------------------------------------------

menu:  cls                  :On screen Menu Generation...
  set n9 "Pro-YAM"; if dS set n9 " ZCOMM "

  echo "                   >>>  %n9 Function Key Menu  <<<                          "
  echo "  Alt-N  EMERGENCY EXIT, 'Nuke It' to get out of trouble/escape a command       "
  echo "                                                                                "
  echo "  F1  Exit Circular Buffer            F2  Enter Circular Buffer                 "
  echo "  F3  OPEN Capture file               F4  Send ASCII Text                       "
  echo "  F5  Send Kermit Upload              F6  Send Zmodem Upload    <<BEST>>        "
  echo "  F7  Receive CrcXmodem Download      F8  Send CrcXmodem Upload                 "
  echo "  F9  Press for THIS HELP SCREEN      F10 Online Manual                         "
  echo "  Alt-1  Get DOS Command prompt       Alt-2  Get %n9 Command prompt         "
  echo "                                                                                "
  echo "  sF3  Holds you on-line...           sF4  Use Turbolearn Script Writer         "
  echo "  sF6  Change YOUR defaults           sF7  Dialing Menu example                 "
  echo "                                                                                "
  echo "  aF1  AutoLog B&F Tech BBS (2400B)   aF2  AutoLog Olde Guard BBS (1200B)       "
  echo "  aF3  CLOSE Capture file             aF4  CIS DEMO at 1200 baud                "
  echo "  aF5  Call PC Magazine's BBS         aF6  Enter HOST MODE operation            "
  echo "  aF7  Sign name on-line...           ALT-F9  Edit PHOMAST.T script             "
  echo "                                                                                "
  echo " TO CALL OTHER BBSs: enter 'call name' where name is a label -=- LD service \45l, "
  echo "    >>To DIAL A NUMBER just enter number followed by ;t  (e.g. 523-8994;t)<<    "
  echo "       -- CompuServe-B, KERMIT, and ZMODEM download automatic --                "
  echo "  Stop Redialing ---- press <CR>      Hangup w/o pgm exit  - enter 'o'          "
  echo "  PgUp into Buffer; <CR> to return    -> EXIT hit F1 then -- enter 'off'        "
  return

                          --------------------------------

capture:                      :called by F3 to generate capture file...
        acceptl1 s1 "\r\n\n\t Do you want to save what has already past as well (Y/n)? "
        if is1,n  kill      : kill old buffer and start new...
        accept s1 "\t Enter name of Capture File: " create -S+ %s1 lput "\r\n"
        return

::                              ---------------------

        Here is a slick way to stay on-line in systems that will log you
        off if you don't hit the keyboard...  Below is an example of how
        to use text positioning (Now Active) to make this happen.

hold:   lput "\E[s\E[f\E[33m"  :save cursor position, move to top line, change color
        lput "  \E[3m\E[5mHOLDING...\E[0m\E[33m Press SPACE-BAR to continue!  \E[0"
        lput "\E[u"     :restore cursor to line where it was called

        :: The line below sends to remote what ever is stored in variable s8
        :: (usually space,BS define at 'setup') until a key is hit (!k). It
        :: allows you to modify what is sent to remote to hold.  For example
        :: on a VT emulation you would use set s8 " \177" for space, backspace/
        :: delete.

        while "!k" putw %s8  sleep 20   :While no keyhit keep adding chars

        lput "\E[f"     :put cursor on top line
        lput "\E[33m  ON-LINE  \E[0m"
        lput "\E[u"     :restore cursor to line where it was called

        return          :return to calling code


::----------------------------------------------------------------------------::
::                     --- Color Generation examples ---
::     To see this just give the command 'gosub color' from the prompt...

color:
     cls; echo "\n\t\t\t\E[32m\E[41m >>> ANSI Color Calls <<< \n"
     echo "All that is required is you precede the text you want in color with \\E[xxm."
     echo "For example: { echo \" This is \\E[32mGREEN\\Em\" } will make GREEN green.\n"
     echo "Foreground:\n"
     lput "\E[47m\E[30m\\E[30m\E[40m  \E[31m\\E[31m  \E[32m\\E[32m  \E[33m"
     lput "\\E[33m  \E[34m\\E[34m  \E[35m\\E[35m  \E[36m\\E[36m  \E[37m\\E[37m"

     echo "\n\nBackground:\n"
     lput "\E[40m\\E[40m \E[30m\E[41m \\E[41m \E[42m \\E[42m \E[43m \\E[43m "
     lput "\E[44m \\E[44m \E[45m \\E[45m \E[46m \\E[46m \E[47m \\E[47m \n\n"

     echo "Modifiers (primary here is green):\E[32m\n"  :Switch foregrd back to green
     lput "\E[0mReset,  Bold, Faint, Italics, Underline,    Blinking,"
     lput "    Reverse, Invisible\n\r"

     lput "\E[0m\\E[0m   \E[1m\\E[1m \E[2m\\E[2m\E[0m   \E[3m\\E[3m\E[0m     \E[4m\\"
     lput "E[4m\E[0m    \E[5m\\E[5m or \\E[6m \E[0m  \E[7m\\E[7m\E[0m     \\E[8m"

     echo "\E[36m\E[22f\t\t   Notice \\E[22f puts cursor on 22rd line...   \E[23f"

     lput "\t\t\t  Hit Any Key to continue..."
     ife y  ;          :basically a no-op wait for keystroke (nul else nul)

     cls; echo "\E[21f\t\t\t>>> All Numeric Color Calls <<<"
     set s0 0
     p#255; p$5; cls; display noautowrap
     while L<129 obey "pn%s0" lput "\E[m %s0  \r\n" setn s0 s0+1
     pn130; p$80; p#24; lput "\E[10;H\E[m"
     pn1055; lput "\n\t\t\t\E[mFor \E[5mBLINKING\E[m text just add 128\r\n\n"
     lput "\t  Possible colors for: *, @, n, r, s and u Numeric Parameters\r\n"
     lput "\t  where: *=highlite (color shown when text in circular buffer is\r\n"
     lput "\t  marked), @=messages, n=normal text, r=reverse, s=status, u=underline."
     lput "\r\n\n\t  Use these number in the following format 'px#', where x is the\r\n"
     lput "\t  parameter choice (e.g. n,r,s etc.) and # is the color number\r\n"
     lput "\t  above... For example pn2 give light green color to normal text.\n\n\n\n\r"
     return

:==============================================================================:
:                      --- Auto Logon Examples --                              :

bnf : Autolog onto the Back and Forth Technical Support BBS.  This is a
    : board I talk to more than all others.  This programming below
    : demonstrates an example of an autolog script for WildCat BBS.

    : Comment in the line below once you have a password, if you want to enter
    : it and not have it done automatically...

    : cls; accept s1 "\E[21f\E[36m\t\t\tEnter your Password now: \E[8m"

    cls ;  echo "\n\n\t\t   Calling B&F Support (Line 1)...  TURBO Mode \n"
    echo "\t\t       -- If no answer try 'call bf2' -- \n\n"
    lput "\t\t Are you calling from the San Antonio Area (y/N)? "
    ife y nolog lput "\r\n\n" speed 2400 670-0954 ena -8g goto go; else lput "\r\n\n"
    speed 2400 %l,512-670-0954 ena -8g     :Default of long distance call...
                                           :Note %l, for long distance prefix

    goto go   : The 'nolog' command above will prevent local call logging to
              : the 'calllog' file.

bf2 cls; echo "\n\n\t\t   Calling B&F Support (Line 2)...  TURBO Mode \n\n"
    lput "\t\t Are you calling from the San Antonio Area (y/N)? "
    ife y nolog lput "\r\n\n" speed 2400 670-1809 ena -8g goto go; else lput "\r\n\n"
    speed 2400 %l,512-670-1809 ena -8g   :Long Distance using %l, service

go: cd %tmp        : UNCOMMENT NEXT LINE once you have a password defined...
    : lput "\n\n\n Please Standby...  "; display inhibit
    : pat 5ci "N]on"  "n"     : Watch for N]onStop incase it's there...


::  Note you will have to log-on manually first to get a password on this
::  system.  Since you don't have a password assigned, the line below
::  skips the rest of the auto log-on and hooks you to this BBS.
::  When you have a name and password, add them in the 'putw' statement
::  BELOW and DELETE (or comment out) the NEXT line and uncomment
::  lines above ('lput "\n\n\n Please Standby..." and 'pat...')

         goto bv  :just put to codeset that watches for carrier...
::       ^^^^^^^^^:delete this after name/password loaded below!


    pat 1i "Name? " ; wait; put "PUT YOUR LOGIN NAME HERE\r"
    pat 1i "word: " ; wait; put "PUT YOUR PASSWORD IN HERE\r"
    :  pat 1i "word: " ; wait; put "%s1\r"  :if you used passwd prompt above

    display noinhibit; lput "Account verified...  "; display inhibit
    pat 1i "    " ; wait; put " "
    pat 1i "[y/N]" ; wait; put "n"

    display noinhibit; lput "Login Complete... \n\n "

    ::                    >>> Alarm Section <<<

    display nobell=visual               :Turn bell back ON
    lput "\r\n\n\t\t  Hit *BACKSPACE* key to \E[3m\E[5mSTOP\E[0m alarm..."
    sleep 30                 :Give 3 seconds for response before alarm
    while "!k&&L<20" lput "\7\7"        :For 20x and While nokey, make noise
    if k goto bv                        :If keyhit then skip next call
bv: : cls
    :: display bell=visual                 :quiet bell
    pat                                 :clear patterns
    pat 1i "Thank you for calling"      :watch for goodbye from BBS
    pf3                                 :set check wait for 3 second
    while "!1&&c" wait                  :while carrier present wait here
    echo "\n\n"
    return

:            --- An example of a TComm BBS that has ZCOMM users ---


oldguard  cls; echo "\n\t\t       Now calling Olde Guard at 1200 Baud \n\n"

          : Note I have default from menu to call at 1200 - just change
          : entry for 'set fa2' to oldg24 if you want 2400 by default.

          ena -E -Z -8g                 :enaBLE Error ck, auto d/l, w graphics
          nolog; speed 1200             :turn off log and set speed 1200 baud
          goto number                   :Skip 2400 baud dial

oldg24    cls; echo "\n\t\t       Now calling Olde Guard at 2400 Baud \n\n"
          ena -E -Z -8g                 :enaBLE Error ck, auto ZModem w graphics
          nolog; speed 2400             :turn off log and set speed 2400 baud

number:
          lput "\t\t Are you calling from the San Antonio Area (y/N)? "
          ife y nolog lput "\r\n\n"  684-4470 ena -8g goto go; else lput "\r\n\n"
          %l,512-684-4470               :Long distance  (outside San Antonio)
                                        :Note the %l, selects Long Distance service
go:       cls
          : echo "\E[34m\n\n\t\t >>> Welcome to Olde Guard BBS -- Please standby <<<"
          : display inhibit             :turns off display for opening setup...
                                        :(use this to not show opening screens)
          ena -E -Z -8g                 :enaBLE Error ck, auto ZModem w graphics
          pat; pat 1i "ENTER"           :Clear patterns and look for ENTER
          wait                          :Wait for pattern
          : put "\rn\ry\r\r"              :REQUEST graphics and color
          put "\r\r\r"                  :SKIP graphics and color
          restime                       :Reset status clock  (Yam Only)
          pat 1i "right (y/N/why)?"
          wait                          :wait for tcomm...
          : display noinhibit           :turn display back on if off
          : pat 1i "~~"; wait           :Watch and for opening screen
          : put "\013"                  :Once found Ctrl-K out of it...
          pat 1i "ast name: "           :Look for log in prompt
          wait                          :Wait until prompt occurs

::        Note you will have to log-on manually first to get a password on Olde
::        Guard...  Since you don't have a password assigned, the line below
::        skips the rest of the auto log-on and hooks you to the BBS.
::        When you have a name and password, add them in the 'putw' statement
::        BELOW and DELETE (or comment out) the NEXT line...

          goto bv  :just put to codeset that watches for carrier...
::        ^^^^^^^^^:delete this after name/password loaded below!

          putw "FIRST LAST NAME\rPASSWORD\r"     :Enter name / password

::        --- Note comment out next four lines if you want bulletins ---
          pat 2i "=="              :Look for bulletin menu if turned on
          wait                     :wait until found...
          put \013                 :Ctrl K to skip this menu
          put "q\rm\r"             :Drop to mail menu level to prevent timeout

::                            >>> Alarm Section <<<

          display nobell=visual           :Turn bell back ON

          lput "\r\n\n\t\t\E[33;1m  Hit *BACKSPACE* key to \E[5;31mSTOP\E[0;33m alarm..."
          : lput "\r\n\n\t\t  Hit *BACKSPACE* key to STOP alarm..." :no ANSI

          sleep 30                        :3 sec for response before alarm
          while "!k&&L<20" lput "\7\7"    :For 20x and While nokey, make noise
          if k goto bv                    :If keyhit then skip next call

::        Put other DOS noise making program here if you wish, for example
::        !sound  (note the '!' will execute DOS programs from inside script)

bv:       : cls
          :: display bell=visual                :quiet bell
          : put "r\r"                        :Prepare to read mail. (off now)
          pf30                               :Reset search wait (30 sec)
          kill                               :Clear circular buffer
          restime                            :Reset the timer (YAM only)
          :  create -S+ %tmp\mail%d.log      :Strip all ANSI, append date file
             ::^If today was 5/25/90 this makes a file in c:\tmp
             :: called mail0525.log -- If you need to use a DOS program on
             :: this filename use the syntax @!% [DOS program] mail%d.log
             :: to force YAM/ZCOMM to fill in the date before passing to DOS

          : cd %tmp                          :Change directory to d/l area

::        Three lines below show how to check for connection to host system
::        every 3 seconds.  Once connection is lost you are returned to YAM
::        command-line.  This is a useful piece of code if you wanted to have
::        a call placed from a DOS menu and return to DOS menu when the call is
::        completed.  If this is the case you would replace 'return' with 'off'
::        and have YAM/ZCOMM return to DOS after this call is completed.

          pf3                 : set pattern fail time to 3 seconds
          while c wait        : While connected just wait here...
          return              : once no carrier, return to command line.


:---------------------------------------------------------------------------:
:           --- Example of an auto logon script for CompuServe ---          :

cis       cls           :Note -- CIS access number for SAN ANTONIO, TX
                        :You will need to modify for your local CIS number...
          echo "\t Now accessing CompuServe at 2400 baud using the SA Texas number\n\n "
          speed 2401 239-6124     :Odd number, 2 stop bits, error trap
          goto cislog             :Goto logon section of CIS script

cis12     cls; bye; echo "\t Now accessing CompuServe at 1200 baud using the SA Texas number\n\n "
          speed 1200 435-3883     :local San Antonio TX access number...

cislog:   sleep 20                            :Sleep for 2 seconds
          ena -E -7e   : put into Error correcting 7 bit, even parity...
          echo ""; echo "Sending ^C"; put \3  :Send Ctrl-C, echo doing it.
          pattern 1i ID:                      :Wait for ID
          wait                                :"i" causes immediate release
          putw "77770,101\r"                  :Enter Account (can be yours)
          pat 1i word:                        :Wait for password prompt
          wait
          putw "FREE-DEMO\r"                  :Enter password for demo...
          pat 1i "word" ;wait
          put "%s1\r"
          cls;  echo "\n\n\t\t\tStandby for CIS to finish logon..."
          pat 1i ompu
          wait
          restime                             :Reset YAM status timer
          putw "\20"; cls                     :Hit ^P to skip menu (\20 = ^P)
                                              :Next line skips interrupt display
          pat 1i "." ; wait; cls; lput "\r\n\nChoice: "
          :  create -S+ %tmp\cis.log          :Setup appended capture file
          :  cd %tmp                          :Change directory to d/l area

          :Set: fULL duplex, B proto, strip ctrl char, don't pAUSE for {CR}
          ena -fcs!p
          kill                                :Kill initial login text
          restime                             :Reset status timer (yam only)

          while c wait                        :while carrier present wait here
          : w; close                          :Write then close capture file...
          echo "\n\n"                         :This will put you back at the
          return                              :command line once off line...

                 ----------------------------------------------------

telegodzilla           : Omen Technology (YAM/ZCOMM Upgrade BBS)
                       : just give the command  'call -99 telegodzilla'

     pat 9 K\r\n; ena -d; cls          : Ck for OK, disable carrier lost message
     putw "ATS7=100\r" ; wait -f1      : Change wait for connect to 100 sec
     cls; echo "Demand Upgrade(TM): Omen Technology's TeleGodzilla system\n\n"
     accept s7 "Please enter your LAST name: "; accept s6 "First name: "
     :  set s6 "FIRST_NAME" ; set s7 "LAST_NAME" :Fill in and you can comment
                                                 :out accept above and use this
     speed 38400 %l,503-617-1698       :Call using phone account in '%l'
     :speed 38400 617-1698       	:Local call
     : speed 2400 1-503-617-1698      :Call using 1-503-617-1698 service
     restime; kill                    :Reset time and Kill buffer
     display overstrike; cls; pat 1 "ease:"; wait -f4
     if "c&&!1" put "\r"; wait -f8
     : if !1||!c echo "Access Failed"; o; fail
     put "\b\b%s6 %s7\r"; pat 1 ect;wait -f2
     put "y"; pat 1 "-Host"; wait -f5
     : !sound  TeleGodzilla is on-line :uncomment if you have external alarm
                                       :program (this one calls sound.exe)
     cd %tmp
     create -S+ %tmp/tele%d.txt        :Strip all ANSI, append to dated file
     : sz -Z [filespec to upload]      :example of how to force file upload

     ::  If you uncomment one of the below you can select a file auto-download
     : zcommand "sz -n upgrade/yam.eqe upgrade/newest.meq upgrade/read.meq"
     : zcommand "sz -n upgrade/newest.meq"
     : zcommand "sz -n answer"
     : zcommand "sz -n rzsz*.* upgrade/newest.meq"
     : putw "bye\r"; o
     t -8g      :force terminal mode...

upgrade    speed 2400 %l-503-617-1698 t  :no frills calling telegodzilla

:                     --- End of Auto Log Examples ---                        :
:=============================================================================:

::         Generate a script with TurboLearn Script Writer(TM)
::                    Hit Shift-F4 to start this...

tlearn    set fc10 "" :: telephone number, and flag that telno was entered
     if c goto connected
     cls
     accept fc10 "Enter Telephone Number "
ag1: accept fa1 "Enter Speed (300, 1200, 2400, 19200, 38400) "
     if ifa1,19200 speed 19200 goto ag2
     if ifa1,38400 speed 38400 goto ag2
     if ifa1,2400 speed 2400 goto ag2
     if ifa1,1200 speed 1200 goto ag2
     if ifa1,300 speed 300 goto ag2
     echo "Bad speed"; goback ag1
ag2: lput "\r\n1 - System uses IBM PC (ANSI) line drawing characters\r\n"
     lput "2 - System uses 7 bits even parity\r\n"
     lput "3 - System uses 8 bits No parity (8n1)\r\n"
     lput "\r\n"
     acceptl1 fa2 "Choose one of the above: "
     lput "\r\n"
     ena -8n
     @%fc10
     if !c echo "Sorry, no connection"; return
     set fa5 ""
     if ifa2,1 ena -8g; set fa5 "ena -8g"
     if ifa2,2 ena -7e; set fa5 "ena -7e"
connected:
     echo "Finish with F1.  Use ALT-B to send a break if necessary"
     learn -y tlrn.tmp
cn2: if !r echo "WARNING: Learning (recording) terminated prematurely!"
     close
     kill
     create newscr.t
     if !r abort
     echo "Is this to become a Telephone Directory entry (y/n)?"
     if !y goto nodir
     accept fa6 "What directory entry name to use? "
     echoc "%fa6    speed %fa1 %fc10 %fa5"
nodir:    close;  set fa2 ""
     echo "Should the script disconnect the phone line (y/n) ?"
     if !y "!tlearn tlrn.tmp >>newscr.t"; goto scdone
     set fa2 "bye;  return"
     echo "Should the script then exit to the Operating System (y/n)?"
     if y  set fa2 "off"
     !tlearn -r tlrn.tmp >>newscr.t
     create -+ newscr.t; echof "   %fa2";  close
scdone:   echo "Your new script is in the file 'newscr.t' !!"
     if %fc10 echo "You may add this file to your Telephone Directory"
     if %fc10 echo "Or execute it with 'call %fa6.newscr.t'";  return
     echo "You may execute this file with 'source newscr.t'"
     return


:=============================================================================:

::                    ---  Using YAM/ZCOMM in HOST MODE  ---

::      Note that for maximum -security- have this section be another file
::      so users won't see your passwords.


::      YAM users can uncomment 'demand %password' line at end of file

host    cls; echo " Activating host mode operation...  Stand by!\n\n"
        sp 2400
        : sp 1200                   : use for 1200 baud host modem...
        : set home "/HOST"          : Optional restricted directory

::    The above command can force users into a specific area on disk.  It
::    CRITICAL you use "/" NOT a "\" in this command.  This will lock users
::    into that directory and its subdirectories.  If you use this
::    command, you MUST have your welcome and xhelpfile as a different
::    file and this file MUST be in the directory specified by the 'set
::    home' command.  To function it MUST be a READ ONLY file.  You may
::    use HOSTHELP.TXT for this purpose but it will need to be renamed to
::    HOSTHELP.T.  Remember you will also need to add some starting
::    labels and utilize new 'set welcome' and 'set xhelpfile' commands.

        set welcome "@gosub welcome.%phones"  : setup Welcome
        set messages "/host/messages"        : setup file for messages

::    Private should set to another directory so people won't see
::    private messages, since when HOST restricted they can change from %home

        set private "/yam/pmessage"         : Setup private message area

::    Normally section below would be in another file so people could NOT
::    view your passwords.  For testing you can get around this by assigning
::    your script a READ-ONLY, HIDDEN attributes.  For YAM users wanting to
::    use the 'demand %password' option, the file CAN NOT have a HIDDEN
::    attribute so you MUST put this in another directory that users can't
::    access for protection.

        set password "xxxxxxxx"   : CHANGE THIS Access Password
        set unrestrict "xxxxxx"   : WARNING - CHANGE THIS DOS drop PASSWORD!!

::                     -- HOST Helpfile Defined Below --

        set xhelpfile "@gosub help.%phones"  : Custom help 17.29+
        : set xhelpfile "@type hosthelp.txt>com1"    : (older versions)
                                           :^^^^ set this for com1 or com2
                                           : Notice this is an EXTERNAL file!

        set disks "abc"                    : Setup restricted disk area

        set call1 "ATZ\r\336\336ATZ\r\336\336"  :prepare to answer phone...
        set call2 "ATZ\r\336\336ATM1X1S0=1\r\336ATM1X1S0=1\r\336\336"

        :       Note 'call3' below would normally be a command that
        :       requires quotes around it, but it includes a quoted string
        :       so you MUST use this alternate form of the set command to
        :       have the actual command start at COL #1 of the next line.
        :                 <<< This works with YAM only...>>>

        : set call3
: @echo "\t\t Now awaiting incoming calls... Press F1 to exit.\n\n"

        set answerback "\r\nYOUR NAME HERE...\r\n\21"

        set outahost "@pk512; putw ATE1V1X1S7=60S8=1S11=50S0=0\r;pwd; gosub menu"


        set baudstr "@gosub baud"               : sub below to find speed
        pc60                                    : callout interval = 60 sec
        host

        :               >>> Check for Caller Speed <<<

baud    pat 1 "CONNECT\r\n"; pat 2 "NO CARRIER"
        pat 3 "CONNECT 1200\r\n"; pat 4 "CONNECT 2400\r\n"
        pe-20
        wait -Ef25
        dis -E
        if 1 speed 300 return
        if 3 speed 1200 sleep 20 return
        if 4 speed 2400 sleep 20 return
        kill create -+ rings
        close
        fail

welcome:
            :In HOST mode, below is what the user will see on login

    echo "                     >>> Welcome to YAM/ZCOMM Host Mode <<<                    "

    : demand %password    :YAM users may uncomment to request password

::    The 'demand' command is only available in YAM and NOT in ZCOMM...
::    If you are using ZCOMM there is no way to restrict initial access
::    like you can with YAM.  ZCOMM CAN will RESTRICT access to DOS if
::    user doesn't know the password ...

help:       :Note this is also the help message...
    echo "                                                                               "
    echo "        The thing to remember is that when you see the prompt followed         "
    echo "        by [HOST] it is like you are actually sitting at the host              "
    echo "        terminal...  To execute commands on your own YAM/ZCOMM hit F1          "
    echo "        to call your local terminal program...                                 "
    echo "                                                                               "
    echo "        To open access to the complete disk enter the command: UNRESTRICT      "
    echo "        and then use the system password -- otherwise you will remain in       "
    echo "        the C:\\host directory or one of its subdirectories.                   "
    echo "                                                                               "
    echo "        To see the files on the host enter: 'dir' and hit return.              "
    echo "                                                                               "
    echo "        TO DOWNLOAD a file from the host enter 'sz filename' (wildcards OK)    "
    echo "            (Remember this is just like typing at the HOST keyboard...)        "
    echo "                - For XMODEM enter 'sx filename' at HOST prompt -              "
    echo "           - For KERMIT enter 'kermit sb filename' at Host prompt -            "
    echo "                                                                               "
    echo "        TO UPLOAD a file hit F1 to get into your terminal command mode and     "
    echo "        then enter 'sz filename'.  In ZModem everything else is automatic.     "
    echo "        XMODEM enter 'rx filename' or 'rc filename' for CRCX at HOST prompt    "
    echo "        - KERMIT enter 'kermit rb' at HOST prompt then start your upload -     "
    echo "                                                                               "
    echo "        To leave a MESSAGE enter the command 'message' and follow prompts.     "
    echo "          ---> To see this message anytime enter the command 'help' <---       "


::-----------------------------  End of Host Mode ----------------------------::

::------------------------------  Start of Setup  ----------------------------::

        : This code segment called from 'setup' label... First thing is to
        : test for the existence of 'PROFILE.DAT' the user's default file.

do_it:  cd %home        :first make sure you're in the home directory.  There
                        :are lots of variables, %variable_name activates them.
                        :To see the various variables enter 'set' at the DOS
                        :prompt to see DOS environment and 'set' at YAM/ZCOMM
                        :prompt to see the local variables.

        if !fprofile.dat gosub make_profile  :If PROFILE.DAT not found make one

        : Initialize Shift-F6 early in case fatal error in PROFILE.DAT produces
        : crashed state (as would happen if you copy the PROFILE.DAT to a system
        : with a different configuration and didn't reinitialize).

        set fs6  "@gosub reset"   :Resets PROFILE.DAT containing modem dialing info

        source profile.dat      :read and activate PROFILE.DAT file...

        set mcommand "gosub dial"
        : The above ^ skips internal dial routine allowing for autospeed sense

	: set mcommand "gosub adial"		: select advanced dialer
	: if "!%MODEM" set MODEM hu96.t		: for modem specific dialer

        ena -d                  :suppress the Carrier Lost msg during setup
        : ena -D                :establishes a 2 second timing loop for line hits
                                :(use for call waiting where you can't disable)
        : pa4000                :use for clones running 8 MHz and above...
        pd1                     :turn on time stamping
        pi10                    :set redial for 10 seconds...
        : pt4  :default throttle of 20 char/sec (lower is faster) (see F4)
        pT3                     :set histfile to save commands only if 3 char+
        pv-1                    :Verbose OFF (-1 shows none; 50 shows all)
        pz360                   :set CST timezone (could use DOS: set ZONE=360)
        : p-1                   :for those using MKS ToolKit UNIX Shell
                                :There are many 'p' parameters you can set,
                                :these are just examples of some useful one.

::      --------------------------------------------------------------------

::      The option below allows you to hit an up arrow key to use past
::      commands by setting up a history file.  Since all keystrokes are
::      recorded (including passwords), the 'onexit' command will delete
::      the history file when you finish your communications session.  Of
::      course, you could have more protection by writing over the file with
::      another.  To do this replace the 'del c:\histfile' with something like
::      '!copy \command.com \histfile'.  This will write over your history file
::      with a copy of command.com.  Usually this file deletion is adequate.

::      If you don't want to use this history file option just put a ':' in
::      front of the command since anything preceded by a ':' is considered
::      to be a comment.

        history c:/histfile   : Setup command line buffer (here in root)

        : Note the special construct below.  Since there are quotes in the
        : string, it is put on two lines and will delete histfile on exit...
        : The '\n\n\t' string means two Newlines then TAB over a mark.

        set onexit
@history; del c:/histfile ; echo "\n\n\t\t\t History file deleted... "; sleep 5

        :: display bell=visual   :turns off bell, comment with ':' for bell

::                             --------------------

      :  if c goto online          :if carrier detected skip modem setup.

::    The above line allows you to check the carrier status when YAM/ZCOMM is
::    loaded.  This means you can take full advantage of the eXit to DOS
::    function.  Anytime you are on-line you can get to the command line by
::    hitting F1 then enter 'X'.  What this does is unload the communication
::    program but leaves the modem and serial port active.  Then you have full
::    access to DOS and can return on-line as long as the host doesn't time
::    out (while you are working at the DOS prompt).  Once through with DOS,
::    re-load YAM/ZCOMM like you did initially and WHAM -- you're back on-line
::    as if you had never left...

::    To activate remove the ':' from in front of 'if c goto online'.  This
::    will prevent YAM/ZCOMM from reinitializing the modem.  Then continue and
::    search for the line 'Second part of testing for on-line conditions' and
::    comment out the command 'fail'

::                         --- Check Modem Status ---

      cls;  lput "\r\n\n\n\t\t\t>>> Modem setup in progress <<<\r\n\n"

::    Below is an example of how to use color and graphics (now turned off).

        : echo "\n\n\n\t\t    ķ"
        : echo "\t\t     \E[44;1;33m   >>> Modem setup in progress <<<  \E[0m "
        : echo "\t\t    Ľ\n"

	bye
        sp 9600                           : Initially set up speed at 9600 baud
        pat 9 K\r\n                       : Check for OK from modem
rc:     put "AT\r"; wait -f3              : Hayes 'AT' then wait up to 3 sec for OK

        :   Modems using stored profiles can have initialization done here
        :   by replacing "AT\r" with ATZ0\r".  Remember you first have to
        :   initialize and store modem string before this functions correctly.
        :   "ATZ0\r" recalls Hayes Profile 0 if already defined.  If this
        :   is done you can have the script skip further modem setup strings...

        if 9 goto modset                  : If Modem on (OK) skip error msg
        lput "\E[4f                                                        "
        lput "\E[5f\t\t  Please turn your modem OFF then back ON,\r\n"
        lput "                                  - OR -                           \r\n"
        lput "\t\t   Hit SHIFT-F6 to change your setup..."
        sleep 20                          : You get 2 seconds to turn it on!
        goback rc                    : Check modem again...

   --------------------------------------------------------------------------

:: <*>     --- Some of the common MODEM SETUP commands definitions ---

::  &C1=Data Carrier Detect  &D2=hang up with change in DTR
::  E1=modem echos commands back to terminal  V1=Word result codes
::  &W=Save config to nonvolatile memory  L=speaker low

::  X4=Detect dial tones and busy signals; enable extended result codes.
::     With this activated (default for most modems) status messages are
::     sent to the screen about modem activity.  English words instead of
::     number codes are displayed on the screen.

::  S0=answer rings  S6=dial tone wait  S7= wait for connect  S8=pause for ","
::  S9=Carrier det response  S10=delay carrier lost and hangup  S11=dial speed

::  Remember if your modem doesn't hang up correctly ADD '&D2' to the string.
::   Any backslash characters (\) must be repeated

modset:
	putw "AT&F E1V1X4 &D2&C1 &Q5&K3 S0=0\r"  :Rockwell v.FC
                                                     :the default setup!
	: putw "AT&F E1V1X6 &D2&C1 \\N5\\Q3 S0=0\r"  :AT&T CS3820
        : putw "AT E1 V1 X1 S0=0 S7=60 S8=2 S11=60 \r" :Normal 1200 baud setup

        :       -- Line below is an alternate 1200 baud setup command --
        :  putw "AT E1 Q0 S0=0 S6=3 S7=40 S8=2 S10=10 S11=50 V1\r" ; wait -f2

        :: -- Line below supports Hayes/Zenith 2400, Compaq LTE/286, NEC Ultra
        :  putw "AT E1 L X4 V1 &C1 &D2 S0=0 S6=3 S7=60 S10=10 S11=60\r"

        :  put "AT E0 V1 X4 &D2 \r"           :for Everex 2400 baud

        :  putw "AT &C1 &D2 E1 &Q0 L1 S7=100 S11=50 \r" :Simple Hayes V-9600
        ::       ^^ Once stored using ATW0 it's in PROM, ATZ0 below gets it...

::         -- A suggested ZOOM 2400 baud modem setup is listed below --

        :  handshake both        : Handshakes both CTS or XOff
        :  putw "AT &C &D2 &L0 C1 X5 S9=5 S10=10 S11=40 S25=0 +Z0=2 +Z3=45\r"
        :  S25 DTR timing to 0 seconds
        :  wait -f1              : Wait 1 second and let modem catch up...

:  --------------------------------------------------------------------------


::                   --- Setup Environment Variables ---

online:
        set disks "abcdefghi"         :set up active disks (you can restrict)

::    Note the prompts below can be anything you wish...

        set mprompt "\r\E[1m(F9=Menu) %drive:\L%pwd-> \E[m"   :Help prompt
        : set mprompt "\r\E[1m%drive:\L%pwd->\E[m "    :Normal path prompt
        set hprompt "\r\E[1m%drive:\L%pwd\U [HOST]->\E[m " :HOST mode prompt

        : The special command below allows you to put comments on status line...
        set statliner "[Alt-2=Cmd Line, F2=View, F9=Help] " :maps status line


::                          -- HELPFILE Defined Below --

::      Notice that the Flashup help processor is called with F10 as defined
::      in key setup or when F1 hit at command line.  The test below
::      'if fFILENAME' checks for the existence of the help files for ZCOMM
::      or YAM.  If they are found the variable 'helpfile' is set to the
::      command that will call help.  The string '@!%' is a clever construct
::      where each character has a meaning.  The '@' says that what follows
::      is a YAM/ZCOMM command.  The '!' means to run a DOS program, and the
::      '%' says to replace all YAM/ZCOMM variables (word beginning with '%')
::      before the DOS program is called.  The %home variable contains the
::      name of the subdirectory where YAM/ZCOMM was first called.  If you use
::      the COMM.BAT file I included, this will always be the location
::      of your communication programs.  First DOS 'echo' if no helpfiles...

        set helpfile "@!%echo     No helpfiles located in the home directory: %home"

        if fZMANH.HLP set helpfile "@!%yhp %home\zmanh.hlp zmain" :ZCOMM Help
        if fUMANH.HLP set helpfile "@!%yhp %home\umanh.hlp main"  :YAM Help


::                          -- Optional setup statements --

        set calllog c:/zcomm/calllog :Setup call log (YAM and Registered ZCOMM)
                                     :This file will keep record of calls made

        set fleft  "@mput \b"        : Makes left arrow destructive bksp
        set fright "@mput \40"       : Makes right arrow a right space
        set s8 " \b"    :set string for 'hold' function to space/backspace key

        set adlopts rm               : Makes ZModem crash recovery / MobyTurbo
                                     : Note the 'm' will cause an error in pre-
                                     : MobyTurbo versions

        set quitcmd \20bye\r\003\336off\r    : maps string given to ALT Q
                                     :to log off automatically after d/l; here
                                     :set to ^P,bye<cr> for CIS then OFF.  Once
                                     :Download starts, just hit Alt-Q to activate

        set answerback "\r\n %m \r\n\21"  :Stuff in 'm' name variable...

        set tmp c:/tmp               : Both tmp and lib are shortcut paths
	if du set tmp /tmp
        set lib c:/yam               : you can use in your script. For example
                                     : if later you may want to change this to
                                     : 'set tmp c:/zcomm/temp' to allow %tmp
                                     : to produce subdirectory location.

        : set dirrx c:/tmp            :Sets up default for downloaded files as
                                     :above. If you made this 'set dirrx c:\tmp
                                     :your download would go to the \tmp subdir.
        : set dircx c:/tmp           :path to capture file directory
        : set dirfx c:/tmp           :path to files (message) directory
        : set dirsx c:/tmp           :path to upload dir
        : set oncloserx "@source c:/yam/gotafile.t"

:: Above is an example of how you can have a reaction to a file download and
:: run another file to do special processing.  As you can see you have total
:: control over where things are placed by the package.



::                       -- Define Function Keys --

key:    cls         :Notice how a label starts in Col 1 and ends in a ":"
        reskeys     :reset function keys

::    Explained below is the function key define command 'set'.  To see all
::    the keys defined give the command 'key' at the YAM/ZCOMM prompt.  Note
::    below that the command format sets a FUNCTION KEY to a specific task.
::    This is just an example, F3 is defined again after this explanation.

 set f3
@accept s1 "Enter name of Capture File: " ; create -S+ %s1

      :  This is just a sample... actual F3 defined below these comments...
      :  Notice that I used a special case of the 'set' command where the
      :  key definition actually appears on the next line starting in col #1.
      :  The reason for this is that normally, function key commands are in
      :  quotes, yet here I wanted a quoted string inside the command.  To
      :  avoid having quotes within quotes, there is a special version of the
      :  set command that accepts the next line starting in column 1, as an
      :  implied command.  This means you don't need quotes around it...  Note
      :  as well the 'set' command DOESN'T start in column 1 because if it did
      :  it would be considered to be a label.

      :  To explain how the command works remember anything beginning with
      :  an "@" sign is a YAM/ZCOMM command (a @! allows you to execute a DOS
      :  program).  Let look at this command defining f3 step by step...
      :  The command "set" tells the program to set the function key
      :  (this case F3) to the following string:

      :        @accept s1 Enter name of Capture File: ;create -S+ %s1

      :  You could have used an escape sequence \40 to define a space
      :  in the string but only necessary in single line format.  This will
      :  make the prompt --> Enter name of Capture File: <--  Now the "accept"
      :  command assigns anything you type in response to this prompt and
      :  stores the response in a variable s1.  Remember ";" is just a way to
      :  separate multiple commands on each line, so you see when we come to
      :  the next command "create", it causes a capture file to be opened
      :  using the name you have entered.  The modifiers -S+ means, strip
      :  off control characters (-S) and append to the file (+) if it already
      :  exists.  Notice the argument %s1 will insert the file name
      :  added after the prompt (stored in s1).

      :  You see the PLUS of YAM/ZCOMM is that you can make things look
      :  any way you want.  You can set 38 function keys (remember that
      :  F1 moves you from circular buffer to terminal mode to command mode
      :  and F2 moves you in the opposite direction).  YAM/ZCOMM has THREE
      :  displays (command line, terminal mode, and circular buffer) yet this
      :  is a FAST way to move between them...

      :  To see variables you have defined just give the 'set' command followed
      :  by a return at the YAM/ZCOMM prompt.  If you want to see the value of
      :  a single key or variable for example 'F5' use the  command 'echo f5'.
      :  To see what KEYS are defined enter the command 'key' at the YAM/ZCOMM
      :  command line.  Remember command lines can't exceed 132 characters.

      :  Now set a series of function keys to activate specific commands...

::                   --- NORMAL Function Key Definitions ---

 set f3 "@gosub capture"        :call capture routine just below 'menu:' label

 set f4
@accept s1 "Send ASCII Msg named: " f -p %s1  : send ASCII text/mesg -paced

 set f5
@accept s1 "Send file using Kermit called: " kermit sb %s1    : send Kermit

 set f6
@accept s1 "Send file using ZModem called: "; echo "\n\tStarted upload at: %t\b\b\b\b\b\b\b\b\b\b\b\b Hours      \n"; sz -rZ %s1
 : above sends file with ZModem (-r) crash recovery and Run Length Encoding
 : (RLE) using '-Z'.  Echo displays the start time of upload...

 set f7
@accept s1 "Receive file using CRCXModem called: " rc %s1   :receive CRCXmodem

 set f8
@accept s1 "Send file CRCXModem called: " sx %s1            :send CRC Xmodem

 set f9  "@gosub menu"                                      :Call Quick Reference
 : set f9 "@gosub fkeys"  : Call ANSI function key menu (commented out here...)

 set f10 "@help"   : Call help processor (newer YAM/ZCOMM just hit F1 x3)


::                 --- SHIFTED Function Key Definitions ---

 set fs3 "@gosub hold"    : puts you in a holding pattern while on-line

 set fs4 "@echo working...;  gosub tlearn"

 set fs5                                         : check phone dir entries
@accept s5 "String to find in phones file: "; find \n%s5 %phones

 set fs6  "@gosub reset"   :Resets PROFILE.DAT containing modem dialing info

 set fs7  "@gosub start.%home/dial.t"   :setup call to dialing menu...

 set fs9 "@!chkdsk"        :@! example of how to run DOS program
                           :In this case CHKDSK used...

::                  --- ALT-ed Function Key Definitions ---

 set fa1 "@kill; call -100 bnf"              : Examples of key assign
 set fa2 "@kill; call -100 old"              : note "@call -100" will
 set fa3 "@write; close"                     : call number up to 100
 set fa4 "@kill; call -100 cis"              : times if busy.
 set fa5 "@kill; call -100 pcmag"            : kill clears buffer...
 set fa6 "@kill; bye; gosub host"            : Put into HOST mode
 set fa7 "\r \r\t\t\t\t %m \r\r"             : When on-line, Alt-F7 signs
                                             : your name defined in 'm' setup
                                             : in PROFILE.DAT

:: Editors are your choice (they just have to be able to save in ASCII format).

:: I have included version 3.10 of the Colorado State Editor developed by
:: J. R. Applegate at the Colorado School of Mines.  This full featured
:: editor is only 13K and features block copies, moves, upcase, lowcase,
:: deletes, etc.  It is fully configurable and is PUBLIC DOMAIN!

:: The best ASCII editor I have found that can be configured to run any
:: command set you want (e.g. WS, WP, Brief, or pull down menus) is a shareware
:: called QEdit.  It is rated high by many publications (and is my personal
:: favorite).  QEdit by SemWare is available on most BBS around the country.
:: Worth a look!

:: Below I again used the special construct @!% (@=command, !=DOS shell,
:: %=replace variables before calling DOS command).  If the DOS 'set phones='
:: command was used to setup environment variable at DOS the %phones will
:: read it.

 set fa9                         : Use incase NO editor selected
@echo " Alt-F9 has no editor defined. Just edit to script under 'set fa9'\n to setup an editor of your choice..."

 set fa9 "@!%edit %phones"            : example using DOS 5 EDIT
 : set fa9 "@!%q %phones"            : example using QEdit

::  If you want the menu just after loading, remove the ':' in front of the
::  line below to comment it in thereby activating the command.

    : goto menu

::  This is an opening msg for new ZCOMM users and can be commented out if
::  you want to skip it.

    lput "\r\n\n\t\t -=* Welcome to the World of Telecommunication *=-\r\n\n"
    lput "\t\t                     PHOMAST.T                    \r\n"
    lput "\t\t                   [Version 6.3a]                 \r\n\n"
    lput "\t\t      >>> Press F9 if you need more help <<<          \E[10f"
    lput "\t If you want to change your *setup* defaults just hit SHIFT-F6. \r\n\n"
    lput "\t To view the current defaults stored in 'PROFILE.DAT' just enter\r\n"
    lput "\t the command 'type profile.dat'.                                \r\n\n"
    lput "\t Remember, to utilize your Long Distance Service start the number\r\n"
    lput "\t with a prefix of '\45l,'.  Notice the sample syntax below...   \r\n\n"
    lput "\t                       '\45l,512-670-0954'                      \E[23f"

::                  Second part of testing for on-line conditions
::                                 (Optional)

     fail       : The 'fail' here eliminates the on-line checking... if
                : you want on-line checking, comment this 'fail' out (put a
                : ':' in front of it) and search from the top of the script
                : for the line 'if c goto online' and remove the ':' in front
                : of it.

     if !c return             :if no carrier return, else go online
     echo "\t\t    System still on-line with remote server..."
     putw "\r" ; t            :hits return and return to terminal mode
     return                   :Returns system back

::---------------------------  End of Setup Code  ----------------------------::

                        ---------------------------------
::--------------------------  AutoConfiguration Code -------------------------::
                        ---------------------------------

::      This code for PROFILE configuration was put at the bottom of the script
::      because the script file is searched from the beginning to end.  Since
::      configuration is done only at install and when configuration is
::      changed, I put this code at the bottom of the script to allow other
::      procedures to be found faster.


reset:  : This code segment attached to Shift-F6 will delete the old defaults
        : stored in PROFILE.DAT and start a new one...  It is completely menu
        : driven.  Once PROFILE.DAT is deleted it branches to 'setup' label
        : later in the script to do the actual configuration.

        display nobell=visual   : Turn bell back ON
        cd %home                : Attempt to return to original directory
        cls; echo "\n\n\d7\t\t >>> Communications Configuration Setup <<<\n\n"
        :: display bell=visual     : Turn bell back OFF and ask about delete of file
        lput "          Don't change your setup if you are currently online...\r\n\n"
        lput "   Insure you are in directory where phones files stored before making\r\n"
        lput "   any changes... you are currently in a subdirectory called: "; !cd
        lput "\r\n\nThis directory contains the following PHONES files:\r\n" ; !dir p*.t
        lput "\n   Is this the correct directory and do you want to change setup (y/N)? "

        if !y cls echo "\n\n"  fail
        del profile.dat             :Delete the old profile data file...

        :               ---------------------------------

        : This code segment is where the PROFILE.DAT file is generated in
        : response to menu selections...

make_profile:
        set s0 ""       :initial variable to NULL
        purgek; kill; pv0; create -y profile.dat   :clear buffer/write profile

        : Since PROFILE.DAT doesn't exist now, the next code actually writes a
        : new file (using the echof) called PROFILE.DAT storing your defaults.
        : What is really happening here is YAM is generating its own script
        : file that will contain changed configuration information for future
        : use.  Remember when you use this technique you must have a space or
        : TAB echoed before every command line so it doesn't write the target
        : file line in column 1.

        echof "::                  >>> DON'T DELETE THIS FILE <<<"
        echof "::                           PROFILE.DAT\n"
        echof "::  This file contains important setup information used by YAM/ZCOMM "
        echof "::  and was completely generated by PHOMAST.T file from menu choices!"
        echof "::  You can edit this file directly or from YAM/ZCOMM; hit Shift-F6"
        echof "::  to call up configuration menus and have the computer do the work.\n"
        echof "::  You can change Color default here or in the main PHOMAST.T script"
        echof "::  but remember ANY changes made here will be changed with Shift-F6."
        echof "::  To see possible colors enter the command 'gosub color' prompt."
        echof "\n::  Note: If there is NO port command below, default is 'COM1' \n"

        :: Note that 'lput' is local echo where 'echof' will write to open file
        :: Remember that 'lput' doesn't put a hard return at the end of lines.
        :: Below the \E[xxm just add color to the letters 'COLOR'

        pn15; cls; lput "\E[m\n\n\n\t\t    Are you using a \E[1m\E[33mC\E[32mO\E[34mL\E[35mO\E[36mR\E[m monitor (y/N)? "
        if !y echof "    pn15 pr127 pu15 ps112 p*112 p@15   :default monochrome..."; goto mono

        echof "    if dc pn1055 pr26 pu26 ps26 p*26 p@30    :setup default colors"
        if dc pn1055 pr26 pu26 ps26 p*26 p@30        :setup colors locally

:: <*>  -------------------- Optional DISPLAY COLORS Setup -------------------

        ::  If you don't like the default colors just pick one of the color
        ::  options below and put one copy inside the quotes of the 'echof'
        ::  above and another copy just below it (e.g. modify the two lines
        ::  of code above this comment...)
        ::
        ::  if dc means -- If Display Color... and the settings are:
        ::  n=text, r=reverse, u=underline, s=status line, *=message,
        ::  @=file indicator (normally blinking i.e. files open)
        ::  For example: 2=green, 3=blue, 10=bright green etc...
        ::  By adding 1024 to any number you will get blinking suppression.
        ::  To see all the possible colors enter the command 'gosub color'
        ::  at the YAM/ZCOMM prompt...

        :: pn15 pr127 pu15 ps112 p*112 p@15       :default monochrome string
        :: pn7  pr7 pu15 ps7  p*112 p@15        :Alternate monochrome setting

        :: if dc pn1055 pr31 pu26 ps26 p*26 p@30 :default color string
        :: if dc pn3  pr10 pu10 ps14 p*10 p@10   :works well with RGB
        :: if dc pn3  pr30 pu15 ps14 p*12 p@79   :color alternate 1
        :: if dc pn2  pr10 pu6  ps3  p*3  p@3    :color alternate 2
        :: if dc pn2  pr30 pu15 ps3  p*3  p@79   :color alternate 3
        :: if dc pn3  pr30 pu15 ps2  p*12 p@79   :Pearson's choice
        :: if dc pn31 pr30 pu15 ps14 p*15 p@79   :Willoughby's choice
        :: if dc pn1055 pr26 pu26 ps23 p*26 p@28 :My favorite...

::      ----------------------------------------------------------------------

        cls; lput "\n\n\n\t    Is snow a problem with your monitor (e.g. CGA) (y/N)? "
        if y echof "    display nowarpdrive       :Turn off high speed display"; goto mono
        display warpdrive   :turn on high speed display locally
        echof "    display warpdrive         :Turn ON highspeed display (no snow checking)"


mono:   cls; lput "\r\n\t\t>>> PULSE / TONE Dial Configuration Menu <<<\r\n\n"
        lput "\t\t   Your current modem dial string is: %mprefix\r\n"
        lput "\t\t   (If 'M' above Manual dial selected...)\r\n\n"
        lput "\t\t    1. Set modem to dial TONE type phone.\r\n"
        lput "\t\t    2. Set modem to dial PULSE type phone.\r\n"
        lput "\t\t    3. Dial the number using an EXTERNAL phone.\r\n"
        lput "\t\t    4. Quit -- Don't change a thing...\r\n\n"

        acceptl1 s9 "\t\t    Choose one of the above: "  :store ans in s9

        if "Js9,1234" goto ok   :check for correct input...
        display nobell=visual
        lput "\E[24f\7\t\t      You MUST choose between 1 and 4"; sleep 15
        :: display bell=visual
        goback mono

ok:     if is9,3 echof "    sets mprefix M          :setup for MANUAL dial" ; goto pdone :setup for MANUAL dial
        if is9,4 echof "    sets mprefix %mprefix"; goto pdone :leave unchanged
        lput "\r\n Excluding long distance service do you need a special dialing prefix (y/N)? "

        if !y goto pdone
        accept s0 "\r\n\t\t    Enter the prefix number now: "
        if %s0<1 set s0 "" ; goto pdone  :Null was entered for prefix number...
        sets s0 %s0,           :appends a comma after the dial prefix...

        : Remember you must put a tab/space in echo so it produces a legal
        : line of code in the PROFILE.DAT file, since without a space or
        : TAB it would just be a label.  Notice the extra spacing after echof.

pdone:  if is9,1 echof "    sets mprefix ATDT%s0         :setup for TONE dial" ; goto ok
        if is9,2 echof "    sets mprefix ATDP%s0         :setup for PULSE dial"; goto ok

        : The next section of code actually looks at the specific hardware
        : configuration.  This test will work for the 90% of you that have
        : COM1 or COM2 active attached to a modem that accepts the HAYES
        : command set.  What happens is the ATtention command is sent to
        : each port looking for a response.  If one is found (e.g. the modem
        : answers 'OK') that port is defined as active.  Once hot port is found
        : a line is added to PROFILE.DAT which activates that port...  This
        : is particularly interesting since I know of no comm program that does
        : auto port configuration...

ok:     write; close        : Before PORT testing turn off file recording
	if du accept s0 "Please enter communications port (e.g. tty1A) "; goto pset

        lput "\r\n      If external MODEM, make sure it's ON for testing, then HIT ANY KEY. "
        : Below will wait for keystroke hit, then it echoes 'working'
        ife y ;  lput "      ...working"   :special construct to wait for any keyhit...
        display inhibit     : Turn off echo to screen (avoids the AT and OK)

        pat 9 K\r\n         : Check for OK from modem indicating port match...
        port 1              : Try COM1 first
        sp 1200             : Initially set up speed at 1200 baud for testing
        put "AT\r"; wait -f3              : AT command and wait 3 sec for OK
        if 9 set s0 1 ; goto pset         : If PORT 1 set s0=1 to indicate COM1
        port 2              : Try COM2 now that COM1 has failed
        put "AT\r"; wait -f3              : AT command and wait 3 sec for OK
        if 9 set s0 2 ; goto pset         : If PORT 2 set s0=2 to indicate COM2
        display noinhibit   : Turn local echo back on

        : If it wasn't PORT 1 or 2 goto ask user what port to use...

        lput "\r\n\t    Testing hardware I was unable to find an ACTIVE modem..."
        acceptl1 s0 "\r\n\t    Enter COM port number modem connected to (normally 1): "
        display nobell=visual
        if %s0<1 lput "\7\t                    Port 1 assumed...\r\n"; set s0 1
        :: display bell=visual

pset:   display noinhibit   : Turn local echo back on
        purgek; kill; pv0; create -+ profile.dat   :restart code recording
        lput  "\r\n\t\t\t Now configured for com port %s0\r\n\n"
        echof "    port %s0                    :setup computer COM port number"
        lput "\t\t\t Hit Any Key to continue..."
        ife y  ;        :basically a no-op wait for keystroke (nul else nul)

        cls; set s0 "1"        :default long distance service as '1' service
        lput "\r\n\n\t Do you want to add a long distance service so you can utilize"
        lput "\r\n\t the syntax \45l,213-555-1212 to add MCI or SPRINT service to the"
        lput "\r\n\t to your call [Return will default to '1' prefix] (y/N)? "
        if y accept s0 "\r\n\t Enter your carrier number (3) COMMAs then account: "
        if %s0<1 echo "\t\t   >>>  Service \"1\" assumed <<<" ; set s0 "1"
        echof "    set l %s0        :setup long distance service variable \45l"

        :  >>> Notice that setting UPPER CASE variables is only allowed in YAM.
        :  ZCOMM doesn't allow upper case variables.  This means if a user
        :  enters %L, for dialing prefix it there is no way to define it to
        :  prevent an error...  ZCOMM users can only use %l.

        : echof "    set L %s0        :setup long distance service variable \45L"

        lput "\r\n\n\t Enter a name you want defined to Alt-F7 to use as a short cut"
        accept s9 "\t for signing your name to a message: "
        if %s9<1 set s9 "<Not defined -  Hit Shift-F6 once off line>"
        sets m "\42%s9\42"         :add the quotes to the string...to %m

        : Note ProYAM users could have used a variable call 'name' here and
        : retrieved it with %name; but ZCOMM is more restrictive.  It does
        : not allow variable names, so I used 'm' here (normally 'm' is the
        : second Long Distance Service).  It's much more flexible to use
        : 'name' since the %name variable makes more sense -=- Oh' well,
        : just a minor limitation in the shareware ZCOMM...

        echof "    set m %m   :name stored in '\45m'"

        echof "\n::\t\t     -- End of Setup Information --\n"

        lput "\n\t Storing your new configuration in file named: PROFILE.DAT\r\n"
        write; close    : Code generation complete, close the PROFILE.DAT file

        lput "\t  Configuration complete -=- All variables now defined..."
        lput "\E[20f\t\tHit Any Key to continue and view new PROFILE.DAT"
        ife y  ;         :basically a no-op wait for keystroke (nul else nul)
        cls; typ profile.dat
        lput "\t\t\tHit Any Key to continue..."
        ife y  ;         :basically a no-op wait for keystroke (nul else nul)
        cls; goto setup  :Force new PROFILE.DAT to be activated.

::----------------------- End of Auto Configuration Code --------------------::

::                -------------------------------------------
::           --- For Fancy TOP LINE Menu using ANSI Graphics ---
::                -------------------------------------------

::  Special thanks to Michael Pearson and Ron Ottinger for ANSI menus concept...

::      Notice the ANSI color setup using 'echo' or 'lput' is not simple. Shown
::      here the \E[44;36m sets up light blue letters on dark blue background.
::      To change to yellow on red for example just search and replace \E[44;36m
::      with \E[33;41m  --  Notice in this example I change pn (normal color)
::      to pn15 to make bright white.  To change back at end of each sequence
::      I moved it back to pn3 (blue).  Be sure to change this to whatever
::      normal color you want...  This code is completely OPTIONAL and just for
::      fun!

fkeys                                            ::func keys menu
        pn15                                     ::make normal color WHITE
        lput "\E[s"                              ::save cursor position
        lput "\E[1;1f"                           ::move cursor to menu line
        lput " 1\E[37;44mExit B\E[0;m 2\E[37;44mEnterB\E[0;m 3\E[37;44mO Capt\E[0;m 4\E[37;44mSascii\E[0;m"   ::the menu
        lput " 5\E[37;44mSKermt\E[0;m 6\E[37;44mSZmodm\E[0;m 7\E[37;44mRec CX\E[0;m 8\E[37;44mSCxmod\E[0;m"   ::the menu
        lput " 9\E[37;44mA KEYS\E[0;m 0\E[37;44m>HELP<\E[0;m"
        lput "\E[u"                              ::restore cursor position
        set f9 "@gosub altkeys"                  ::f9 calls ctrl f keys next
        pn3                                      ::change normal color to blue
    return

altkeys                                          ::alt-func keys menu
        pn15                                     ::make normal color WHITE
        lput "\E[s"                              ::save cursor position
        lput "\E[1;1f"                           ::move cursor to menu line
        lput "a1\E[37;44mB&F-24\E[0;ma2\E[37;44mGurd12\E[0;ma3\E[37;44mCloseC\E[0;ma4\E[37;44mCISdem\E[0;m"   ::the menu
        lput "a5\E[37;44mPC Mag\E[0;ma6\E[37;44m-HOST-\E[0;ma7\E[37;44msignat\E[0;ma8\E[37;44m      \E[0;m"   ::the menu
        lput "a9\E[37;44mEdPhon\E[0;ma0\E[37;44m      \E[0;m"
        lput "\E[u"                              :: restore cursor position
        set f9 "@gosub shiftkeys"                :: f9 calls no keys next
        pn3                                      ::change normal color to blue
    return

shiftkeys                                        ::shift-func keys menu
        pn15                                     ::make normal color WHITE
        lput "\E[s"                              ::save cursor position
        lput "\E[1;1f"                           ::move cursor to menu line
        lput "s1\E[37;44m      \E[0;ms2\E[37;44m      \E[0;ms3\E[37;44mHoldOL\E[0;ms4\E[37;44mTLearn\E[0;m"   ::the menu
        lput "s5\E[37;44mSearch\E[0;ms6\E[37;44mConfig\E[0;ms7\E[37;44m      \E[0;ms8\E[37;44m      \E[0;m"   ::the menu
        lput "s9\E[37;44mC KEYS\E[0;ms0\E[37;44m      \E[0;m"
        lput "\E[u"                              :: restore cursor position
        set f9 "@gosub ctrlkeys"                 :: f9 calls alt f keys next
        pn3                                      ::change normal color to blue
    return

ctrlkeys                                         ::ctrl-func keys menu
        pn15                                     ::make normal color WHITE
        lput "\E[s"                              ::save cursor position
        lput "\E[1;1f"                           ::move cursor to menu line
        lput "c1\E[37;44m     1\E[0;mc2\E[37;44m     2\E[0;mc3\E[37;44m      \E[0;mc4\E[37;44m      \E[0;m"   ::the menu
        lput "c5\E[37;44m      \E[0;mc6\E[37;44m      \E[0;mc7\E[37;44m      \E[0;mc8\E[37;44m      \E[0;m"   ::the menu
        lput "c9\E[37;44mOFF   \E[0;mc0\E[37;44m      \E[0;m"
        lput "\E[u"                              :: restore cursor position
        set f9 "@gosub nokeys"                   :: f9 calls shift keys next
        pn3                                      ::change normal color to blue
    return


nokeys:                                           :: restore status line
        cls; lput "\E[s"                          :: save cursor position
        lput "\E[1;1f"                            :: move cursor to menu line
        lput "                                                                                "
                                                  :: erase to end of line
        display nostat                            :: restore status line
        lput "\E[u"                               :: restore cursor position
        set f9 "@gosub fkeys"                     :: f9 calls f keys next
    return

:: This code demonstrated one way of displaying a HELP MENU using ANSI codes.
::
:: What it does: (by pressing F9)
::
::    1.  Saves the current cursor position
::    2.  Moves cursor to top of screen
::    3.  Displays a FUNCTION KEY help menu.
::    4.  Puts the cursor back to its original position
::    5.  Sets F9 to the next FUNCTION KEY menu in the rotation.

::-------------------------- End of ANSI Menu Demo ------------------------::


    ::  I would like to personally thank Bob Willoughby for the tireless
    ::  hours he spent proof reading both PHOMAST.T and the supporting
    ::  document files for this effort.  This release is just over 3000
    ::  lines went through multiple revisions as I found better and
    ::  better ways to make both YAM and ZCOMM easier for the user.  Bob
    ::  was there the whole way finding spelling errors and pointing out
    ::  areas that needed more explanation.  I owe him lots for sticking
    ::  with this effort.    Thank you Bob!


::---------------------------------------------------------------------------::
