/*
 * Header for the wrpn project
 */
					/* fundamental contstants */
const int SCREEN_SIZE = 35;
const int STACK_SIZE = 5;
const int REGISTER_SIZE = 10;
const int MAX_FLOAT_DIGITS = SCREEN_SIZE -1;
const int MAX_HEX_DIGITS = 8;
const int MAX_OCTAL_DIGITS = 11;
const int MAX_DECIMAL_DIGITS = 10;
const int MAX_BINARY_DIGITS = 32;
const int CTRL = 256;
const int ALT = 512;

enum MODE {FLOAT_MODE, HEX_MODE, DEC_MODE, OCT_MODE, BIN_MODE};
enum TWO_PART {NONE, STORE, RECALL, FLOAT_DIGITS};
enum COMPLEMENT {ONES, TWOS, UNSGN};

					/* the dialog object */
class wrpn : public TDialog {
	public:
		wrpn();
					/* functions */
		void flash_button(char key);
		void calc_key(int);
		void push(double);
		double pop(void);
		unsigned long dtoul(double);
		double convert(char *, int);
		char *bitpattern(unsigned long);
		void display(double, int);
		void message(char *, int);

					/* data */
		MODE mode;
		COMPLEMENT complement;
		int decimal_places;
		int word_size;
		int carry_bit;
		double last_x;
		double stack[STACK_SIZE];
		double sto[REGISTER_SIZE];

					/* the command menu */
		void cm_file_exit();
		void cm_edit_copy();
		void cm_edit_paste();
		void ce_edit_paste(TCommandEnabler &ce);
		void cm_view_float();
		void cm_view_decimal();
		void cm_view_hex();
		void cm_view_octal();
		void cm_view_binary();
		void cm_options_8bit();
		void cm_options_16bit();
		void cm_options_32bit();
		void cm_options_1s();
		void cm_options_2s();
		void cm_options_unsgn();
		void cm_help_contents();
		void cm_help_search();
		void cm_help_using();
		void cm_help_about();

					/* the owner-draw buttons */
		alt_button* alt_bn;
		ctrl_button* ctrl_bn;
		TBitmap* bg;

	DECLARE_RESPONSE_TABLE(wrpn);

	protected:
		LRESULT EvCommand(UINT, HWND, UINT);
		void EvPaint();
		HBRUSH EvCtlColor(HDC, HWND, UINT);
};


// RWS objects

#define BACKGRND			801
#define MINATURE_BN		802
#define MINATURE			1802
#define DISPLAY			803

// command menu

#define CM_FILE_NEW			901
#define CM_FILE_OPEN			902
#define CM_FILE_SAVE			903
#define CM_FILE_SAVEAS		904
#define CM_FILE_PRINT		905
#define CM_FILE_PAGE_SETUP	906
#define CM_FILE_PTR_SETUP	907
#define CM_FILE_EXIT			908
#define CM_EDIT_COPY			909
#define CM_EDIT_PASTE		910
#define CM_VIEW_FLOAT		911
#define CM_VIEW_DECIMAL		912
#define CM_VIEW_HEX			913
#define CM_VIEW_OCTAL		914
#define CM_VIEW_BINARY		915
#define CM_OPTIONS_8BIT		916
#define CM_OPTIONS_16BIT 	917
#define CM_OPTIONS_32BIT 	918
#define CM_OPTIONS_1S  		919
#define CM_OPTIONS_2S  		920
#define CM_OPTIONS_UNSGN	921
#define CM_HELP_CONTENTS 	922
#define CM_HELP_SEARCH		923
#define CM_HELP_USING		924
#define CM_HELP_ABOUT		925

// calculator keys

#define PB_A			97
#define PB_GSB			71
#define PB_RS			82
#define PB_ON			113
#define PB_B			98
#define PB_GTO			103
#define PB_SST			83
#define PB_CTRL		128
#define PB_C			99
#define PB_HEX			104
#define PB_ROL			108
#define PB_ALT			129
#define PB_D			100
#define PB_DEC			68
#define PB_XY			120
#define PB_STO			115
#define PB_E			101
#define PB_OCT			111
#define PB_BSP			8
#define PB_RCL			114
#define PB_F			102
#define PB_BIN			66
#define PB_ENTER		13
#define PB_7			55
#define PB_4			52
#define PB_1			49
#define PB_0			48
#define PB_8			56
#define PB_5			53
#define PB_2			50
#define PB_POINT		46
#define PB_9			57
#define PB_6			54
#define PB_3			51
#define PB_CHG			67
#define PB_DIVIDE		47
#define PB_MULTIPLY	42
#define PB_SUBTRACT	45
#define PB_ADD			43

