{**************************************************************}
{*                                                            *}
{*    Here is How-to-use-exceptions-under-MS-DOS              *}
{*        or: have you ever believed that this proggy         *}
{*        could be compiled under MS-DOS ?                    *}
{*    Want some help ? CATCH THIS: 'dcc -cd -m excdemo.pas'   *}
{*    And, for the protected mode: 'dcc -cp -m excdemo.pas'   *}
{*    And, for Windows, of course: 'dcc -m excdemo.pas'       *}
{*    But for that you must have (what a surprise !)          *}
{*        TURBO.TPL and/or TPP.TPL                            *}
{*                                                            *}
{*    Written by Cosmin Truta                                 *}
{*    Babes-Bolyai University, Cluj-Napoca, Romania, 1996     *}
{*                                                            *}
{**************************************************************}

program HowToUseExceptionsUnderMsDos;
{$F+}

uses
{$IFDEF WINDOWS}
  SimplExc, WinCrt;
{$ELSE}
  SimplExc;
{$ENDIF}

type

  TRaiser = procedure;

  IntException = class
  public
    N: Integer;
    constructor Create(AN: Integer);
  end;

  Dummy = class(TObject);

constructor IntException.Create(AN: Integer);
begin
  N := AN;
end;

procedure CatchException(ARaiser: TRaiser);
begin
  try
    { Let's see what do we catch now... }
    ARaiser;
  except
    on E: SimpleException do
      Writeln('SimpleException: ', E.Message);
    on E: IntException do
      Writeln('IntException: ', E.N);
    on TObject do
    begin
      Writeln('A-ha ! So here we have a TObject !');
      raise;
    end;
    else
      (** I don't think that the execution would get here **)
      Writeln('Unknown exception (but I guess that it''s a TObject)');
  end;
end;

procedure GenHelloException;
begin
  raise SimpleException.Create('Hello, world!');
end;

procedure GenIntException;
begin
  raise IntException.Create(79);
end;

procedure GenObjException;
begin
  try
    raise TObject.Create;
  finally
    Writeln('Finally, the execution point is here.');
  end;
end;

procedure GenOtherException;
begin
  raise Dummy.Create;
end;

begin
  Writeln('Watch out for the exceptions !');
  Writeln;
  try
    CatchException(GenHelloException);
    CatchException(GenIntException);
    CatchException(GenObjException);
    CatchException(GenOtherException);
  except
    Writeln('This exception has been re-raised.');
  end;
end.
