unit Iconwarn;

interface

uses WinTypes, WinProcs, Sysutils, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, lrsbmp16, ExtCtrls;

type
  TIconWarningDlg = class(TForm)
	Button1: TButton;
	Button2: TButton;
	GroupBox1: TGroupBox;
	Label1: TLabel;
	LrsBmp1: TLrsBmp;
	CheckBox1: TCheckBox;
	Label2: TLabel;
	Label3: TLabel;
	Label6: TLabel;
	Label8: TLabel;
	Label9: TLabel;
	Bevel1: TBevel;
	Label4: TLabel;
	procedure CheckBox1Click(Sender: TObject);
	procedure Button2Click(Sender: TObject);
	procedure Button1Click(Sender: TObject);
	procedure FormCreate(Sender: TObject);
	procedure FormActivate(Sender: TObject);
  private
	{ Private declarations }
	procedure ShowEditor;
  public
	{ Public declarations }
  end;

var
	IconWarningDlg: TIconWarningDlg;
	BypassedWarning: Bool;
implementation

uses Iconsorc,Utils;

{$R *.DFM}

procedure TIconWarningDlg.CheckBox1Click(Sender: TObject);
begin
	If Checkbox1.Checked then WritePrivateProfileString('Defaults','Hackwarning','Shown','.\FACELIFT.INI')
		else WritePrivateProfileString('Defaults','Hackwarning','Denied','.\FACELIFT.INI');
end;

procedure TIconWarningDlg.Button2Click(Sender: TObject);
begin
	Close;
end;

procedure TIconWarningDlg.Button1Click(Sender: TObject);
var P1: array [byte] of Char;
begin
	StrPCopy(P1,ChangefileExt(Application.Exename,'.INI'));
	WritePrivateProfileString('Defaults','Hackwarning','Shown',P1);
	BypassedWarning := True;
	ShowEditor;
end;

procedure TIconWarningDlg.FormCreate(Sender: TObject);
var P1,P2: array [byte] of Char;
begin
	BypassedWarning := False;
	Font.Name := 'System';
	StrPCopy(P1,ChangeFileExt(Application.ExeName,'.INI'));
	GetPrivateProfileString('Defaults','Hackwarning','',P2,SizeOf(P2),P1);
	If StrPas(P2) = StrPas('Shown') then begin
		ShowEditor;
		Application.Processmessages;
		BypassedWarning := True;
	end;
end;

procedure TIconWarningDlg.ShowEditor;
var	box: TIconedit;
begin
	box := TIconedit.Create(Application);
	IconWarningDlg.Hide;
	box.Showmodal;
	box.Free;
end;


procedure TIconWarningDlg.FormActivate(Sender: TObject);
begin
	{Dirty as hell...couldn't figure out a better way to do this}
	If Bypassedwarning then Application.Terminate;
end;

end.
