unit Jwlinez;

{
        **   VERSION History   **
   Version     Date     Notes
    v1.00  - 01APR99    Original Release
}

{
   JwLinez is actually the first compoenent that I have ever written.  I highly
suggest anyone who want to make a component, and are just starting, make a
real simple component like this one that does  a few simple thing.  And over
time, add more and more functionality.
   This component is just a line draw.  Something that I would otherwise have
to do during runtime, but have decided to make available at design time.
}

interface

uses
  SysUtils, {$IFDEF WIN32} Windows, {$ELSE} WinProcs, WinTypes, {$ENDIF}
  Messages, Classes, Graphics, Controls, Forms, Dialogs;

type
  TJwLineStyle = ( jlTop, jlBottom, jlRight, jlLeft, jlTopLeft, jlRightTo, jlRectangle );

  TJwLinez = Class( TGraphicControl )
    private
      FJwLineStyle: TJwLineStyle;
      FThisPenStyle: TPenStyle;
      FThisPenWidth: Byte;
      FThisLineColor: TColor;
      FDouble: Boolean;

      Procedure SetJwLineStyle( Value: TJwLineStyle );
      Procedure SetThisPenStyle( Value: TPenStyle );
      Procedure SetThisPenWidth( Value: Byte );
      Procedure SetThisLineColor( Value: TColor );
      Procedure SetDouble( Value: Boolean );

      Procedure Paint; Override;
    protected
      { Protected declarations }
    public
      { Public declarations }
      Constructor Create( AOwner: TComponent ); override;
    published
      { Published declarations }
      Property JwLineStyle: TJwLineStyle
        Read FJwLineStyle
        Write SetJwLineStyle
        default jlTop;

      Property ThisPenStyle: TPenStyle
        Read FThisPenStyle
        Write SetThisPenStyle
        Default psSolid;

      Property ThisPenWidth: Byte
        Read FThisPenWidth
        Write SetThisPenWidth
        Default 1;

      Property ThisLineColor: TColor
        Read FThisLineColor
        Write SetThisLineColor
        Default clBlack;

      Property Double: Boolean
        Read FDouble
        Write SetDouble
        Default False;
    end;

procedure Register;

implementation


procedure Register;
begin
  RegisterComponents('JwTools', [TJwLinez]);
end;

Constructor TJwLinez.Create( AOwner: TComponent );
begin
  Inherited Create( AOwner );
  Width := 10;
  Height := 10;
  FJwLineStyle := jlTop;
  FThisPenStyle := psSolid;
  FThisPenWidth := 1;
  FThisLineColor := clBlack;
  FDouble := False;
end;

Procedure TJwLinez.SetJwLineStyle( Value: TJwLineStyle );
begin
  if FJwLineStyle <> Value then
    begin
      FJwLineStyle := Value;
      Invalidate;
    end;
end;

Procedure TJwLinez.SetThisPenStyle( Value: TPenStyle );
begin
  if FThisPenStyle <> Value then
    begin
      FThisPenStyle := Value;
      Invalidate;
    end;
end;

Procedure TJwLinez.SetThisPenWidth( Value: Byte );
begin
  if FThisPenWidth <> Value then
    begin
      FThisPenWidth := Value;
      Invalidate;
    end;
end;

Procedure TJwLinez.SetThisLineColor( Value: TColor );
begin
  if FThisLineColor <> Value then
    begin
      FThisLineColor := Value;
      Invalidate;
    end;
end;

Procedure TJwLinez.SetDouble( Value: Boolean );
begin
  if FDouble <> Value then
    begin
      FDouble := Value;
      Invalidate;
    end;
end;

Procedure TJwLinez.Paint;
begin
  with Canvas do
    begin
      Pen.Width := FThisPenWidth;
      Pen.Style := FThisPenStyle;
      Pen.Color := FThisLineColor;
      case FJwLineStyle of
            jlTop: begin
                     MoveTo( FThisPenWidth, FThisPenWidth );
                     LineTo( Width-FThisPenWidth, FThisPenWidth );
                   end;
         jlBottom: begin
                     MoveTo( FThisPenWidth, Height-FThisPenWidth );
                     LineTo( Width-FThisPenWidth, Height-FThisPenWidth );
                   end;
          jlRight: begin
                     MoveTo( Width-FThisPenWidth, FThisPenWidth );
                     LineTo( Width-FThisPenWidth, Height-FThisPenWidth );
                   end;
           jlLeft: begin
                     MoveTo( FThisPenWidth, FThisPenWidth );
                     LineTo( FThisPenWidth, Height-FThisPenWidth );
                   end;
        jlTopLeft: begin
                     MoveTo( FThisPenWidth, FThisPenWidth );
                     LineTo( Width-FThisPenWidth, Height-FThisPenWidth );
                   end;
        jlRightTo: begin
                     MoveTo( FThisPenWidth, Height-FThisPenWidth );
                     LineTo( Width-FThisPenWidth, FThisPenWidth );
                   end;
       jlRectangle:begin
                     MoveTo( FThisPenWidth, FThisPenWidth );
                     LineTo( Width-FThisPenWidth, FThisPenWidth );
                     LineTo( Width-FThisPenWidth, Height-FThisPenWidth );
                     LineTo( FThisPenWidth, Height-FThisPenWidth );
                     LineTo( FThisPenWidth, FThisPenWidth );
                   end;
      end;
    if FDouble then
      begin
        case FJwLineStyle of
              jlTop: begin
                       MoveTo( FThisPenWidth, FThisPenWidth+(FThisPenWidth*2) );
                       LineTo( FThisPenWidth+Width, FThisPenWidth+(FThisPenWidth*2) );
                     end;
           jlBottom: begin
                       MoveTo( FThisPenWidth, Height-FThisPenWidth-(FThisPenWidth*2) );
                       LineTo( Width-FThisPenWidth, Height-FThisPenWidth-(FThisPenWidth*2) );
                     end;
            jlRight: begin
                       MoveTo( Width-FThisPenWidth-(FThisPenWidth*2), FThisPenWidth );
                       LineTo( Width-FThisPenWidth-(FThisPenWidth*2), Height-FThisPenWidth );
                     end;
             jlLeft: begin
                       MoveTo( FThisPenWidth+(FThisPenWidth*2), FThisPenWidth );
                       LineTo( FThisPenWidth+(FThisPenWidth*2), FThisPenWidth+Height );
                     end;
          jlTopLeft: begin
                       MoveTo( FThisPenWidth, FThisPenWidth+(FThisPenWidth*2) );
                       LineTo( FThisPenWidth+Width, FThisPenWidth+Height+(FThisPenWidth*2) );
                     end;
          jlRightTo: begin
                       MoveTo( FThisPenWidth, FThisPenWidth+Height+(FThisPenWidth*2) );
                       LineTo( FThisPenWidth+Width, FThisPenWidth+(FThisPenWidth*2) );
                     end;
         jlRectangle:begin
                       MoveTo( FThisPenWidth+(FThisPenWidth*2), FThisPenWidth+(FThisPenWidth*2) );
                       LineTo( Width-(FThisPenWidth*2)-FThisPenWidth, FThisPenWidth+(FThisPenWidth*2) );
                       LineTo( Width-(FThisPenWidth*2)-FThisPenWidth, Height-(FThisPenWidth*2)-FThisPenWidth );
                       LineTo( FThisPenWidth+(FThisPenWidth*2), Height-(FThisPenWidth*2)-FThisPenWidth );
                       LineTo( FThisPenWidth+(FThisPenWidth*2), FThisPenWidth+(FThisPenWidth*2) );
                     end;

        end;
      end;
    end;
end;



end.
