unit PictEdit;

interface

uses DsgnIntf;

type
  TPictureEditor = class(TClassProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure Edit; override;
  end;

procedure Register;

implementation

uses SysUtils, Controls, Graphics, TypInfo, ImageWin, ViewWin;

function TPictureEditor.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog]
end;

procedure TPictureEditor.Edit;
begin
  with TImageForm.Create(nil) do
  try
    Image1.Picture := TPicture(GetOrdValue);
    ViewForm := TViewForm.Create(nil);
    if ShowModal = mrOk then
      if (GetPropType^.Name = 'TPicture') then
        SetOrdValue(LongInt(Image1.Picture))
      else
        SetOrdValue(LongInt(Image1.Picture.Bitmap));
  finally
    Free;
    ViewForm.Free;
  end; { finally }
end;

procedure Register;
begin
  RegisterPropertyEditor(TypeInfo(TPicture), nil, '', TPictureEditor);
  RegisterPropertyEditor(TypeInfo(TBitmap), nil, '', TPictureEditor);
end;

end.