unit Demunit5;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, WinImage;

type
  TForm1 = class(TForm)
    BitBtn1: TBitBtn;
    ScrollBox1: TScrollBox;
    ListBox1: TListBox;
    WindowImage1: TWindowImage;
    Label1: TLabel;
    Label2: TLabel;
    procedure BitBtn1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ListBox1Click(Sender: TObject);
    procedure WindowImage1Capture(Sender: TObject);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

var
   WMAX,HMAX:integer;

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
     close;
end;

procedure stretch_fit(var image:TWindowImage);
var
   width,height:integer;
   s1,s2:single;
begin
     width :=image.picture.bitmap.width;
     height:=image.picture.bitmap.height;
     if (width>WMAX) or (height>HMAX) then
        begin
             s1:=WMAX/width;
             s2:=HMAX/height;
             if s2<s1 then s1:=s2;
             width :=trunc(width*s1);
             height:=trunc(height*s1);
        end;
     image.setbounds(image.left,image.top,width,height);
end;

function getwindows(window:Hwnd;lparam:longint):bool;export;
var
   wtext:array [0..100] of char;
begin
     if iswindowvisible(window) and
        (getwindowword(window,gww_hwndparent)=0) then
        begin
             getwindowtext(window,wtext,100);
             form1.listbox1.items.add(strpas(wtext));
        end;
     getwindows:=true;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  WMAX:=windowimage1.width;      {store max width}
  HMAX:=windowimage1.height;     {store max height}
  listbox1.clear;
  enumwindows(@getwindows,0);    {wnd enum callback}
end;

procedure TForm1.ListBox1Click(Sender: TObject);
var
   window:Hwnd;
   wtext:string;
begin
     wtext:=listbox1.items[listbox1.itemindex]+#0;
     window:=findwindow(nil,@wtext[1]);
     windowimage1.picture:=nil;
     windowimage1.refresh;
     windowimage1.otherwindow:=window;
     windowimage1.getwindowimage;
     stretch_fit(windowimage1);
end;

procedure TForm1.WindowImage1Capture(Sender: TObject);
begin
     windowimage1.picture.savetofile('stuff.bmp');
end;

end.
