unit Demunit6;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, WinImage;

type
  TForm1 = class(TForm)
    BitBtn1: TBitBtn;
    WindowImage1: TWindowImage;
    Label1: TLabel;
    procedure BitBtn1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
         procedure WMUSER(var msg:Tmessage);message WM_USER;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

var
   WMAX,HMAX:integer;

procedure initialize(callerhwnd:Hwnd);far;external 'demokbhk';

procedure stretch_fit(var image:TWindowImage);
var
   width,height:integer;
   s1,s2:single;
begin
     width :=image.picture.bitmap.width;
     height:=image.picture.bitmap.height;
     if (width>WMAX) or (height>HMAX) then
        begin
             s1:=WMAX/width;
             s2:=HMAX/height;
             if s2<s1 then s1:=s2;
             width :=trunc(width*s1);
             height:=trunc(height*s1);
        end;
     image.setbounds(image.left,image.top,width,height);
end;

procedure TForm1.WMUSER(var msg:Tmessage);
begin
     windowimage1.picture:=nil;
     windowimage1.refresh;
     case msg.wparam of
          vk_f2 : begin   {capture full screen}
                          windowimage1.WActiveWindow:=false;
                          windowimage1.WClientArea:=false;
                          windowimage1.getwindowimage;
                          windowimage1.picture.savetofile('d6-full.bmp');
                  end;
          vk_f3 : begin   {capture active window}
                          windowimage1.WActiveWindow:=true;
                          windowimage1.WClientArea:=false;
                          windowimage1.getwindowimage;
                          windowimage1.picture.savetofile('d6-activ.bmp');
                  end;
          vk_f4 : begin   {capture active window client area}
                          windowimage1.WActiveWindow:=true;
                          windowimage1.WClientArea:=true;
                          windowimage1.getwindowimage;
                          windowimage1.picture.savetofile('d6-clien.bmp');
                  end;
     end;
     stretch_fit(windowimage1);
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
     close;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  WMAX:=windowimage1.width;      {store max width}
  HMAX:=windowimage1.height;     {store max height}
  windowimage1.autosize:=false;
  windowimage1.stretch:=true;
  windowimage1.otherwindow:=0;
  initialize(form1.handle);
end;

end.
