{//////////////////////////////////////////////////////////////////////////}
{////////     Borland Pascal Interface unit to WCLCODE2.DLL   /////////////}
{//////////////////////////////////////////////////////////////////////////}


Unit Wcl_Int;
{$F+,G+,K-}     {force far calls; 286 code generation; no smart callbacks }

Interface


{ these are the data structures used in WCLCODE2.DLL  }
Type
StringArray = Array[1..20] of String[79]; { Pascal String array }
MyChar      = Array[0..79] of Char;       { MyChar char[80] in C/C++ }
PCharArray  = Array[1..20] of MyChar;     { PCharArray MyChar[20] in C/C++ }


Function WclCode2Version : Word;
{ returns the version number of the current wclcode2.dll }
{   the current version is 10, and ALL future versions will have
    numbers higher than this - so you can always test for
    WclCode2Version >= 10
}

{ the exported functions }
Function BreakString(Source : String; Var sArray : StringArray) : Integer;
{* breaks up a Pascal string into an array of up to 20 Pascal substrings;
returns the number of substrings *}

Function BreakPChar(Source : PChar; Var sArray : PCharArray) : Integer;
{* breaks up a null terminated string into an array of up to 15 null terminated
substrings;  returns the number of substrings *}

Function TrimString(s : string) : string;
{* trims a Pascal string; returns trimmed string *}

Function TrimPChar(VAR P : PChar) : Integer;
{* trims a null terminated string; returns trimmed string in P *}

Function WinExecWait (Pname: PChar; ShowCmd : Integer) : Word;
{*  similar to WinExec() - but waits until the EXECed program
    terminates  - the "wait" part fails under OS/2 - and probably
    Windows NT in the sense that it returns immediately - like WinExec()
*}


Procedure ShowHourGlass;
{* shows the infamous hour glass *}

Procedure RestoreCursor;
{* restores the cursor to Arrow *}

Implementation
{////////////////////////////////////////////////////////////////////////////////}
{////////////////////////////////////////////////////////////////////////////////}

Function BreakString(Source : String; Var sArray : StringArray) : Integer;
External 'WCLCODE2' index 10;
{////////////////////////////////////////////////////////////////////////////////}
{////////////////////////////////////////////////////////////////////////////////}

Function BreakPChar(Source : PChar; Var sArray : PCharArray) : Integer;
External 'WCLCODE2' index 11;
{////////////////////////////////////////////////////////////////////////////////}
{////////////////////////////////////////////////////////////////////////////////}

Function TrimString(s : string) : string;
External 'WCLCODE2' index 12;

{////////////////////////////////////////////////////////////////////////////////}
{////////////////////////////////////////////////////////////////////////////////}

Function TrimPChar(VAR P : PChar) : Integer;
External 'WCLCODE2' index 13;

{////////////////////////////////////////////////////////////////////////////////}
{////////////////////////////////////////////////////////////////////////////////}

Function WinExecWait (Pname: PChar; ShowCmd : Integer) : Word;
External 'WCLCODE2' index 14;
{////////////////////////////////////////////////////////////////////////////////}
{////////////////////////////////////////////////////////////////////////////////}

Procedure ShowHourGlass;
External 'WCLCODE2' index 15;
{////////////////////////////////////////////////////////////////////////////////}
{////////////////////////////////////////////////////////////////////////////////}


Procedure RestoreCursor;
External 'WCLCODE2' index 16;
{////////////////////////////////////////////////////////////////////////////////}
{////////////////////////////////////////////////////////////////////////////////}


Function WclCode2Version : Word;
External 'WCLCODE2' index 100;
{////////////////////////////////////////////////////////////////////////////////}
{////////////////////////////////////////////////////////////////////////////////}


End.