{$A+,B-,D-,F-,G+,I-,K+,L-,N+,P+,Q-,R-,S+,T-,V+,W-,X+,Y-}
{$M 16384,8192}
library Mapi;

uses
  WinTypes, Dialogs, WinProcs, SysUtils, IniFiles;

const
   mapi_orig              = 0;             (* Recipient is message originator *)
   mapi_to                = 1;             (* Recipient is a primary recipient *)
   mapi_cc                = 2;             (* Recipient is a copy recipient *)
   mapi_bcc               = 3;             (* Recipient is blind copy recipient *)

   mapi_ole               = $00000001;     (* Attachment is OLE *)
   mapi_ole_static        = $00000002;     (* Use with mapi_ole, static object *)

   mapi_unread            = $00000001;
   mapi_receipt_requested = $00000002;
   mapi_sent              = $00000004;

   mapi_logon_ui          = $00000001;     (* Display logon UI *)
   mapi_new_session       = $00000002;     (* Do not use default. *)
   mapi_dialog            = $00000008;     (* Display a send note UI *)
   mapi_unread_only       = $00000020;     (* Only unread messages *)
   mapi_envelope_only     = $00000040;     (* Only header information *)
   mapi_peek              = $00000080;     (* Do not mark as read. *)
   mapi_guarantee_fifo    = $00000100;     (* use date order *)
   mapi_body_as_file      = $00000200;
   mapi_ab_nomodify       = $00000400;     (* Don't allow mods of AB entries *)
   mapi_suppress_attach   = $00000800;     (* Header + body, no files *)
   mapi_force_download    = $00001000;     (* Force download of new mail during MAPILogon *)


type
   tflags = longint;
   ulong = longint;
   lhandle = longint;

   plhandle = ^lhandle;
   pulong = ^ulong;

   pMapiFileDesc = ^tMapiFileDesc;
   tMapiFileDesc = record
      ulReserved : longint;         (* Reserved for future use (must be 0) *)
      flFlags : tflags;             (* Flags *)
      nPosition : longint;          (* Character in text to be replaced by attachment *)
      lpszPathName : pchar;         (* Full path name of attachment file *)
      lpszFileName : pchar;         (* Original file name (optional) *)
      lpFileType : pointer;         (* Attachment file type (optional) *)
   end;

   pMapiRecipDesc = ^tMapiRecipDesc;
   tMapiRecipDesc = record
      ulReserved : longint;         (* Reserved for future use *)
      ulRecipClass : longint;       (* Recipient class MAPI_TO, MAPI_CC, MAPI_BCC, MAPI_ORIG *)
      lpszName : pchar;             (* Recipient name *)
      lpszAddress : pchar;          (* Recipient address (optional) *)
      ulEIDSize : longint;          (* Count in bytes of size of pEntryID *)
      lpEntryID : pointer;          (* System-specific recipient reference *)
   end;

   pMapiMessage = ^tMapiMessage;
   tMapiMessage = record
      ulReserved : longint;               (* Reserved for future use (must be 0) *)
      lpszSubject : pchar;                (* Message Subject *)
      lpszNoteText : pchar;               (* Message Text *)
      lpszMessageType : pchar;            (* Message Class *)
      lpszDateReceived : pchar;           (* In YYYY/MM/DD HH:MM format *)
      lpszConversationID : pchar;         (* Conversation thread ID *)
      flFlags : tflags;                   (* Unread,return receipt *)
      lpOriginator : pMapiRecipDesc;      (* Originator descriptor *)
      nRecipCount : ulong;                (* Number of recipients *)
      lpRecips : pMapiRecipDesc;          (* Recipient descriptors *)
      nFileCount : ulong;                 (* # of file attachments *)
      lpFiles : pMapiFileDesc;            (* Attachment descriptors *)
   end;

const                                                 (* error codes *)
   success_success                 = 0;
   mapi_user_abort                 = 1;
   mapi_e_failure                  = 2;
   mapi_e_login_failure            = 3;
   mapi_e_disk_full                = 4;
   mapi_e_insufficient_memory      = 5;
   mapi_e_access_denied            = 6;
   mapi_e_too_many_sessions        = 8;
   mapi_e_too_many_files           = 9;
   mapi_e_too_many_recipients      = 10;
   mapi_e_attachment_not_found     = 11;
   mapi_e_attachment_open_failure  = 12;
   mapi_e_attachment_write_failure = 13;
   mapi_e_unknown_recipient        = 14;
   mapi_e_bad_reciptype            = 15;
   mapi_e_no_messages              = 16;
   mapi_e_invalid_message          = 17;
   mapi_e_text_too_large           = 18;
   mapi_e_invalid_session          = 19;
   mapi_e_type_not_supported       = 20;
   mapi_e_ambiguous_recipient      = 21;
   mapi_e_message_in_use           = 22;
   mapi_e_network_failure          = 23;
   mapi_e_invalid_editfields       = 24;
   mapi_e_invalid_recips           = 25;
   mapi_e_not_supported            = 26;

var
  INIFile: TINIFile;
  INIFileName: String;
  MailProgram: String;
  ToSyntax: String;
  CmdLine: array[0..256] of char;
  OldExitProc: Pointer;
  DebugLevel: Integer;
  ProgHandle: THandle;


function Substitute(BigString, OldSubString, NewSubString: String): String;
var Position: Byte;
begin
  Position := Pos(OldSubString, BigString);
  if Position > 0 then begin
    Delete(BigString, Position, Length(OldSubString));
    Insert(NewSubString, BigString, Position);
  end;
  Result := BigString;
end;

function MAPILogon (ulUIParam : ulong;
                    lpszName, lpszPassword : pchar;
                    flFlags : tflags;
                    ulReserved : ulong;
                    lplhSession : plhandle) : ulong; export;
begin
  StrPCopy(CmdLine, MailProgram);
  if DebugLevel > 1 then
    ShowMessage('Logon: Invoking ' + StrPas(CmdLine));
  ProgHandle := WinExec(CmdLine, SW_SHOWMINIMIZED);
  if ProgHandle < HINSTANCE_ERROR then begin
    ShowMessage('Error ' + IntToStr(ProgHandle) + ' executing '
      + StrPas(CmdLine));
    Result := mapi_e_failure;
  end else
    Result := success_success;
end;

function MAPILogoff (lhSession : lhandle;
                     ulUIParam : ulong;
                     flFlags : tflags;
                     ulReserved : ulong) : ulong; export;
begin
  Result := success_success;
end;

function MAPISendMail (lhSession : lhandle;
                       ulUIParam : ulong;
                       lpMessage : pMapiMessage;
                       flFlags : tflags;
                       ulReserved : ulong) : ulong; export;
begin
  if lpMessage^.nRecipCount = 0 then
    StrPCopy(CmdLine, MailProgram)
  else
    StrPCopy(CmdLine, MailProgram
      + Substitute(ToSyntax,'%s',StrPas(lpMessage^.lpRecips^.lpszName)));
  if DebugLevel > 1 then
    ShowMessage('Send Mail: Invoking ' + StrPas(CmdLine));
  ProgHandle := WinExec(CmdLine, SW_SHOW);
  if ProgHandle < HINSTANCE_ERROR then begin
    ShowMessage('Error ' + IntToStr(ProgHandle) + ' executing '
      + StrPas(CmdLine));
    Result := mapi_e_failure;
  end else
    Result := success_success;
end;

function MAPISendDocuments (ulUIParam : ulong;
                            lpszDelimChar : pchar;
                            lpszFilePaths : pchar;
                            lpszFileNames : pchar;
                            ulReserved : ulong) : ulong; export;
begin
  ShowMessage('Send documents not supported.');
  Result := mapi_e_not_supported;
end;

function MAPIFindNext (lhSession : lhandle;
                       ulUIParam : ulong;
                       lpszMessageType, lpszSeedMessageID : pchar;
                       flFlags : tflags;
                       ulReserved : ulong;
                       lpszMessageID : pchar) : ulong; export;
begin
  if DebugLevel > 0 then
    ShowMessage('Find next not supported');
  Result := mapi_e_not_supported;
end;

function MAPIReadMail (lhSession : lhandle;
                       ulUIParam : ulong;
                       lpszMessageID : pchar;
                       flFlags : tflags;
                       ulReserved : ulong;
                       lppMessageOut : pMapiMessage) : ulong; export;
begin
  if DebugLevel > 0 then
    ShowMessage('Read mail not supported');
  Result := mapi_e_not_supported;
end;

function MAPISaveMail (lhSession : lhandle;
                       ulUIParam : ulong;
                       pMessage : pMapiMessage;
                       flFlags : tflags;
                       ulReserved : ulong;
                       lpszMessageID : pchar) : ulong; export;
begin
  if DebugLevel > 0 then
    ShowMessage('Save mail not supported');
  Result := mapi_e_not_supported;
end;

function MAPIDeleteMail (lhSession : lhandle;
                         ulUIParam : ulong;
                         lpszMessageID : pchar;
                         flFlags : tflags;
                         ulReserved : ulong) : ulong; export;
begin
  if DebugLevel > 0 then
    ShowMessage('Delete mail not supported');
  Result := mapi_e_not_supported;
end;

function MAPIFreeBuffer (pv : pointer) : ulong; export;
begin
  if DebugLevel > 0 then
    ShowMessage('Free buffer not supported');
  Result := mapi_e_not_supported;
end;

function MAPIAddress (lhSession : lhandle;
                      ulUIParam : ulong;
                      plszCaption : pchar;
                      nEditFields : ulong;
                      lpszLabels : pchar;
                      nRecips : ulong;
                      lpRecips : pMapiRecipDesc;
                      flFlags : tflags;
                      ulReserved : ulong;
                      lpnNewRecips : pUlong;
                      lppNewRecips : pMapiRecipDesc) : ulong; export;
begin
  if DebugLevel > 0 then
    ShowMessage('Address not supported');
  Result := mapi_e_not_supported;
end;

function MAPIDetails (lhSession : lhandle;
                      ulUIParam : lhandle;
                      lpRecip : pMapiRecipDesc;
                      flFlags : tflags;
                      ulReserved : ulong) : ulong; export;
begin
  if DebugLevel > 0 then
    ShowMessage('Details not supported');
  Result := mapi_e_not_supported;
end;

function MAPIResolveName (lhSession : lhandle;
                          ulUIParam : ulong;
                          lpszName : pchar;
                          flFlags : tflags;
                          ulReserved : ulong;
                          lppRecip : pMapiRecipDesc) : ulong; export;
begin
  if DebugLevel > 0 then
    ShowMessage('Resolve name not supported');
  Result := mapi_e_not_supported;
end;

procedure MyExitProc; far;
begin
  INIFile.Free;
  ExitProc := OldExitProc;
end;

{$R *.RES}

exports
  MAPILogon index 1,
  MAPILogoff index 2,
  MAPISendMail index 3,
  MAPISendDocuments index 4,
  MAPIFindNext index 5,
  MAPIReadMail index 6,
  MAPISaveMail index 7,
  MAPIDeleteMail index 8,
  MAPIFreeBuffer index 9,
  MAPIAddress index 10,
  MAPIDetails index 11,
  MAPIResolveName index 12;

begin
  INIFileName := Substitute(ParamStr(0), '.DLL', '.INI');
  INIFile := TINIFile.Create(INIFileName);
  DebugLevel := INIFile.ReadInteger('Options','Debug Level',1);
  if DebugLevel > 1 then
    ShowMessage('Config read from ' + INIFileName);
  OldExitProc := ExitProc;
  ExitProc := @MyExitProc;
  MailProgram := INIFile.ReadString('Mailer','Program','');
  if MailProgram = '' then
    ShowMessage('No definition for Program in Mailer section of ' + INIFileName);
  ToSyntax := ' ' + INIFile.ReadString('Mailer','ToSyntax','');
  if ToSyntax = '' then begin
    if DebugLevel > 0 then
      ShowMessage('No definition for To Syntax in Mailer section of ' + INIFileName)
  end else
    ToSyntax := ' ' + ToSyntax;
end.
