unit Unit9;

interface

uses
  {$IfDef Win32} Windows, {$Else} WinTypes, WinProcs, {$EndIf}
  Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, T_TETRIS;

type
  TForm9 = class(TForm)
    Timer1: TTimer;
    Label1: TLabel;
    Label2: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Memo1: TMemo;
    Label3: TLabel;
    LCP: TLabel;
    Label4: TLabel;
    LDL: TLabel;
    Label7: TLabel;
    LDLT: TLabel;
    Label8: TLabel;
    LCL: TLabel;
    Panel1: TPanel;
    TETRIS1: TTETRIS;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    Label9: TLabel;
    LSCO: TLabel;
    CheckBox3: TCheckBox;
    Label10: TLabel;
    Label11: TLabel;
    Edit1: TEdit;
    procedure Timer1Timer(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure CheckBox2Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure CheckBox3Click(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    SCORE:LONGINT;
    LEVEL:INTEGER;
    NUMLINE:INTEGER;{ NUMBER OF DELETED LINES}
    PROCEDURE SET_SCR(SPEED,SN:INTEGER);
    PROCEDURE ADD_NOISE;
  public
    { Public declarations }
  end;

var
  Form9: TForm9;

implementation

{$R *.DFM}

PROCEDURE TForm9.ADD_NOISE;
 VAR
  R1:INTEGER;
 BEGIN
  IF NUMLINE<80 THEN
   R1:=30
  ELSE
   IF NUMLINE<105 THEN
    R1:=20
   ELSE
   IF NUMLINE<120 THEN
    R1:=15
   ELSE
    R1:=10;
  {ADD A PIECE ON A COLUMN}
  IF RANDOM(R1)<=R1 DIV 2 THEN
   TETRIS1.SET_PIECE(RANDOM(9),-1,RGB(125,125,125));
  IF LEVEL>7 THEN
   BEGIN
    {ADD A LINE ON THE BOTTOM OF THE SCREEN}
    IF RANDOM(R1)=0 THEN
     TETRIS1.INSERT_LINE(RANDOM(9),RGB(RANDOM(200)+55,RANDOM(200)+55,RANDOM(200)+55));
   END;
  IF LEVEL>8 THEN
   BEGIN
    {ADD A PIECE SOMEWHERE IN THE SCREEN}
    IF RANDOM(R1)<=R1 DIV 2 THEN
     TETRIS1.SET_PIECE(RANDOM(9),RANDOM(19)+1,RGB(125,125,125));
   END;
 END;

PROCEDURE TForm9.SET_SCR(SPEED,SN:INTEGER);
 BEGIN
  TIMER1.ENABLED:=FALSE;
  TIMER1.INTERVAL:=SPEED;
  SHOWMESSAGE('Changing level...'+#13+'Free lines = '+INTTOSTR(TETRIS1.GET_FREE_LINES(TRUE)));
  IF SN<6 THEN
   TETRIS1.SCREENNUMBER:=SN
  ELSE
   TETRIS1.SCREENNUMBER:=0;
  TIMER1.ENABLED:=TRUE;
  LEVEL:=SN;
  LCL.CAPTION:=INTTOSTR(LEVEL);
 END;

procedure TForm9.Timer1Timer(Sender: TObject);
begin
 CASE TETRIS1.MOVE_DOWN OF
  0:BEGIN
     {NO THING TO DO...}
    END;
  1:BEGIN
     {THE CURRENT PIECE CAN NOT CONTINUE TO GO DOWN...}
     INC(SCORE,TETRIS1.GET_FREE_LINES(FALSE));
     LCP.CAPTION:=INTTOSTR(TETRIS1.NUMBEROFPIECES);
     LDL.CAPTION:=INTTOSTR(TETRIS1.LASTDELETEDLINE);
     INC(SCORE,(LEVEL+1)*4*TETRIS1.LASTDELETEDLINE);
     INC(NUMLINE,TETRIS1.LASTDELETEDLINE);
     LDLT.CAPTION:=INTTOSTR(NUMLINE);
     {NOW CHECK IF YOU MUST CHANGE LEVEL...}
     IF (NUMLINE>=8) AND (LEVEL=0) THEN
      SET_SCR(800,1)
     ELSE
      IF (NUMLINE>=20) AND (LEVEL=1) THEN
       SET_SCR(650,2)
      ELSE
       IF (NUMLINE>=33) AND (LEVEL=2) THEN
        SET_SCR(500,3)
       ELSE
        IF (NUMLINE>=44) AND (LEVEL=3) THEN
         SET_SCR(350,4)
        ELSE
         IF (NUMLINE>=55) AND (LEVEL=4) THEN
          SET_SCR(200,5)
         ELSE
          IF (NUMLINE>=66) AND (LEVEL=5) THEN
           SET_SCR(150,6)
          ELSE
           IF (NUMLINE>=80) AND (LEVEL=6) THEN
            SET_SCR(150,7)
           ELSE
            IF (NUMLINE>=100) AND (LEVEL=7) THEN
             SET_SCR(150,8)
            ELSE
             IF (NUMLINE>=120) AND (LEVEL=8) THEN
              SET_SCR(150,9);
      IF LEVEL>5 THEN
       ADD_NOISE;
    END;
  2:BEGIN {DOPO CHE SI E' FERMATO E' FINITA LA PARTITA}
     TIMER1.ENABLED:=FALSE;
     SHOWMESSAGE('You lose...');
     EDIT1.ENABLED:=TRUE;
    END;
 END;
 LSCO.CAPTION:=INTTOSTR(SCORE);
end;

procedure TForm9.FormKeyPress(Sender: TObject; var Key: Char);
begin
 case key of
  'n','N':begin
           {INITIALIZE SOMETHING}
           TETRIS1.SCREENNUMBER:=0;
           SCORE:=0;
           LEVEL:=0;
           NUMLINE:=0;
           TETRIS1.NEW_GAME;
           TIMER1.INTERVAL:=1000;
           TIMER1.ENABLED:=TRUE;
           EDIT1.ENABLED:=FALSE;
          end;
  '1':TETRIS1.MOVE_DOWN;
  '4':TETRIS1.MOVE_LEFT;
  '6':TETRIS1.MOVE_RIGHT;
  '5':TETRIS1.ROTATE_LEFT;
  '8':TETRIS1.ROTATE_RIGHT;
  '2':INC(SCORE,TETRIS1.SEND_BOTTOM);
 end;
end;

procedure TForm9.CheckBox2Click(Sender: TObject);
begin
 TETRIS1.SHOWFILLCOLOR:=CHECKBOX2.CHECKED;
end;

procedure TForm9.CheckBox1Click(Sender: TObject);
begin
TETRIS1.SHOWBORDERCOLOR:=CHECKBOX1.CHECKED;
end;

procedure TForm9.CheckBox3Click(Sender: TObject);
begin
 TETRIS1.SHOWNEXTPIECE:=CHECKBOX3.CHECKED;
end;

procedure TForm9.TrackBar1Change(Sender: TObject);
begin
{ TETRIS1.PREVIEWSIZE:=TRACKBAR1.POSITION;}
end;

procedure TForm9.Edit1Change(Sender: TObject);
begin
 TETRIS1.PREVIEWCAPTION:=EDIT1.TEXT;
end;

procedure TForm9.FormCreate(Sender: TObject);
begin
 TETRIS1.MOVE_PREVIEW(50,50);
end;

end.
