#include <windows.h>
#include <string.h>
#include <stdlib.h>
#include "..\convert.h"

const char	szEnd[] = "END";
const char	szBitPix[] = "BITPIX";
const char	szNAxis[] = "NAXIS";
const char	szNAxis1[] = "NAXIS1";
const char	szNAxis2[] = "NAXIS2";
const char	szNAxis3[] = "NAXIS3";
const char	szNAxis4[] = "NAXIS4";
const char	szSimple[] = "SIMPLE";

#define INT_LEN	20
#define COMPLEX_LEN	20
#define FLOAT_LEN	20
typedef struct _tagCnvData
{ 
	LONG	lDataOffset;
} CNVDATA;
												   
typedef struct _tagBOOLData
{
	char	pad[19];
	char	value[1];
	char	comment[50];
} BOOLDATA;

typedef struct _tagIntData
{
	char	value[INT_LEN];
	char	comment[70-INT_LEN];
} INTDATA;

typedef struct _tagFloatData
{
	char	value[FLOAT_LEN];
	char	comment[70-FLOAT_LEN];
} FLOATDATA;

typedef struct _tagComplexData
{
	char	pad[20];
	char	value[COMPLEX_LEN];
	char	comment[50-COMPLEX_LEN];
} COMPLEXDATA;    
    
typedef struct _tagFITSCard
{
	char	keyword[8];
	char	indicator[2];
	union	
	{
		BOOLDATA		b;
		INTDATA		i;
		FLOATDATA	f;
		COMPLEXDATA	c;
	} data;
} FITSCARD;       

char *GetSZData(char *szData, char *cPadData)
{
	int	i,j;         
	
	i =0;
	while (i<INT_LEN && *(cPadData+i)==' ')
		i++;
	
	j =0;	
	while (i<INT_LEN)          
	{
		szData[j] = *(cPadData+i);
		i++; j++;
	}
	szData[j] = 0;
	
	return szData;
}

int GetIntData(char *cIntData)
{	
	char	szWork[INT_LEN+1];
	
	GetSZData(szWork, cIntData);
	
	return (WORD)atol(szWork);
}

double GetFloatData(char *cFloatData)
{
   char	szWork[FLOAT_LEN+1];
   
   GetSZData(szWork, cFloatData);
   
   return atof(szWork);
}

#define GetBoolData(cBool)	(*cBool == 'T' ? TRUE : FALSE )


void CALLBACK _export GetInfo(LPCONVERTERINFO lpCnv, LPCSTR lpstrProfileName)
{
	lstrcpy(lpCnv->szDescription, "F.I.T.S. File");
	lstrcpy(lpCnv->szExtension, "fts");
	lpCnv->wCaps = CC_READ;
	lpCnv->dwMem = sizeof(CNVDATA) ;
}

BOOL CALLBACK _export ReadRow(WORD wRow, WORD wFrame, WORD wSequence, LPIMAGEINFO lpImg, CNVDATA far *lpCnv, char huge *lpBuffer)
{  	                                                                                  
	BOOL		bRet;
	LONG		lLineLength;    
	char		*pIntBuffer;
	WORD		i;
	LONG		lPos;
		   
   lLineLength = (LONG)DATABYTES(lpImg->iDataType) * (LONG)lpImg->wWidth;	            	
	
	pIntBuffer = (char *)malloc((size_t)lLineLength);
	lPos =		lpCnv->lDataOffset + 												// beginning of data dump
					lLineLength * (LONG)lpImg->wWidth * (LONG)(wFrame-1) +	// beginning of frame
					lLineLength * wRow;													// row in frame
	
	bRet = (_llseek(lpImg->hFile, lPos,0) == lPos);
					
	if (bRet)	
		bRet = (_hread(		lpImg->hFile, 
								pIntBuffer,
								lLineLength
						) == lLineLength);  
	 
	if (bRet)
	{
		switch (DATABYTES(lpImg->iDataType))
		{
			case	1:	// 8-bit
				hmemcpy(lpBuffer, pIntBuffer, lLineLength);
				break;
	
			case 2:	// 16-bit (word)		
				for (i=0; i<(WORD)lLineLength; i+=2)
				{
					lpBuffer[i] = pIntBuffer[i+1];
					lpBuffer[i+1] = pIntBuffer[i];
				}
			break;
			
			case 4:	// 32-bit (dword, float)						
				for (i=0; i<(WORD)lLineLength; i+=4)
				{
					lpBuffer[i] = pIntBuffer[i+3];
					lpBuffer[i+1] = pIntBuffer[i+2];
					lpBuffer[i+2] = pIntBuffer[i+1];
					lpBuffer[i+3] = pIntBuffer[i];
				}
			break;
			
			case 8:	// 64-bit (double)			
				for (i=0; i<(WORD)lLineLength; i+= 8)
				{  				
					lpBuffer[i] = pIntBuffer[i+7];
					lpBuffer[i+1] = pIntBuffer[i+6];
					lpBuffer[i+2] = pIntBuffer[i+5];
					lpBuffer[i+3] = pIntBuffer[i+4];
					lpBuffer[i+4] = pIntBuffer[i+3];
					lpBuffer[i+5] = pIntBuffer[i+2];
					lpBuffer[i+6] = pIntBuffer[i+1];
					lpBuffer[i+7] = pIntBuffer[i];
				}
			break;
			
		}  	// end switch
	}	// end if bRet
	free(pIntBuffer);
	return bRet;					
}

#define FF_BITPIX		0x0001
#define FF_NAXIS		0x0002
#define FF_NAXIS1		0x0004
#define FF_NAXIS2		0x0008
#define FF_NAXIS3		0x0010
#define FF_NAXIS4		0x0020

BOOL CALLBACK _export ReadHeader(LPIMAGEINFO lpImg, CNVDATA far *lpCnv)
{
	BOOL bOK;
	FITSCARD		fc;
	int	iData;
	WORD		wFlags = 0;
	
	if (_llseek(lpImg->hFile, 0, 0)==HFILE_ERROR)
		return 0;
	
	if (	_lread(lpImg->hFile, &fc, sizeof(FITSCARD))!=sizeof(FITSCARD) ||
			strncmp(fc.keyword, szSimple,sizeof(szSimple)-1)!=0)	
		return FALSE;
		
	lpImg->wNumFrames = 1;
	lpImg->wNumSequences = 1;
	
	while (	_lread(lpImg->hFile, &fc, sizeof (FITSCARD))==sizeof(FITSCARD))				
	{
		if (strncmp(fc.keyword, szEnd, sizeof(szEnd)-1)==0)
		{
				// 
				//	Make sure that BITPIX, NAXIS and NAXIS1 and NAXIS2 have been read
				//
			bOK = 	((wFlags&(FF_BITPIX|FF_NAXIS|FF_NAXIS1|FF_NAXIS2)) == 
							(FF_BITPIX|FF_NAXIS|FF_NAXIS1|FF_NAXIS2)) ;
			
			bOK = bOK && (lpImg->wHeight>0 && lpImg->wWidth >0);
							                                               
			bOK = bOK && (lpImg->wNumFrames==1 || (wFlags&FF_NAXIS3 && lpImg->wNumFrames>1));
			
			bOK = bOK && (lpImg->wNumSequences==1 || (wFlags&FF_NAXIS4 && lpImg->wNumSequences>1));
						
			bOK = bOK && ((lpCnv->lDataOffset = _llseek(lpImg->hFile, 0, 1)) != HFILE_ERROR);
			
			if (lpCnv->lDataOffset%2880)
				lpCnv->lDataOffset += 2880-(lpCnv->lDataOffset%2880);
					
			return bOK;		
		}
			
		if (strncmp(fc.keyword, szBitPix, sizeof(szBitPix)-1) == 0)
		{
			switch(GetIntData(fc.data.i.value))
			{
				case 8:	lpImg->iDataType = U_BYTE; break;
				case 16:	lpImg->iDataType = U_WORD;	break;
				case 32: lpImg->iDataType = U_DWORD;	break;
				case -32: lpImg->iDataType = FLOAT;	break;
				case -64: lpImg->iDataType = DOUBLE; break;
				default: return FALSE;
			}        
			wFlags |= FF_BITPIX;
			continue;
		}
		
		if (strncmp(fc.keyword, szNAxis1, sizeof(szNAxis1)-1)==0)
		{
			lpImg->wWidth = GetIntData(fc.data.i.value);
			wFlags |= FF_NAXIS1;
			continue;
		}
		
		if (strncmp(fc.keyword, szNAxis2, sizeof(szNAxis2)-1)==0)
		{
			lpImg->wHeight = GetIntData(fc.data.i.value);
			wFlags |= FF_NAXIS2;
			continue;
		}
		
		if (strncmp(fc.keyword, szNAxis3, sizeof(szNAxis3)-1)==0)
		{
			lpImg->wNumFrames = GetIntData(fc.data.i.value);
			wFlags |= FF_NAXIS3;
			continue;
		}
		
		if (strncmp(fc.keyword, szNAxis4, sizeof(szNAxis4)-1)==0)
		{
			lpImg->wNumSequences = GetIntData(fc.data.i.value);
			wFlags |= FF_NAXIS4;
			continue;
		}                     		
		
		if (strncmp(fc.keyword, szNAxis, sizeof(szNAxis)-1)==0)
		{
			iData = GetIntData(fc.data.i.value);
			if (iData<2 || iData >4)
				return FALSE;		// <2D or >4D		
			wFlags |= FF_NAXIS;
			continue;
		}
	}
	
	
	return bOK;
	
}       







/***************************************************************************
 *
 *
 * LibMain()
 *
 *
 *--------------------------------------------------------------------------
 */
int FAR PASCAL LibMain( // DLL initialization, returns always 1
	HANDLE  hInst,      // handle to instance of App that required this DLL.
	WORD    wDataSeg,   // number of words in DLL's data segment.
	WORD    wHeapSize,  // number of bytes in DLL's heap.
	LPSTR   lpszCmdLine)// command line for App that required this DLL.
{  	
	if (wHeapSize > 0)
		UnlockData(0);
	return(1);
}

int CALLBACK WEP(int nExitType)
{
 	return TRUE;
}
