////////////////////////////////////////////////////////////////////////////////
// HTML2TXT.CPP  By Gregory Kwok <gkwok@jps.net>
// Another 10-minute utility by GK
//
// 1.00 07 Jan 1995 First version (only 15 lines of code!)
// 1.10 14 Jan 1997 Added removal &..; entities, more efficient structure
// 2.00 28 Jan 1997 &..; entities now converted into ANSI or ASCII equivalents
// 2.00 26 Nov 1997 Recompiled with DJGPP 32-bit compiler
// 2.01 16 Feb 1998 Handles unknown entities better (or those without a ; )
////////////////////////////////////////////////////////////////////////////////

// Include files
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Function prototypes
int parseCmdLine(int , char*[] , int* );
int convertEntity(int );
#define until(cond) while (!(cond))

////////////////////////////////////////////////////////////////////////////////
int main(int argc, char* argv[])
{
  int useansi;                                   // How to output entities
  char c;

  parseCmdLine(argc, argv, &useansi);

  do {
    c = getchar();
    switch (c) {
      case '<': while (c != '>' && c != EOF) c = getchar(); break;
      case '&': putchar(convertEntity(useansi)); break;
      default:  putchar(c);
    }
  } while (c != EOF);

  return 0;
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
int parseCmdLine(int argc, char* argv[], int* amode)
{
  *amode = 1;                                    // This is 1 for ANSI, 0 for ASCII

  if (argc > 1) {
    if (!strcmp(argv[1], "/?") || !strcmp(argv[1], "-?")) {
      printf("\nHTML2TXT.CPP v2.01 \xfe By Gregory Kwok <gkwok@jps.net>\n"
             "\nSyntax: HTML2TXT [{/ANSI | /ASCII}] < infile.htm > outfile.txt"
             "\nIf neither /ansi or /ascii is specified, /ansi is assumed\n");
      exit(1);
    }
    else if (!stricmp(argv[1], "/ascii") || !stricmp(argv[1], "-ascii"))
      *amode = 0;
  }

  return *amode;
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// Character to output if no ASCII equivalent
#define UNK '~'
int convertEntity(int ansi)
{
  static char entity[256];
  char* ep = entity;

  while ((*ep = getchar()) != ';' && *ep != ' ' && *ep != '\n' && *ep != EOF)
    ep++;

  *++ep = '\0';

  // Special cases before we take care of regular entities
  if (entity[strlen(entity) - 1] != ';') {       // Not valid, doesn't end with ;
    putchar('&');                                // Just pass the whole thing on
    ep = entity;                                 // This is puts() without the \n
    while (*(ep + 1))
      putchar(*ep++);
    return *ep;
  }

  // The following entities taken from http://www.w3.org/pub/WWW/TR/REC-html32.html
  else if (!strcmp(entity, "quot;")   || !strcmp(entity, "#34;"))  return '\"';
  else if (!strcmp(entity, "amp;")    || !strcmp(entity, "#38;"))  return '&';
  else if (!strcmp(entity, "lt;")     || !strcmp(entity, "#60;"))  return '<';
  else if (!strcmp(entity, "gt;")     || !strcmp(entity, "#62;"))  return '>';
  else if (!strcmp(entity, "nbsp;")   || !strcmp(entity, "#160;")) return (ansi ? 160 : ' ');
  else if (!strcmp(entity, "iexcl;")  || !strcmp(entity, "#161;")) return (ansi ? 161 : 173);
  else if (!strcmp(entity, "cent;")   || !strcmp(entity, "#162;")) return (ansi ? 162 : 155);
  else if (!strcmp(entity, "pound;")  || !strcmp(entity, "#163;")) return (ansi ? 163 : 156);
  else if (!strcmp(entity, "curren;") || !strcmp(entity, "#164;")) return (ansi ? 164 : 'o');
  else if (!strcmp(entity, "yen;")    || !strcmp(entity, "#165;")) return (ansi ? 165 : 157);
  else if (!strcmp(entity, "brvbar;") || !strcmp(entity, "#166;")) return (ansi ? 166 : '|');
  else if (!strcmp(entity, "sect;")   || !strcmp(entity, "#167;")) return (ansi ? 167 : 'S');
  else if (!strcmp(entity, "uml;")    || !strcmp(entity, "#168;")) return (ansi ? 168 : UNK);
  else if (!strcmp(entity, "copy;")   || !strcmp(entity, "#169;")) return (ansi ? 169 : 'c');
  else if (!strcmp(entity, "ordf;")   || !strcmp(entity, "#170;")) return (ansi ? 170 : 166);
  else if (!strcmp(entity, "laquo;")  || !strcmp(entity, "#171;")) return (ansi ? 171 : 174);
  else if (!strcmp(entity, "not;")    || !strcmp(entity, "#172;")) return (ansi ? 172 : 170);
  else if (!strcmp(entity, "shy;")    || !strcmp(entity, "#173;")) return (ansi ? 173 : '-');
  else if (!strcmp(entity, "reg;")    || !strcmp(entity, "#174;")) return (ansi ? 174 : 'r');
  else if (!strcmp(entity, "macr;")   || !strcmp(entity, "#175;")) return (ansi ? 175 : UNK);
  else if (!strcmp(entity, "deg;")    || !strcmp(entity, "#176;")) return (ansi ? 176 : 248);
  else if (!strcmp(entity, "plusmn;") || !strcmp(entity, "#177;")) return (ansi ? 177 : 241);
  else if (!strcmp(entity, "sup2;")   || !strcmp(entity, "#178;")) return (ansi ? 178 : 253);
  else if (!strcmp(entity, "sup3;")   || !strcmp(entity, "#179;")) return (ansi ? 179 : UNK);
  else if (!strcmp(entity, "acute;")  || !strcmp(entity, "#180;")) return (ansi ? 180 : '\'');
  else if (!strcmp(entity, "micro;")  || !strcmp(entity, "#181;")) return (ansi ? 181 : 230);
  else if (!strcmp(entity, "para;")   || !strcmp(entity, "#182;")) return (ansi ? 182 : 'P');
  else if (!strcmp(entity, "middot;") || !strcmp(entity, "#183;")) return (ansi ? 183 : 249);
  else if (!strcmp(entity, "cedil;")  || !strcmp(entity, "#184;")) return (ansi ? 184 : ','); // The file says "&ccedil;" but that is already #231
  else if (!strcmp(entity, "sup1;")   || !strcmp(entity, "#185;")) return (ansi ? 185 : UNK);
  else if (!strcmp(entity, "ordm;")   || !strcmp(entity, "#186;")) return (ansi ? 186 : 167);
  else if (!strcmp(entity, "raquo;")  || !strcmp(entity, "#187;")) return (ansi ? 187 : 175);
  else if (!strcmp(entity, "frac14;") || !strcmp(entity, "#188;")) return (ansi ? 188 : 172);
  else if (!strcmp(entity, "frac12;") || !strcmp(entity, "#189;")) return (ansi ? 189 : 171);
  else if (!strcmp(entity, "frac34;") || !strcmp(entity, "#190;")) return (ansi ? 190 : UNK);
  else if (!strcmp(entity, "iquest;") || !strcmp(entity, "#191;")) return (ansi ? 191 : 168);
  else if (!strcmp(entity, "Agrave;") || !strcmp(entity, "#192;")) return (ansi ? 192 : 'A');
  else if (!strcmp(entity, "Aacute;") || !strcmp(entity, "#193;")) return (ansi ? 193 : 'A');
  else if (!strcmp(entity, "Acirc;")  || !strcmp(entity, "#194;")) return (ansi ? 194 : 'A');
  else if (!strcmp(entity, "Atilde;") || !strcmp(entity, "#195;")) return (ansi ? 195 : 'A');
  else if (!strcmp(entity, "Auml;")   || !strcmp(entity, "#196;")) return (ansi ? 196 : 142);
  else if (!strcmp(entity, "Aring;")  || !strcmp(entity, "#197;")) return (ansi ? 197 : 143);
  else if (!strcmp(entity, "AElig;")  || !strcmp(entity, "#198;")) return (ansi ? 198 : 146);
  else if (!strcmp(entity, "Ccedil;") || !strcmp(entity, "#199;")) return (ansi ? 199 : 128);
  else if (!strcmp(entity, "Egrave;") || !strcmp(entity, "#200;")) return (ansi ? 200 : 'E');
  else if (!strcmp(entity, "Eacute;") || !strcmp(entity, "#201;")) return (ansi ? 201 : 144);
  else if (!strcmp(entity, "Ecirc;")  || !strcmp(entity, "#202;")) return (ansi ? 202 : 'E');
  else if (!strcmp(entity, "Euml;")   || !strcmp(entity, "#203;")) return (ansi ? 203 : 'E');
  else if (!strcmp(entity, "Igrave;") || !strcmp(entity, "#204;")) return (ansi ? 204 : 'I');
  else if (!strcmp(entity, "Iacute;") || !strcmp(entity, "#205;")) return (ansi ? 205 : 'I');
  else if (!strcmp(entity, "Icirc;")  || !strcmp(entity, "#206;")) return (ansi ? 206 : 'I');
  else if (!strcmp(entity, "Iuml;")   || !strcmp(entity, "#207;")) return (ansi ? 207 : 'I');
  else if (!strcmp(entity, "ETH;")    || !strcmp(entity, "#208;")) return (ansi ? 208 : 'D');
  else if (!strcmp(entity, "Ntilde;") || !strcmp(entity, "#209;")) return (ansi ? 209 : 165);
  else if (!strcmp(entity, "Ograve;") || !strcmp(entity, "#210;")) return (ansi ? 210 : 'O');
  else if (!strcmp(entity, "Oacute;") || !strcmp(entity, "#211;")) return (ansi ? 211 : 'O');
  else if (!strcmp(entity, "Ocirc;")  || !strcmp(entity, "#212;")) return (ansi ? 212 : 'O');
  else if (!strcmp(entity, "Otilde;") || !strcmp(entity, "#213;")) return (ansi ? 213 : 'O');
  else if (!strcmp(entity, "Ouml;")   || !strcmp(entity, "#214;")) return (ansi ? 214 : 153);
  else if (!strcmp(entity, "times;")  || !strcmp(entity, "#215;")) return (ansi ? 215 : 'x');
  else if (!strcmp(entity, "Oslash;") || !strcmp(entity, "#216;")) return (ansi ? 216 : 'O');
  else if (!strcmp(entity, "Ugrave;") || !strcmp(entity, "#217;")) return (ansi ? 217 : 'U');
  else if (!strcmp(entity, "Uacute;") || !strcmp(entity, "#218;")) return (ansi ? 218 : 'U');
  else if (!strcmp(entity, "Ucirc;")  || !strcmp(entity, "#219;")) return (ansi ? 219 : 'U');
  else if (!strcmp(entity, "Uuml;")   || !strcmp(entity, "#220;")) return (ansi ? 220 : 154);
  else if (!strcmp(entity, "Yacute;") || !strcmp(entity, "#221;")) return (ansi ? 221 : 'Y');
  else if (!strcmp(entity, "THORN;")  || !strcmp(entity, "#222;")) return (ansi ? 222 : UNK);
  else if (!strcmp(entity, "szlig;")  || !strcmp(entity, "#223;")) return (ansi ? 223 : 225);
  else if (!strcmp(entity, "agrave;") || !strcmp(entity, "#224;")) return (ansi ? 224 : 133);
  else if (!strcmp(entity, "aacute;") || !strcmp(entity, "#225;")) return (ansi ? 225 : 160);
  else if (!strcmp(entity, "acirc;")  || !strcmp(entity, "#226;")) return (ansi ? 226 : 'a');
  else if (!strcmp(entity, "atilde;") || !strcmp(entity, "#227;")) return (ansi ? 227 : 'a');
  else if (!strcmp(entity, "auml;")   || !strcmp(entity, "#228;")) return (ansi ? 228 : 132);
  else if (!strcmp(entity, "aring;")  || !strcmp(entity, "#229;")) return (ansi ? 229 : 134);
  else if (!strcmp(entity, "aelig;")  || !strcmp(entity, "#230;")) return (ansi ? 230 : 145);
  else if (!strcmp(entity, "ccedil;") || !strcmp(entity, "#231;")) return (ansi ? 231 : 135);
  else if (!strcmp(entity, "egrave;") || !strcmp(entity, "#232;")) return (ansi ? 232 : 138);
  else if (!strcmp(entity, "eacute;") || !strcmp(entity, "#233;")) return (ansi ? 233 : 130);
  else if (!strcmp(entity, "ecirc;")  || !strcmp(entity, "#234;")) return (ansi ? 234 : 'e');
  else if (!strcmp(entity, "euml;")   || !strcmp(entity, "#235;")) return (ansi ? 235 : 137);
  else if (!strcmp(entity, "igrave;") || !strcmp(entity, "#236;")) return (ansi ? 236 : 141);
  else if (!strcmp(entity, "iacute;") || !strcmp(entity, "#237;")) return (ansi ? 237 : 161);
  else if (!strcmp(entity, "icirc;")  || !strcmp(entity, "#238;")) return (ansi ? 238 : 140);
  else if (!strcmp(entity, "iuml;")   || !strcmp(entity, "#239;")) return (ansi ? 239 : 139);
  else if (!strcmp(entity, "eth;")    || !strcmp(entity, "#240;")) return (ansi ? 240 : UNK);
  else if (!strcmp(entity, "ntilde;") || !strcmp(entity, "#241;")) return (ansi ? 241 : 164);
  else if (!strcmp(entity, "ograve;") || !strcmp(entity, "#242;")) return (ansi ? 242 : 149);
  else if (!strcmp(entity, "oacute;") || !strcmp(entity, "#243;")) return (ansi ? 243 : 162);
  else if (!strcmp(entity, "ocirc;")  || !strcmp(entity, "#244;")) return (ansi ? 244 : 147);
  else if (!strcmp(entity, "otilde;") || !strcmp(entity, "#245;")) return (ansi ? 245 : 'o');
  else if (!strcmp(entity, "ouml;")   || !strcmp(entity, "#246;")) return (ansi ? 246 : 148);
  else if (!strcmp(entity, "divide;") || !strcmp(entity, "#247;")) return (ansi ? 247 : 246);
  else if (!strcmp(entity, "oslash;") || !strcmp(entity, "#248;")) return (ansi ? 248 : 'o');
  else if (!strcmp(entity, "ugrave;") || !strcmp(entity, "#249;")) return (ansi ? 249 : 151);
  else if (!strcmp(entity, "uacute;") || !strcmp(entity, "#250;")) return (ansi ? 250 : 163);
  else if (!strcmp(entity, "ucirc;")  || !strcmp(entity, "#251;")) return (ansi ? 251 : 150);
  else if (!strcmp(entity, "uuml;")   || !strcmp(entity, "#252;")) return (ansi ? 252 : 129);
  else if (!strcmp(entity, "yacute;") || !strcmp(entity, "#253;")) return (ansi ? 253 : 'y');
  else if (!strcmp(entity, "thorn;")  || !strcmp(entity, "#254;")) return (ansi ? 254 : UNK);
  else if (!strcmp(entity, "yuml;")   || !strcmp(entity, "#255;")) return (ansi ? 255 : 152);

  return UNK;
}
