#ifndef DIBDLL_DEFINED
#define DIBDLL_DEFINED

#include "dibclass.h"
#include "dibview.h"
#include "dibapi.h"

// LOGPALETTE's version number.
#define PALVERSION 0x300

// WIDTHBYTES takes # of bits in a scan line and rounds up to nearest
//  word.
#define WIDTHBYTES(bits)      (((bits) + 31) / 32 * 4)

// Given a pointer to a DIB header, return TRUE if is a Windows 3.x
//  DIB, false if otherwise (PM style DIB).
#define IS_WIN3x_DIB(lpbi)  ((BOOL)((*(LPDWORD) (lpbi)) == sizeof (BITMAPINFOHEADER)))

// Given a pointer to a DIB header, return TRUE if is an OS/2 PM
//  DIB, false if otherwise (Windows 3.x style DIB).
#define IS_OS2PM_DIB(lpbi)  ((BOOL)((*(LPDWORD) (lpbi)) == sizeof (BITMAPCOREHEADER)))

#endif
