//------------------------------------------------------------------------------
//	DIBAPI.CPP --
//
// Original code from MicroSoft MSDN sample
//
//	
//------------------------------------------------------------------------------
#define STRICT
#include <windows.h>
#pragma hdrstop

#include "dibapi.h"

WORD DIBNumColors (LPSTR lpbi)
{
   WORD wBitCount;


      // If this is a Windows style DIB, the number of colors in the
      //  color table can be less than the number of bits per pixel
      //  allows for (i.e. lpbi->biClrUsed can be set to some value).
      //  If this is the case, return the appropriate value.

   if (IS_WIN3x_DIB (lpbi))
      {
      DWORD dwClrUsed;

      dwClrUsed = ((LPBITMAPINFOHEADER) lpbi)->biClrUsed;

      if (dwClrUsed)
         return (WORD) dwClrUsed;
      }


      // Calculate the number of colors in the color table based on
      //  the number of bits per pixel for the DIB.

   if (IS_WIN3x_DIB (lpbi))
      wBitCount = ((LPBITMAPINFOHEADER) lpbi)->biBitCount;
   else
      wBitCount = ((LPBITMAPCOREHEADER) lpbi)->bcBitCount;

   switch (wBitCount)
      {
      case 1:
         return 2;

      case 4:
         return 16;

      case 8:
         return 256;

      default:
         return 0;
      }
}


LPSTR FindDIBBits (LPSTR lpbi)
{
   return (lpbi + *(LPDWORD)lpbi + PaletteSize (lpbi));
}



WORD PaletteSize (LPSTR lpbi)
{
   if (IS_WIN3x_DIB (lpbi))
      return (DIBNumColors (lpbi) * sizeof (RGBQUAD));
   else
      return (DIBNumColors (lpbi) * sizeof (RGBTRIPLE));
}


//
// CreateDIBPalette
//
// Creates a palette from a DIB.  Parameter passed in is the
//  handle to global memory containing the DIB.
//

HPALETTE CreateDIBPalette (HANDLE hDIB)
{
   LPLOGPALETTE     lpPal;
   HANDLE           hLogPal;
   HPALETTE         hPal = NULL;
   int              i, wNumColors;
   LPSTR            lpbi;
   LPBITMAPINFO     lpbmi;
   LPBITMAPCOREINFO lpbmc;
   BOOL             bWinStyleDIB;

   if(!hDIB)
      return NULL;

   lpbi         = (char *)GlobalLock (hDIB);
   lpbmi        = (LPBITMAPINFO) lpbi;
   lpbmc        = (LPBITMAPCOREINFO) lpbi;
   wNumColors   = DIBNumColors (lpbi);
   bWinStyleDIB = IS_WIN3x_DIB (lpbi);

   if (wNumColors)
      {
      hLogPal = GlobalAlloc (GHND, sizeof (LOGPALETTE) +
                             sizeof (PALETTEENTRY) * wNumColors);

      if (!hLogPal)
         {
         MessageBox (NULL, "Couldn't allocate memory for LOGPALETTE!", NULL, MB_OK);
         GlobalUnlock (hDIB);
         return NULL;
         }

      lpPal = (LPLOGPALETTE) GlobalLock (hLogPal);

      lpPal->palVersion    = PALVERSION;
      lpPal->palNumEntries = wNumColors;

      for (i = 0;  i < wNumColors;  i++)
         {
         if (bWinStyleDIB)
            {
            lpPal->palPalEntry[i].peRed   = lpbmi->bmiColors[i].rgbRed;
            lpPal->palPalEntry[i].peGreen = lpbmi->bmiColors[i].rgbGreen;
            lpPal->palPalEntry[i].peBlue  = lpbmi->bmiColors[i].rgbBlue;
            lpPal->palPalEntry[i].peFlags = 0;
            }
         else
            {
            lpPal->palPalEntry[i].peRed   = lpbmc->bmciColors[i].rgbtRed;
            lpPal->palPalEntry[i].peGreen = lpbmc->bmciColors[i].rgbtGreen;
            lpPal->palPalEntry[i].peBlue  = lpbmc->bmciColors[i].rgbtBlue;
            lpPal->palPalEntry[i].peFlags = 0;
            }
         }

      hPal = CreatePalette (lpPal);

      if (!hPal)
         MessageBox (NULL, "CreatePalette() failed!", NULL, MB_OK);

      GlobalUnlock (hLogPal);
      GlobalFree   (hLogPal);
   }

   GlobalUnlock (hDIB);

   return hPal;
}




DWORD DIBHeight (LPSTR lpDIB)
{
   LPBITMAPINFOHEADER lpbmi;
   LPBITMAPCOREHEADER lpbmc;

   lpbmi = (LPBITMAPINFOHEADER) lpDIB;
   lpbmc = (LPBITMAPCOREHEADER) lpDIB;

   if(lpbmi->biSize == sizeof (BITMAPINFOHEADER))
      return lpbmi->biHeight;
   else
      return (DWORD)lpbmc->bcHeight;
}



DWORD DIBWidth (LPSTR lpDIB)
{
   LPBITMAPINFOHEADER lpbmi;
   LPBITMAPCOREHEADER lpbmc;

   lpbmi = (LPBITMAPINFOHEADER) lpDIB;
   lpbmc = (LPBITMAPCOREHEADER) lpDIB;

   if (lpbmi->biSize == sizeof (BITMAPINFOHEADER))
      return lpbmi->biWidth;
   else
      return (DWORD) lpbmc->bcWidth;
}




// Given a handle to memory with a DIB, create/realize a palette into
//  the given DC.  Returns old palette in the DC (or NULL on error).

HPALETTE RealizeDIBPalette(HDC hDC, HANDLE hDIB)
{
	HPALETTE hPal, hOldPal = NULL;

	if(hDIB && hDC)
	{
		if(hPal = CreateDIBPalette(hDIB))
		{
			hOldPal = SelectPalette(hDC, hPal, FALSE);
			if(hOldPal)
				RealizePalette(hDC);
			else
				DeleteObject(hPal);
		}
	}
	return hOldPal;
}

void PaintDIBInBands(HDC hDC,
							HANDLE hDIB,
							int nDIBWidth,
							int nDIBHeight,
							int nBandHeight)
{
   int y;

   for (y = 0;  y < nDIBHeight;  y += nBandHeight)
//      if (gnZoomFactor == 1)
			DIBBlt (hDC,
					0, y,
					nDIBWidth, nBandHeight,
					hDIB,
					0, y,
					SRCCOPY);
/*
		else
			StretchDIBBlt(hDC,
								0, y * gnZoomFactor,
								nDIBWidth * gnZoomFactor, nBandHeight * gnZoomFactor,
								hDIB,
								0, y,
								nDIBWidth, nBandHeight,
								SRCCOPY);
*/
}

//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//!!! Bummer, dwROP not used...
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
#pragma argsused
BOOL DIBBlt(HDC  hDC,
				int  xDst,
				int  yDst,
				int  nWidth,
				int  nHeight,
				HANDLE hDIB,
				int  xSrc,
				int  ySrc,
				DWORD dwROP)
{
   LPSTR    lpDIBHdr, lpDIBBits;
   BOOL     bSuccess = TRUE;
   int      nDIBWidth, nDIBHeight;


      // Make sure we've got proper handles.
   if (!hDIB || !hDC)
      return FALSE;

      // Lock down the DIB, and get a pointer to the beginning of the bit
		//  buffer.  Then get the DIB's height/width.  Translate
      //  the passed in y coordinate into the DIB coord system.
	lpDIBHdr   = (char *)GlobalLock(hDIB);
	lpDIBBits  = FindDIBBits (lpDIBHdr);
	nDIBWidth  = (int) DIBWidth (lpDIBHdr);
	nDIBHeight = (int) DIBHeight (lpDIBHdr);
	ySrc       = (int) nDIBHeight - ySrc - nHeight;


      // Insure the x/y/widht/height are valid.  Adjust if not, or abort
      //  if no painting necessary.

   if (xSrc > nDIBWidth)
      bSuccess = FALSE;
   else if (xSrc < 0)
		{
      nWidth += xSrc;
		xSrc    = 0;
      }

   if (ySrc > nDIBHeight)
      bSuccess = FALSE;
   else if (ySrc < 0)
      {
      nHeight -= ySrc;
      ySrc     = 0;
      }


      // Do the SetDIBitsToDevice().

   if (bSuccess)
		bSuccess = SetDIBitsToDevice (hDC,                          // hDC
                                    xDst,                         // DestX
												yDst,                         // DestY
                                    nWidth,                       // nDestWidth
                                    nHeight,                      // nDestHeight
                                    xSrc,                         // SrcX
                                    ySrc,                         // SrcY
                                    0,                            // nStartScan
                                    nDIBHeight,                   // nNumScans
                                    lpDIBBits,                    // lpBits
                                    (LPBITMAPINFO) lpDIBHdr,      // lpBitsInfo
                                    DIB_RGB_COLORS) != 0;         // wUsage


      // Clean up and get outta here.
   GlobalUnlock (hDIB);

	return bSuccess;
}

HBITMAP DIBToDDB (HANDLE hDIB, HPALETTE hPal)
{
	LPSTR    lpDIBHdr, lpDIBBits;
	HBITMAP  hBitmap;
	HDC      hDC;
	HPALETTE hOldPal = NULL;

	if (!hDIB)
		return NULL;

	lpDIBHdr  = (char *)GlobalLock (hDIB);
   lpDIBBits = FindDIBBits (lpDIBHdr);
   hDC       = GetDC (NULL);

   if (!hDC)
      {
      GlobalUnlock (hDIB);
      return NULL;
      }

   if (hPal)
      hOldPal = SelectPalette (hDC, hPal, FALSE);

   RealizePalette (hDC);

   hBitmap = CreateDIBitmap (hDC,
              (LPBITMAPINFOHEADER) lpDIBHdr,
				  CBM_INIT,
              lpDIBBits,
              (LPBITMAPINFO) lpDIBHdr,
              DIB_RGB_COLORS);

   if (!hBitmap)
      MessageBox (NULL, "CreateDIBitmap() failed!", NULL, MB_OK);

   if (hOldPal)
      SelectPalette (hDC, hOldPal, FALSE);

   ReleaseDC (NULL, hDC);
   GlobalUnlock (hDIB);

   return hBitmap;
}

BOOL AddDIBToListBox(HWND hList, LPSTR myStr, DIB * pBmp)
{
	LRESULT dwIndex;

	if(pBmp)
	{
		dwIndex = SendMessage(hList, LB_ADDSTRING, 0, (LONG)myStr);
		if((dwIndex != LB_ERR) && (dwIndex != LB_ERRSPACE))
		  if(SendMessage(hList, LB_SETITEMDATA, (WPARAM)dwIndex, (LONG)pBmp) != LB_ERR)
				return TRUE;
	}
	return FALSE;
}

void RemoveListBoxDIBs(HWND hList)
{
	DIB *	pBmp;
	DWORD cnt = (DWORD)SendMessage(hList, LB_GETCOUNT, 0, 0);

	for(int i = 0; i < cnt; i++)
	{
		pBmp = (DIB *)SendMessage(hList, LB_GETITEMDATA, i, 0L);
		if(pBmp)
			delete pBmp;
	}
}


