/*------------------------------------------------------------------------------
DIBCLASS.CPP --  Adam King, 2000

Description: Class to store a Device-Independent Bitmap (DIB)

Notes: Some of this code was adapted from original code  Charles Petzold, 1992

------------------------------------------------------------------------------*/
#define STRICT
#include <windows.h>
#include <windowsx.h>
#pragma hdrstop
#include <mem.h>

#include "dibclass.h"

#define MIN(a, b) ((a) < (b) ? (a) : (b))


//------------------------------------------------------------------------------
// The DIB class
//------------------------------------------------------------------------------
DIB::DIB()
{
//	memset(this, 0, sizeof(DIB));
}

//------------------------------------------------------------------------------
// Clear all information from the DIB class, freeing any alocated memory
//------------------------------------------------------------------------------
void DIB::Clear()
{
	if(lpDib != NULL)
		GlobalFreePtr(lpDib);
}

// Utility function to extract the Header Size from the DIB memory block
DWORD DIB::GetDibInfoHeaderSize()
{
	return (lpDib) ? ((LPBITMAPINFOHEADER)lpDib)->biSize : 0;
}

// Utility function to extract the Width of the DIB
DWORD DIB::GetDibWidth()
{
	LPBITMAPINFOHEADER lpbmi;
	LPBITMAPCOREHEADER lpbmc;

	lpbmi = (LPBITMAPINFOHEADER)lpDib;
	lpbmc = (LPBITMAPCOREHEADER)lpDib;

	if (lpbmi->biSize == sizeof(BITMAPINFOHEADER))
		return lpbmi->biWidth;
	else
		return (DWORD) lpbmc->bcWidth;
}

// Utility function to extract the Height of the DIB
DWORD DIB::GetDibHeight()
{
	LPBITMAPINFOHEADER lpbmi;
	LPBITMAPCOREHEADER lpbmc;

	lpbmi = (LPBITMAPINFOHEADER)lpDib;
	lpbmc = (LPBITMAPCOREHEADER)lpDib;

	if(lpbmi->biSize == sizeof(BITMAPINFOHEADER))
		return lpbmi->biHeight;
	else
		return (DWORD)lpbmc->bcHeight;
}

// Read a DIB from a file into memory
LPBITMAPINFO DIB::ReadDib(LPCSTR szFileName)
{
	BITMAPFILEHEADER bmfh;
	DWORD            dwDibSize, dwOffset, dwHeaderSize;
	HFILE            hFile;
	WORD             wDibRead;
	OFSTRUCT			  ofs;

	if (-1 == (hFile = OpenFile(szFileName, &ofs, OF_READ | OF_SHARE_DENY_WRITE)))
		return NULL;

	if(lpDib != NULL)
	{
		GlobalFreePtr(lpDib);
		lpDib = NULL;
	}

	if(_lread(hFile, (LPSTR)&bmfh, sizeof(bmfh)) != sizeof(bmfh) ||
		bmfh.bfType != * (WORD *) "BM")
	{
		_lclose (hFile);
		return NULL;
	}

	if(lpDib != NULL)
	{
		GlobalFreePtr(lpDib);
		lpDib = NULL;
	}

	dwDibSize = bmfh.bfSize - sizeof (BITMAPFILEHEADER);

	lpDib = (LPBITMAPINFO)GlobalAllocPtr(GMEM_MOVEABLE, dwDibSize);

	if(lpDib == NULL)
	{
		_lclose (hFile);
		return NULL;
	}

	dwOffset = 0 ;

	while (dwDibSize > 0)
	{
		wDibRead = (WORD) MIN(32768ul, dwDibSize);

		if (wDibRead != _lread (hFile, (LPSTR) (lpDib + dwOffset), wDibRead))
		{
			_lclose (hFile);
			GlobalFreePtr (lpDib);
			return NULL;
		}

		dwDibSize -= wDibRead;
		dwOffset  += wDibRead;
	}

	_lclose (hFile);

	dwHeaderSize = GetDibInfoHeaderSize();

	// Check if header is legal
	if(dwHeaderSize < 12 || (dwHeaderSize > 12 && dwHeaderSize < 16))
	{
		GlobalFreePtr (lpDib);
		return NULL;
	}

	return lpDib;
}

