/* ------------------------------------------------------------------------ */
/* WAIT.C (C) CopyLeft Bill Buckels 1999                                    */
/* All Rights Reversed.                                                     */
/*                                                                          */
/* Licence Agreement                                                        */
/* -----------------                                                        */
/*                                                                          */
/* You have a royalty-free right to use, modify, reproduce and              */
/* distribute this source code in any way you find useful,                  */
/* provided that you agree that Bill Buckels has no warranty obligations    */
/* or liability resulting from said distribution in any way whatsoever.     */
/* If you don't agree, remove this source code from your computer now.      */
/*                                                                          */
/* Written by   : Bill Buckels                                              */
/*                589 Oxford Street                                         */
/*                Winnipeg, Manitoba, Canada R3M 3J2                        */
/*                                                                          */
/* Email: bbuckels@escape.ca                                                */
/* WebSite: http://www.escape.ca/~bbuckels                                  */
/*                                                                          */
/* Date Written : 1995                                                      */
/* Purpose      : Wait... Wait from 1-60 or until a scheduled time.         */
/*                Can be called from a WIN95/98 DOS Batchfile or            */
/*                a WinRobot Script                                         */
/*                To pause for a specified period of time.                  */
/* Revision     : 2.0 Second Release                                        */
/* Notes        : Version 1.0                                               */
/*                  Wait... Wait from 1 to 60 seconds                       */
/*                    as specified on the command line.                     */
/*                Version 2.0                                               */
/*                  Command line problem fixed...                           */
/*                    was not working in version 1.0 due to memory model    */
/*                    mismatch.                                             */
/*                  Added "Until" Option.                                   */
/*                  Usage is now:                                           */
/*                  - "Wait"                  - Waits a minute.             */
/*                  - "Wait [1-60 seconds]"   - Waits a number of seconds.  */
/*                  - "Wait Until HH"         - Waits until the hour.       */
/*                  - "Wait Until HH:MM"      - Waits until hour:minute     */
/*                  - "Wait Until HH PM"      - Waits until AM or PM        */
/*                  - "Wait Until HH:MM AM"                                 */
/*                  - "Wait Before HH"         - Waits Before the hour.     */
/*                  - "Wait Before HH:MM"      - Waits Before hour:minute   */
/*                  - "Wait Before HH PM"      - Waits Before AM or PM      */
/*                  - "Wait Before HH:MM AM"                                */
/*                  - "Wait After HH"         - Waits After the hour.       */
/*                  - "Wait After HH:MM"      - Waits After hour:minute     */
/*                  - "Wait After HH PM"      - Waits After AM or PM        */
/*                  - "Wait After HH:MM AM"                                 */
/*                                                                          */
/* ------------------------------------------------------------------------ */
/* Written in Small Model Microsoft C Version 6.00a                         */
/* ------------------------------------------------------------------------ */

#include <windows.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>

#define ID_TIMER    1001

LONG FAR PASCAL WndProc (HWND, WORD, WORD, LONG);
BOOL PASCAL SetStopTime(HWND);
BOOL PASCAL GetStopTime();

UINT ONEMINUTE = (UINT)60000;

static char *pCopyRight = "Wait(C) CopyLeft Bill Buckels 1995-1999.";
static char szCmdParam[128] = "\0";
static char szMessBuf[256] = "\0";


enum {
  NOTYPE = 0,
  UNTIL,
  BEFORE,
  AFTER};


static int iDelayType = 0;

static BOOL WAITTIME = FALSE;
static UINT wStartHour = 0, wStartMinute = 0;
static UINT wTarget = 0, wCurrent = 0;
static struct dostime_t logtime;

static char *pCmdTestUntil  = "UNTIL HH:MM";
static char *pCmdTestBefore = "BEFORE HH:MM";
static char *pCmdTestAfter  = "AFTER HH:MM";

// set-up the time interval and options...
// called when the (minimized) window opens
BOOL PASCAL SetStopTime(HWND hWnd)
{
  char *pAction,
       *hourptr,
       *minptr = "";
  int  seconds,
       idx,
       iOffSet;

#define ARG1_LEN            5
#define ARG2_SEPARATOR_POS  ARG1_LEN
#define ARG2_START_POS      (ARG2_SEPARATOR_POS + 1)

  WAITTIME  = FALSE;
  wStartHour = wStartMinute = 0;

  seconds = atoi(szCmdParam);

  if (seconds>0 && seconds <60)
  {
    ONEMINUTE = (UINT)seconds;
    ONEMINUTE *= 1000;
    return FALSE;
  }

  iDelayType = NOTYPE;
  if (0 == memcmp(szCmdParam, pCmdTestUntil, ARG1_LEN))
    iDelayType = UNTIL;
  else if (0 == memcmp(szCmdParam, pCmdTestBefore, ARG1_LEN))
    iDelayType = BEFORE;
  else if (0 == memcmp(szCmdParam, pCmdTestAfter, ARG1_LEN))
    iDelayType = AFTER;

  if (NOTYPE == iDelayType)
    return FALSE;

  if (BEFORE == iDelayType)
   iOffSet = 1;
  else
   iOffSet = 0;


  ONEMINUTE = (UINT)1000; // set timer to nominal value of 1 second
                          // this will allow the window to finish opening
                          // gracefully before shutting down
                          // in case we want to bail-out...

  /* we want a space separator followed by a numeric */
  if (szCmdParam[ARG2_SEPARATOR_POS+iOffSet] != ' ' ||
      szCmdParam[ARG2_START_POS+iOffSet] < '0' ||
      szCmdParam[ARG2_START_POS+iOffSet] > '9') {
    wsprintf((LPSTR)szMessBuf, "Invalid StartTime : %s\n"
                               "Format must be :\n\t%s\n\t%s\n\t%s\n\n"
                               "Unable to continue.",
                               (LPCSTR)szCmdParam,
                               (LPCSTR)pCmdTestUntil,
                               (LPCSTR)pCmdTestBefore,
                               (LPCSTR)pCmdTestAfter);

    MessageBox(hWnd,szMessBuf,pCopyRight,MB_ICONHAND);
    return FALSE;
  }

  // parse hours and minutes
  hourptr=(char *)&szCmdParam[ARG2_START_POS+iOffSet];
  idx=ARG2_SEPARATOR_POS+iOffSet;
  for(;;)
  {
    idx++;
    if(szCmdParam[idx]==0)break;
    if(szCmdParam[idx]==':')
    {
       idx++;
       minptr=(char *)&szCmdParam[idx];
       break;
    }
  }

  wStartHour    = atoi(hourptr);
  wStartMinute  = atoi(minptr);

  // assume all time is AM
  // check for PM
  idx = ARG2_SEPARATOR_POS+iOffSet;
  for (;;) {
    idx++;
    if(szCmdParam[idx]==0)break;
    if (szCmdParam[idx - 1] ==  'P' && szCmdParam[idx] == 'M') {
      if (wStartHour < 12) {
        wStartHour = (wStartHour + 12);
      }
      break;
    }
  }

  // adjust for some people's preference to use 24:00 instead of midnight
  if (wStartHour == 24)
    wStartHour = 0;

  if (wStartHour>23||wStartMinute>59) {
    wsprintf((LPSTR)szMessBuf, "Invalid StartTime %d:%002d.\n\n"
                               "Unable to continue.",
                               wStartHour,wStartMinute);
    MessageBox(hWnd,szMessBuf,pCopyRight,MB_ICONHAND);
    return FALSE;
  }

  wTarget = (wStartHour * 60)+wStartMinute;
  _dos_gettime(&logtime);
  wCurrent =  0;
  wCurrent += logtime.hour;
  wCurrent *= 60;
  wCurrent += logtime.minute;

  switch(iDelayType) {
      case BEFORE:
        if(wCurrent < wTarget) {
          WAITTIME = TRUE;
          pAction = (char *)"If Before";
        }
        break;
      case AFTER:
        if(wCurrent > wTarget) {
          WAITTIME = TRUE;
          pAction = (char *)"If After";
        }
        break;
      case UNTIL:
      default:
        // if we are past the target time
        // assume we process tomorrow...
        if(wCurrent < wTarget || wCurrent > wTarget) {
          WAITTIME = TRUE;
          pAction = (char *)"Event At";
        }
    }


  if (WAITTIME == TRUE) {
    ONEMINUTE = (UINT)15000; // fire every 15 seconds

    wsprintf((LPSTR)szMessBuf, "Wait %s %d:%002d",
                                (LPSTR)pAction,
                                wStartHour,wStartMinute);
    SetWindowText(hWnd,(LPSTR)szMessBuf);
  }
  return WAITTIME;
}


// check the stop time each time the timer fires...
BOOL PASCAL CheckStopTime()
{
  if (TRUE == WAITTIME)  {
    WAITTIME = FALSE;
    wTarget = (wStartHour * 60)+wStartMinute;
    _dos_gettime(&logtime);
    wCurrent =  0;
    wCurrent += logtime.hour;
    wCurrent *= 60;
    wCurrent += logtime.minute;
    switch(iDelayType) {
      case BEFORE:
        if(wCurrent < wTarget)
          WAITTIME = TRUE;
        break;
      case AFTER:
        if(wCurrent > wTarget)
          WAITTIME = TRUE;
        break;
      case UNTIL:
      default:
        if(wCurrent < wTarget || wCurrent > wTarget)
          WAITTIME = TRUE;
    }
  }
  return WAITTIME;

}


int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdParam, int nCmdShow)
     {
     HWND        hwnd ;
     MSG         msg ;
     WNDCLASS    wndclass ;
     int         idx;
     char        ch;


     // commandline...
     // transfer a far buffer to a near buffer
     idx = 0;
     for (;;) {
       ch = lpszCmdParam[idx];

       // force upper case
       if (ch >= 'a' && ch <= 'z')
         szCmdParam[idx] = (ch - 32);
       else
         szCmdParam[idx] = ch;
       if (szCmdParam[idx] == 0)break;
       idx++;
     }

     if (!hPrevInstance)
          {
          wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
          wndclass.lpfnWndProc   = WndProc ;
          wndclass.cbClsExtra    = 0 ;
          wndclass.cbWndExtra    = 0 ;
          wndclass.hInstance     = hInstance ;
          wndclass.hIcon         = LoadIcon (NULL, IDI_APPLICATION) ;
          wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
          wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
          wndclass.lpszMenuName  = NULL ;
          wndclass.lpszClassName = "wait" ;

          RegisterClass (&wndclass) ;
	  }


     hwnd = CreateWindow ("Wait",
            "Wait", WS_MINIMIZE|WS_OVERLAPPEDWINDOW,
                    CW_USEDEFAULT, CW_USEDEFAULT,
                    CW_USEDEFAULT, CW_USEDEFAULT,
                    NULL, NULL, hInstance, NULL) ;

     // Run In a Minimized Window

     ShowWindow (hwnd, SW_SHOWMINIMIZED) ;
     UpdateWindow (hwnd) ;

     while (GetMessage (&msg, NULL, 0, 0))
          {
          TranslateMessage (&msg) ;
          DispatchMessage (&msg) ;
          }
     return msg.wParam ;
     }


LONG FAR PASCAL WndProc (HWND hwnd, WORD message, WORD wParam, LONG lParam)
     {


     switch (message)
          {

          case WM_SYSCOMMAND :

                      // foil attempts to Maximize or Restore
                      if((wParam &0xfff0)==SC_MAXIMIZE)return 0L;
                      if((wParam &0xfff0)==SC_RESTORE)return 0L;
                      break;

          case WM_CREATE:

                    if (TRUE == SetStopTime(hwnd))
                      SetTimer (hwnd, ID_TIMER, 10, NULL);
                    else
                      SetTimer (hwnd, ID_TIMER, ONEMINUTE, NULL);
                    return 0L;

          case WM_TIMER:

                    if (FALSE == CheckStopTime()) {
                      KillTimer(hwnd,ID_TIMER);
                      DestroyWindow(hwnd);
                    }
                    else {
                      SetTimer (hwnd, ID_TIMER, ONEMINUTE, NULL);
                    }
                    return 0L;

          case WM_DESTROY:

               PostQuitMessage(0);
               return 0L;
          }

     return DefWindowProc (hwnd, message, wParam, lParam) ;
     }

