/*
**  DIR_IO.C
*/

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <string.h>
#include "windows.h"
#include "dir_io.h"

/*** define compiler specfic includes ***/

#ifdef __BORLANDC__
/* Borland Turbo C compiler */
#include <dir.h>
static char DTAbuffer[256];
static struct ffblk DirStruct;
#endif

#ifdef _MSC_VER
/* Microsoft C compiler */
static struct _find_t DirStruct;
#endif

/*** FindFirst() and FindNext() functions ***/

int FindFirst(char *FileSpec,char *Buffer)
{
#ifdef _MSC_VER
 if(_dos_findfirst(FileSpec,_A_NORMAL,&DirStruct)==0)
   {
    strncpy(Buffer,DirStruct.name,13);
    return(TRUE);
   }
 return(FALSE);
#endif

#ifdef __BORLANDC__
 setdta(DTAbuffer);
 if( findfirst(FileSpec,&DirStruct,0)==0)
   {
    strncpy(Buffer,DirStruct.ff_name,13);
    return(TRUE);
   }
 return(FALSE);
#endif
}

int FindNext(char *Buffer)
{
#ifdef _MSC_VER
 int Result;
Result = _dos_findnext(&DirStruct);
if(Result==0)
   {
    strncpy(Buffer,DirStruct.name,13);
    return(TRUE);
   }
 return(FALSE);
#endif

#ifdef __BORLANDC__
 if( findnext(&DirStruct)==0 )
   {
    strncpy(Buffer,DirStruct.ff_name,13);
    return(TRUE);
   }
 return(FALSE);
#endif
}