/* opcodes.h */


#ifndef BYTE
#define BYTE unsigned char
#endif

#ifndef WORD
#define WORD unsigned int
#endif

int MatchOpCode(WORD);
int MatchOpText(char *);
int GetOpCode(WORD);
char *GetOpText(WORD);
int GetOperType(WORD);
char *GetOperText(WORD);

/*
** Opcodes  0..7  are NO_REF
*/

/* referenced by *RefText[] */
#define NO_REF    0
#define CODE_REF  1
#define DATA_REF  2

#define FIRST_REF  8

#define OPC_HALT      0
#define OPC_STATUS    1
#define OPC_RETURN    2
#define OPC_NOP       3
#define OPC_DEBUG     4
#define OPC_XXX_5     5
#define OPC_XXX_6     6
#define OPC_XXX_7     7
#define OPC_CALL      8
#define OPC_LOOP      9
#define OPC_IFTRUE   10
#define OPC_IFFALSE  11
#define OPC_GOTO     12
#define OPC_BAUD     13
#define OPC_DATABITS 14
#define OPC_STOPBITS 15
#define OPC_PARITY   16
#define OPC_QUIET    17
#define OPC_HANGUP   18
#define OPC_REPLY    19
#define OPC_DELAY    20
#define OPC_SETCOUNT 21
#define OPC_SETWAIT  22
#define OPC_SAY      23
#define OPC_WAITFOR  24
#define OPC_SETPACE  25
#define OPC_SETCASE  26
#define OPC_ACCEPT   27
#define OPC_PROTOCOL 28
#define OPC_SEND     29
#define OPC_RECEIVE  30
#define OPC_TEST     31
#define OPC_IF       32
#define OPC_IFNOT    33

#define OPC_XXX_34   34
#define OPC_XXX_35   35
#define OPC_XXX_36   36
#define OPC_XXX_37   37
#define OPC_XXX_38   38
#define OPC_XXX_39   39
#define OPC_XXX_40   40

#define OPC_USER1    41
#define OPC_USER2    42
#define OPC_USER3    43
#define OPC_USER4    44
#define OPC_USER5    45
#define OPC_USER6    46
#define OPC_USER7    47
#define OPC_USER8    48

#define NBR_OPCODES  49

#define REF_HALT     NO_REF
#define REF_STATUS   NO_REF
#define REF_RETURN   NO_REF
#define REF_NOP      NO_REF
#define REF_DEBUG    NO_REF
#define REF_CALL     CODE_REF
#define REF_LOOP     CODE_REF
#define REF_IFTRUE   CODE_REF
#define REF_IFFALSE  CODE_REF
#define REF_GOTO     CODE_REF
#define REF_DELAY    DATA_REF
#define REF_BAUD     DATA_REF
#define REF_DATABITS DATA_REF
#define REF_STOPBITS DATA_REF
#define REF_PARITY   DATA_REF
#define REF_QUIET    DATA_REF
#define REF_HANGUP   DATA_REF
#define REF_REPLY    DATA_REF
#define REF_SETCOUNT DATA_REF
#define REF_SETWAIT  DATA_REF
#define REF_SAY      DATA_REF
#define REF_WAITFOR  DATA_REF
#define REF_SETPACE  DATA_REF
#define REF_SETCASE  DATA_REF
#define REF_ACCEPT   DATA_REF
#define REF_PROTOCOL DATA_REF
#define REF_SEND     DATA_REF
#define REF_RECEIVE  DATA_REF

#define REF_TEST     DATA_REF
#define REF_IF       CODE_REF
#define REF_IFNOT    CODE_REF

#define REF_USER     DATA_REF
