/* ------------------------------------------------------------------------ */
/* System       : Microsoft C Demo Routines                                 */
/* Program      : bload.c                                                   */
/* Description  : demonstrates simple loading of CGA compatible graphics    */
/*                images in both the BSAVED and PCX formats.                */
/*                (C) CopyLeft Bill Buckels 1997.                           */
/*                All Rights Reversed.                                      */
/*                                                                          */
/* You have a royalty-free right to use, modify, reproduce and              */
/* distribute this source code in any way you find useful,                  */
/* provided that you agree that Bill Buckels has no warranty obligations    */
/* or liability resulting from said distribution in any way whatsoever.     */
/* ------------------------------------------------------------------------ */

#include "lib\std.h"
#include "lib\stdkeys.h"
#include "lib\crtmode.h"
#include "lib\cgaload.h"
#include "lib\cgapcx.h"
#include "lib\bread.h"

char *pszTitle = "BLOAD(C) Copyright by Bill Buckels 1997-1999";

int main(int argc, char **argv)
{
    int status, idx;
    unsigned char buffer[TEMP_BUFF_LEN];

    /* 1. if no commandline args then print usage and exit */
    if (argc < 2)
      errorexit(pszTitle,
        "Usage is : \"BLOAD <BSAVED.PIC> [pic2 pic3...] \"", NULL);

    /* 2. if we can't allocate memory then say so and exit */
    if (NULL == (cgascreenbuffer = malloc(CGA_SCREENSIZE)))
       errorexit(pszTitle, "Memory Allocation Error!", NULL);

    /* 3. if some error reading the file then print the error and exit */
    if (SUCCESS != (status = bread(argv[1]))) {
      switch (status) {
        case INVALID_HEADER:
          sprintf(buffer, "%s is not in a supported format.",argv[1]);
          if (INVALID_HANDLE != (status = cgxread(argv[1])))
            break;
        case INVALID_HANDLE:
        default:
          sprintf(buffer, "unable to open %s.",argv[1]);
      }

      if (SUCCESS != status)
        errorexit(pszTitle, (char *)&buffer[0], cgascreenbuffer);
    }

   /* 4. if we are unable to switch to CGA mode then complain and exit */
   if (ucCgaDisplayMode != setcrtmode(ucCgaDisplayMode))
     errorexit(pszTitle, "CGA or better adapter required", cgascreenbuffer);

   /* 5. if multiple images were named on the command line                  */
   /*    perform a slideshow of sorts... but stay in the initial video mode */
   idx = 2;
   for (;;) {
     cgaload();
     if (ESCKEY == (status = getch()))
       break;
     if (FUNCKEY == status)
       getch();
     idx++;
     if (idx > argc)
       break;
     if (SUCCESS != bread(argv[idx-1]))
       if (SUCCESS != cgxread(argv[idx -1]))
         break;
   }

   (void)setcrtmode(TEXT_VIDEO);
   if (ESCKEY == status)
     return (1);
   return (SUCCESS);
}
