/* ------------------------------------------------------------------ */
/* cga2bsv.c by bill buckels 1997                                     */
/* demonstrates translation of CGA compatible graphics images to      */
/* BSAVED color text screens                                          */
/* ------------------------------------------------------------------ */

#include "lib\std.h"
#include "lib\stdkeys.h"
#include "lib\crtmode.h"
#include "lib\cgaload.h"
#include "lib\cgapcx.h"
#include "lib\bread.h"

char *pszTitle = "CGA2BSV(C) Copyright Bill Buckels 1997-1999";

void errorexit(char *msg)
{

  if (NULL != cgascreenbuffer)
    free(cgascreenbuffer);

  fprintf(stderr, "%s\n", pszTitle);
  fprintf(stderr, "%s\n", msg);

  exit(1);
}


/* -------------------------------------------------------------- */
/* saved region selection function                                */
/*  - arrow keys select                                           */
/*  - enter saves                                                 */
/*  - escape aborts                                               */
/* -------------------------------------------------------------- */
void vfnSaveArea(char *pszInFile)
{

  int c, x, y, width, height, maxx, maxy;
  char szOutFile[TEMP_BUFF_LEN];

  /* create output file name from input file name */
  strcpy(szOutFile, pszInFile);

  for (x = 0; szOutFile[x] != ASCIIZ; x++) {
    szOutFile[x] = toupper(szOutFile[x]);
    if (PERIOD == szOutFile[x]) {
      // create a zoned filename for MiniPix Demo Images in .PCX format.
      // PIC1A etc.
      if (x == 5 &&
          szOutFile[0] == 'P' &&
          szOutFile[1] == 'I' &&
          szOutFile[2] == 'C' &&
          (szOutFile[3] >= '0' && szOutFile[3] <= '9') &&
          (szOutFile[4] >= 'A' && szOutFile[4] <= 'Z')) {
        szOutFile[x] = '?';
        x++;
      }
      szOutFile[x] = ASCIIZ;
      break;
    }
  }


  strcat(szOutFile, ".bsv");
   
  /* set-up the coordinates */
  width   = 80;
  height  = 50;
  x       = 0;
  y       = 0;
  maxx    = 320 - width;
  maxy    = 200 - height;

  cgaxbox(x, y, width, height);

  for (;;) {

    if (FUNCKEY == (c=getch())) {

      switch(getch()) {

        case UPARROW:
          if (y > 0) {
            y--;
            cgahxline(x, y + height, width);   /* erase old line */
            cgahxline(x, y, width);            /* draw new line  */
          }
          break;

        case DOWNARROW:
          if (y < maxy) {
            cgahxline(x, y + height, width);   /* draw new line  */
            cgahxline(x, y, width);            /* erase old line */
            y++;
          }
          break;

        case LEFTARROW:
          if (x > 0) {
            x -= CGA_X_RATE;
            cgaxbox(x + width, y, CGA_X_RATE, height);
            cgaxbox(x, y, CGA_X_RATE, height);
          }
          break;

        case RIGHTARROW:
          if (x < maxx) {
            cgaxbox(x, y, CGA_X_RATE, height);
            cgaxbox(x + width, y, CGA_X_RATE, height);
            x += CGA_X_RATE;
          }
          break;

      }
    }
    else {
      if (c == ESCKEY) {
        bronx();
        break;
      }
      if (c == ENTERKEY) {
        if (SUCCESS == textsave(szOutFile, x, y)) {
          beep();
          break;
        }
        bronx();
      }
    }
  }
  return;
}


/* ---------------------------------------------------- */
/* write the text pixel image to file...                */
/* ---------------------------------------------------- */
int textpixel(unsigned uiTop, unsigned uiBottom, FILE *fp)
{
    int idx;
    unsigned char ch, attr;  /* color and attribute     */

    ch = BLACKSPACE;         /* default = solid         */
    attr = BWHITE;           /* black back - white fore */

    /* 1. */
    /* if both pixels are the same then use a solid unless black */
    /* if black, use a space...                                  */
    if (uiTop == uiBottom) {
       switch(uiTop) {
         case CGA_BLACK:
           ch = WHITESPACE; /* black... so use a space */
           break;
         case CGA_CYAN:
           attr = CYAN;
           break;
         case CGA_MAGENTA:
           attr = RED;
           break;
       }
       fputc(ch, fp);
       fputc(attr, fp);
       return (SUCCESS);
    }

   /* change default character from solid to half-solid... */

                           /* default background is on top              */
   ch = BOTTOMONLY;        /* default bottom is solid (dominant color)  */
   idx = uiBottom;

   /* 2. */
   /* if something is black, use a black background */
   /* that gets rid of all black cases....          */
   if (CGA_BLACK == uiTop || CGA_BLACK == uiBottom) {

      if (CGA_BLACK == uiBottom) { /* if black is on the bottom     */
        idx = uiTop;               /* top is solid (colored)        */
        ch = TOPONLY;
      }

      switch (idx) {
         case CGA_CYAN:
           attr = CYAN;
           break;
         case CGA_MAGENTA:
           attr = RED;
           break;
       }
       fputc(ch, fp);
       fputc(attr, fp);
       return (SUCCESS);
   }

   /* 3. */
   /* if something is white, use a colored background */
   /* that gets rid of all white cases...             */
   if (CGA_WHITE == uiTop || CGA_WHITE == uiBottom) {

      idx  = uiTop;                   /* assume white is on the bottom    */
                                      /* so background is on top          */
      if (CGA_WHITE == uiTop) {       /* but if white is on the top       */
        ch = TOPONLY;                 /* the top is solid                 */
        idx = uiBottom;               /* and the background is the bottom */
      }

      switch (idx) {
         case CGA_CYAN:
           attr = CYAN<<4|BWHITE;
           break;
         case CGA_MAGENTA:
           attr = RED<<4|BWHITE;
           break;
       }
       fputc(ch, fp);
       fputc(attr, fp);
       return (SUCCESS);
   }

   /* 4. only cyan and magenta are left       */
   /* use a red background...                 */
   /* that gets rid of the rest of the cases  */

   attr = RED<<4 | CYAN;

   if (CGA_CYAN == uiTop)
     ch = TOPONLY;

   fputc(ch, fp);
   fputc(attr, fp);

   return (SUCCESS);
}

int TextZone[9][4] = {
  0,   0,  107, 84,
  108, 0,  207, 84,
  208, 0,  319, 84,

  0,   85,  107, 137,
  108, 85,  207, 137,
  208, 85,  319, 137,

  0,   138,  107, 199,
  108, 138,  207, 199,
  208, 138,  319, 199};

int textsave(char *outfile, int xorg, int yorg)
{
   FILE *fp;
   unsigned topbyte, botbyte, x, y, toff, boff, idx, iZone;

   // create a zoned filename for MiniPix Demo Images in .PCX format.
   if (outfile[5] == '?') {
     iZone = 0;
     for (idx = 0; idx < 9; idx++) {
       if (xorg >= TextZone[idx][0] && yorg >= TextZone[idx][1] &&
           xorg <= TextZone[idx][2] && yorg <= TextZone[idx][3]) {
         iZone = idx;
         break;
       }
     }
     outfile[5] = iZone + '1';
   }
   if (NULL == (fp = fopen(outfile,"w")))
     return INVALID_HANDLE;

   fwrite(ucBsavedHeader, sizeof(ucBsavedHeader), 1, fp);

   xorg = xorg/CGA_X_RATE;

   for (y = 0; y < 25; y++) {
     toff = (yorg * CGA_LINE_SIZE) + xorg;
     boff = toff + CGA_LINE_SIZE;
     yorg += 2;

     for (x= 0; x < 20; x++) {
       topbyte = cgascreenbuffer[toff+x];
       botbyte = cgascreenbuffer[boff+x];

       textpixel((topbyte>>6)&3, (botbyte>>6)&3, fp);
       textpixel((topbyte>>4)&3, (botbyte>>4)&3, fp);
       textpixel((topbyte>>2)&3, (botbyte>>2)&3, fp);
       textpixel(topbyte&3,      botbyte&3,      fp);
     }
   }

   fputc(ucBsavedTailer[0], fp);
   fclose(fp);

   return (SUCCESS);

}

int main(int argc, char **argv)
{
    int status, idx;
    unsigned char buffer[TEMP_BUFF_LEN];

    /* 1. if no commandline args then print usage and exit */
    if (argc < 2)
      errorexit("Usage is : \"CGA2BSV <BSAVED.PIC>\"");

    /* 2. if we can't allocate memory then say so and exit */
    if (NULL == (cgascreenbuffer = malloc(CGA_SCREENSIZE)))
       errorexit("Memory Allocation Error!");

    /* 3. if some error reading the file then print the error and exit */
    if (SUCCESS != (status = bread(argv[1]))) {
      switch (status) {
        case INVALID_HEADER:
          sprintf(buffer, "%s is not in a supported format.",argv[1]);
          if (INVALID_HANDLE != (status = cgxread(argv[1])))
            break;
        case INVALID_HANDLE:
        default:
          sprintf(buffer, "unable to open %s.",argv[1]);
      }

      if (SUCCESS != status)
        errorexit((char *)&buffer[0]);
    }

   /* 4. if we are unable to switch to CGA mode then complain and exit */
   if (ucCgaDisplayMode != setcrtmode(ucCgaDisplayMode))
     errorexit("CGA or better adapter required");

   cgaload();
   vfnSaveArea(argv[1]);
   (void)setcrtmode(TEXT_VIDEO);
   return (SUCCESS);
}
