/* ------------------------------------------------------------------------ */
/* System       : Library Routines                                          */
/* Program      : cgaload.c                                                 */
/* Description  : screenloader for cga mode graphics                        */
/*                (C) CopyLeft Bill Buckels 1997.                           */
/*                All Rights Reversed.                                      */
/*                                                                          */
/* You have a royalty-free right to use, modify, reproduce and              */
/* distribute this source code in any way you find useful,                  */
/* provided that you agree that Bill Buckels has no warranty obligations    */
/* or liability resulting from said distribution in any way whatsoever.     */
/* ------------------------------------------------------------------------ */

#define _CGALOAD_C_

#include "std.h"
#include "stdkeys.h"
#include "cgaload.h"

void cgaload()
{

  char *crtptr = (char *)0xb8000000L;
  int y, y1, y2, idx;

  if (NULL == cgascreenbuffer)
    return;

  y  = 0;
  y1 = 0;
  y2 = CGA_INTERLEAF;

  for (idx = 0; idx < 100; idx++) {

    memcpy(&crtptr[y1], &cgascreenbuffer[y], CGA_LINE_SIZE);
    y += CGA_LINE_SIZE;
    y1+= CGA_LINE_SIZE;

    memcpy(&crtptr[y2], &cgascreenbuffer[y], CGA_LINE_SIZE);
    y += CGA_LINE_SIZE;
    y2+= CGA_LINE_SIZE;

  }
  return;
}
