/* ------------------------------------------------------------------------ */
/* System       : Library Routines                                          */
/* Program      : dstr.c                                                    */
/* Description  : direct video routines for text mode string display        */
/*                (C) CopyLeft Bill Buckels 1997.                           */
/*                All Rights Reversed.                                      */
/*                                                                          */
/* You have a royalty-free right to use, modify, reproduce and              */
/* distribute this source code in any way you find useful,                  */
/* provided that you agree that Bill Buckels has no warranty obligations    */
/* or liability resulting from said distribution in any way whatsoever.     */
/* ------------------------------------------------------------------------ */
#define  _DSTR_C_

#ifndef ASCIIZ
  #define ASCIIZ '\x00'
#endif

#include <stdio.h>
#include <dos.h>
#include "dstr.h"

/* --------------------------------------------------------------------- */
/* set-up pointer to text screen or cga video if in graphics mode 4 or 6 */
/* return address of text screen (monochrome text mode 7 or cga mode 3)  */
/* --------------------------------------------------------------------- */
unsigned getscreenseg()
{
    union REGS inregs,outregs;

    int86(0x11,&inregs,&outregs);
    /* get equipment list from the bios */
    /* and isolate videomode info       */
    if(((outregs.x.ax>>4) &3) <3)   {
      pScreenPointer = (char far *)0xb8000000L;   /* cga */
      return 0xb800;
    }
    else {
      pScreenPointer = (char far *)0xb0000000L;   /* hercules */
      return 0xb000;
    }
}


/* write string with attribute direct to screen */
void dstr(char just, char *ptr, int row, int col, int bgr, int fgr, int trans)
{
  unsigned char c, a;
  unsigned offset;
  int len;

  if ('M' == just) {
    for (len = 0; ptr[len] != ASCIIZ; len++);
    col = ((col+1)-(len/2));
  }

  offset = 160 * row + 2 * col;

  a = (bgr << 4) | fgr;

  if (pScreenPointer == (char far *)NULL) {
    getscreenseg();
  }

  while ((c = *ptr++)!=ASCIIZ){
    if (!trans || c != 32)
      pScreenPointer[offset] = c;
    offset++;
    if (!trans || c != 32)
      pScreenPointer[offset] = a;
    offset++;
  }
  return;
}
