/* ------------------------------------------------------------------------ */
/* System       : Library Routines                                          */
/* Program      : vidlow.c                                                  */
/* Description  : Low Level Text Screen Functions using Bios Calls          */
/*                (C) CopyLeft Bill Buckels 1997.                           */
/*                All Rights Reversed.                                      */
/*                                                                          */
/* You have a royalty-free right to use, modify, reproduce and              */
/* distribute this source code in any way you find useful,                  */
/* provided that you agree that Bill Buckels has no warranty obligations    */
/* or liability resulting from said distribution in any way whatsoever.     */
/* ------------------------------------------------------------------------ */

/* -------------------------------------------------------------------- */
/* low level text mode video routines using bios int 10h                */
/* -------------------------------------------------------------------- */

#include <dos.h>

static union REGS regs;

/* turn cursor off */
void cursoroff(void)
{
  regs.h.ah = 0x01;
  regs.x.cx = 0x2000;

  int86(0x10, &regs, &regs);
}

/* turn cursor on */
void cursoron(void)
{
  regs.h.ah = 0x01;
  regs.x.cx = 0x0607;

  int86(0x10, &regs, &regs);
}

/* clear screen in color */
void cls(int BACK, int FRONT)
{
  regs.h.ah = 6;
  regs.h.al = 0;
  regs.h.ch = 0;
  regs.h.cl = 0;
  regs.h.dh = 24;
  regs.h.dl = 79;
  regs.h.bh = (BACK << 4) + FRONT;

  int86(0x10, &regs, &regs);
}

/* set cursor location */
void locate(unsigned row, unsigned column)
{
  regs.h.ah = 2;
  regs.h.bh = 0;
  regs.h.dh = row;
  regs.h.dl = column;

  int86(0x10, &regs, &regs);
}
