
                      NBMC: Navigator BookMark Customizer
                      ===================================
                    Version 2.0 for Netscape Navigator 2.02
                         (c) F. Pacquier - August 1996

==============================================================================
 Table Of Contents:
==============================================================================

 1 - What's it for ?
 2 - (How) does it work ?
 3 - Step-by-step installation
 4 - Known issues and limitations, possible improvements
 5 - About the author
 6 - Famous last words

 APPENDIX A - NBMC configuration file details

 APPENDIX B - NBMC.BAT commented code

 APPENDIX C - History

==============================================================================
 1 - What's it for ?
==============================================================================

 It's for customizing Netscape Navigator bookmarks :-)

 Seriously, now, here's why I created this utility:

 Netscape stores its bookmarks in HTML format. When you use Add Bookmark and 
 the Bookmark Editor to create the entries and submenus in the Bookmark menu, 
 everything is saved in a file called bookmark.htm in the Netscape Navigator
 directory.

 I use this file as my Home Page --ie, in my General Preferences, my home 
 page URL is something like "file:///C|/Netscape/Navigator/Bookmark.htm".
 Thus, when I launch Netscape or press the Home button, my bookmarks get 
 displayed in the browser window instead of Netscape's site or whatever, and 
 I don't have to use the Bookmark menu to surf around.

 The only problem is, Netscape has its own HTML layout to store your 
 bookmarks in. It's not particularly pretty, and it's not very compact: even 
 if you try to keep your bookmark list tidy, the resulting page can easily 
 scroll through a few screens, which is uncool. And you can't customize your 
 bookmark.htm, because it's overwritten every time you add or edit bookmarks 
 from the menu.

 What I wanted was something to generate a customized home page from the 
 bookmark file, showing all my links on more or less one screen, in whatever
 flashy layout I fancied. Of course I needed a quick way to update this page 
 after adding, deleting or editing links, and maybe switching between 
 different layouts depending on my mood. This is what NBMC does.
 
 If you still don't quite see what I mean, maybe the best way is to go to my 
 Web page (providing it still works) and see the examples I've set up there 
 to illustrate how NBMC works (see Section #6 below).

 
==============================================================================
 2 - (How) does it work ?
==============================================================================

 Let me say it right now before you find out:
 It's a quick hack, it's downright ugly, and it works well enough.
 And it beats trying to learn C++ just for that :)

 NBMC is a combination of a DOS batch file, a search & replace utility called 
 GSAR, one or more configuration files... and Netscape Navigator.

 GSAR is a freely distributable package I found on the Net. For simplicity's 
 sake (& size) I have included only the executable, man page and GNU license 
 agreement. The complete package (with sources) is available with the latest
 version of NBMC on my home page (if it works), or at Garbo or any of its 
 mirrors.

 So this is how it goes: the batch file filters Netscape's bookmark.htm and 
 writes a temp file containing only the HTML statements concerning submenus 
 and links (ie, <H3> and <A> tags).
 From the first section in the configuration file (passed as a parameter to
 the batch) an auxiliary batch file is created, that contains all the GSAR
 search & replace commands that have been specified to massage the HTML
 code for your bookmarks. This auxiliary batch is run on the temp file just
 created and generates the body for your new bookmark file (nbmc.htm).
 Then, the second and third sections of the configuration file are also
 filtered and prepended or appended, respectively, to the new nbmc.htm so
 that you can also customize the header and footer of the file and add any 
 relevant statements there automatically.

 That's the bulk of it. It is in fact a bit more complicated than that, 
 because I wanted to make configuration files as easy to understand, read 
 and maintain as possible for the user. So the search & replace commands you 
 define in the configuration file use a very easy syntax; GSAR itself is run 
 once on those lines to translate them to actual GSAR commands for the 
 auxiliary batch file. These commands are more arcane mostly because HTML 
 uses a lot of signs like spaces, <, and > that have to be converted to 
 ASCII codes before being passed as parameters. This way, the user never has 
 to bother with this.
  
 Appendix A shows a heavily commented configuration file, with syntax, 
 caveats, hints, etc. It is actually the same as the CONFIG1.BMC sample file 
 in the package. Its size may seem daunting due to the amount of comments, 
 but if you look at the other two sample files (CONFIG2-3.BMC) which have 
 the comments stripped out, you will find that there actually is little meat 
 and very few things to change to make your own customizations.

 You can have as many config files as you wish, by any name you wish, 
 provided the extension is .BMC (see why below). Run the batch with a config 
 file's name as a parameter (together with extension, see why below) and your 
 plain old bookmark.htm gets a new look each time...

 Now the final straw:
 You can include links to your config files in the generated home page. In 
 Netscape, set up NBMC as a helper app associated with .BMC files, and a 
 click on such a link will recreate said home page according to that 
 particular config file. I still can't believe it myself.

 If you're interested in how things work, Appendix B has a commented version
 of NBMC.BAT (the actual program has no comments to speed things up). Among 
 others things it shows how to make a very small change to achieve non-
 case-sensitive search & replace if you ever need it. You might think of 
 other improvements, too.


==============================================================================
 3 - Step-by-step installation:
==============================================================================

 Even if you get the general idea from my lousy explanations (and especially 
 if you don't), it's good to follow this checklist to make sure all the 
 grousy little details are taken care of:

 Step 1:
 ------
 Create a subdirectory named NBMC (or whatever) _right under_ your 
 Netscape or Navigator directory (ie: the one where Bookmark.htm is). This is 
 mandatory, as it keeps absolute path references to a bare minimum, making 
 things more 'portable'.

 Step 2:
 ------
 Dump the entire NBMC.ZIP content in that directory and switch to it.

 Step 3:
 ------
 Run nbmc.bat with one of the sample config files provided (as in, for 
 instance, 'nbmc config1.bmc'). The batch will only run if it finds itself in 
 the current directory, along with some .bmc files in general and the one you 
 specified in particular, _and_ a bookmark.htm file in the parent dir. Whew.
 And oh, yeah, it also wants GSAR.EXE right alongside, too...
 If everything goes well (and why not?) a nbmc.htm is created.

 Step 4:
 ------
 Create a NBMC.PIF file in this same directory (with pifedit in Windows3, 
 a shortcut in Windows 95). Set it to run NBMC.BAT and _specify the working 
 directory_ to the nbmc dir, as well as _close on exit_. You will probably 
 want it to run in a window rather than full-screen, but maybe you should 
 not run it minimized until you are sure everything is OK (ie after step 7).

 Step 5:
 ------
 Run Netscape. Use Open File to load nbmc.htm from its directory (never 
 mind if you hate the results ! :-). Now select the URL in the location 
 window and copy it (control-C). Now go to General Preferences and paste it 
 in the Home Page location (with control-V).

 Step 6:
 ------
 Still in General Preferences, go to the Helpers tab. 
 Press the "Create New type" button.
 Type in something sensible like:
         Mime Type   : application
         Mime subType: nbmc
 This new entry now needs two things:
  - An associated extension -- type BMC
  - An associated action -- check the Launch radio button 
                            then browse to NBMC.PIF 
    (make sure the result really is nbmc.pif, not nbmc.bat -- sometimes 
     Windows95 gets it wrong).

 Step 7:
 ------
 Now back to the home page -- click on one of the three links at the 
 bottom, pointing to config1.bmc, config2.bmc or config3.bmc. You should see 
 Netscape invoke the helper app and run the batch in a window with the 
 corresponding config file as a parameter.
 Then hit 'Reload', and you should have a brand new home page...
 Notice that the current configuration number's link is between parentheses.

 Step 8:
 ------
 If all is well, now is the time to start tinkering with your own config 
 files to customize your own layouts. It's a fun way to learn basic HTML if 
 you don't already have. Examine the sample files until you understand why 
 they're made that way, what to edit and what to leave alone.

 Two things to keep in mind:

 a) you can't break anything, and certainly not your original bookmark file, 
 so go ahead and experiment ;

 b) there are only three absolute path references to the NBMC directory in 
 the whole system: one for the Netscape Home Page, one for the Netscape 
 Helper App, and one inside NBMC.PIF. None inside NBMC.BAT, and none inside 
 the configuration files. You should probably try to keep it that way !

 
==============================================================================
 4 - Known issues and limitations, possible improvements:
==============================================================================

 * under Windows 95, you may have to manually type in the .PIF 
   extension when specifying NBMC as the helper app. Dunno why.

 * if you regenerate your nbmc.htm home page too soon after editing 
   your bookmarks, the bookmark file may still be in the disk cache, with 
   Bookmark.htm on disk (and thus nbmc.htm) not reflecting the changes.

 * you still have to manually reload the page after refreshing it. I would 
   like to have it done automatically. I would also like to have graphics 
   painted on startup even if 'Autoload images' is off. If anyone knows how
   to do this, mail me...

 * I have only tested this with Netscape Navigator 2.02 (16 and 32 bit 
   versions), and my bookmarks only have one level of menus. YMMV.
   
 * a nifty enhancement would be to have the batch scan the NBMC dir for all 
   configuration files and insert links to them at the bottom when 
   generating a new NBMC.HTM, instead of hardcoding them in the config file 
   like it's done now. Maybe next time.

 
==============================================================================
 5 - About the author:
==============================================================================

 I live in Paris, I'm no programmer, I love Quake deathmatches and I can't 
 write dox (not even in French :-)

 At the time of this writing, my email address is:
    fredp@mygale.org

 and my home page for NBMC stuff is:
     http://www.mygale.org/11/fredp
 
 Unfortunately, the Internet being in the state it is (especially in 
 France :), both are liable to change without notice.
 
 If you really want to contact me, and none of the above work, go to 
 Alta Vista and search Usenet for Fred Pacquier. You'll find me <g>.

 
==============================================================================
 6 - Famous last words:
==============================================================================

 NBMC is free and you get what you pay for. It works for me. If it doesn't 
 for you, fix it or can it. Send me praise. Send flames to AOL.
 
 ...Above all, Enjoy ! :-)


==============================================================================
                   APPENDIX A - NBMC configuration file details
==============================================================================

:: This is the same as the CONFIG1.BMC sample in the original package
:: 
:: NBMC 2.0 sample configuration file -- (c) F. Pacquier 1996
:: (lines starting with ':: ' are comments and ignored by NBMC.BAT)
:: 
:: Section 1
:: 
:: This section holds the search & replace instructions
:: 
:: These will be parsed and used by GSAR to read the headers and bookmarks
:: from your original BOOKMARK.HTM file and generate the body of your
:: custom NBMC.HTM file.
:: 
:: Each line must follow the syntax:
:: 
:: from{string1}to{string2}
:: 
:: 
:: Things To Be Careful Of:
:: =======================
:: 
:: * WHITESPACE is SIGNIFICANT in string1 and string2 ! 
::   string2 may be empty if you just want to remove string1 completely
::   (see first uncommented search & replace line below)
:: 
:: * Everything is CASE SENSITIVE by default
::   (this can be changed and is documented in NBMC.MAN)
:: 
:: * NO TRAILING SPACES after the last '}' at the end of each line...
:: 
:: * Special characters can be specified using the :ddd notation, where
::   ddd is the 3-digit decimal ASCII code for the character. Add a zero
::   if necessary. For instance, if you need a '|' (pipe) char in string1
::   or string2, use ':124'. A DOS end-of-line pair is ':013:010'.
::   If you need a plain ':' use '::'. (This is GSAR syntax).
:: 
:: * KEEP LINES SHORT ! These instructions will be parsed by GSAR to
::   produce GSAR commands that will in turn parse NBMC.TMP. In doing this,
::   special chars like spaces, <, > will be turned into :ddd notation, and
::   from{...}to{...} tokens will be turned into GSAR commands and options.
:: 
::   For instance, the instruction:
:: 
::    from{< A >}to{<a>}
:: 
::   would be executed as the DOS command:
:: 
::    gsar -s:060:032A:032:062  -r:060a:062 -o nbmc_htm.tmp>NUL
:: 
::   As expanded commands will typically be quite longer than the original
::   instructions, these must be kept short to avoid running into the DOS
::   command length limitation...
:: 
::   To achieve this you can spread your substitutions over several passes,
::   as in the examples below. First suppress all unwanted material; then
::   substitute existing tags or insert new ones. You can use shorthand
::   (like '^' for return/linefeed and <dot.blue> for an image anchor) for
::   frequently repeated stuff and then expand these in turn at the end.
::   This also makes the substitution code easier to read and to maintain.
:: 
::   Note: instructions are executed in the order they appear here, with
::   additional expansion to GSAR command lines at the very end.
:: 

from{  }to{}
from{<DT>}to{}
from{FOLDED }to{}
from{<H3}to{<HR>^<dot.blue>^<B}
from{/H3>}to{/B>^<dot.blue>}
from{/A>}to{/A>^<dot.gray>}
from{^}to{:013:010}
from{<dot.blue>}to{<img alt="" src="dot_blue.gif" hspace=5>}
from{<dot.gray>}to{<img alt="" src="dot_gray.gif" hspace=0>}


:: 
:: Section 2
:: 
:: This section is used to store additional HTML statements 
:: 
:: These lines will be inserted at the beginning of nbmc.htm
:: 
:: They will be added by nbmc.bat using a FIND on the tag string {head}
:: so edit at will & add as many as you want but make sure each line
:: starts with the tag string !
::

{head}<html>
{head}<head>
{head}<title>NBMC Custom BookMarks</title>
{head}</head>
{head}<body background="bg_moon.jpg" link="#FF0000" vlink="#2F4F2F" alink="#000000">
{head}<center>


:: 
:: Section 3
:: 
:: This section is used to store additional HTML statements 
:: 
:: These lines will be appended to nbmc.htm
:: 
:: They will be added by nbmc.bat using a FIND on the tag string {tail}
:: so edit at will & add as many as you want but make sure each line
:: starts with the tag string !
::

{tail}<hr><font size=-1><i>
{tail}Generate configuration :
{tail}<A HREF="config1.bmc">(1)</A> &#183;
{tail}<A HREF="config2.bmc">2</A> &#183;
{tail}<A HREF="config3.bmc">3</A>
{tail}</i></font></center>
{tail}</body>
{tail}</html>

:: 
:: End of config file.
:: 

==============================================================================
                        APPENDIX B - NBMC.BAT commented code
==============================================================================

@echo off
:: 
:: All these conditions must be met before NBMC.BAT will run:
:: 
:: Current dir must be subdirectory of original Netscape BOOKMARK.HTM 
if not exist ..\bookmark.htm goto error1

:: Current dir must contain NBMC.BAT itself
if not exist nbmc.bat        goto error2

:: GSAR.EXE must also be in current directory (not needed in PATH)
if not exist gsar.exe        goto error3

:: at least one configuration file must be present
if not exist *.bmc           goto error4

:: if no parm passed print usage & available configs
if (%1)==()                  goto usage

:: if parm passed assume it is a config file & test if present
if not exist %1              goto error5

:: create a temp file in current directory from BOOKMARK.HTM in parent dir
:: containing only header & anchor tags (ie menus titles & links),
:: stripped of all other HTML formatting information
echo. nbmc: parsing Netscape bookmark file for header & link tags
 type  ..\bookmark.htm | find "ADD_DATE" > nbmc_htm.tmp

:: now we create an auxiliary batch file by running GSAR on the 'search &
:: replace' section of the configuration file passed as a parameter.
:: The concise and easy-to-read instructions from the config file are
:: translated to absconse GSAR DOS command lines, compliant with GSAR syntax
:: and characters significant to COMMMAND.COM like <, > and spaces.
:: 
echo. nbmc: creating auxiliary batch file

:: create the temp batch file from the first section of the config file,
:: without comment lines. The triple find is probably overkill, just to
:: stay on the safe side...
 type %1 | find "from{" | find "}to{" | find /v ":: " > nbmc_s&r.bat

:: this changes all '<' chars in the batch to their GSAR ':060' equivalent
 gsar  -s:060       -r::060                           -o nbmc_s&r.bat >NUL

:: this changes all '>' chars in the batch to their GSAR ':062' equivalent
 gsar  -s:062       -r::062                           -o nbmc_s&r.bat >NUL

:: this changes all spaces in the batch to their GSAR ':032' equivalent
 gsar  -s:032       -r::032                           -o nbmc_s&r.bat >NUL

:: this replaces 'from{' with 'gsar -s', creating the command lines
:: NOTE:
:: if you want the s&r instructions in your configuration files to be
:: case-insensitive, you should replace this line with the following:
:: gsar  -sfrom{      -rgsar:032-i:032-s              -o nbmc_s&r.bat >NUL
 gsar  -sfrom{      -rgsar:032-s                      -o nbmc_s&r.bat >NUL

:: this replaces '}to{' with ' -s'
 gsar  -s}to{       -r:032-r                          -o nbmc_s&r.bat >NUL

:: this replaces the trailing '}' with ' -o nbmc_htm.tmp'
 gsar  -s}:013:010  -r:032-o:032nbmc_htm.tmp:013:010  -o nbmc_s&r.bat >NUL

:: this adds '>NUL' to the end of the command line for silent operation
:: NOTE:
:: if your original s&r instruction is a bit long and the expanded command
:: line nears the DOS limit, you can safely comment out this line to
:: gain a few characters
 gsar  -smp:013:010 -rmp:062NUL:013:010               -o nbmc_s&r.bat >NUL

:: now we run the newly created auxiliary batch file against the temp file
:: created from BOOKMARK.HTM, to generate the new HTML formatting for your
:: menu titles and links
echo. nbmc: substituting HTML tags from Bookmark.htm to NBMC.HTM
 call nbmc_s&r.bat

:: finally we create the NBMC.HTM file that will be used as your Netscape
:: home page, by combining the second section of the configuration file,
:: the temp file as generated above, and the third section of the config:
echo. nbmc: writing NBMC.HTM head & tail
:: get the uncommented lines from section 2 of config files and initialize
:: nbmc.thm with them
 type %1 | find "{head}"  | find /v ":: "  > nbmc.htm
:: append the modified HTML body generated by GSAR
 type nbmc_htm.tmp                        >> nbmc.htm
:: get the uncommented lines from section 3 of config files append them
 type %1 | find "{tail}"  | find /v ":: " >> nbmc.htm
:: use GSAR again to remove the {head} and {tail} tags from nbmc.htm
 gsar  -s{head}  -r  -o nbmc.htm  > NUL
 gsar  -s{tail}  -r  -o nbmc.htm  > NUL

:: housekeeping
:: NOTE:
:: if you have problems with NBMC's output or want to trace or otherwise
:: modify the way it works, comment out these lines so you can run the
:: batch and see the working files being generated
echo. nbmc: deleting temp files
 del nbmc_htm.tmp
 del nbmc_s&r.bat

echo. nbmc: done.

goto end

:usage
echo. 
echo. nbmc: Navigator BookMark Customizer
echo.       Version 2.0 for Netscape Navigator 2.02
echo.       (c) Fred Pacquier - August 1996
echo. 
echo. Usage: nbmc config.bmc
echo. 
echo. Action: reads bookmark.htm in parent directory and generates nbmc.htm
echo. in current directory according to directives in config.bmc
echo. 
echo. Available configuration files are:
dir /-p/w *.bmc | find /i ".BMC"
echo. 
goto end

:error1
echo. nbmc error: BOOKMARK.HTM not in parent directory -- aborted.
goto end

:error2
echo. nbmc error: NBMC.BAT not in current directory -- aborted.
goto end

:error3
echo. nbmc error: GSAR.EXE not in current directory -- aborted.
goto end

:error4
echo. nbmc error: no .BMC config files in current directory -- aborted.
goto end

:error5
echo. nbmc error: %1 not found in current directory -- aborted.
goto end

:end

==============================================================================
                                APPENDIX C - History
==============================================================================

* July 1996 - version 1.0 released to Winsite. This version used a search & 
  replace utility named FileScrub. This used to be shareware, not freeware,
  but I thought it safe to include it with NBMC because NBMC itself is 
  freeware and FileScrub had not been updated since 1987... Unfortunately
  soon afterward I found the original author on the Net and he did not agree 
  with me. So if you find old copies of NBMC 1.0 lying around (which is 
  unlikely, as it was uploaded only to one archive and not advertised), it 
  would be best to advise the maintainers of the archive to delete them or 
  update them to NBMC 2.0...
  
* August 1996 - version 2.0 is a complete rewrite using the GNU-licensed 
  GSAR package as a s&r engine. Parsing of the configuration files by GSAR 
  to produce its own output allows for much easier syntax in the user- 
  configurable sections. Also, much improved docs (wasn't hard :-).

==============================================================================

