/*--------------------------------------------------
   HMM_DEMO.C -- Helpfile Macro Manipulation Demo
   (c) 1997 Bent Lynggaard
  --------------------------------------------------*/

/* 1997-01-28: v. 1.00
*/

#include <windows.h>
#include <commdlg.h>
#include <shellapi.h>
#include "insmacro.h"
#include "hmm_demo.h"

#define PROGNAME "HMM_Demo"
#define TESTFILE PROGNAME ".hlp"

#define MACROS 5
/* number of checkboxes */
#define IDC_FIRST IDC_PRINT
/* the first one of MACROS checkboxes */

char *macros[MACROS] = { /* macro strings */
	"CB(`id_print',`&Print',`Print()')",
	"CB(`id_copy',`Cop&y',`CopyTopic()')",
	"BrowseButtons()",
	"CB(`id_notepad',`&Notepad',`ExecProgram(`Notepad.exe',0)')",
	"CB(`id_exit',`E&xit',`Exit()')"
}; /* char *macros[MACROS] */

HWND deleteList;	/* handle for To Delete list */
HWND insertList;	/* handle for To Insert list */

void registerCls(void);
long CALLBACK _export WndProc(HWND, UINT, UINT, LONG);
BOOL FAR PASCAL _export AboutDlgProc(HWND, WORD, WORD, LONG);
int reportError(int);
long CALLBACK _export WndProc(HWND, UINT, UINT, LONG);

char	szAppName[] = PROGNAME;

HANDLE	hInst;
HWND	hwndMain;
FARPROC	lpfnAboutDlgProc;

#ifdef __TURBOC__
	#pragma option -w-par
#endif

void registerCls(void) {
	WNDCLASS	wndclass;
		wndclass.style			= 0;
		wndclass.lpfnWndProc	= WndProc;
		wndclass.cbClsExtra		= 0;
		wndclass.cbWndExtra		= DLGWINDOWEXTRA;
		wndclass.hInstance		= hInst;
		wndclass.hIcon			= LoadIcon(hInst, "HMM1");
		wndclass.hCursor		= LoadCursor(NULL, IDC_ARROW);
		wndclass.hbrBackground	= COLOR_WINDOW+1;
		wndclass.lpszMenuName	= NULL;
		wndclass.lpszClassName	= szAppName;

		RegisterClass(&wndclass);
} // void registerCls()

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
				LPSTR lpszCmdLine, int nCmdShow)
{
	MSG msg;
	int i;

	hInst = hInstance;
	if (!hPrevInstance)
		registerCls();

	hwndMain = CreateDialog(hInst, szAppName, 0 , NULL);

	/* find handles for the To Delete and To Insert lists */
	deleteList = GetDlgItem(hwndMain, IDC_TO_DELETE);
	insertList = GetDlgItem(hwndMain, IDC_TO_INSERT);
	/* insert the macro strings in the To Delete listbox */
	for (i=0; i<MACROS; i++)
		SendMessage(deleteList, LB_INSERTSTRING, i, (LONG)(LPSTR)macros[i]);
	/* delete all buttons from TESTFILE, if left there since last demo */
	reportError(InsertMacros(TESTFILE, deleteList, 0, 0));

	lpfnAboutDlgProc = MakeProcInstance((FARPROC)AboutDlgProc, hInstance);

	ShowWindow(hwndMain, nCmdShow);
	UpdateWindow(hwndMain);

	while (GetMessage(&msg, NULL, 0, 0)) {
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	} /* while () */
	return msg.wParam;
} // int PASCAL WinMain()

BOOL FAR PASCAL _export AboutDlgProc(HWND hwnd, WORD message,
	WORD wParam, LONG lParam) {
	/* about/help dialog box handler */
	switch (message) {

	case WM_INITDIALOG:
		return TRUE;

	case WM_COMMAND:
		switch (wParam) {
			case IDOK:
			case IDCANCEL:
				EndDialog(hwnd, 0);
				return TRUE;
		}
		break;
	}
	return FALSE;
} // BOOL FAR PASCAL _export AboutDlgProc()

int reportError(int err) {
/* display an error message if err!=0 */
	char buffer[80];
	if (err) {
		LoadString(hInst, err, (LPSTR)buffer, sizeof(buffer));
		MessageBox(hwndMain, (LPSTR)buffer, "HMM_Demo Error", MB_OK);
	} /* if (err) */
	return err;
} // int reportError()

long CALLBACK _export WndProc(HWND hwnd, UINT message, UINT wParam, LONG lParam)
{
	WORD i, j, m, n;
	static WORD checkMarks; /* mirrors checkbox settings, initialized to 0 */

	switch (message) {

	case WM_COMMAND:
	/* message from one of the checkboxes, pushbuttons, or lists */
		switch (wParam) {
		case IDC_PRINT:
		case IDC_COPY:
		case IDC_BROWSE:
		case IDC_NOTEPAD:
		case IDC_EXIT:
		/* handle the checkboxes */
			n = wParam - IDC_FIRST; /* number of activated box, 0 - MACROS-1 */
			j = 1; /* bit 0 */
			m = 0; /* initialize counter */
			for (i=0; i<n; i++) {
			/* count marks set before selected one */
				if (checkMarks & j) /* checkMarks mirrors checkboxes */
					m++;
				j <<= 1; /* next bit */
			} /* for (i=0...) */
			/* there are m entries in To Insert, and n-m entries in To Delete
			   before the actual macro string
			*/
			checkMarks ^= j; /* toggle value */
			if (checkMarks & j) {
				/* cleared before, set now: Move from To Delete to To Insert */
				/* remove string from To Delete */
				SendMessage(deleteList, LB_DELETESTRING, n-m, 0);
				/* insert proper string into To Insert */
				SendMessage(insertList, LB_INSERTSTRING, m,
					 (LONG)(LPSTR)macros[n]);
			} /* if (checkMarks & j) */
			else {
				/* move in opposite direction */
				SendMessage(insertList, LB_DELETESTRING, m, 0);
				SendMessage(deleteList, LB_INSERTSTRING, n-m,
					 (LONG)(LPSTR)macros[n]);
			} /* else */
			return 0;

		case IDC_SHOW:
			reportError(ShowMacroMessagebox(TESTFILE, 0));
			return 0 ;

		case IDC_FILE:
			/* write macros to file hmm_demo.txt */
			if (reportError(WriteMacrosToFile(TESTFILE, "hmm_demo.txt",
					"[CONFIG]", NULL, "; (no macros)", 0)) == 0)
				/* open notepad.exe and load hmm_demo.txt */
				ShellExecute(hwnd, "open", "notepad.exe", "hmm_demo.txt", ".",
					SW_SHOW);
			return 0 ;

		case IDC_TEST:
			/* open TESTFILE (hmm_demo.hlp) */
			ShellExecute(hwnd, "open", "winhelp.exe", TESTFILE, ".",
				SW_SHOW);
			return 0 ;

		case IDC_DELETE:
			/* call InsertMacros function 0 with To Delete list */
			reportError(InsertMacros(TESTFILE, deleteList, 0, 0));
			return 0 ;

		case IDC_INSERT:
			/* call InsertMacros function 1 with To Insert list */
			reportError(InsertMacros(TESTFILE, insertList, 1, 0));
			return 0 ;

		case IDC_TO_DELETE:
		case IDC_TO_INSERT:
		/* a listbox was clicked, unselect the selected item again */
			SendMessage((HWND)LOWORD(lParam), LB_SETCURSEL, -1, 0);
			return 0;

		case IDC_ABOUT:
			/* open About/Help dialog box */
	showAbout:
			DialogBox(hInst, "AboutBox", hwnd, lpfnAboutDlgProc);
			return 0;

		case IDC_QUIT:
			/* done, close this window */
			SendMessage (hwnd, WM_CLOSE, 0, 0L);
			return 0 ;

		} /* switch (wparam) */
		break;

	case WM_KEYDOWN:
	/* open about/help dialog if F1 is pressed */
		if (wParam == VK_F1)
			goto showAbout;
		break;

	case WM_INITMENUPOPUP:
	/* Fixed size window, so we want to disable System Menu entries */
		if (HIWORD(lParam)) { /* disable Size and Maximize */
			EnableMenuItem(wParam, 2, MF_BYPOSITION | MF_GRAYED);
			EnableMenuItem(wParam, 4, MF_BYPOSITION | MF_GRAYED);
		} /* if (HIWORD...) */
		return 0;

	case WM_DESTROY:
	/* this window is closing, terminate program */
		PostQuitMessage(0);
		return 0;

	} /* switch (message) */

	return DefWindowProc(hwnd, message, wParam, lParam);

} // long CALLBACK _export WndProc()

